(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22109,        559]
NotebookOptionsPosition[     19621,        480]
NotebookOutlinePosition[     21073,        519]
CellTagsIndexPosition[     21030,        516]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: Angle Dialog"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->50319517],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{211, 178},
 CellID->160414654],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->235286875],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->757240145],

Cell[BoxData[
 RowBox[{
  RowBox[{"AnglePrompt", "[", "]"}], ":=", 
  RowBox[{
  "GUIRunModal", "[", "\"\<Wolfram/Example/AngleDialog\>\"", "]"}]}]], "Input",\

 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->92009743],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->547936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Get", "[", "\"\<Wolfram/Example/AngleDialog.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1470470],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Frame\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"title\"\>", "\[Rule]", "\<\"Get angle...\"\>"}], ",", 
     RowBox[{"\<\"resizable\"\>", "\[Rule]", "False"}], ",", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Label\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Enter an angle:\"\>"}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextField\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
             RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], "}"}], 
           ",", 
           RowBox[{"Name", "\[Rule]", "\<\"inputField\"\>"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"Border\"\>", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"15", ",", "15"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"10", ",", "5"}], "}"}]}], "}"}]}], "}"}]}]}], "]"}], 
     ",", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"RadioButton\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"degrees\"\>"}], ",", 
             RowBox[{"\<\"selected\"\>", "\[Rule]", "True"}]}], "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"degreesButton\"\>"}]}], "]"}], ",",
          
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"RadioButton\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"radians\"\>"}], ",", 
             RowBox[{"\<\"selected\"\>", "\[Rule]", "False"}]}], "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"radiansButton\"\>"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\<\"Border\"\>", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"15", ",", "15"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "5"}], "}"}]}], "}"}], ",", "\<\"Units\"\>",
              ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"15", ",", "15"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}], ",", 
          RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Maximize", ",", "Maximize"}], "}"}]}]}], "}"}]}]}], 
      "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"Cancel\"\>"}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"returnValue", "=", "False"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"frame\"\>", ",", "\<\"dispose\"\>"}], "}"}], 
              "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"cancelAction\"\>"}]}], "]"}], ",", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"WidgetFill", "[", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"OK\"\>"}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{
                 RowBox[{"returnValue", "=", "True"}], ";", 
                 RowBox[{"InvokeMethod", "[", 
                  RowBox[{"{", 
                   RowBox[{"\<\"frame\"\>", ",", "\<\"dispose\"\>"}], "}"}], 
                  "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"okButton\"\>"}]}], "]"}], ",", 
         RowBox[{"WidgetSpace", "[", "5", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{"WidgetReference", "[", "\<\"cancelAction\"\>", "]"}]}],
              ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Cancel\"\>"}]}], "}"}], 
           ",", 
           RowBox[{"Name", "\[Rule]", "\<\"cancelButton\"\>"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\<\"Border\"\>", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"5", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}]}], "]"}], ",",
      
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"ButtonGroup\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"WidgetReference", "[", "\<\"degreesButton\"\>", "]"}], ",", 
         
         RowBox[{"WidgetReference", "[", "\<\"radiansButton\"\>", "]"}]}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"PropertyValue", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"frame\"\>", ",", "\<\"rootPane\"\>"}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"rootPane\"\>"}]}], "]"}], ",", 
     RowBox[{"SetPropertyValue", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"rootPane\"\>", ",", "\<\"defaultButton\"\>"}], "}"}], 
       ",", 
       RowBox[{"WidgetReference", "[", "\<\"okButton\"\>", "]"}]}], "]"}], 
     ",", 
     RowBox[{"InvokeMethod", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"rootPane\"\>", ",", "\<\"getInputMap\"\>"}], "}"}], ",", 
       
       RowBox[{"PropertyValue", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"rootPane\"\>", ",", "\<\"WHEN_IN_FOCUSED_WINDOW\"\>"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"inputMap\"\>"}]}], "]"}], ",", 
     RowBox[{"InvokeMethod", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"inputMap\"\>", ",", "\<\"put\"\>"}], "}"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"KeyStroke\"\>", ",", 
         RowBox[{"InitialArguments", "\[Rule]", 
          RowBox[{"{", "\<\"ESCAPE\"\>", "}"}]}]}], "]"}], 
       ",", "\<\"window.canceled\"\>"}], "]"}], ",", 
     RowBox[{"PropertyValue", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"rootPane\"\>", ",", "\<\"actionMap\"\>"}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"actionMap\"\>"}]}], "]"}], ",", 
     RowBox[{"InvokeMethod", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"actionMap\"\>", ",", "\<\"put\"\>"}], "}"}], 
       ",", "\<\"window.canceled\"\>", ",", 
       RowBox[{"WidgetReference", "[", "\<\"cancelAction\"\>", "]"}]}], "]"}],
      ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{"\<\"endModal\"\>", ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"TrueQ", "[", "returnValue", "]"}], ",", 
           RowBox[{
            RowBox[{"angle", "=", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"PropertyValue", "[", 
               RowBox[{"{", 
                RowBox[{"\<\"inputField\"\>", ",", "\<\"text\"\>"}], "}"}], 
               "]"}], "]"}]}], ";", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"angle", "=!=", "Null"}], "&&", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"degreesButton\"\>", ",", "\<\"selected\"\>"}], 
                 "}"}], "]"}]}], ",", 
              RowBox[{"angle", "*=", 
               FractionBox["\[Pi]", "180"]}]}], "]"}]}], ",", 
           RowBox[{"angle", "=", "Null"}]}], "]"}], ";", 
         RowBox[{"returnValue", "=", "False"}], ";", "angle"}], "]"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"Name", "\[Rule]", "\<\"frame\"\>"}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->173374676]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->45218527],

Cell[TextData[{
 "This example provides a reusable dialog for angle input. This is based on",
 " ",
 "a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " example, but rewritten here using the ",
 StyleBox["GUIKit`", "MR"],
 " APIs."
}], "Text",
 CellID->266076845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnglePrompt", "[", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[3]:=",
 CellID->354495379],

Cell[BoxData[
 FractionBox["\[Pi]", "3"]], "Output",
 CellLabel->"Out[3]=",
 CellID->116632737]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: Angle Dialog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 4.6314000}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example provides a reusable dialog for angle input. This is based \
on a J/Link example, but rewritten here using the GUIKit` APIs.", 
    "synonyms" -> {}, "title" -> "GUIKit Example: Angle Dialog", "type" -> 
    "Tutorial", "uri" -> "GUIKit/tutorial/AngleDialog"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 118, 5, 70, "Title",
 CellID->554471618],
Cell[852, 36, 35, 1, 70, "Text",
 CellID->50319517],
Cell[890, 39, 8585, 143, 70, "Graphics",
 CellID->160414654],
Cell[CellGroupData[{
Cell[9500, 186, 52, 1, 70, "SubsectionOpener",
 CellID->235286875],
Cell[9555, 189, 166, 5, 70, "Input",
 InitializationCell->True,
 CellID->757240145],
Cell[9724, 196, 253, 9, 70, "Input",
 InitializationCell->True,
 CellID->92009743],
Cell[CellGroupData[{
Cell[10002, 209, 58, 1, 70, "SubsubsectionOpener",
 CellID->547936],
Cell[CellGroupData[{
Cell[10085, 214, 330, 10, 70, "Input",
 CellID->1470470],
Cell[10418, 226, 8515, 214, 70, "Output",
 CellID->173374676]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18994, 447, 45, 1, 70, "Section",
 CellID->45218527],
Cell[19042, 450, 264, 10, 70, "Text",
 CellID->266076845],
Cell[CellGroupData[{
Cell[19331, 464, 126, 4, 70, "Input",
 CellID->354495379],
Cell[19460, 470, 95, 3, 70, "Output",
 CellID->116632737]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19594, 478, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

