(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24085,        596]
NotebookOptionsPosition[     21627,        517]
NotebookOutlinePosition[     23044,        556]
CellTagsIndexPosition[     23001,        553]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: Calculator"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->7382063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{270, 206},
 CellID->609366553],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->328534504],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->9578261],

Cell[BoxData[
 RowBox[{
  RowBox[{"Calculator", "[", "]"}], ":=", 
  RowBox[{
  "GUIRunModal", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",\

 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->110664375],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->424998509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Get", "[", "\"\<Wolfram/Example/Calculator.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->39151539],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Frame\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"title\"\>", "\[Rule]", "\<\"Calc with Mathematica\"\>"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Label\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"First argument:\"\>"}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"WidgetAlign", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"columns\"\>", "\[Rule]", "\<\"20\"\>"}], ",", 
           RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
            RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\<\"action\"\>", ",", 
             RowBox[{"Script", "[", 
              RowBox[{"calculateResults", "[", "]"}], "]"}]}], "]"}]}], "}"}],
          ",", 
         RowBox[{"Name", "\[Rule]", "\<\"FirstArgumentField\"\>"}]}], "]"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Label\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Second argument:\"\>"}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"WidgetAlign", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
            RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\<\"action\"\>", ",", 
             RowBox[{"Script", "[", 
              RowBox[{"calculateResults", "[", "]"}], "]"}]}], "]"}]}], "}"}],
          ",", 
         RowBox[{"Name", "\[Rule]", "\<\"SecondArgumentField\"\>"}]}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"WidgetFill", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Compute\"\>"}], ",", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\<\"action\"\>", ",", 
             RowBox[{"Script", "[", 
              RowBox[{"calculateResults", "[", "]"}], "]"}]}], "]"}]}], 
          "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Label\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Results: \"\>"}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Label\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Sum: \"\>"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"WidgetAlign", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
            RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
           RowBox[{"\<\"editable\"\>", "\[Rule]", "\<\"false\"\>"}]}], "}"}], 
         ",", 
         RowBox[{"Name", "\[Rule]", "\<\"SumField\"\>"}]}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Label\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Difference:\"\>"}], "}"}]}],
         "]"}], ",", 
       RowBox[{"WidgetAlign", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
            RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
           RowBox[{"\<\"editable\"\>", "\[Rule]", "\<\"false\"\>"}]}], "}"}], 
         ",", 
         RowBox[{"Name", "\[Rule]", "\<\"DifferenceField\"\>"}]}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Label\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Product:\"\>"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"WidgetAlign", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
            RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
           RowBox[{"\<\"editable\"\>", "\[Rule]", "\<\"false\"\>"}]}], "}"}], 
         ",", 
         RowBox[{"Name", "\[Rule]", "\<\"ProductField\"\>"}]}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Label\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Quotient:\"\>"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"WidgetAlign", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
            RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
           RowBox[{"\<\"editable\"\>", "\[Rule]", "\<\"false\"\>"}]}], "}"}], 
         ",", 
         RowBox[{"Name", "\[Rule]", "\<\"QuotientField\"\>"}]}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{"\<\"endModal\"\>", ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"fields", "=", 
          RowBox[{"{", 
           
           RowBox[{"\<\"FirstArgumentField\"\>", 
            ",", "\<\"SecondArgumentField\"\>", ",", "\<\"SumField\"\>", 
            ",", "\<\"DifferenceField\"\>", ",", "\<\"ProductField\"\>", 
            ",", "\<\"QuotientField\"\>"}], "}"}]}], ";", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#1", "\[Rule]", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"PropertyValue", "[", 
               RowBox[{"{", 
                RowBox[{"#1", ",", "\<\"text\"\>"}], "}"}], "]"}], "]"}]}], 
            "&"}], ")"}], "/@", "fields"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"Script", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"calculateResults", "[", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], "=", 
            RowBox[{"ToExpression", "/@", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 
                 RowBox[{"\<\"FirstArgumentField\"\>", 
                  ",", "\<\"SecondArgumentField\"\>"}], "}"}], 
                ",", "\<\"text\"\>"}], "}"}], "]"}]}]}], ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"SumField\"\>", ",", "\<\"text\"\>"}], "}"}], ",", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"x", "+", "y"}], ",", "InputForm"}], "]"}]}], "]"}], 
           ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"DifferenceField\"\>", ",", "\<\"text\"\>"}], "}"}],
              ",", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"x", "-", "y"}], ",", "InputForm"}], "]"}]}], "]"}], 
           ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"ProductField\"\>", ",", "\<\"text\"\>"}], "}"}], 
             ",", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"x", " ", "y"}], ",", "InputForm"}], "]"}]}], "]"}], 
           ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"QuotientField\"\>", ",", "\<\"text\"\>"}], "}"}], 
             ",", 
             RowBox[{"ToString", "[", 
              RowBox[{
               FractionBox["x", "y"], ",", "InputForm"}], "]"}]}], "]"}], 
           ";"}]}], "]"}]}], ";"}], "]"}]}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->477260661]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->424735882],

Cell[TextData[{
 "Here is a simple calculator example using the ",
 StyleBox["GUIKit`", "MR"],
 " package and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scripts for calculations.",
 " "
}], "Text",
 CellID->954968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calculator", "[", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[3]:=",
 CellID->804842438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FirstArgumentField\"\>", "\[Rule]", "34"}], ",", 
   RowBox[{"\<\"SecondArgumentField\"\>", "\[Rule]", 
    RowBox[{"-", "0.977530117665097`"}]}], ",", 
   RowBox[{"\<\"SumField\"\>", "\[Rule]", "33.0224698823349`"}], ",", 
   RowBox[{"\<\"DifferenceField\"\>", "\[Rule]", "34.9775301176651`"}], ",", 
   RowBox[{"\<\"ProductField\"\>", "\[Rule]", 
    RowBox[{"-", "33.2360240006133`"}]}], ",", 
   RowBox[{"\<\"QuotientField\"\>", "\[Rule]", 
    RowBox[{"-", "34.78153704482427`"}]}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->416522994]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: Calculator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 5.4438584}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Here is a simple calculator example using the GUIKit` package and \
Mathematica scripts for calculations. ", "synonyms" -> {}, "title" -> 
    "GUIKit Example: Calculator", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/Calculator"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 116, 5, 70, "Title",
 CellID->554471618],
Cell[850, 36, 34, 1, 70, "Text",
 CellID->7382063],
Cell[887, 39, 10154, 168, 70, "Graphics",
 CellID->609366553],
Cell[CellGroupData[{
Cell[11066, 211, 52, 1, 70, "SubsectionOpener",
 CellID->328534504],
Cell[11121, 214, 164, 5, 70, "Input",
 InitializationCell->True,
 CellID->9578261],
Cell[11288, 221, 252, 9, 70, "Input",
 InitializationCell->True,
 CellID->110664375],
Cell[CellGroupData[{
Cell[11565, 234, 61, 1, 70, "SubsubsectionOpener",
 CellID->424998509],
Cell[CellGroupData[{
Cell[11651, 239, 330, 10, 70, "Input",
 CellID->39151539],
Cell[11984, 251, 8482, 217, 70, "Output",
 CellID->477260661]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20527, 475, 46, 1, 70, "Section",
 CellID->424735882],
Cell[20576, 478, 226, 9, 70, "Text",
 CellID->954968],
Cell[CellGroupData[{
Cell[20827, 491, 125, 4, 70, "Input",
 CellID->804842438],
Cell[20955, 497, 606, 13, 70, "Output",
 CellID->416522994]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[21600, 515, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

