(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38406,        848]
NotebookOptionsPosition[     33394,        684]
NotebookOutlinePosition[     36714,        783]
CellTagsIndexPosition[     36642,        778]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Executing GUIs", "Title",
 CellTags->"Executing",
 CellID->2482719],

Cell[TextData[{
 "One of the most basic features of ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " is loading and executing an existing user interface application. This can \
be accomplished in one step in either a modal or modeless session with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel using ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Executing",
 CellID->12266160],

Cell[TextData[{
 "Load the ",
 StyleBox["GUIKit`", "MR"],
 " package before calling any ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " functions."
}], "Text",
 CellTags->"Executing",
 CellID->116921759],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Executing",
 CellLabel->"In[96]:=",
 CellID->397456822],

Cell[TextData[{
 "Here you load and execute an example user interface for a simple calculator \
that uses the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel for the calculations and, on closing, returns the results to the \
kernel."
}], "Text",
 CellTags->"Executing",
 CellID->207059706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/Calculator\>\"", 
  "]"}]], "Input",
 CellTags->"Executing",
 CellLabel->"In[97]:=",
 CellID->503275108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FirstArgumentField\"\>", "\[Rule]", "34"}], ",", 
   RowBox[{"\<\"SecondArgumentField\"\>", "\[Rule]", 
    RowBox[{"-", "0.977530117665097`"}]}], ",", 
   RowBox[{"\<\"SumField\"\>", "\[Rule]", "33.0224698823349`"}], ",", 
   RowBox[{"\<\"DifferenceField\"\>", "\[Rule]", "34.9775301176651`"}], ",", 
   RowBox[{"\<\"ProductField\"\>", "\[Rule]", 
    RowBox[{"-", "33.2360240006133`"}]}], ",", 
   RowBox[{"\<\"QuotientField\"\>", "\[Rule]", 
    RowBox[{"-", "34.78153704482427`"}]}]}], "}"}]], "Output",
 CellTags->"Executing",
 CellLabel->"Out[97]=",
 CellID->564355256]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous interface would look like on a \
typical platform.\
\>", "Text",
 CellTags->"Executing",
 CellID->136503601],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{270, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->149708522],

Cell[TextData[{
 "The ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " functions will search a path defined by the symbol ",
 Cell[BoxData[
  ButtonBox["$GUIPath",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/$GUIPath"]], "InlineFormula"],
 " to discover user interfaces so that only a short path to the definition is \
necessary."
}], "Text",
 CellTags->"Executing",
 CellID->249087475],

Cell["\<\
Here is another example that provides an input dialog for entering angles. \
With both examples, a modal session with the kernel is initiated so that \
control and the result is only returned to the kernel when the user is \
finished.\
\>", "Text",
 CellTags->"Executing",
 CellID->319303718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/AngleDialog\>\"", 
  "]"}]], "Input",
 CellTags->"Executing",
 CellLabel->"In[3]:=",
 CellID->183672338],

Cell[BoxData[
 FractionBox[
  RowBox[{"14", " ", "\[Pi]"}], "45"]], "Output",
 CellTags->"Executing",
 CellLabel->"Out[3]=",
 CellID->20141134]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous user interface would look like on \
a typical platform.\
\>", "Text",
 CellTags->"Executing",
 CellID->485981019],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{207, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->176181174],

Cell[TextData[{
 "You are also free to execute an interface in a modeless fashion. Executing \
the previous calculator example again with ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " immediately returns control to the kernel, but the calculator window \
continues to function. Also note that in a modeless session there is no way \
for the interface to return a custom result to the kernel when closed as the \
result value of the call to ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Executing",
 CellID->325609927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]], "Input",\

 CellTags->"Executing",
 CellLabel->"In[4]:=",
 CellID->358139978],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject180685885145089, 
   JLink`Objects`JavaObject471665540595713]]], "Output",
 CellTags->"Executing",
 CellLabel->"Out[4]=",
 CellID->68268357]
}, Open  ]],

Cell[TextData[{
 "The next two sections explain the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " expression that is returned from ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " and discuss some features of working with modeless windows. Also discussed \
is a technique of delaying the execution of the user interface, even if used \
with a modal session, so that you can customize its features before \
presenting it on screen."
}], "Text",
 CellTags->"Executing",
 CellID->705504987]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Executing GUIs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 14.5996396}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "One of the most basic features of GUIKit is loading and executing an \
existing user interface application. This can be accomplished in one step in \
either a modal or modeless session with the Mathematica kernel using \
GUIRunModal or GUIRun. Load the GUIKit` package before calling any GUIKit \
functions. Here you load and execute an example user interface for a simple \
calculator that uses the Mathematica kernel for the calculations and, on \
closing, returns the results to the kernel.", "synonyms" -> {}, "title" -> 
    "Executing GUIs", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/ExecutingGUIs"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Executing"->{
  Cell[731, 29, 73, 2, 70, "Title",
   CellTags->"Executing",
   CellID->2482719],
  Cell[807, 33, 646, 21, 70, "Text",
   CellTags->"Executing",
   CellID->12266160],
  Cell[1456, 56, 205, 9, 70, "Text",
   CellTags->"Executing",
   CellID->116921759],
  Cell[1664, 67, 158, 5, 70, "Input",
   CellTags->"Executing",
   CellID->397456822],
  Cell[1825, 74, 303, 9, 70, "Text",
   CellTags->"Executing",
   CellID->207059706],
  Cell[2153, 87, 168, 5, 70, "Input",
   CellTags->"Executing",
   CellID->503275108],
  Cell[2324, 94, 631, 14, 70, "Output",
   CellTags->"Executing",
   CellID->564355256],
  Cell[2970, 111, 161, 5, 70, "Text",
   CellTags->"Executing",
   CellID->136503601],
  Cell[16946, 350, 399, 13, 70, "Text",
   CellTags->"Executing",
   CellID->249087475],
  Cell[17348, 365, 302, 7, 70, "Text",
   CellTags->"Executing",
   CellID->319303718],
  Cell[17675, 376, 168, 5, 70, "Input",
   CellTags->"Executing",
   CellID->183672338],
  Cell[17846, 383, 143, 5, 70, "Output",
   CellTags->"Executing",
   CellID->20141134],
  Cell[18004, 391, 166, 5, 70, "Text",
   CellTags->"Executing",
   CellID->485981019],
  Cell[31501, 622, 707, 18, 70, "Text",
   CellTags->"Executing",
   CellID->325609927],
  Cell[32233, 644, 161, 5, 70, "Input",
   CellTags->"Executing",
   CellID->358139978],
  Cell[32397, 651, 286, 8, 70, "Output",
   CellTags->"Executing",
   CellID->68268357],
  Cell[32698, 662, 654, 17, 70, "Text",
   CellTags->"Executing",
   CellID->705504987]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Executing", 35129, 723}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 73, 2, 70, "Title",
 CellTags->"Executing",
 CellID->2482719],
Cell[807, 33, 646, 21, 70, "Text",
 CellTags->"Executing",
 CellID->12266160],
Cell[1456, 56, 205, 9, 70, "Text",
 CellTags->"Executing",
 CellID->116921759],
Cell[1664, 67, 158, 5, 70, "Input",
 CellTags->"Executing",
 CellID->397456822],
Cell[1825, 74, 303, 9, 70, "Text",
 CellTags->"Executing",
 CellID->207059706],
Cell[CellGroupData[{
Cell[2153, 87, 168, 5, 70, "Input",
 CellTags->"Executing",
 CellID->503275108],
Cell[2324, 94, 631, 14, 70, "Output",
 CellTags->"Executing",
 CellID->564355256]
}, Open  ]],
Cell[2970, 111, 161, 5, 70, "Text",
 CellTags->"Executing",
 CellID->136503601],
Cell[3134, 118, 13809, 230, 70, "Output",
 Evaluatable->False,
 CellID->149708522],
Cell[16946, 350, 399, 13, 70, "Text",
 CellTags->"Executing",
 CellID->249087475],
Cell[17348, 365, 302, 7, 70, "Text",
 CellTags->"Executing",
 CellID->319303718],
Cell[CellGroupData[{
Cell[17675, 376, 168, 5, 70, "Input",
 CellTags->"Executing",
 CellID->183672338],
Cell[17846, 383, 143, 5, 70, "Output",
 CellTags->"Executing",
 CellID->20141134]
}, Open  ]],
Cell[18004, 391, 166, 5, 70, "Text",
 CellTags->"Executing",
 CellID->485981019],
Cell[18173, 398, 13325, 222, 70, "Output",
 Evaluatable->False,
 CellID->176181174],
Cell[31501, 622, 707, 18, 70, "Text",
 CellTags->"Executing",
 CellID->325609927],
Cell[CellGroupData[{
Cell[32233, 644, 161, 5, 70, "Input",
 CellTags->"Executing",
 CellID->358139978],
Cell[32397, 651, 286, 8, 70, "Output",
 CellTags->"Executing",
 CellID->68268357]
}, Open  ]],
Cell[32698, 662, 654, 17, 70, "Text",
 CellTags->"Executing",
 CellID->705504987]
}, Open  ]],
Cell[33367, 682, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

