(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25139,        881]
NotebookOptionsPosition[     14945,        547]
NotebookOutlinePosition[     21234,        732]
CellTagsIndexPosition[     21161,        727]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUI Lifecycles", "Title",
 CellTags->"Lifecycles",
 CellID->161298071],

Cell[TextData[{
 "Normally a live ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " instance will shut down and dispose of itself through the normal user \
action of closing a window or other interface widget that performs the \
equivalent user interface closure. Sometimes, however, it is convenient to \
programmatically close a live modeless interface.",
 " ",
 "You can use ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 " on an active ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " instance to initiate a close action."
}], "Text",
 CellTags->"Lifecycles",
 CellID->721323347],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 " only initiates a close request on the active interface and will not \
necessarily force the removal of all interface resources like ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 " if an initial ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " has requested the interface live on past its closing by using the option \
",
 Cell[BoxData[
  RowBox[{"ReleaseMethod", "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 ". If you want to ensure the original lifecycle intent of a ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " call, it is recommended that you use ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 ", since this will still close and possibly remove all resources associated \
with an interface if ",
 Cell[BoxData[
  RowBox[{"ReleaseMethod", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " was used or also allow the interface to live on if ",
 Cell[BoxData[
  RowBox[{"ReleaseMethod", "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 " was used."
}], "Text",
 CellTags->"Lifecycles",
 CellID->600041655],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[1]:=",
 CellID->721298099],

Cell["\<\
Here you create a live user interface object by loading a calculator example.\
\
\>", "Text",
 CellTags->"Lifecycles",
 CellID->447610973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[2]:=",
 CellID->395919343],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject180685885145089, 
   JLink`Objects`JavaObject471665540595713]]], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[2]=",
 CellID->280317814]
}, Open  ]],

Cell[TextData[{
 "You can verify this user interface is active even if not displayed using ",
 Cell[BoxData[
  ButtonBox["GUIObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObjectQ"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Lifecycles",
 CellID->237677800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[3]:=",
 CellID->30699070],

Cell[BoxData["True"], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[3]=",
 CellID->517249381]
}, Open  ]],

Cell[TextData[{
 "Instead of closing the active window with the mouse, you programmatically \
request the window close using ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Lifecycles",
 CellID->206535338],

Cell[BoxData[
 RowBox[{"CloseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[4]:=",
 CellID->436273252],

Cell[TextData[{
 "You now see that ",
 Cell[BoxData[
  ButtonBox["GUIObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObjectQ"]], "InlineFormula"],
 " correctly reports this user interface, and its runtime representation as a \
",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " is no longer valid because ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " was initiated with the default ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " release method."
}], "Text",
 CellTags->"Lifecycles",
 CellID->789099310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[5]:=",
 CellID->159359075],

Cell[BoxData["False"], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[5]=",
 CellID->566360349]
}, Open  ]],

Cell[TextData[{
 "Here you request instead that the definition should still stay active after \
it is closed using the ",
 Cell[BoxData["ReleaseMethod"], "InlineFormula"],
 " option."
}], "Text",
 CellTags->"Lifecycles",
 CellID->750820283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"\"\<Wolfram/Example/Calculator\>\"", ",", " ", 
    RowBox[{"ReleaseMethod", "\[Rule]", "Manual"}]}], "]"}]}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[6]:=",
 CellID->576908187],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject180685885145089, 
   JLink`Objects`JavaObject471665540595713]]], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[6]=",
 CellID->437383598]
}, Open  ]],

Cell[TextData[{
 "Instead of closing the active window with the mouse, you programmatically \
request the window close using ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Lifecycles",
 CellID->253859637],

Cell[BoxData[
 RowBox[{"CloseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[7]:=",
 CellID->123128642],

Cell[TextData[{
 "Here you see that ",
 Cell[BoxData[
  ButtonBox["GUIObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObjectQ"]], "InlineFormula"],
 " correctly reports that this definition is still active because of the \
initial ",
 Cell[BoxData[
  ButtonBox["Manual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manual"]], "InlineFormula"],
 " release method."
}], "Text",
 CellTags->"Lifecycles",
 CellID->70528961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[8]:=",
 CellID->541301043],

Cell[BoxData["True"], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[8]=",
 CellID->698403432]
}, Open  ]],

Cell[TextData[{
 "You can force complete termination of the interface using ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Lifecycles",
 CellID->45261219],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[9]:=",
 CellID->2050676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[10]:=",
 CellID->84742328],

Cell[BoxData["False"], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[10]=",
 CellID->171245410]
}, Open  ]],

Cell[TextData[{
 "If you decided that you wanted to dispose of an active modeless interface \
either before or after it is already displayed, you can use ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 " to force shutdown and remove all resources allocated to the running user \
interface."
}], "Text",
 CellTags->"Lifecycles",
 CellID->545402385],

Cell[TextData[{
 "Here you gain access to the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " associated with an interface created in a modeless session."
}], "Text",
 CellTags->"Lifecycles",
 CellID->508122740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/AngleDialog\>\"", "]"}]}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[11]:=",
 CellID->81997542],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject180685885145089, 
   JLink`Objects`JavaObject471665540595713]]], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[11]=",
 CellID->711463949]
}, Open  ]],

Cell[TextData[{
 "Once you call ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 ", the interface is closed just as if the user themselves closed the user \
interface through normal interaction."
}], "Text",
 CellTags->"Lifecycles",
 CellID->14196679],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "ref", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[12]:=",
 CellID->411506652],

Cell[TextData[{
 "The resources and the ",
 Cell[BoxData["JavaObject"], "InlineFormula"],
 " associated with the user interface are now cleared."
}], "Text",
 CellTags->"Lifecycles",
 CellID->25487122],

Cell[CellGroupData[{

Cell[BoxData["ref"], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[13]:=",
 CellID->262111695],

Cell[BoxData[
 RowBox[{"GUIObject", "[", 
  RowBox[{
   TagBox[
    RowBox[{"Removed", "[", "\<\"JavaObject75641856720897\"\>", "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"Removed", "[", "\<\"JavaObject239886523170817\"\>", "]"}],
    False,
    Editable->False]}], "]"}]], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[13]=",
 CellID->204086684]
}, Open  ]],

Cell[TextData[{
 "You can also use the ",
 Cell[BoxData[
  ButtonBox["GUIObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObjectQ"]], "InlineFormula"],
 " function to determine a live ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " reference from one that is now shut down."
}], "Text",
 CellTags->"Lifecycles",
 CellID->296612549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[14]:=",
 CellID->275080581],

Cell[BoxData["False"], "Output",
 CellTags->"Lifecycles",
 CellLabel->"Out[14]=",
 CellID->560976234]
}, Open  ]],

Cell[TextData[{
 "However, it is probably more appropriate to use ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 " to only initiate the close action on the active interface. The reason for \
this is that ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " supports the option ",
 Cell[BoxData[
  RowBox[{"ReleaseMethod", "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 " to allow you to reuse a live definition even after it is closed and \
reopened."
}], "Text",
 CellTags->"Lifecycles",
 CellID->273242386],

Cell[TextData[{
 "A common useful technique that takes advantage of the ",
 Cell[BoxData[
  RowBox[{"ReleaseMethod", "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " is to define and use a single copy of a definition throughout a single \
kernel session, automatically handling the initial creation, as well as \
redisplaying it if it has happened to be closed manually by a user. The \
following wrapper function for requesting a specific interface definition \
supports all these concepts nicely, where ",
 Cell[BoxData["\"\<Wolfram/Example/PrimeFinder\>\""], "InlineFormula"],
 " represents the path to the definition you are interested in."
}], "Text",
 CellTags->"Lifecycles",
 CellID->175097136],

Cell[BoxData[
 RowBox[{
  RowBox[{"SingletonDialog", "[", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"GUIObjectQ", "[", "$SingletonDialogObject", "]"}]}], ",", 
      RowBox[{"$SingletonDialogObject", " ", "=", 
       RowBox[{
       "GUILoad", "[", "\"\<Wolfram/Example/PrimeFinder\>\"", "]"}]}]}], 
     "]"}], ";", 
    RowBox[{"GUIRunModal", "[", 
     RowBox[{"$SingletonDialogObject", ",", 
      RowBox[{"ReleaseMethod", "\[Rule]", "Manual"}]}], "]"}]}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[15]:=",
 CellID->367610896],

Cell[BoxData[
 RowBox[{"SingletonDialog", "[", "]"}]], "Input",
 CellTags->"Lifecycles",
 CellLabel->"In[16]:=",
 CellID->308581073]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUI Lifecycles - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 16.5526646}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Normally a live GUIObject instance will shut down and dispose of itself \
through the normal user action of closing a window or other interface widget \
that performs the equivalent user interface closure. Sometimes, however, it \
is convenient to programmatically close a live modeless interface. You can \
use CloseGUIObject on an active GUIObject instance to initiate a close \
action. Note that CloseGUIObject only initiates a close request on the active \
interface and will not necessarily force the removal of all interface \
resources like ReleaseGUIObject if an initial GUIRun has requested the \
interface live on past its closing by using the option ReleaseMethod->Manual. \
If you want to ensure the original lifecycle intent of a GUIRun call, it is \
recommended that you use CloseGUIObject instead of ReleaseGUIObject, since \
this will still close and possibly remove all resources associated with an \
interface if ReleaseMethod->Automatic was used or also allow the interface to \
live on if ReleaseMethod->Manual was used. Here you create a live user \
interface object by loading a calculator example.", "synonyms" -> {}, "title" -> 
    "GUI Lifecycles", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/GUILifecycles"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Lifecycles"->{
  Cell[731, 29, 76, 2, 70, "Title",
   CellTags->"Lifecycles",
   CellID->161298071],
  Cell[810, 33, 847, 24, 70, "Text",
   CellTags->"Lifecycles",
   CellID->721323347],
  Cell[1660, 59, 1896, 55, 70, "Text",
   CellTags->"Lifecycles",
   CellID->600041655],
  Cell[3559, 116, 158, 5, 70, "Input",
   CellTags->"Lifecycles",
   CellID->721298099],
  Cell[3720, 123, 148, 5, 70, "Text",
   CellTags->"Lifecycles",
   CellID->447610973],
  Cell[3893, 132, 198, 6, 70, "Input",
   CellTags->"Lifecycles",
   CellID->395919343],
  Cell[4094, 140, 288, 8, 70, "Output",
   CellTags->"Lifecycles",
   CellID->280317814],
  Cell[4397, 151, 285, 9, 70, "Text",
   CellTags->"Lifecycles",
   CellID->237677800],
  Cell[4707, 164, 137, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->30699070],
  Cell[4847, 170, 99, 3, 70, "Output",
   CellTags->"Lifecycles",
   CellID->517249381],
  Cell[4961, 176, 327, 10, 70, "Text",
   CellTags->"Lifecycles",
   CellID->206535338],
  Cell[5291, 188, 142, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->436273252],
  Cell[5436, 194, 768, 25, 70, "Text",
   CellTags->"Lifecycles",
   CellID->789099310],
  Cell[6229, 223, 138, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->159359075],
  Cell[6370, 229, 100, 3, 70, "Output",
   CellTags->"Lifecycles",
   CellID->566360349],
  Cell[6485, 235, 240, 7, 70, "Text",
   CellTags->"Lifecycles",
   CellID->750820283],
  Cell[6750, 246, 272, 7, 70, "Input",
   CellTags->"Lifecycles",
   CellID->576908187],
  Cell[7025, 255, 288, 8, 70, "Output",
   CellTags->"Lifecycles",
   CellID->437383598],
  Cell[7328, 266, 327, 10, 70, "Text",
   CellTags->"Lifecycles",
   CellID->253859637],
  Cell[7658, 278, 142, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->123128642],
  Cell[7803, 284, 445, 15, 70, "Text",
   CellTags->"Lifecycles",
   CellID->70528961],
  Cell[8273, 303, 138, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->541301043],
  Cell[8414, 309, 99, 3, 70, "Output",
   CellTags->"Lifecycles",
   CellID->698403432],
  Cell[8528, 315, 281, 9, 70, "Text",
   CellTags->"Lifecycles",
   CellID->45261219],
  Cell[8812, 326, 142, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->2050676],
  Cell[8979, 334, 138, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->84742328],
  Cell[9120, 340, 101, 3, 70, "Output",
   CellTags->"Lifecycles",
   CellID->171245410],
  Cell[9236, 346, 445, 11, 70, "Text",
   CellTags->"Lifecycles",
   CellID->545402385],
  Cell[9684, 359, 297, 9, 70, "Text",
   CellTags->"Lifecycles",
   CellID->508122740],
  Cell[10006, 372, 199, 6, 70, "Input",
   CellTags->"Lifecycles",
   CellID->81997542],
  Cell[10208, 380, 289, 8, 70, "Output",
   CellTags->"Lifecycles",
   CellID->711463949],
  Cell[10512, 391, 348, 10, 70, "Text",
   CellTags->"Lifecycles",
   CellID->14196679],
  Cell[10863, 403, 140, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->411506652],
  Cell[11006, 409, 201, 6, 70, "Text",
   CellTags->"Lifecycles",
   CellID->25487122],
  Cell[11232, 419, 98, 3, 70, "Input",
   CellTags->"Lifecycles",
   CellID->262111695],
  Cell[11333, 424, 378, 13, 70, "Output",
   CellTags->"Lifecycles",
   CellID->204086684],
  Cell[11726, 440, 437, 14, 70, "Text",
   CellTags->"Lifecycles",
   CellID->296612549],
  Cell[12188, 458, 134, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->275080581],
  Cell[12325, 464, 101, 3, 70, "Output",
   CellTags->"Lifecycles",
   CellID->560976234],
  Cell[12441, 470, 744, 22, 70, "Text",
   CellTags->"Lifecycles",
   CellID->273242386],
  Cell[13188, 494, 905, 21, 70, "Text",
   CellTags->"Lifecycles",
   CellID->175097136],
  Cell[14096, 517, 672, 19, 70, "Input",
   CellTags->"Lifecycles",
   CellID->367610896],
  Cell[14771, 538, 132, 4, 70, "Input",
   CellTags->"Lifecycles",
   CellID->308581073]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Lifecycles", 17308, 594}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 76, 2, 70, "Title",
 CellTags->"Lifecycles",
 CellID->161298071],
Cell[810, 33, 847, 24, 70, "Text",
 CellTags->"Lifecycles",
 CellID->721323347],
Cell[1660, 59, 1896, 55, 70, "Text",
 CellTags->"Lifecycles",
 CellID->600041655],
Cell[3559, 116, 158, 5, 70, "Input",
 CellTags->"Lifecycles",
 CellID->721298099],
Cell[3720, 123, 148, 5, 70, "Text",
 CellTags->"Lifecycles",
 CellID->447610973],
Cell[CellGroupData[{
Cell[3893, 132, 198, 6, 70, "Input",
 CellTags->"Lifecycles",
 CellID->395919343],
Cell[4094, 140, 288, 8, 70, "Output",
 CellTags->"Lifecycles",
 CellID->280317814]
}, Open  ]],
Cell[4397, 151, 285, 9, 70, "Text",
 CellTags->"Lifecycles",
 CellID->237677800],
Cell[CellGroupData[{
Cell[4707, 164, 137, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->30699070],
Cell[4847, 170, 99, 3, 70, "Output",
 CellTags->"Lifecycles",
 CellID->517249381]
}, Open  ]],
Cell[4961, 176, 327, 10, 70, "Text",
 CellTags->"Lifecycles",
 CellID->206535338],
Cell[5291, 188, 142, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->436273252],
Cell[5436, 194, 768, 25, 70, "Text",
 CellTags->"Lifecycles",
 CellID->789099310],
Cell[CellGroupData[{
Cell[6229, 223, 138, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->159359075],
Cell[6370, 229, 100, 3, 70, "Output",
 CellTags->"Lifecycles",
 CellID->566360349]
}, Open  ]],
Cell[6485, 235, 240, 7, 70, "Text",
 CellTags->"Lifecycles",
 CellID->750820283],
Cell[CellGroupData[{
Cell[6750, 246, 272, 7, 70, "Input",
 CellTags->"Lifecycles",
 CellID->576908187],
Cell[7025, 255, 288, 8, 70, "Output",
 CellTags->"Lifecycles",
 CellID->437383598]
}, Open  ]],
Cell[7328, 266, 327, 10, 70, "Text",
 CellTags->"Lifecycles",
 CellID->253859637],
Cell[7658, 278, 142, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->123128642],
Cell[7803, 284, 445, 15, 70, "Text",
 CellTags->"Lifecycles",
 CellID->70528961],
Cell[CellGroupData[{
Cell[8273, 303, 138, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->541301043],
Cell[8414, 309, 99, 3, 70, "Output",
 CellTags->"Lifecycles",
 CellID->698403432]
}, Open  ]],
Cell[8528, 315, 281, 9, 70, "Text",
 CellTags->"Lifecycles",
 CellID->45261219],
Cell[8812, 326, 142, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->2050676],
Cell[CellGroupData[{
Cell[8979, 334, 138, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->84742328],
Cell[9120, 340, 101, 3, 70, "Output",
 CellTags->"Lifecycles",
 CellID->171245410]
}, Open  ]],
Cell[9236, 346, 445, 11, 70, "Text",
 CellTags->"Lifecycles",
 CellID->545402385],
Cell[9684, 359, 297, 9, 70, "Text",
 CellTags->"Lifecycles",
 CellID->508122740],
Cell[CellGroupData[{
Cell[10006, 372, 199, 6, 70, "Input",
 CellTags->"Lifecycles",
 CellID->81997542],
Cell[10208, 380, 289, 8, 70, "Output",
 CellTags->"Lifecycles",
 CellID->711463949]
}, Open  ]],
Cell[10512, 391, 348, 10, 70, "Text",
 CellTags->"Lifecycles",
 CellID->14196679],
Cell[10863, 403, 140, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->411506652],
Cell[11006, 409, 201, 6, 70, "Text",
 CellTags->"Lifecycles",
 CellID->25487122],
Cell[CellGroupData[{
Cell[11232, 419, 98, 3, 70, "Input",
 CellTags->"Lifecycles",
 CellID->262111695],
Cell[11333, 424, 378, 13, 70, "Output",
 CellTags->"Lifecycles",
 CellID->204086684]
}, Open  ]],
Cell[11726, 440, 437, 14, 70, "Text",
 CellTags->"Lifecycles",
 CellID->296612549],
Cell[CellGroupData[{
Cell[12188, 458, 134, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->275080581],
Cell[12325, 464, 101, 3, 70, "Output",
 CellTags->"Lifecycles",
 CellID->560976234]
}, Open  ]],
Cell[12441, 470, 744, 22, 70, "Text",
 CellTags->"Lifecycles",
 CellID->273242386],
Cell[13188, 494, 905, 21, 70, "Text",
 CellTags->"Lifecycles",
 CellID->175097136],
Cell[14096, 517, 672, 19, 70, "Input",
 CellTags->"Lifecycles",
 CellID->367610896],
Cell[14771, 538, 132, 4, 70, "Input",
 CellTags->"Lifecycles",
 CellID->308581073]
}, Open  ]],
Cell[14918, 545, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

