(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14658,        429]
NotebookOptionsPosition[     10814,        303]
NotebookOutlinePosition[     12999,        368]
CellTagsIndexPosition[     12926,        363]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: Hello World"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->544188069],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{123, 48},
 CellID->166742933],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->30971541],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->65022972],

Cell[BoxData[
 RowBox[{
  RowBox[{"HelloWorld", "[", "]"}], " ", ":=", 
  RowBox[{"GUIRunModal", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", " ", "\[IndentingNewLine]", " ", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Label\>\"", ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello World!\>\""}], "}"}]}],
        "]"}], "\[IndentingNewLine]", " ", "}"}]}], " ", "]"}], 
   "\[IndentingNewLine]", "   ", "]"}]}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->252196508]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->305259809],

Cell[TextData[{
 "This example displays the classic simple \[OpenCurlyDoubleQuote]Hello World\
\[CloseCurlyDoubleQuote] application using",
 " ",
 "the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " framework."
}], "Text",
 CellID->666915999],

Cell[BoxData[
 RowBox[{"HelloWorld", "[", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[3]:=",
 CellID->35095001],

Cell[CellGroupData[{

Cell["Optional additional forms achieving the same result", \
"SubsubsectionOpener",
 CellID->78023981],

Cell["\<\
The following are other variants on the basic theme of specifying the user \
interface definition.\
\>", "Text",
 CellID->385024172],

Cell[TextData[{
 "Here you choose to pass arguments to the constructor of the label widget \
instead of setting the ",
 StyleBox["\"text\"", "MR"],
 " property."
}], "Text",
 CellTags->"HelloWorld",
 CellID->962297790],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", " ", "\[IndentingNewLine]", " ", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", "  ", 
     RowBox[{"Widget", "[", 
      RowBox[{"\"\<Label\>\"", ",", "  ", 
       RowBox[{"InitialArguments", " ", "\[Rule]", " ", 
        RowBox[{"{", " ", "\"\<Hello World!\>\"", "}"}]}]}], "]"}], "   ", 
     "\[IndentingNewLine]", "    ", "}"}]}], " ", "]"}], "   ", 
  "]"}]], "Input",
 CellTags->"HelloWorld",
 CellLabel->"In[4]:=",
 CellID->174466461],

Cell["\<\
Technically, even this version will work since frame and content panes will \
be automatically wrapped if not included.\
\>", "Text",
 CellID->292204917],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", " ", "\[IndentingNewLine]", " ", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Label\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello World!\>\""}], "}"}]}], 
   "]"}], "\[IndentingNewLine]", "   ", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->140927484],

Cell["You could add extra layout options to center the text.", "Text",
 CellID->510614159],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", " ", "\[IndentingNewLine]", " ", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Label\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello World!\>\""}], ",", 
      "\[IndentingNewLine]", " ", 
      RowBox[{"\"\<horizontalAlignment\>\"", " ", "\[Rule]", " ", 
       RowBox[{"PropertyValue", "[", "\"\<Center\>\"", "]"}]}]}], "}"}]}], 
   "]"}], "\[IndentingNewLine]", "   ", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->67605880],

Cell[TextData[{
 "The ",
 StyleBox["\"Panel\"", "Program"],
 " and ",
 StyleBox["\"Label\" ", "Program"],
 "widget controls simply wrap the Java Swing controls, which you can also \
call",
 " ",
 "directly, either the ",
 Cell[BoxData["Swing"], "InlineFormula"],
 " or ",
 Cell[BoxData["AWT"], "InlineFormula"],
 " versions:"
}], "Text",
 CellTags->"HelloWorld",
 CellID->510623705],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", " ", "\[IndentingNewLine]", " ", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<class:javax.swing.JPanel\>\"", ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", "     ", 
     RowBox[{"Widget", "[", 
      RowBox[{"\"\<class:javax.swing.JLabel\>\"", ",", "  ", 
       RowBox[{"{", " ", 
        RowBox[{"\"\<text\>\"", "->", "\"\<Hello World!\>\""}], "}"}]}], 
      "]"}], "   ", "\[IndentingNewLine]", "    ", "}"}]}], " ", "]"}], "   ",
   "]"}]], "Input",
 CellTags->"HelloWorld",
 CellLabel->"In[7]:=",
 CellID->253860115],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", " ", "\[IndentingNewLine]", " ", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<class:java.awt.Panel\>\"", ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", "     ", 
     RowBox[{"Widget", "[", 
      RowBox[{"\"\<class:java.awt.Label\>\"", ",", "  ", 
       RowBox[{"{", " ", 
        RowBox[{"\"\<text\>\"", "->", "\"\<Hello World!\>\""}], "}"}]}], 
      "]"}], "   ", "\[IndentingNewLine]", "    ", "}"}]}], " ", "]"}], "   ",
   "]"}]], "Input",
 CellTags->"HelloWorld",
 CellLabel->"In[8]:=",
 CellID->469775594],

Cell["Here we also try this using an XML definition equivalent.", "Text",
 CellTags->"HelloWorld",
 CellID->163348176],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", 
  RowBox[{"ImportString", "[", 
   RowBox[{
   "\"\<\n<widget src='Panel'>\n  <group>\n    <widget src='Label'>\n    \
<property name='text'>\n    <string value='Hello World!'/>\n    </property>\n \
   </widget>\n  </group>\n</widget>\n\>\"", ",", " ", "\"\<GUIKitXML\>\""}], 
   "]"}], "]"}]], "Input",
 CellTags->"HelloWorld",
 CellLabel->"In[9]:=",
 CellID->162385974]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: Hello World - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 17.4276198}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example displays the classic simple 'Hello World' application using \
the GUIKit framework. The following are other variants on the basic theme of \
specifying the user interface definition.", "synonyms" -> {}, "title" -> 
    "GUIKit Example: Hello World", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/HelloWorld"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "HelloWorld"->{
  Cell[6801, 178, 218, 7, 70, "Text",
   CellTags->"HelloWorld",
   CellID->962297790],
  Cell[7022, 187, 545, 13, 70, "Input",
   CellTags->"HelloWorld",
   CellID->174466461],
  Cell[8693, 235, 382, 15, 70, "Text",
   CellTags->"HelloWorld",
   CellID->510623705],
  Cell[9078, 252, 568, 13, 70, "Input",
   CellTags->"HelloWorld",
   CellID->253860115],
  Cell[9649, 267, 560, 13, 70, "Input",
   CellTags->"HelloWorld",
   CellID->469775594],
  Cell[10212, 282, 118, 2, 70, "Text",
   CellTags->"HelloWorld",
   CellID->163348176],
  Cell[10333, 286, 415, 10, 70, "Input",
   CellTags->"HelloWorld",
   CellID->162385974]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"HelloWorld", 12275, 338}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 117, 5, 70, "Title",
 CellID->554471618],
Cell[851, 36, 36, 1, 70, "Text",
 CellID->544188069],
Cell[890, 39, 4301, 72, 70, "Graphics",
 CellID->166742933],
Cell[CellGroupData[{
Cell[5216, 115, 51, 1, 70, "SubsectionOpener",
 CellID->30971541],
Cell[5270, 118, 165, 5, 70, "Input",
 InitializationCell->True,
 CellID->65022972],
Cell[5438, 125, 629, 16, 70, "Input",
 InitializationCell->True,
 CellID->252196508]
}, Closed]],
Cell[CellGroupData[{
Cell[6104, 146, 46, 1, 70, "Section",
 CellID->305259809],
Cell[6153, 149, 245, 9, 70, "Text",
 CellID->666915999],
Cell[6401, 160, 124, 4, 70, "Input",
 CellID->35095001],
Cell[CellGroupData[{
Cell[6550, 168, 103, 2, 70, "SubsubsectionOpener",
 CellID->78023981],
Cell[6656, 172, 142, 4, 70, "Text",
 CellID->385024172],
Cell[6801, 178, 218, 7, 70, "Text",
 CellTags->"HelloWorld",
 CellID->962297790],
Cell[7022, 187, 545, 13, 70, "Input",
 CellTags->"HelloWorld",
 CellID->174466461],
Cell[7570, 202, 163, 4, 70, "Text",
 CellID->292204917],
Cell[7736, 208, 335, 8, 70, "Input",
 CellID->140927484],
Cell[8074, 218, 90, 1, 70, "Text",
 CellID->510614159],
Cell[8167, 221, 523, 12, 70, "Input",
 CellID->67605880],
Cell[8693, 235, 382, 15, 70, "Text",
 CellTags->"HelloWorld",
 CellID->510623705],
Cell[9078, 252, 568, 13, 70, "Input",
 CellTags->"HelloWorld",
 CellID->253860115],
Cell[9649, 267, 560, 13, 70, "Input",
 CellTags->"HelloWorld",
 CellID->469775594],
Cell[10212, 282, 118, 2, 70, "Text",
 CellTags->"HelloWorld",
 CellID->163348176],
Cell[10333, 286, 415, 10, 70, "Input",
 CellTags->"HelloWorld",
 CellID->162385974]
}, Closed]]
}, Open  ]]
}, Open  ]],
Cell[10787, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

