(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34007,        828]
NotebookOptionsPosition[     27459,        619]
NotebookOutlinePosition[     31768,        742]
CellTagsIndexPosition[     31659,        736]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Interacting with GUIs", "Title",
 CellTags->"InteractingIntro",
 CellID->486709749],

Cell[TextData[{
 "This tutorial discusses how the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " expression for a running GUI can be a handle to the widgets that make up \
the interface. This lets you get runtime information about the GUI, and can \
be a useful technique for learning about how GUIs work and how to develop \
them."
}], "Text",
 CellTags->"InteractingIntro",
 CellID->77467686],

Cell[CellGroupData[{

Cell["GUI Information", "Section",
 CellTags->"Referencing",
 CellID->23288840],

Cell[TextData[{
 "With a ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"], " "}]], "InlineFormula"],
 ", you can discover what special widgets are registered with unique \
reference string names. Using these names, you can modify and further \
discover member information about these widgets, such as what properties, \
method functions, and events exist to control them. More information on \
widget properties and names can be found in the sections ",
 ButtonBox["Widget Basics",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
 ", and",
 " ",
 ButtonBox["GUI Building Blocks",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"],
 "."
}], "Text",
 CellTags->"Referencing",
 CellID->263117627],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[109]:=",
 CellID->327580673],

Cell[TextData[{
 "This gains access to the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " associated with an interface created in a modeless session."
}], "Text",
 CellTags->"Referencing",
 CellID->56095317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/AngleDialog\>\"", "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[110]:=",
 CellID->714792644],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject275325187522561, 
   JLink`Objects`JavaObject207392562216961]]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[110]=",
 CellID->23450406]
}, Open  ]],

Cell[TextData[{
 "You can easily take a dynamic snapshot of the interface by calling the \
utility ",
 Cell[BoxData[
  ButtonBox["GUIScreenShot",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIScreenShot"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"Referencing",
 CellID->57228793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[111]:=",
 CellID->466067545],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztfAd8VUX2/8srCQFCDQgSmkCAUEwo0gxFOiGBhAQSQkICJIQuRVCEtaxu
1vZbWF1ZXQtYUFSwrIggwiIquuJSlF7SXn/peS8vgcD3f87ce19ekvdCENzy
+fs+n7n3zsyZM2fO+c6ZM3NvEpm6JiNtWeqaRfNTu0xclXp/xqL5q7tMWLGK
ijQ+KpXqGKWPuqj4GfSoXDRQBb4EVetnOamOiqtKpYWq7S6oOm2V07Ym/KDj
p8b8RJeOIsuXjlt9uUKnlG1zVUhPjeVmHd0qGrtY6Wo+tanZNpDLWBwhxpuc
g6rD33xkOYmm/TE0CjuHVjEGtF1ciEZxl6jUb5r1EFSTSnh44Reh6neAhVMp
zTSiiUL+PfItZ32Y0Iep/neIophI5YsC63kUFWShrMSEckcBnOVFqCgvboUK
Z3ELXLlSruEn0mKFsxSVFaV0L6EGl33rb9+BW7Wvp73OXchO9QqphdX4Mz9h
40vvo0f8Ez2huncNFd8R+TssffZtOOw26rfQ1zP1MM/UNyWAIecYFmZuRc/I
JxG58VAvLHq8kEg5u+SZN5mlyrcW6ZSVz+PNXZ8Owenj31DlqeNf49Sxw/h4
z2eYtHyT0uwmpNAg7/JRMYqndupVIeKqEfmyEqOg0Mk2UegOHvkncrNOI/vy
z8i5fGowZ6iaHpF18SQunPkRn335pcLCqyh+A+rCJu/yD6xWFkIkm82AfJuh
G12MVM1ZiznHVc2kJYW5vq6BSK2ZWM3EVJYvOBhF2cBabPS555F96WeFjSLp
SAHwbfVJqnX19QyJQSkYxcVW0lRRoVkq+tAgqosLc1S1xSsutqmGudFbhSjn
XPS/SI7/+9CI/9tlCBbciW+RRRQ955Ij2wUlpUlJST6noW5NbNY8GHIvuJr8
IlE2f2yiZGzGzDUQ5PSkEo9Kp2SfumWNxVXH8ihMvApfWlrAqVYnarGEaAVH
hbMXAaobiacbyZNv08OYd/HWNPPCp2a88HdzAPEt4IVC9FXgSipZDm91Srvi
4nz8hVhx8q6fQk5SEz9P7Gp2KWlO414py6KpQaxpYFlTN1l5DhrzLt1Yd558
pDKgv35upWRpylaX+5IxQLmaZZJMdemaiKtO2PcliZ1X/ZWVFXLy1J1WXP3c
y5RuvXavEpHBjUXnXGM3MQvyDTDp66quQcuLMpZXvrDi1f22pjwguS95eJTj
q6+rTI7ClOdmoloIjle/sBEnm1eN2e1FnDz1ouOrVlaM0g1XqGsRS2qiJ50H
4iZuwhQWGGE2XL41vWw9kM+JJS5yCVEk5/iqdZXJd7WilCIhRyG2HSiglF+P
Uoo5eepCK66+7mV1ulLXaqcopSFlTd3ELCwwkbqybk1dbx8qwFtfFTTlAcl9
ycOjXM0yya3UpZPa6oSMbx8uxNtfFXpVncNRwslTdzq+ym6b81r3jiW/rhBo
apHWZNTYTR5eii3G7FvT0Y5vivDut8UBLLnsxeVxiCTpxXud0o7lY1acvOmn
vLyUqEvr66q9qNO419GQq7sopiXfamrAkP3Cznod8s7virHzSEkzFkhWOT3J
vbKQnFN7KGssrjoh2c4jxfiAkvfBlnGq7uTOGzAsKbbCRoGV56Fta9jQPv6h
lFMwdy34lkpFR0vrEdTOaahbkxIKH2zm3FsT5dMfy7D7X2XBqKgoJw5OpwOf
/ksU1RKlOs6sqHBSnFlNX1ZSSPsq463Jsee4HZ+fsAfTHqySOFy5UkFZBz4/
7vAqx5UrV0iOanqHvZTorDeWo+5E0yH3ksR0308OSuWoqqpSBdP1Ksm476RU
xvW0efSt1eTatSqRuMlQucnVq1dQbi9Vmrgik0s33ONK46ONIPb/XE77Jr5q
RJ73rtX7pmq6g/+6qBqO69evU7/Xr1+j/AWF/qb7ffgv7/I2UdUb/zJB3jI+
/OJ7NJtP1YAk08VtfAP/OHZpGOhHxaeyzKJIJr+JrmkXmn0MxtwTgm2tHfPC
P26FWf8TJ1/P1MM8U9/U2ElgwZZsqmqDnIv/bIFLpw9r+Ik4s6V51ExBlL4e
GnVi0vb1NPIqjp+HsxBBVHPq/I8Q1fXw/3Gi8Ev/y0TeoNKSid7hudeyweTb
8fabW6iCf3zkxDBu3uDWVEbNlcaqNzyUtfhVmNVdR35jdrPMGv3G7H+XmbRm
3ASzO8TVD2fOHcNrH32O+I0vo/us34s756lc1ZppxA4nuAHUo2+neG3EtQms
5jPYtf8AusY+juWbdmLf96dR5ijH/h/O4f7NH4pyric6uY0UmCu+q6snPn/6
AHu/O4VSu4P4nK3DZ+SvMRBmPuexN/DZNycpJC5HZWUFB6YcDFJoeA37j55D
ypPbmU4Ko5QDRR6J24jkfY4XAqWgmqrWUzM3cRIf24bdXx+nnYLdJRJHpRyp
uouj86BXdT0iehHMaxNFwFpdiNwdt9MWgeIaIFDMBv/74WO0/+bNaZlXmzAd
o1vrUQkqRXalXBqlG52q5sg9Efu5M62tmTqq8VTGuca1BvfJoR9RUlIkD9Cz
hWsOTudJjlu09I2V42ksgfVZ/WbdpmJ19lOLnnkHRUX5QjHmQiNePvpXdH+x
O/76/RYUlhW4LM8ugehlxdRvIN0vMKKUq1vm66GsiZv8GU9tR36+xTUGb8at
Kb9nw3oHls697KaBWNvI1V7wNhuUF59dB75zKWTrydcQ8m5P3PVGF7T+cwv8
9bstrunM6wXRywrx9WYs3c2AtjaxlKuB/2Zuor6/71uYzYYb2o+XpGpRPehW
20AhG0zs8mXtfg0zcZyQlZMFq9Uoxh55cAruOzwKQ/cORtdtXRH8YjeX5+Wl
nehvv7d1Vdxmb8uDO3/xPAyG3Bsal+MN1+DUaKBEN142tTWmq4vtf8jNSlD/
BiZTnjD5jovbEXcqGmPJ5L3fDRYuV9EIR3MMdZ23MebXDXh8aytBuatrUtd6
CnAT7509h5Cbe/mGRuMg0dNMVNXtrb6VsNon1DVVtYD1Rjq3sualZ75JI80R
Bsk1XxYG4TnI7pLXQCX64fCa14xGHpDS143fgj9sQ3b2hRtqkMNs5tfKA79e
v8Zglchnx97DrgErTsddOA7BlcinvsEq/LbvPljvgDmGVvjVHiyj4rYO1n0/
MWvDK14Hy7Et7zc4gB/m1iZu/cteB8QhI28KuE29m6BfKrT7LoxhyX6ClwZe
xTk0c9+FDfPQhqHHk5c9Li+nHA41eOd2s0I3ZIcc3gCaevfFt/UM4DdmvzH7
jdn/l8zO/sbsJpm5fy3niZmISbXVoVuj+qJ0vqtrBnx/rEeYer9I9SSM173g
Tezf1bXq3IahyvxvE9bTmeMfbpeQ9FNp5Ktbx/Vs/uo5ERFmF0N+Umb5y+Tz
ld+81RXIy/7u5q0s6v5Q3xu+uh8cVc+4drW0U21WbW1JqqdC9QQSDf92ax3V
LPPzUPb67eygNghZh9sa0sH3t0TkDg3vb4P/vURe/xzjv5/Ii8Y7/ueI/DwR
1f124tcgms1EKXjk1b3NG0xOZUTv8pxzZDfHZcpMCfDGrNEtMPPwkXb9zGbJ
zHi+KmXqX9rBBJf7avFrdzXFg+8J+LU7Ffb3ft7tedFxO8ry4Cpv6uXezdE3
8HzN8xuW26pDv9o69NhpA850b0Dj6VVQQ47AvZfduK1LtpuwjLJI3oqS6/3q
99aUfON3bg15x+f9PdcvfZ3gOXpr8l+tTE/ewtflJhuAS01Diav1VCe2FEL4
/Vv05OkFn9cp4/2lophMugbQeJ/KN9fuf2wa15wKCiSqvbpH/65SdFrf2xXf
GxHczLub27+23LS+/D2U9fdQ9u9xIzVm4n9cpNsREP77O3Dfw9y2Drx9yv4f
6aDe7cINmdXcqvyifxLgP+j8fx2RnweiEefp0nXHfzMR+c87j1FptpQissl1
jj1GbX3GHoPPuOOcyEmpxx/X8KOay1UaqYYpKDeAc6HcLIzznWQGgl//i1AN
OMT/mKLNn4VrqdUbKfIo04tu1FI3qinko30iLzKP6UQRmUf3XI526UplM3L4
SclNz53HJNT/hGzOM8+IPJHzVcrGkhSjReJcuLiOPC+VSbnRNcpGnufehp/j
E+KhZ/kJqsFnpWe+s+xDrTwyVuMzYt1yDSzCJokcm8dM4o2s4ngqm5MPVUoh
VHNLNdCklWihybBTp5qMK/BZLBJR8pUESbsGnwWVnFQ0sJRKvlSJJ1bhnErO
SveECqhmO6iHMpr45aJHJ/c4qxyqODtU0Xa+q/lBy08saXQxVFOLpLtEw+2m
lpG+Jhb58NB83MfmV3Ns8TSGxFLlTi01KfxngZrUch4Rj4dyvosr6bK0yg+a
JVfJrouvh3HNCB4aVevSryL9bw7hR5rL3sRQcE2UUR2LQ3Qk8IIqhDx8FZmf
XKNUpUHmx+JyVYvMj4hv5odXaECZu64gc+cVrHujEiGrnFAlVzCHOZXcU2I5
0l8sdevJD4b8KqRvKoFuWimPmFBiVeypqj3o3BqD9klx8EAZqWmVsvFoqDxS
KvNbcY3m3KprWviuvE6Vq0CX5ejJwycw6tKcaBT5E/xD30Xjdr+H/7DdnB8l
qttg4WvlOH6+BL1mHkbAqM/QctyXaDX+CwSO34tW4/ai9fj9aD3hS7QYfwAB
4/+BxuMPodG4w/Ad8w9oRv0DPqMOk7wH0DlqL46dLWB+KqF5QnGf31Vh+esO
tEm4BL/I0/Cfdg6No86iSdQZup9Rc4bWc38q8os6B9+o89BGXoAm4hzUk8/B
Z9IFqMafRYuoU1j+YjFCVjpZwSlVqvZI31KGwtPHsXtcL2zvE4APQlvi/bBW
2DEgEDtCW+GDAa2xk9KusBb4ODQAn/RvjE/7NcLHIb74uJcGn/b0wa7uKnxw
b2dYfz6G9OdLGIuSYWoZRVvbKGq2CBVL4Lsi2WNplTCFmk3hC78119Uue/Ri
e5A+Fu8ATl6yo6KySixpxeXAiZxKySxjDgqzjZDtYii8hl7JWWg9LQsd4rLQ
dXYueszJQXBSNrrTvVtyLrpS6kSpw1wD2iYb0DrJiGaJBvjHG6GNNcInikQe
/xPZ5nN5OWbeOqzbUYU2STY0jrOhGTmJlrP5n1kEzrapmqH1bBtaJ3KZDS0o
NU8sQNPZBWicUAC/+HzoZhZAPaOAeJOSJuehBUEr8x2nYheeTj9O7oWjQ1vj
6MgOODauK45N7EEpGMcmdMfxid1wYkJXnBzfCafGd8Cp+9ri9OjWOBXeDKeH
+ePUYC1OhPrgqxAV3ifbCLm92MW3zmSRJ0ozxMXFqcR8YPUrScv67SFjM6fg
OiquXMefdtu5BH8/eV10ZrXZeaqMlM3Av2bTCxCUWIRe84txd0YxBi4pwaCl
JQhbWoqwZaXov6IUIfeXosf9Zei8ogztl9nRerEdAel2+KWUQT2bPF4kSTl8
r5sZ/NirwC+2FM1nl6JNcinap5Siw7xSBM1j/3ZnapmqKdpRvi2lwHllaJFa
hoAUOxonE99EO7SzyuAzg3FLehlTwwz8OzukGS6MDcKlqb1wOeZuZMUNRPas
QciOC0P2zDDkzOyP3LgQ6Gf0gH56ZximkvkmtYZhbAD0I/2QPVSNE3er8F43
lTczKKtr55M1fdZcyWe9vm0rGUmv5//Gk3v+AkxmMyeyjM1mozKqZ5OI2UFz
ainNFsln1fBXdG80+Uf4JtkU/PrFXq7hznTzy2SlkiNMNIlySsRIUjSz47JG
0edcz8RO1Ko5JxqLJ1UrbPzkOt77R4HCBY/98aAYP89a5s5o4dYsgV98nsh7
kEjm6T/qgMbDUwd+aiLWGwlkgTPL0GOeHWFL7Bi20o7wNQ5K5RjxgAPD1jow
ZJ0DAx4sR98HneixzonOa51oT6tOy+UVaJLhhI6AoZ5Bcz78gAwy5k2r1EdX
0GSmHYFz7AQpOzotYF11SbPTXO+cRvm0MnRcUIY7F9hxxwIHAim1mO8QQPNP
csA3gRbXOAJapA0+Y04h822HtMhJILt0byCyI3ogJzYMeYnDoE8Oh34upeQR
MCQPozQExqQBMCX2hXlWD1hiO8MyvT0sU1rCPK4J9OE6nB6oxofBPhLI3BfG
sG9dIKOQqNtpORowSZFNNciwaNEiNeNMLeDljwsXLuCbZ54Vd4KaAB4/853z
DEzZPhT6SKpqgZMXSl2umV3DOWMVXnvrX8KoHBcdPOFARcVVUV/iuIZHXzhB
cDol6t75vkpsdnxF9OSHE5fKBd13F67iRFaleGZeuqRCeVfk6+Kr/Dh/znRd
K6pb0upwndkKkr99VSVE273v3A1FsZRch7WwEv7h+3lWLeCI4UZlHbisiXAe
OsG0XUIZ+lNcNZygeN86B42IhfJHyIYKdF9fgY7rKtBmdQWaLa2A/3w7LQs0
MUYdVKAn+GTuqkQAwbpdMvlF8mHd0spotX/2VZOqC/xml0EXVwINLSM+Y35G
5lt2KaqMd4r+L49uh5zo/sibMxz6effBcWi3KDemjaU0BsYF4TDNGwpzygBY
5oTAmtBd1Ds/3wbLpGYwjPbHmXt0+KinuhpXY8wSrvp+p8BKWw0rBl00uRjC
FWGBUUWAciVGD9+/z1gIS2I09u3bJ6GM7ode2CyQVVZWJrm0jCsiUpMUrYOl
6Kow1o5DpRxL49k9VTIG/ITNvzx9Tch48HAWPjl2TWDvyMVrQo9sKM7L+OA4
msq0OJ4jtWHnRG0USHGWu3CHFOWlaq3Istn5t3nLEcnjNUWjUV9Dm1AoWrp1
5k0wtcSSGGk8PPUUEkoo6pRUhnuWE4LIgU1+uBpF/TaSEyMUdSIU3UEoarnM
KVbLJgkmEVgqKKok55i5swItZpag49wSdJtfgp5pJYwh9EwvRXB6CXpQ/q70
YnJmxQhaUIx2tEoHppagxVyJzj+hBH5xRRRdmqHhVfJNXl2lPQn/sigSyY2/
R6DMsHCySvqeQwdjxniYFo6BacEImOcNhjW5n1znL7yXcVwAzoxogo/7+EoI
YwAxwnghdFseW8nLI0NMT/1apT0ZeS/GyurVqwV2GFu7IyJx/Mi3OJMwC7mL
opG1Mgk/LJ6NQ9264dO//10tr6QvPP88o0veEfBVS5aqcllKmygFqMrhC1tS
tioNiy2uFY7TDSO6anrJLfnGZNfAUK3qWs2xYWelRoZYjq1KoNB/xL56hRjE
G0jZBD0ouAlfbcekhx2IerS8GiYbnAh+qAJdaL1rv9qJtiucaL3IjhZJZjQe
53I2xIdg8r4TgfHF6JJSjGCCQe+FxcL8vQkavdK4rIjgU4gu8wvQcV4h2qUW
InBuEVomFwm6pglFFA8XoNE0E3RjjiPzjWIBkxKVZF5e5PJocTMsnATj0igY
l01XvvwxZdwHU9q9hJJ7ZIQ0FmuceWpb6Ce2xtlRtAfp11hCiYIQPqII2eO2
vDFI+J9qCpAYXJt3BslXX30lGb8Jvk2cg30hwbDPmYD86LEwbV+KPSnh2BLc
UQBj86Y/Yd8j6/gug0PYVuzWix3S1F6+djfv9hNL3Y0j/1Ra2UT+fd8Se083
M7Pzoa0321jyC+8dKGA6d2TUalLdi7/IKiKQ88GzuyU/xRG3TKryLpHGJRHT
9eRrEz5/kMOnPuQ9xj1I8HmkHDGPl2PG78sRTffIx5yYRGVjKYX/rhyDN5Sj
33qCFUGq6xonOqx0ot1yShSvt51rQvOJLu8jeGe+T2ERucbuBJneaYXos7BQ
wKVPupQPJjh1m5+PLqn5CErJR7u5BQhMKkDLRIkuYFYBAuLy0XSaHo3GHEPm
Vl7/VdHFEsiRM60P9PPHwbgkCqYVMZRmwLg8WsZRc8JVuEuf1x0lMMd2hXl6
B5gi20E/pR3O0P7pk7DmkqZG51Qff4XscXmgNlB1+U46RmJwRdcE19EfjuLS
/i/w8/79+HbaROTND4fjrSUwvpCK/HlDcGFoX3wf1hP7Jg1GcewUnD99Gq9t
fV06gVHXhpEI/+MLXZ6S8+5Lit/k0+KZ18NG930vaD2118pcjmdfdfkNBWf+
Q/YIOnecaWP0ahm5jUYcqFGlm54jN20q6mo3rUe8QUIKCWEDKDCP2OhALCFr
5hNOxP3eKZAW+Wg5Jm0sx32ErHvXl2MQBen91pYjmBxWV0JX0IpyBC2jRAgL
SjWi1aSDLoQx78z3SnFnYj56LchH34UF6E9JICzNht7zbQhOtaEbpS5zCWFJ
hDCyW+DsfLRMyBd0zWfSJn2GBc2n5aLx6B+R+Xq+QJiNnAr/cmMHwLAoAqb7
Y2FaORPm++ME0oxLI3WyVkxxwTDFdIUxKgjGyCDkTQ3C6QlB+GhgKwlYDCo+
geRYSTgtsf/2gCte3eJFfI31iQnIGRZG28l7YJsThdKX0lD5zydQ+sED0G+M
xY/R98Lw2hrkr4/BK08/haNff41XXn2Fj7eS+D9WMj5rWDjWwKXx/P9kGRX8
2/1toYiq+XfiIp83xtuEqUVk4ytT+w/Y6drEWSjg1cbkughVAXj0lSxsev2U
pCyzU1TzKsa/Te9kC18l6kzl8Jt4XDB1D9+OZ8nCfFPgLoxqMKtDBs8QCoKi
HyvHrCedSPiDU9xjKB9JLmniw+UY8xDt9GiHN4h2fX1XEXgINHcRaDotKUfn
xeXourgMXecZ0Xaya3dHvLsgcwcFRnNsBJZ8Ak4+7l4ogaLPfCt6p1oRPNeK
u5Kt6JxkRVCilVyZFYGzrGg10yroWsRa0HKGCS2jstF09D+R+ZpNMmRknpA7
L2EITMuiYV41C+bVCQSgWeSeCDyLI2klnKiRVWiY1ReGGcEwTL8LhshOlDoj
N6orTk/uig8Ht5VApBxn9yYVBn+gckPRnfuhuuekdAjOR+zxRtoLmAWKlF1b
wZr5yH96DhybEwWCTm5ahj3pM3BkYQSce9fC/Pg0bHsqE2+99RYeWv8QeydC
ka8UaxEiix3SkkVrH3wnn/EV+tO6bMc/ehZqFeuNRKBzteMfg2LDO3ZZ+VJY
cM7g8k9KvVpuqmCIqy3F1/DlT5VS0xr+jmYMdezygSyQmEXEYpAbgO5dZUdC
ZjmSnnYi6SkJRDMIQFEMoPUOjKG1bziBZ9AqAtAKB3oudaAbAafLIgJShgM9
FpVSmGVE+wh3AGkIQEXoQuC4O4NBHbbIprpTAKPvfAt6p1gQnGzBXUkWdJ5t
QRDZ5I5ZZrSJM6M1AYfpWsWYEBhjQGDUZQSM+R6Zr1qk9xARMoCSKC5akwDz
uiSY1ybBtCoBRlrjDEuiFO+jj+4J/bRu5HW6IC/yLloSe+DUlB74cIh0xCBA
w/Bg4Ajv02xjXdxMuSh7IIMrrhY7/72f4cwTMbQ/HCaw8t3SOHzzxDrsSRxF
8kzCpdnDYRgcguy/viy8j4QbftthERg8cl4KUt777DL8Q7YSdn4SuuP/y+x3
3xE0GrZX5Pz4qhjRP/R9KYajijvdKySLSxXDxFWy7oSHHEh51ol5z1Ug5Rkn
EjOdiH3ciShaUybSejKGLDt8JVmX3Ei/JQ70WuRA94UO2veQZeneO6OU1go9
OkR86bIu82br9ki1YOASKwYttmHgImu1deeSdWmUd802o3O8GUG0g28XS9ad
QdaNMQu6QLJu22g92kZdQrPRR8i6ZuYdkS1HL4a0CTCvT4F5wzzpviYRpuWx
ruiFd+/uv9zI7siNuIvuPZA9vTd+ntobu4Z1qDYzm5jXFMk/CDv71bVzbJ5i
Z5VaHCUG4EL/nvj8nr44OqAfvps6VKwsHLE8E9RW2PjsrAn47NWXYMzOwrtb
aAOVZOEYOIFPizJeKRaTlNN7X1qFndlS3x/NEwuCb8RpDtCFzY+cqxQ+gXNB
NWxOjbyZNuPPFVj8fAXS/lSBZJq8syh0mE4Tdwp5/bEPOBBOpuVt8t1k2j5k
2l5k0p5k2hCauH1p4obM0yNoqrtpdch8VzLtkOU2DF1mxeAlVvlwRYe2MUbc
EcNmu4jmY74ls5lks/m6zGZ5LAPW3y+G5XdpNDmTlb2MPnUs9EnhyIuv3svk
RvVE7nSaI9F98VNkCHYOC5IspkxKyWK1JuaQHyhuOCkZjN+dyhMzLi4O5h1v
isn59epVIgxgB86hgTIhtw/ui0uf7hbOXwk3yVizTdKbTQ0yXi4iT3mFLeby
nOyJX95vF+rpKVsrxyZ5Z86F8rUJOwnZMrz2Lt9Sgftfkqwz79kKJJJbjX3U
iUhakyeuK8docqfDyZ0OWmZHKAWA/Wj32Zcs1I9Sf7JM3/kGdJy6X7FMtLAM
TbreC6w0Ya0YQWnoMovLMu3IVbaLzsMdbJnRXyPzFaNsGWknzOuqLXM5bE/f
z9ZxHUYYMiKhXzAR+rmjkZc4HLkzB7lC7NyYfsiK6U+m6YudwztWm6bvd5Jp
um93n0zt3ueDVahGsW3OSu+6aUJVT6am4iDrxK5dKJg1DWVPzEfZg1NgmzIA
px9+EBczUrFz0FBcvXoVlQ4H26baNMvcgM+x8UOvV2DDtgqsJBUv3Cz5toQn
pZWLVTyBQp4xq1nFdgylCTBoqR0DlkqH4KGLStCXgO+mXgn4O3gXZsHoByy4
b60F9640u9R75ww92kfn4I6p50m9h0m9elm90lLCcW/+5oeQ//wGUvFKOI9+
JZXTqmRaNkNW8wRS8xih5ryEoaK+7IudyI0LQ9aMUPwU5UXNbj6rkaTmAYek
Dw0mnqEpcJ60lCWmAMUn/E+R+fXOD5MnwG6Rjg7t3xyAvm9P8cyazdfrxVsT
1jQ3oyWJDztMGtZ0GGsjlC3XhKeXrPP4P5Tjqfcq8dzOSjzypqR3hvaC/3Mi
+Wkpaoglu0TTniVigwNTKPGueRQ5oeGrWP/kbFLz0G7SF4rOBe/MHQW4e5EZ
kx+2UDsLxq41s94J2mYMXmzGgIVm3J1G6wpFGH1SDOiVZEDPJD26z85D1/g8
dJ6Zi6CYbLSNOIuA8ENkl7wadjGviUfhq0+haNtzKPjLI8I2wjltXADzg8kw
cei5IhZGCkUNGRGUpohdsz5llFhjsmcOwsmpIfjgnnaSXdj5eIC/toZd1OOP
8wDPk1dk/SpHuJzYO9FdzYbgo/Kpk4QZKFGOr1rJJLNNShJWSa1tkLRNTmz5
tBIv77kiDLN+awVWvVyBZX+pEKtC2p9o0SfjpD7nFKEdh3gxtMGcSr5pLE2O
IctL0WtuHtpM2OtmkFDaNBZg8Aozpj9moYlmxeT1Fox5QDLK8OVmDFnKhjFh
0CIjBmYYEZZmwN0UIPQh4/ZKzkO3hFx0nJGFNlNOo8m9B8kgucIT+EReFHJb
HklD8Y4tKPngZWGY/M3rYXtmFaxPLhMrh5lWDQst+paHU6XQbg2HdTEwLJ5K
hhmLHNo3nJzSC+8NlPQgPA4b5K69bBA3e3TfLtljzD/hM1W2h/RmkEN5niVi
rmgUS3x9uJYlJGJVsomT2zIR6nGGrH2lAps+rMQLn1TiyXcq8ADleRHI+LMT
6ZskY8ylSCyZPdUfaaf/ZDmm04yZvEGaJQOWlKLbnDyEzvkGhvyr1QZ5vxAj
11ox9VErosgoE9abMXINGYMMMmSZCfcsJWMsMWEAGWUAGeXuhUb0X2AQS3tP
fpWfkEPeKwutySDtp3yDdc9n1zBI/nNrUfTmJhRvfwGFLz8J23MPwEoLhZWM
YXkkXRjD/NBcSskwP0CzZdVM2qhNp5kyWcyS7LgBOD6hGz6LCIXBWikZhPVe
wyBqcXKtVawhea0Z59ntZLFqWcnzLJz4DDnNRpQLC9T8xFtzqvGhPaeKtgwi
zbGI01nTErFq+yP9RRsuGq5hNU0AjnbjnpA2wJNo/8JvCMgTUYORqx1qWjfp
MnCpnaZm6GI7ei2w0xa2CIMWZou3dMRJCgW6IGSVCWu2FiL8QQpvV9jQbzHt
fNMptF1gQbdUM7rPM6NrCicTOs+llGxEh9kGdEigpWKWnsLdPLSIykLQjDNY
sSkbIemX5O+8spG+2YQrORcJ+asJ6Sm0+42Tdr7pkyhQuo9dkJrWipFqckIj
1LQoD+RoidaI7MheuDi+M47PGISisyeRnplVrfGQPXK01Gar+FxOFHKUFPGj
+M5MVrfWXd2sYg0rm0oXlQq1SxaQPu6SUhjvdkcIvWugSzYjfUs+DAVVqhZi
CjYSeS4XmxuRzOjzgA3rtpcg8yOaY5kflvHXTaV8KaH4PXNXMTJ3cipC5geU
3isUa0HmjnxxD1mhpxjaIO3YKcDTzcxD+vMWMTOkTrVIfzobutE/SivhkB/U
8jde8uAFEaGNB6+tNW4xvIUFGqiXlvhDs5znPz3K33vxPpyuL/JXbfQ0n8+M
NKk2AUGK7kUi8Elfw2lYPA07AzFh+aM+/kSPZ5dQ/RTxZy0Tz3DvHBSN/Ula
Q9q9L15LC1flEpXRwVZSbEIdC7GWO6BZcYU//YFqNb++06ziMyI5L+7KM3+R
Qs/c6Wr+Mo3L+WsVv1XXVClcG8qfQ/AnRkRIT0ojraD3F5/uiXdArIq0EumI
f26p9FHe3FL5LJ2/Umok5atR4v5JoHQaIc7CqFSlkbZWPPjwiyp55MqxKvsD
1qnvQrsYriR+6/VQ487H6dL1KfFPvJ8D+mwSiWrpqkHYC9giPVGlKFPzkwbd
nlRaUFu5vXSlGleZ4KzjPjRSb34rWGPi00PaX7BwsqQCTWoWlD8FJDFJm9xE
JSQkZTJb7i7sWbBUagzfTJfwv8Afo7YgjJ9CXU86fqJx0yPTud/JAPTky3zU
YhRa7oY/AZPC6rBvpdhcCurF56E/Cv2xaAJn4nNTCltF9M27o9l6Cfby3eVH
ObiYI/wps5ljCWNrhfLRcSjvXsVHnkIbhdKhvpyzSSfAGulMJNrGX024Niji
CwpRZpOeI0Q0NkHP52X8EasoM0n1/FZz1EmdPAt8/h+xavBG\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{207, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Referencing",
 CellLabel->"Out[111]=",
 CellID->23531734]
}, Open  ]],

Cell["\<\
You can retrieve a list of all widgets in the interface that have been \
registered with unique string names and reference these widget instances by \
this reference name.\
\>", "Text",
 CellTags->"Referencing",
 CellID->498904818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[112]:=",
 CellID->26370402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"actionMap\"\>", ",", "\<\"cancelAction\"\>", 
   ",", "\<\"cancelButton\"\>", ",", "\<\"degreesButton\"\>", 
   ",", "\<\"frame\"\>", ",", "\<\"inputField\"\>", ",", "\<\"inputMap\"\>", 
   ",", "\<\"okButton\"\>", ",", "\<\"radiansButton\"\>", 
   ",", "\<\"rootPane\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[112]=",
 CellID->71670873]
}, Open  ]],

Cell[TextData[{
 "This discovers all property names available with the widget registered with \
the name ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\""], "InlineFormula"],
 ". You can query and set these values using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PropertyValue",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/PropertyValue"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"propertyName\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPropertyValue",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/SetPropertyValue"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"propertyName\", \"TI\"]\)\>\""}], "}"}], ",", " ", 
    StyleBox["newValue", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Referencing",
 CellID->38549142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<PropertyNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", 
   RowBox[{"ref", ",", "\"\<inputField\>\""}], "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[113]:=",
 CellID->816309410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AccessibleContext\"\>", ",", "\<\"Action\"\>", 
   ",", "\<\"ActionCommand\"\>", ",", "\<\"ActionListeners\"\>", 
   ",", "\<\"ActionMap\"\>", ",", "\<\"Actions\"\>", 
   ",", "\<\"AlignmentX\"\>", ",", "\<\"AlignmentY\"\>", 
   ",", "\<\"AncestorListeners\"\>", ",", "\<\"Autoscrolls\"\>", 
   ",", "\<\"Background\"\>", ",", "\<\"BackgroundSet\"\>", 
   ",", "\<\"Border\"\>", ",", "\<\"Bounds\"\>", ",", "\<\"Caret\"\>", 
   ",", "\<\"CaretColor\"\>", ",", "\<\"CaretListeners\"\>", 
   ",", "\<\"CaretPosition\"\>", ",", "\<\"Class\"\>", 
   ",", "\<\"ColorModel\"\>", ",", "\<\"Columns\"\>", 
   ",", "\<\"Component\"\>", ",", "\<\"ComponentCount\"\>", 
   ",", "\<\"ComponentListeners\"\>", ",", "\<\"ComponentOrientation\"\>", 
   ",", "\<\"Components\"\>", ",", "\<\"ContainerListeners\"\>", 
   ",", "\<\"Cursor\"\>", ",", "\<\"CursorSet\"\>", 
   ",", "\<\"DebugGraphicsOptions\"\>", ",", "\<\"DisabledTextColor\"\>", 
   ",", "\<\"Displayable\"\>", ",", "\<\"Document\"\>", 
   ",", "\<\"DoubleBuffered\"\>", ",", "\<\"DragEnabled\"\>", 
   ",", "\<\"DropTarget\"\>", ",", "\<\"Editable\"\>", ",", "\<\"Enabled\"\>",
    ",", "\<\"Focusable\"\>", ",", "\<\"FocusAccelerator\"\>", 
   ",", "\<\"FocusCycleRoot\"\>", ",", "\<\"FocusCycleRootAncestor\"\>", 
   ",", "\<\"FocusListeners\"\>", ",", "\<\"FocusOwner\"\>", 
   ",", "\<\"FocusTraversable\"\>", ",", "\<\"FocusTraversalKeys\"\>", 
   ",", "\<\"FocusTraversalKeysEnabled\"\>", 
   ",", "\<\"FocusTraversalPolicy\"\>", 
   ",", "\<\"FocusTraversalPolicySet\"\>", ",", "\<\"Font\"\>", 
   ",", "\<\"FontSet\"\>", ",", "\<\"Foreground\"\>", 
   ",", "\<\"ForegroundSet\"\>", ",", "\<\"Graphics\"\>", 
   ",", "\<\"GraphicsConfiguration\"\>", ",", "\<\"Height\"\>", 
   ",", "\<\"HierarchyBoundsListeners\"\>", ",", "\<\"HierarchyListeners\"\>",
    ",", "\<\"Highlighter\"\>", ",", "\<\"HorizontalAlignment\"\>", 
   ",", "\<\"HorizontalVisibility\"\>", ",", "\<\"IgnoreRepaint\"\>", 
   ",", "\<\"InputContext\"\>", ",", "\<\"InputMap\"\>", 
   ",", "\<\"InputMethodListeners\"\>", ",", "\<\"InputMethodRequests\"\>", 
   ",", "\<\"InputVerifier\"\>", ",", "\<\"Insets\"\>", 
   ",", "\<\"KeyListeners\"\>", ",", "\<\"Keymap\"\>", ",", "\<\"Layout\"\>", 
   ",", "\<\"Lightweight\"\>", ",", "\<\"Locale\"\>", ",", "\<\"Location\"\>",
    ",", "\<\"LocationOnScreen\"\>", ",", "\<\"ManagingFocus\"\>", 
   ",", "\<\"Margin\"\>", ",", "\<\"MaximumSize\"\>", 
   ",", "\<\"MaximumSizeSet\"\>", ",", "\<\"MinimumSize\"\>", 
   ",", "\<\"MinimumSizeSet\"\>", ",", "\<\"MouseListeners\"\>", 
   ",", "\<\"MouseMotionListeners\"\>", ",", "\<\"MouseWheelListeners\"\>", 
   ",", "\<\"Name\"\>", ",", "\<\"NavigationFilter\"\>", 
   ",", "\<\"NextFocusableComponent\"\>", ",", "\<\"NotifyAction\"\>", 
   ",", "\<\"Opaque\"\>", ",", "\<\"OptimizedDrawingEnabled\"\>", 
   ",", "\<\"PaintingTile\"\>", ",", "\<\"Parent\"\>", ",", "\<\"Peer\"\>", 
   ",", "\<\"PreferredScrollableViewportSize\"\>", 
   ",", "\<\"PreferredSize\"\>", ",", "\<\"PreferredSizeSet\"\>", 
   ",", "\<\"PropertyChangeListeners\"\>", 
   ",", "\<\"RegisteredKeyStrokes\"\>", ",", "\<\"RequestFocusEnabled\"\>", 
   ",", "\<\"RootPane\"\>", ",", "\<\"ScrollableTracksViewportHeight\"\>", 
   ",", "\<\"ScrollableTracksViewportWidth\"\>", ",", "\<\"ScrollOffset\"\>", 
   ",", "\<\"SelectedText\"\>", ",", "\<\"SelectedTextColor\"\>", 
   ",", "\<\"SelectionColor\"\>", ",", "\<\"SelectionEnd\"\>", 
   ",", "\<\"SelectionStart\"\>", ",", "\<\"Showing\"\>", ",", "\<\"Size\"\>",
    ",", "\<\"Text\"\>", ",", "\<\"Toolkit\"\>", ",", "\<\"ToolTipText\"\>", 
   ",", "\<\"TopLevelAncestor\"\>", ",", "\<\"TransferHandler\"\>", 
   ",", "\<\"TreeLock\"\>", ",", "\<\"UI\"\>", ",", "\<\"UIClassID\"\>", 
   ",", "\<\"Valid\"\>", ",", "\<\"ValidateRoot\"\>", 
   ",", "\<\"VerifyInputWhenFocusTarget\"\>", 
   ",", "\<\"VetoableChangeListeners\"\>", ",", "\<\"Visible\"\>", 
   ",", "\<\"VisibleRect\"\>", ",", "\<\"Width\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"Y\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[113]=",
 CellID->892487643]
}, Open  ]],

Cell[TextData[{
 "You can also find out what method names exist that can be executed on this \
widget with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InvokeMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeMethod"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"methodName\", \"TI\"]\)\>\""}], "}"}], ",", " ", 
    StyleBox["arguments", "TI"]}], "]"}]], "InlineFormula"],
 " and even filter these names using string patterns."
}], "Text",
 CellTags->"Referencing",
 CellID->561993925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"\"\<MethodNames\>\"", " ", "/.", " ", 
    RowBox[{"GUIInformation", "[", 
     RowBox[{"ref", ",", "\"\<inputField\>\""}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", "\"\<*text*\>\"", ",", " ", 
      RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[114]:=",
 CellID->572426759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GetAccessibleContext\"\>", ",", "\<\"GetDisabledTextColor\"\>",
    ",", "\<\"GetInputContext\"\>", ",", "\<\"GetSelectedText\"\>", 
   ",", "\<\"GetSelectedTextColor\"\>", ",", "\<\"GetText\"\>", 
   ",", "\<\"GetToolTipText\"\>", ",", "\<\"SetDisabledTextColor\"\>", 
   ",", "\<\"SetSelectedTextColor\"\>", ",", "\<\"SetText\"\>", 
   ",", "\<\"SetToolTipText\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[114]=",
 CellID->92842788]
}, Open  ]],

Cell[TextData[{
 "Additionally, you can discover what event names can be used to cause ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to execute whenever the event occurs by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BindEvent",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/BindEvent"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"eventName\", \"TI\"]\)\>\""}], "}"}], ",", " ", 
    RowBox[{
     ButtonBox["Script",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/Script"], "[", 
     StyleBox["code", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Referencing",
 CellID->186212963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<EventNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", 
   RowBox[{"ref", ",", "\"\<inputField\>\""}], "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[115]:=",
 CellID->430865221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Action\"\>", ",", "\<\"ActionPerformed\"\>", 
   ",", "\<\"Ancestor\"\>", ",", "\<\"AncestorAdded\"\>", 
   ",", "\<\"AncestorMoved\"\>", ",", "\<\"AncestorRemoved\"\>", 
   ",", "\<\"AncestorResized\"\>", ",", "\<\"Caret\"\>", 
   ",", "\<\"CaretPositionChanged\"\>", ",", "\<\"CaretUpdate\"\>", 
   ",", "\<\"Component\"\>", ",", "\<\"ComponentAdded\"\>", 
   ",", "\<\"ComponentHidden\"\>", ",", "\<\"ComponentMoved\"\>", 
   ",", "\<\"ComponentRemoved\"\>", ",", "\<\"ComponentResized\"\>", 
   ",", "\<\"ComponentShown\"\>", ",", "\<\"Container\"\>", 
   ",", "\<\"Focus\"\>", ",", "\<\"FocusGained\"\>", ",", "\<\"FocusLost\"\>",
    ",", "\<\"Hierarchy\"\>", ",", "\<\"HierarchyBounds\"\>", 
   ",", "\<\"HierarchyChanged\"\>", ",", "\<\"InputMethod\"\>", 
   ",", "\<\"InputMethodTextChanged\"\>", ",", "\<\"Key\"\>", 
   ",", "\<\"KeyPressed\"\>", ",", "\<\"KeyReleased\"\>", 
   ",", "\<\"KeyTyped\"\>", ",", "\<\"Mouse\"\>", ",", "\<\"MouseClicked\"\>",
    ",", "\<\"MouseDragged\"\>", ",", "\<\"MouseEntered\"\>", 
   ",", "\<\"MouseExited\"\>", ",", "\<\"MouseMotion\"\>", 
   ",", "\<\"MouseMoved\"\>", ",", "\<\"MousePressed\"\>", 
   ",", "\<\"MouseReleased\"\>", ",", "\<\"MouseWheel\"\>", 
   ",", "\<\"MouseWheelMoved\"\>", ",", "\<\"PropertyChange\"\>", 
   ",", "\<\"VetoableChange\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[115]=",
 CellID->750194938]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interacting with GUIs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 19.7556256}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This tutorial discusses how the GUIObject expression for a running GUI \
can be a handle to the widgets that make up the interface. This lets you get \
runtime information about the GUI, and can be a useful technique for learning \
about how GUIs work and how to develop them. With a GUIObject , you can \
discover what special widgets are registered with unique reference string \
names. Using these names, you can modify and further discover member \
information about these widgets, such as what properties, method functions, \
and events exist to control them. More information on widget properties and \
names can be found in the sections Widget Basics, and GUI Building Blocks. \
This gains access to the GUIObject associated with an interface created in a \
modeless session.", "synonyms" -> {}, "title" -> "Interacting with GUIs", 
    "type" -> "Tutorial", "uri" -> "GUIKit/tutorial/InteractingWithGUIs"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "InteractingIntro"->{
  Cell[731, 29, 89, 2, 70, "Title",
   CellTags->"InteractingIntro",
   CellID->486709749],
  Cell[823, 33, 481, 12, 70, "Text",
   CellTags->"InteractingIntro",
   CellID->77467686]},
 "Referencing"->{
  Cell[1329, 49, 79, 2, 70, "Section",
   CellTags->"Referencing",
   CellID->23288840],
  Cell[1411, 53, 832, 23, 70, "Text",
   CellTags->"Referencing",
   CellID->263117627],
  Cell[2246, 78, 161, 5, 70, "Input",
   CellTags->"Referencing",
   CellID->327580673],
  Cell[2410, 85, 294, 9, 70, "Text",
   CellTags->"Referencing",
   CellID->56095317],
  Cell[2729, 98, 202, 6, 70, "Input",
   CellTags->"Referencing",
   CellID->714792644],
  Cell[2934, 106, 297, 8, 70, "Output",
   CellTags->"Referencing",
   CellID->23450406],
  Cell[3246, 117, 308, 10, 70, "Text",
   CellTags->"Referencing",
   CellID->57228793],
  Cell[3579, 131, 139, 4, 70, "Input",
   CellTags->"Referencing",
   CellID->466067545],
  Cell[3721, 137, 13281, 222, 70, "Output",
   Evaluatable->False,
   CellTags->"Referencing",
   CellID->23531734],
  Cell[17017, 362, 241, 6, 70, "Text",
   CellTags->"Referencing",
   CellID->498904818],
  Cell[17283, 372, 191, 5, 70, "Input",
   CellTags->"Referencing",
   CellID->26370402],
  Cell[17477, 379, 407, 9, 70, "Output",
   CellTags->"Referencing",
   CellID->71670873],
  Cell[17899, 391, 1016, 30, 70, "Text",
   CellTags->"Referencing",
   CellID->38549142],
  Cell[18940, 425, 235, 6, 70, "Input",
   CellTags->"Referencing",
   CellID->816309410],
  Cell[19178, 433, 4126, 66, 70, "Output",
   CellTags->"Referencing",
   CellID->892487643],
  Cell[23319, 502, 597, 17, 70, "Text",
   CellTags->"Referencing",
   CellID->561993925],
  Cell[23941, 523, 483, 14, 70, "Input",
   CellTags->"Referencing",
   CellID->572426759],
  Cell[24427, 539, 502, 10, 70, "Output",
   CellTags->"Referencing",
   CellID->92842788],
  Cell[24944, 552, 745, 23, 70, "Text",
   CellTags->"Referencing",
   CellID->186212963],
  Cell[25714, 579, 232, 6, 70, "Input",
   CellTags->"Referencing",
   CellID->430865221],
  Cell[25949, 587, 1444, 25, 70, "Output",
   CellTags->"Referencing",
   CellID->750194938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"InteractingIntro", 29505, 661},
 {"Referencing", 29708, 668}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 89, 2, 70, "Title",
 CellTags->"InteractingIntro",
 CellID->486709749],
Cell[823, 33, 481, 12, 70, "Text",
 CellTags->"InteractingIntro",
 CellID->77467686],
Cell[CellGroupData[{
Cell[1329, 49, 79, 2, 70, "Section",
 CellTags->"Referencing",
 CellID->23288840],
Cell[1411, 53, 832, 23, 70, "Text",
 CellTags->"Referencing",
 CellID->263117627],
Cell[2246, 78, 161, 5, 70, "Input",
 CellTags->"Referencing",
 CellID->327580673],
Cell[2410, 85, 294, 9, 70, "Text",
 CellTags->"Referencing",
 CellID->56095317],
Cell[CellGroupData[{
Cell[2729, 98, 202, 6, 70, "Input",
 CellTags->"Referencing",
 CellID->714792644],
Cell[2934, 106, 297, 8, 70, "Output",
 CellTags->"Referencing",
 CellID->23450406]
}, Open  ]],
Cell[3246, 117, 308, 10, 70, "Text",
 CellTags->"Referencing",
 CellID->57228793],
Cell[CellGroupData[{
Cell[3579, 131, 139, 4, 70, "Input",
 CellTags->"Referencing",
 CellID->466067545],
Cell[3721, 137, 13281, 222, 70, "Output",
 Evaluatable->False,
 CellTags->"Referencing",
 CellID->23531734]
}, Open  ]],
Cell[17017, 362, 241, 6, 70, "Text",
 CellTags->"Referencing",
 CellID->498904818],
Cell[CellGroupData[{
Cell[17283, 372, 191, 5, 70, "Input",
 CellTags->"Referencing",
 CellID->26370402],
Cell[17477, 379, 407, 9, 70, "Output",
 CellTags->"Referencing",
 CellID->71670873]
}, Open  ]],
Cell[17899, 391, 1016, 30, 70, "Text",
 CellTags->"Referencing",
 CellID->38549142],
Cell[CellGroupData[{
Cell[18940, 425, 235, 6, 70, "Input",
 CellTags->"Referencing",
 CellID->816309410],
Cell[19178, 433, 4126, 66, 70, "Output",
 CellTags->"Referencing",
 CellID->892487643]
}, Open  ]],
Cell[23319, 502, 597, 17, 70, "Text",
 CellTags->"Referencing",
 CellID->561993925],
Cell[CellGroupData[{
Cell[23941, 523, 483, 14, 70, "Input",
 CellTags->"Referencing",
 CellID->572426759],
Cell[24427, 539, 502, 10, 70, "Output",
 CellTags->"Referencing",
 CellID->92842788]
}, Open  ]],
Cell[24944, 552, 745, 23, 70, "Text",
 CellTags->"Referencing",
 CellID->186212963],
Cell[CellGroupData[{
Cell[25714, 579, 232, 6, 70, "Input",
 CellTags->"Referencing",
 CellID->430865221],
Cell[25949, 587, 1444, 25, 70, "Output",
 CellTags->"Referencing",
 CellID->750194938]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[27432, 617, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

