(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24226,        611]
NotebookOptionsPosition[     19247,        457]
NotebookOutlinePosition[     22875,        557]
CellTagsIndexPosition[     22805,        552]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Loading GUIs", "Title",
 CellTags->"Loading",
 CellID->15171192],

Cell[TextData[{
 "When you load an interface with ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 " the widget definitions are turned into runtime widgets, and the graphical \
user interface is immediately displayed on the screen.",
 " ",
 "It may be useful to break up the two-step process of turning a definition \
into the runtime widgets and the actual display of the resulting interface to \
the screen so that either existing widget properties can be modified before \
display, or, as a speed improvement to the user, preload the widgets and then \
later display the interface on screen only when requested."
}], "Text",
 CellTags->"Loading",
 CellID->701462091],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GUILoad",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUILoad"]], "InlineFormula"],
 " provides this functionality by loading and creating a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " instance that defines the runtime classes in the same manner that ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " works.",
 " ",
 "However, the interface is not displayed on screen. Only when you later call \
",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 " on the ",
 Cell[BoxData[
  RowBox[{"GUIObject", ","}]], "InlineFormula"],
 " will there be a visual display of the user interface."
}], "Text",
 CellTags->"Loading",
 CellID->3049409],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Loading",
 CellLabel->"In[1]:=",
 CellID->161084193],

Cell[TextData[{
 "Here ",
 "you ",
 "use ",
 Cell[BoxData[
  ButtonBox["GUILoad",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUILoad"]], "InlineFormula"],
 " to create the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 ", but there is no immediate display."
}], "Text",
 CellTags->"Loading",
 CellID->513446888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", 
  RowBox[{
  "GUILoad", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"Loading",
 CellLabel->"In[2]:=",
 CellID->8971622],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject392301742391297, 
   JLink`Objects`JavaObject359086512144385]]], "Output",
 CellTags->"Loading",
 CellLabel->"Out[2]=",
 CellID->113971071]
}, Open  ]],

Cell["\<\
You are free to change some of the initial values of some of the widgets, \
such as the default text property of one of the input text fields.\
\>", "Text",
 CellTags->"Loading",
 CellID->307941369],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<FirstArgumentField\>\"", ",", "\"\<text\>\""}], "}"}], ",", 
    " ", 
    RowBox[{"ToString", "[", 
     RowBox[{
      RowBox[{"N", "[", "Pi", "]"}], ",", " ", "InputForm"}], "]"}]}], 
   "]"}]}]], "Input",
 CellTags->"Loading",
 CellLabel->"In[3]:=",
 CellID->161420942],

Cell[TextData[{
 "You can pass the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " expression to ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 " when you are ready to display the interface to the user. If you decided \
not to display the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " definition, ",
 "you ",
 "would call ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 " to remove any resources and definitions created by ",
 Cell[BoxData[
  ButtonBox["GUILoad",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUILoad"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Loading",
 CellID->107099879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRun", "[", "ref", "]"}]], "Input",
 CellTags->"Loading",
 CellLabel->"In[4]:=",
 CellID->14346535],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject392301742391297, 
   JLink`Objects`JavaObject359086512144385]]], "Output",
 CellTags->"Loading",
 CellLabel->"Out[4]=",
 CellID->271437084]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous user interface would look like \
when initially shown.\
\>", "Text",
 CellTags->"Loading",
 CellID->204785257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Loading",
 CellLabel->"In[5]:=",
 CellID->32771307],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{270, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Loading",
 CellLabel->"Out[5]=",
 CellID->281488009]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Loading GUIs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 24.0835290}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "When you load an interface with GUIRun or GUIRunModal the widget \
definitions are turned into runtime widgets, and the graphical user interface \
is immediately displayed on the screen. It may be useful to break up the \
two-step process of turning a definition into the runtime widgets and the \
actual display of the resulting interface to the screen so that either \
existing widget properties can be modified before display, or, as a speed \
improvement to the user, preload the widgets and then later display the \
interface on screen only when requested. GUILoad provides this functionality \
by loading and creating a GUIObject instance that defines the runtime classes \
in the same manner that GUIRun works. However, the interface is not displayed \
on screen. Only when you later call GUIRun, GUIRunModal, or ReleaseGUIObject \
on the GUIObject, will there be a visual display of the user interface. Here \
you use GUILoad to create the GUIObject, but there is no immediate display.", 
    "synonyms" -> {}, "title" -> "Loading GUIs", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/LoadingGUIs"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Loading"->{
  Cell[731, 29, 70, 2, 70, "Title",
   CellTags->"Loading",
   CellID->15171192],
  Cell[804, 33, 887, 21, 70, "Text",
   CellTags->"Loading",
   CellID->701462091],
  Cell[1694, 56, 1222, 39, 70, "Text",
   CellTags->"Loading",
   CellID->3049409],
  Cell[2919, 97, 155, 5, 70, "Input",
   CellTags->"Loading",
   CellID->161084193],
  Cell[3077, 104, 409, 16, 70, "Text",
   CellTags->"Loading",
   CellID->513446888],
  Cell[3511, 124, 189, 6, 70, "Input",
   CellTags->"Loading",
   CellID->8971622],
  Cell[3703, 132, 292, 8, 70, "Output",
   CellTags->"Loading",
   CellID->113971071],
  Cell[4010, 143, 208, 5, 70, "Text",
   CellTags->"Loading",
   CellID->307941369],
  Cell[4221, 150, 403, 13, 70, "Input",
   CellTags->"Loading",
   CellID->161420942],
  Cell[4627, 165, 1100, 37, 70, "Text",
   CellTags->"Loading",
   CellID->107099879],
  Cell[5752, 206, 125, 4, 70, "Input",
   CellTags->"Loading",
   CellID->14346535],
  Cell[5880, 212, 292, 8, 70, "Output",
   CellTags->"Loading",
   CellID->271437084],
  Cell[6187, 223, 163, 5, 70, "Text",
   CellTags->"Loading",
   CellID->204785257],
  Cell[6375, 232, 132, 4, 70, "Input",
   CellTags->"Loading",
   CellID->32771307],
  Cell[6510, 238, 12683, 213, 70, "Output",
   Evaluatable->False,
   CellTags->"Loading",
   CellID->281488009]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Loading", 21474, 502}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 70, 2, 70, "Title",
 CellTags->"Loading",
 CellID->15171192],
Cell[804, 33, 887, 21, 70, "Text",
 CellTags->"Loading",
 CellID->701462091],
Cell[1694, 56, 1222, 39, 70, "Text",
 CellTags->"Loading",
 CellID->3049409],
Cell[2919, 97, 155, 5, 70, "Input",
 CellTags->"Loading",
 CellID->161084193],
Cell[3077, 104, 409, 16, 70, "Text",
 CellTags->"Loading",
 CellID->513446888],
Cell[CellGroupData[{
Cell[3511, 124, 189, 6, 70, "Input",
 CellTags->"Loading",
 CellID->8971622],
Cell[3703, 132, 292, 8, 70, "Output",
 CellTags->"Loading",
 CellID->113971071]
}, Open  ]],
Cell[4010, 143, 208, 5, 70, "Text",
 CellTags->"Loading",
 CellID->307941369],
Cell[4221, 150, 403, 13, 70, "Input",
 CellTags->"Loading",
 CellID->161420942],
Cell[4627, 165, 1100, 37, 70, "Text",
 CellTags->"Loading",
 CellID->107099879],
Cell[CellGroupData[{
Cell[5752, 206, 125, 4, 70, "Input",
 CellTags->"Loading",
 CellID->14346535],
Cell[5880, 212, 292, 8, 70, "Output",
 CellTags->"Loading",
 CellID->271437084]
}, Open  ]],
Cell[6187, 223, 163, 5, 70, "Text",
 CellTags->"Loading",
 CellID->204785257],
Cell[CellGroupData[{
Cell[6375, 232, 132, 4, 70, "Input",
 CellTags->"Loading",
 CellID->32771307],
Cell[6510, 238, 12683, 213, 70, "Output",
 Evaluatable->False,
 CellTags->"Loading",
 CellID->281488009]
}, Open  ]]
}, Open  ]],
Cell[19220, 455, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

