(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9818,        324]
NotebookOptionsPosition[      5475,        197]
NotebookOutlinePosition[      8919,        287]
CellTagsIndexPosition[      8854,        282]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " BSF Scripting Engine"
}], "Title",
 CellTags->"BSF",
 CellID->971660931],

Cell[CellGroupData[{

Cell["Integrating with apache-ant", "Section",
 CellTags->"BSF",
 CellID->356313603],

Cell[TextData[{
 "You can use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " BSF engine that ships with the ",
 StyleBox["GUIKit`", "Output"],
 " framework in third-party applications that support BSF.\nThe naming \
conventions to note are that BSF uses the Bean concept so object lookups in \
the registry only support the ",
 Cell[BoxData[
  RowBox[{"Bean", "[", "\"\<\!\(\*
StyleBox[\"id\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " function and not the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetReference"], "[", "\"\<\!\(\*
StyleBox[\"id\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " notation of ",
 StyleBox["GUIKit`",
  FontFamily->"Courier"],
 ".",
 " ",
 "Also note that BSF will not make ",
 StyleBox["language=\"mathematica\"",
  FontFamily->"Courier"],
 " the default scripting language in the ",
 StyleBox["<script>",
  FontFamily->"Courier"],
 " tag, so ",
 StyleBox["<script language=\"mathematica\">",
  FontFamily->"Courier"],
 " must be used explicitly."
}], "Text",
 CellTags->"BSF",
 CellID->285588533],

Cell[TextData[{
 "You need to update the ",
 StyleBox["/lib/", "Output"],
 " directory of an apache-ant distribution to support ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a script language. Copy the following four resources from the ",
 StyleBox["GUIKit`", "Output"],
 " AddOn's ",
 StyleBox["Java/ ", "Output"],
 "directory and ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "'s distribution."
}], "Text",
 CellTags->"BSF",
 CellID->21762519],

Cell[TextData[{
 StyleBox["  bsf.jar\n  bsf-Wolfram.jar\n  JLink.jar\n  SystemFiles/",
  FontFamily->"Courier"],
 "...    ( J/Link native library)"
}], "Program",
 CellTags->"BSF",
 CellID->45776155],

Cell[TextData[{
 StyleBox["NOTE",
  FontWeight->"Bold"],
 ": Depending upon which version of BSF the ant or third-party tool requires, \
you may actually have to grab the ",
 StyleBox["bsf-ibm.jar", "InlineCode"],
 " and ",
 StyleBox["bsf-ibm-Wolfram.jar", "InlineCode"],
 " versions from the ",
 StyleBox["Java-Alternatives/BSF/lib/", "InlineCode"],
 " directory. Starting with apache-ant Version 1.6.x and later, the new ",
 StyleBox["bsf.jar", "InlineCode"],
 " and ",
 StyleBox["bsf-Wolfram.jar", "InlineCode"],
 " should be used, since these are based on the apache BSF classes, while \
apache-ant Versions 1.5.x and earlier require the older ",
 StyleBox["bsf-ibm-*", "InlineCode"],
 " jars."
}], "Text",
 CellTags->"BSF",
 CellID->113526251],

Cell[TextData[{
 "With the above files in the ant distribution's path, you should then be \
able to use the ",
 StyleBox["<script language=\"mathematica\">", "Output"],
 " ant task.",
 " ",
 "Many of the ant properties and objects will be accessible from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 Cell[BoxData[
  RowBox[{"Bean", "[", "\"\<\!\(\*
StyleBox[\"id\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " instances, and you can also specify settings for the MathematicaBSFEngine \
using ant ",
 StyleBox["<property>", "Output"],
 " instances. The most useful one would be to specify an alternate ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " command line to launch the kernel than the one used by default."
}], "Text",
 CellTags->"BSF",
 CellID->6791910],

Cell[TextData[{
 "Here is an optional setting for specifying the launch of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "Text",
 CellTags->"BSF",
 CellID->12215444],

Cell["\<\
<property 
  name=\"bsf_engine_Mathematica_KernelLinkCommandLine\" 
  value=\"-linkmode launch -linkname 'C:\\\\Program Files\\\\Wolfram Research\
\\\\Mathematica\\\\5.0\\\\MathKernel.exe'\"  />\
\>", "Program",
 FontFamily->"Courier",
 CellTags->"BSF",
 CellID->161436039],

Cell["Here is an example of a complete ant build file project.", "Text",
 CellTags->"BSF",
 CellID->131637754],

Cell["\<\
<project name=\"helloWorld\" default=\"main\" basedir=\".\">
  <target name=\"setup\">
    <script language=\"mathematica\"><![CDATA[
     echo = Bean[\"helloWorld\"] @ createTask[\"echo\"];
     Bean[\"main\"] @ addTask[echo];
     echo @ setMessage[\"Hello World! From Mathematica :\" <> 
        ToString[$Version] <> \" \" <>  ToString[10!]];
    ]]></script>
  </target>
  <target name=\"main\" depends=\"setup\"/>
</project>\
\>", "Program",
 FontFamily->"Courier",
 CellTags->"BSF",
 CellID->136761065]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematica BSF Scripting Engine - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 26.4896558}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "You can use the Mathematica BSF engine that ships with the GUIKit` \
framework in third-party applications that support BSF. The naming \
conventions to note are that BSF uses the Bean concept so object lookups in \
the registry only support the Bean[\"id\"] function and not the \
WidgetReference[\"id\"] notation of GUIKit`. Also note that BSF will not make \
language=\"mathematica\" the default scripting language in the <script> tag, \
so <script language=\"mathematica\"> must be used explicitly. You need to \
update the /lib/ directory of an apache-ant distribution to support \
Mathematica as a script language. Copy the following four resources from the \
GUIKit` AddOn's Java/ directory and J/Link's distribution. NOTE: Depending \
upon which version of BSF the ant or third-party tool requires, you may \
actually have to grab the bsf-ibm.jar and bsf-ibm-Wolfram.jar versions from \
the Java-Alternatives/BSF/lib/ directory. Starting with apache-ant Version \
1.6.x and later, the new bsf.jar and bsf-Wolfram.jar should be used, since \
these are based on the apache BSF classes, while apache-ant Versions 1.5.x \
and earlier require the older bsf-ibm-* jars.", "synonyms" -> {}, "title" -> 
    "Mathematica BSF Scripting Engine", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/MathematicaBSFScriptingEngine"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "BSF"->{
  Cell[731, 29, 140, 6, 70, "Title",
   CellTags->"BSF",
   CellID->971660931],
  Cell[896, 39, 84, 2, 70, "Section",
   CellTags->"BSF",
   CellID->356313603],
  Cell[983, 43, 1122, 36, 70, "Text",
   CellTags->"BSF",
   CellID->285588533],
  Cell[2108, 81, 459, 16, 70, "Text",
   CellTags->"BSF",
   CellID->21762519],
  Cell[2570, 99, 199, 6, 70, "Program",
   CellTags->"BSF",
   CellID->45776155],
  Cell[2772, 107, 748, 20, 70, "Text",
   CellTags->"BSF",
   CellID->113526251],
  Cell[3523, 129, 783, 22, 70, "Text",
   CellTags->"BSF",
   CellID->6791910],
  Cell[4309, 153, 191, 7, 70, "Text",
   CellTags->"BSF",
   CellID->12215444],
  Cell[4503, 162, 283, 8, 70, "Program",
   CellTags->"BSF",
   CellID->161436039],
  Cell[4789, 172, 110, 2, 70, "Text",
   CellTags->"BSF",
   CellID->131637754],
  Cell[4902, 176, 519, 15, 70, "Program",
   CellTags->"BSF",
   CellID->136761065]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"BSF", 7934, 245}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 140, 6, 70, "Title",
 CellTags->"BSF",
 CellID->971660931],
Cell[CellGroupData[{
Cell[896, 39, 84, 2, 70, "Section",
 CellTags->"BSF",
 CellID->356313603],
Cell[983, 43, 1122, 36, 70, "Text",
 CellTags->"BSF",
 CellID->285588533],
Cell[2108, 81, 459, 16, 70, "Text",
 CellTags->"BSF",
 CellID->21762519],
Cell[2570, 99, 199, 6, 70, "Program",
 CellTags->"BSF",
 CellID->45776155],
Cell[2772, 107, 748, 20, 70, "Text",
 CellTags->"BSF",
 CellID->113526251],
Cell[3523, 129, 783, 22, 70, "Text",
 CellTags->"BSF",
 CellID->6791910],
Cell[4309, 153, 191, 7, 70, "Text",
 CellTags->"BSF",
 CellID->12215444],
Cell[4503, 162, 283, 8, 70, "Program",
 CellTags->"BSF",
 CellID->161436039],
Cell[4789, 172, 110, 2, 70, "Text",
 CellTags->"BSF",
 CellID->131637754],
Cell[4902, 176, 519, 15, 70, "Program",
 CellTags->"BSF",
 CellID->136761065]
}, Open  ]]
}, Open  ]],
Cell[5448, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

