(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19090,        502]
NotebookOptionsPosition[     16093,        412]
NotebookOutlinePosition[     17848,        455]
CellTagsIndexPosition[     17805,        452]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: PrimeFinder"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->412527281],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{147, 96},
 CellID->499998915],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->654463834],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->234686496],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrimeFinder", "[", "]"}], ":=", 
   RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/PrimeFinder\>\"", "]"}]}],
   ";"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->58154049],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrimeFinderModeless", "[", "]"}], ":=", 
   RowBox[{"GUIRun", "[", "\"\<Wolfram/Example/PrimeFinder\>\"", "]"}]}], 
  ";"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[3]:=",
 CellID->154980201],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->254847369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Get", "[", "\"\<Wolfram/Example/PrimeFinder.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->191707696],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Panel\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"WidgetFill", "[", "]"}], ",", 
           RowBox[{"Widget", "[", 
            RowBox[{"\<\"Button\"\>", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\<\"label\"\>", "\[Rule]", "\<\"Previous\"\>"}], ",", 
               
               RowBox[{"BindEvent", "[", 
                RowBox[{"\<\"action\"\>", ",", 
                 RowBox[{"Script", "[", 
                  RowBox[{
                   RowBox[{"findPrime", "[", 
                    RowBox[{"-", "1"}], "]"}], ";"}], "]"}]}], "]"}]}], "}"}],
              ",", 
             RowBox[{"Name", "\[Rule]", "\<\"previousButton\"\>"}]}], "]"}], 
           ",", 
           RowBox[{"WidgetSpace", "[", "5", "]"}], ",", 
           RowBox[{"Widget", "[", 
            RowBox[{"\<\"Button\"\>", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\<\"label\"\>", "\[Rule]", "\<\"Next\"\>"}], ",", 
               RowBox[{"BindEvent", "[", 
                RowBox[{"\<\"action\"\>", ",", 
                 RowBox[{"Script", "[", 
                  RowBox[{"findPrime", "[", "1", "]"}], "]"}]}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"Name", "\[Rule]", "\<\"nextButton\"\>"}]}], "]"}], ",", 
           
           RowBox[{"WidgetFill", "[", "]"}]}], "}"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextField\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"1\"\>"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"keyReleased\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{
                 RowBox[{"testIfPrime", "[", "]"}], ";"}], "]"}]}], "]"}]}], 
            "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"valueField\"\>"}], ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "Maximize"}], "}"}]}], "}"}]}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Label\"\>", ",", 
           RowBox[{"{", 
            
            RowBox[{"\<\"text\"\>", 
             "\[Rule]", "\<\"Number is not prime.\"\>"}], "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"primeIndicator\"\>"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"WidgetLayout", "\[Rule]", "Column"}]}], "]"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{"\<\"endModal\"\>", ",", 
       RowBox[{"Script", "[", 
        RowBox[{"Union", "[", 
         RowBox[{"ToExpression", "/@", "primesVisited"}], "]"}], "]"}]}], 
      "]"}], ",", 
     RowBox[{"Script", "[", 
      RowBox[{
       RowBox[{"primesVisited", "=", 
        RowBox[{"{", "}"}]}], ";", 
       RowBox[{
        RowBox[{"findPrime", "[", "direction_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", "value", "}"}], ",", 
          RowBox[{
           RowBox[{"value", "=", 
            RowBox[{"PropertyValue", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"valueField\"\>", ",", "\<\"text\"\>"}], "}"}], 
             "]"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"SyntaxQ", "[", "value", "]"}]}], ",", 
             RowBox[{"Return", "[", "]"}]}], "]"}], ";", 
           RowBox[{"value", "=", 
            RowBox[{"Round", "[", 
             RowBox[{"ToExpression", "[", "value", "]"}], "]"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"NumericQ", "[", "value", "]"}]}], ",", 
             RowBox[{"value", "=", "0"}]}], "]"}], ";", 
           RowBox[{"value", "+=", "direction"}], ";", 
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"PrimeQ", "[", "value", "]"}]}], ",", 
             RowBox[{"value", "+=", "direction"}]}], "]"}], ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"valueField\"\>", ",", "\<\"text\"\>"}], "}"}], ",",
              
             RowBox[{"ToString", "[", 
              RowBox[{"value", ",", "InputForm"}], "]"}]}], "]"}], ";", 
           RowBox[{"testIfPrime", "[", "]"}], ";"}]}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"testIfPrime", "[", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"value", ",", 
            RowBox[{"isPrime", "=", "False"}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"value", "=", 
            RowBox[{"PropertyValue", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"valueField\"\>", ",", "\<\"text\"\>"}], "}"}], 
             "]"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SyntaxQ", "[", "value", "]"}], ",", 
             RowBox[{"isPrime", "=", 
              RowBox[{"PrimeQ", "[", 
               RowBox[{"ToExpression", "[", "value", "]"}], "]"}]}]}], "]"}], 
           ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"TrueQ", "[", "isPrime", "]"}], ",", 
             RowBox[{
              RowBox[{"primesVisited", "=", 
               RowBox[{"primesVisited", "\[Union]", 
                RowBox[{"{", 
                 RowBox[{"ToString", "[", "value", "]"}], "}"}]}]}], ";", 
              RowBox[{"SetWidgetReference", "[", 
               RowBox[{"\<\"primesVisited\"\>", ",", "primesVisited"}], "]"}],
               ";"}]}], "]"}], ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"primeIndicator\"\>", ",", "\<\"text\"\>"}], "}"}], 
             ",", 
             RowBox[{"\<\"Number is \"\>", "<>", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"TrueQ", "[", "isPrime", "]"}], ",", "\<\"\"\>", 
                ",", "\<\"not \"\>"}], "]"}], "<>", "\<\"prime.\"\>"}]}], 
            "]"}], ";"}]}], "]"}]}], ";"}], "]"}]}], "}"}]}], "]"}]], "Output",\

 CellLabel->"Out[5]=",
 CellID->356769613]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->268283824],

Cell[TextData[{
 "This example displays a dialog for finding prime numbers and alerting the \
user when any entered expression evaluates to a prime number. The modal \
version also shows how results can be returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when the dialog is finished. In this example, a sorted list of all prime \
numbers visited during the session is returned."
}], "Text",
 CellID->441823396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeFinder", "[", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[4]:=",
 CellID->442606541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"43", ",", "47063351"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->327669891]
}, Open  ]],

Cell["\<\
This dialog can also be run in a modeless session as well with multiple \
copies running independently.\
\>", "Text",
 CellID->100142805],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrimeFinderModeless", "[", "]"}], ";"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[10]:=",
 CellID->302432578]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: PrimeFinder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 31.1769158}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example displays a dialog for finding prime numbers and alerting \
the user when any entered expression evaluates to a prime number. The modal \
version also shows how results can be returned to Mathematica when the dialog \
is finished. In this example, a sorted list of all prime numbers visited \
during the session is returned. This dialog can also be run in a modeless \
session as well with multiple copies running independently.", 
    "synonyms" -> {}, "title" -> "GUIKit Example: PrimeFinder", "type" -> 
    "Tutorial", "uri" -> "GUIKit/tutorial/PrimeFinder"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 117, 5, 70, "Title",
 CellID->554471618],
Cell[851, 36, 36, 1, 70, "Text",
 CellID->412527281],
Cell[890, 39, 6184, 103, 70, "Graphics",
 CellID->499998915],
Cell[CellGroupData[{
Cell[7099, 146, 52, 1, 70, "SubsectionOpener",
 CellID->654463834],
Cell[7154, 149, 166, 5, 70, "Input",
 InitializationCell->True,
 CellID->234686496],
Cell[7323, 156, 271, 9, 70, "Input",
 InitializationCell->True,
 CellID->58154049],
Cell[7597, 167, 275, 9, 70, "Input",
 InitializationCell->True,
 CellID->154980201],
Cell[CellGroupData[{
Cell[7897, 180, 61, 1, 70, "SubsubsectionOpener",
 CellID->254847369],
Cell[CellGroupData[{
Cell[7983, 185, 332, 10, 70, "Input",
 CellID->191707696],
Cell[8318, 197, 6587, 162, 70, "Output",
 CellID->356769613]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14966, 366, 46, 1, 70, "Section",
 CellID->268283824],
Cell[15015, 369, 428, 9, 70, "Text",
 CellID->441823396],
Cell[CellGroupData[{
Cell[15468, 382, 126, 4, 70, "Input",
 CellID->442606541],
Cell[15597, 388, 124, 4, 70, "Output",
 CellID->327669891]
}, Open  ]],
Cell[15736, 395, 147, 4, 70, "Text",
 CellID->100142805],
Cell[15886, 401, 153, 5, 70, "Input",
 CellID->302432578]
}, Open  ]]
}, Open  ]],
Cell[16066, 410, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

