(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    328185,       7013]
NotebookOptionsPosition[     93215,       2176]
NotebookOutlinePosition[    322793,       6851]
CellTagsIndexPosition[    322616,       6843]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Quick introduction to building user interfaces with ",
 StyleBox["GUIKit",
  FontSlant->"Italic"]
}], "Chapter"],

Cell[TextData[{
 "This tutorial provides an introduction to constructing graphical user \
interfaces with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 ShowCellBracket->False,
 CellMargins->{{80, 80}, {6, 6}},
 LineSpacing->{1, 3},
 FontSize->14,
 Magnification->1],

Cell[TextData[{
 "You can change the examples in any of the slides and re-evaluate them in \
place. Normally changes you make will not be saved. To save them, explicitly \
use ",
 StyleBox["Save As...", "SR"],
 " in the ",
 StyleBox["File", "SR"],
 " menu."
}], "Text",
 ShowCellBracket->False,
 CellMargins->{{80, 80}, {6, 6}},
 LineSpacing->{1, 3},
 FontSize->14,
 Magnification->1],

Cell["\<\
The top of each slide has a toolbar with buttons to navigate between slides.\
\>", "Text",
 ShowCellBracket->False,
 CellMargins->{{80, 80}, {6, 6}},
 LineSpacing->{1, 3},
 FontSize->14,
 Magnification->1],

Cell[BoxData[GridBox[{
   {" ", 
    ButtonBox[Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVj1oFEEUftm92/M4LzkxgqRIzkbbFDaCStLERiWtVjnDYa4Qj+QEweYa
SwnYaWGwEAuLNHYWIY1iY7C08dRGRCQQRMG/c76Z+fZm/+4WtXJgd9++eb/f
vDcz5xqdleaVRqe13KifWW20V1rLa/WFq6uK5Y+JSFM9h+sCuq9I+2rK67UT
mNQfD5+G9PsvvGGMI2CIL1tbd6XXe6z/TsWFZjS7KBsbXanVqsLR7V5OCk9r
4ZK2hjE7e0xbX1o6r//BPxlXmrIeMAlh/OHZ3d1WAuAUZGfnoaYwVCSHjA2l
UbY5QIA5VCwPBmiwEvdaskLfPz0JPRpeEHrimJs7DgeeFVpcnA+n6vUp7Rsz
7fZFZRujrDMnTJijGdD4Yng2BHeuaN8uD3nBD22DZq6wj8E8EctAtqhtEAfG
Y/xWIzzqcolhw42BdJCFY+/6adl7dtvBsRA6gKJy4mnrk3pyfb3DxdTxAS/E
kVU5Q3DMCyOWx8jDeU3T4KXBiPQR7ObmrTBUhOJAloVimmo+FA3Dl/d3LsmP
vW0nkXLCCwPGmrEeTSePax49Iwo20z/CMVq+5ciciyOX0rSFsYNlBUDJcgwi
PKRgdV3VfDj6Fsc3N+bl88t7thiTOAITYodgSXva9oReRVB/gOX/A2bBgvnu
5tlwr/T1ezqxTwIwNDRm8cVggzOYeIMT9GFgQo5JKPlgJI4zqXNoYO6lw5qb
c+6h8/fdzar8+Oia/Pr23KnKwWohCu54GQcOcAOexNhs9NVcBw43dSQAl6OB
jBaw+fPD9RgcNJOJg4bxoGDjIOJ/xEGTec6A87a7IF9ePUic17Dv0L6xoSIt
8JBSq8/TmjcHKBDQICVpOna70U+5dRTCO0kx5f7hp1guZuX44X5Lfn59mnon
gTKxVe7HHV8oE5RExaqAZtSA2cITpCS030nI3nZkX56QD1i2uxXQ14Rj1LZu
eDdjmZlSM2XF8sBz0Mqxx/DNFdBRxymXlTz3dlnKY+yCo8i6SQiNvmi7jOhN
XcZ+Axgz4dU=\
\>"], "Text",
      CellMargins->{{Inherited, 50}, {Inherited, Inherited}},
      Evaluatable->False,
      TextAlignment->Right,
      ImageSize->{101, 24},
      ImageMargins->{{0, 0}, {0, 0}},
      ImageRegion->{{0, 1}, {0, 1}}],
     Active->True,
     BaseStyle->"Hyperlink",
     ButtonFrame->"None",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonMargins->0]}
  },
  ColumnsEqual->True,
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}}]], "Text",
 ShowCellBracket->False,
 CellMargins->{{Inherited, 90}, {Inherited, Inherited}},
 TextAlignment->Right,
 Magnification->1,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Right}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {True, {False}, True}, "ColumnsIndexed" -> {}, 
   "Rows" -> {True, {False}, True}, "RowsIndexed" -> {}}}],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Text",
 ShowCellBracket->False,
 CellMargins->{{0, -3}, {Inherited, 30}},
 Evaluatable->False,
 ImageSize->{850, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Magnification->1],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Building user interfaces with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellTags->"ShiftReturn"],

Cell["\<\
This tutorial walks you through a number of steps that show how to produce a \
number of simple user interfaces.\
\>", "Text"],

Cell[TextData[{
 "After completing the tutorial, you should be able to build simple widgets \
and have a grasp of the utility of ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 "."
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
 "The ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " package:"
}], "Text"],

Cell[TextData[{
 "Provides a way to build user interfaces that are integrated with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell["\<\
Builds simple little widgets that do basic tasks and builds entire \
applications.\
\>", "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell[TextData[{
 "Leverages Java technology, via ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", but no direct Java programming is required."
}], "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell[TextData[StyleBox["Runs without modification on multiple platforms and \
multiple deployment environments.",
 FontWeight->"Plain"]], "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell[TextData[{
 StyleBox["Allows ",
  FontWeight->"Plain"],
 StyleBox["Mathematica ",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["evaluations to interact with user interface components.",
  FontWeight->"Plain"]
}], "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{54, Inherited}, {Inherited, Inherited}}]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Getting started", "Section",
 CellTags->"FunctionSyntax"],

Cell[TextData[{
 "First, load the ",
 StyleBox["GUIKit`", "MR",
  FontVariations->{"CompatibilityType"->0}],
 " package.     "
}], "Text"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "InputOnly",
 CellLabel->"In[1]:="],

Cell["\<\
Then, define a panel that contains three widgets; each widget has a text \
property that is set to an initial value.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"panelExpr1", "=", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Label\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Result:\>\""}], "}"}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<TextField\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<some text\>\""}], "}"}], ",", 
          " ", 
          RowBox[{"Name", "->", "\"\<myText\>\""}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Button\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "->", "\"\<OK\>\""}], "}"}], ",", " ", 
        RowBox[{"Name", "->", "\"\<myButton\>\""}]}], "]"}]}], " ", "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Panel\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Label\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Result:\"\>"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"some text\"\>"}], "}"}], 
         ",", 
         RowBox[{"Name", "\[Rule]", "\<\"myText\"\>"}]}], "]"}]}], "}"}], ",",
      
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Button\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"OK\"\>"}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"myButton\"\>"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[2]="]
}, Open  ]],

Cell["\<\
Although nothing actually appears at this stage, the text field and button \
were given names.\
\>", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Running the user interface", "Section",
 CellTags->"FunctionSyntax"],

Cell[TextData[{
 "Evaluating ",
 StyleBox["GUIRun", "Program"],
 " on the widget expression will display the panel. The first time the ",
 StyleBox["GUIKit`", "MR",
  FontVariations->{"CompatibilityType"->0}],
 " package starts up there is a short delay for initialization."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"active1", "=", 
  RowBox[{"GUIRun", "[", "panelExpr1", "]"}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject475402430578689, 
   JLink`Objects`JavaObject210201571491841]]], "Output",
 CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
 StyleBox["GUIRun", "MR"],
 " returns a handle that can be used for interacting with the user interface. \
When the panel is displayed, it should look like the following."
}], "Text"],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Text",
 Evaluatable->False,
 ImageSize->{123, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Note how the arrangement of the widgets was carried out automatically, and \
resizing the window also resizes the widgets appropriately.\
\>", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Interacting with the panel", "Section",
 CellTags->"NumericalValues"],

Cell[TextData[{
 "This user interface does not have any interactivity built in to respond to \
particular events. Initially, you can query the runtime user interface to see \
what named widgets it contains using ",
 StyleBox["GUIInformation", "MR"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "active1", "]"}]}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"myButton\"\>", ",", "\<\"myText\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
 "You can also see what events named widgets will respond to with ",
 StyleBox["GUIInformation", "MR"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<EventNames\>\"", "/.", " ", 
  RowBox[{"GUIInformation", "[", 
   RowBox[{"active1", " ", ",", "\"\<myButton\>\""}], "]"}], " "}]], "Input",
 CellLabel->"In[5]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Action\"\>", ",", "\<\"ActionPerformed\"\>", 
   ",", "\<\"Ancestor\"\>", ",", "\<\"AncestorAdded\"\>", 
   ",", "\<\"AncestorMoved\"\>", ",", "\<\"AncestorRemoved\"\>", 
   ",", "\<\"AncestorResized\"\>", ",", "\<\"CaretPositionChanged\"\>", 
   ",", "\<\"Change\"\>", ",", "\<\"Component\"\>", 
   ",", "\<\"ComponentAdded\"\>", ",", "\<\"ComponentHidden\"\>", 
   ",", "\<\"ComponentMoved\"\>", ",", "\<\"ComponentRemoved\"\>", 
   ",", "\<\"ComponentResized\"\>", ",", "\<\"ComponentShown\"\>", 
   ",", "\<\"Container\"\>", ",", "\<\"Focus\"\>", ",", "\<\"FocusGained\"\>",
    ",", "\<\"FocusLost\"\>", ",", "\<\"Hierarchy\"\>", 
   ",", "\<\"HierarchyBounds\"\>", ",", "\<\"HierarchyChanged\"\>", 
   ",", "\<\"InputMethod\"\>", ",", "\<\"InputMethodTextChanged\"\>", 
   ",", "\<\"Item\"\>", ",", "\<\"ItemStateChanged\"\>", ",", "\<\"Key\"\>", 
   ",", "\<\"KeyPressed\"\>", ",", "\<\"KeyReleased\"\>", 
   ",", "\<\"KeyTyped\"\>", ",", "\<\"Mouse\"\>", ",", "\<\"MouseClicked\"\>",
    ",", "\<\"MouseDragged\"\>", ",", "\<\"MouseEntered\"\>", 
   ",", "\<\"MouseExited\"\>", ",", "\<\"MouseMotion\"\>", 
   ",", "\<\"MouseMoved\"\>", ",", "\<\"MousePressed\"\>", 
   ",", "\<\"MouseReleased\"\>", ",", "\<\"MouseWheel\"\>", 
   ",", "\<\"MouseWheelMoved\"\>", ",", "\<\"PropertyChange\"\>", 
   ",", "\<\"StateChanged\"\>", ",", "\<\"VetoableChange\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
 "Note the event called ",
 StyleBox["Action", "MR"],
 ", which will be used in a later slide."
}], "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Other commands for interacting", "Section",
 CellTags->"NumericalValues"],

Cell[TextData[{
 "Another useful introspective rule set is ",
 StyleBox["PropertyNames", "MR"],
 " that returns the list of a widget\[CloseCurlyQuote]s characteristics, \
which you can further process using optional string match filtering."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"\"\<PropertyNames\>\"", " ", "/.", " ", 
    RowBox[{"GUIInformation", "[", 
     RowBox[{"active1", ",", "\"\<myText\>\""}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", "\"\<*size*\>\"", ",", " ", 
      RowBox[{"IgnoreCase", "\[Rule]", " ", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"MaximumSize\"\>", ",", "\<\"MaximumSizeSet\"\>", 
   ",", "\<\"MinimumSize\"\>", ",", "\<\"MinimumSizeSet\"\>", 
   ",", "\<\"PreferredScrollableViewportSize\"\>", 
   ",", "\<\"PreferredSize\"\>", ",", "\<\"PreferredSizeSet\"\>", 
   ",", "\<\"Size\"\>"}], "}"}]], "Output",
 CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
 "There are other introspective commands that can query the interface. \
Additionally, ",
 StyleBox["WidgetReference", "MR"],
 " returns the underlying object from a name."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"active1", " ", "@", " ", 
  RowBox[{"WidgetReference", "[", "\"\<myButton\>\"", "]"}]}]], "Input",
 CellLabel->"In[7]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"javax.swing.JButton\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject386770596265985]], "Output",
 CellLabel->"Out[7]="]
}, Open  ]]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Hooking up an event", "Section",
 CellTags->"NumericalValues"],

Cell[TextData[{
 "Now a new panel will be constructed. This adds an event handler to ",
 StyleBox["myButton", "MR"],
 " that causes the string ",
 StyleBox["button pressed", "MR"],
 " to be inserted in the notebook whenever the button is clicked."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"panelExpr2", "=", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Result:\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<some text\>\""}], "}"}], ",", 
           " ", 
           RowBox[{"Name", "->", "\"\<myText\>\""}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<text\>\"", "->", "\"\<OK\>\""}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\"\<action\>\"", ",", " ", 
             RowBox[{"Script", "[", 
              RowBox[{"Print", "[", "\"\<button pressed\>\"", "]"}], "]"}]}], 
            "]"}]}], "}"}], ",", " ", 
         RowBox[{"Name", "->", "\"\<myButton\>\""}]}], "]"}]}], " ", "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"active2", "=", 
  RowBox[{"GUIRun", "[", "panelExpr2", "]"}]}]}], "Input",
 CellLabel->"In[8]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject457544392769537, 
   JLink`Objects`JavaObject329220131651585]]], "Output",
 CellLabel->"Out[9]="],

Cell[BoxData["\<\"button pressed\"\>"], "Print"],

Cell[BoxData["\<\"button pressed\"\>"], "Print"],

Cell[BoxData["\<\"button pressed\"\>"], "Print"]
}, Open  ]],

Cell["", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Hooking up an event - continued", "Section",
 CellTags->"NumericalValues"],

Cell["\<\
An alternative way to add an event handler to a widget is to place it \
anywhere in the enclosing definition and refer to the widget by its name.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Label\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Result:\>\""}], "}"}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<TextField\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<some text\>\""}], "}"}], ",", 
          " ", 
          RowBox[{"Name", "->", "\"\<myText\>\""}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Button\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "->", "\"\<OK\>\""}], "}"}], ",", " ", 
        RowBox[{"Name", "->", "\"\<myButton\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<myButton\>\"", ",", "\"\<action\>\""}], "}"}], ",", " ",
         
        RowBox[{"Script", "[", 
         RowBox[{"Print", "[", "\"\<button pressed\>\"", "]"}], "]"}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "InputOnly",
 CellLabel->"In[10]:="],

Cell[TextData[{
 "This definition has the same functionality as the definition ",
 StyleBox["panelExpr2", "MR"],
 " in the previous slide."
}], "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Hooking up an event - continued", "Section"],

Cell["\<\
This definition adds an event handler that changes part of the panel by \
setting the property value of another widget.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"panelExpr3", "=", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"\"\<text\>\"", "->", "\"\<Click Here\>\""}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\"\<action\>\"", ",", 
             RowBox[{"Script", "[", 
              RowBox[{"setText", "[", "]"}], "]"}]}], "]"}]}], "}"}]}], "]"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<TextField\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<columns\>\"", "\[Rule]", "20"}], " ", "}"}], ",", 
         RowBox[{"Name", "\[Rule]", "\"\<TextOutput\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Script", "[", " ", 
        RowBox[{
         RowBox[{"setText", "[", "]"}], ":=", "\[IndentingNewLine]", 
         RowBox[{"SetPropertyValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<TextOutput\>\"", ",", "\"\<text\>\""}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"Random", "[", "]"}], ",", " ", "InputForm"}], "]"}]}], 
          "]"}]}], "\[IndentingNewLine]", "  ", "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"active3", "=", 
   RowBox[{"GUIRun", "[", "panelExpr3", "]"}]}], ";"}]}], "InputOnly",
 CellLabel->"In[11]:="],

Cell["\<\
Every time the button is clicked a new random number is written into the text \
field. Once the button has been clicked, the panel should look something like \
the following.\
\>", "Text"],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Text",
 Evaluatable->False,
 ImageSize->{179, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Widget summary", "Section"],

Cell[TextData[{
 StyleBox["Widget[\"", "Program",
  FontWeight->"Bold"],
 StyleBox["widgetname", "Program",
  FontSlant->"Italic"],
 StyleBox["\"", "Program",
  FontWeight->"Bold"],
 StyleBox[",", "Program"],
 StyleBox["{", "Program",
  FontWeight->"Bold"],
 StyleBox["contents", "Program",
  FontSlant->"Italic"],
 StyleBox["}", "Program",
  FontWeight->"Bold"],
 StyleBox[", ", "Program"],
 StyleBox["opts", "Program",
  FontSlant->"Italic"],
 StyleBox["]", "Program",
  FontWeight->"Bold"],
 " is the basic building block, used to construct user interfaces. "
}], "Text"],

Cell["\<\
The contents of the widget can include property settings, for example, the \
text to show in a label widget. \
\>", "Text"],

Cell["\<\
The contents can also include other widgets and code to react to various \
events.\
\>", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], " ", "of", " ", 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Widget summary - continued", "Section"],

Cell[TextData[{
 "The basics of building a user interface with the ",
 StyleBox["GUIKit`", "MR"],
 " package can be summarized as follows:"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Choosing widgets",
 FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
You can choose the widgets that you need for your application from the large \
collection of possible widgets that is provided. It is also possible to add \
new types of widgets.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Setting the state of the widgets",
 FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
The initial state of the properties of your widgets must be set. For example, \
setting properties such as text and images that are initially displayed. \
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Designing the layout of widgets",
 FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
The layout of your interface must be designed. The automatic layout features \
make this particularly easy.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Adding code to run the widgets",
 FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
You also need to add the code that reacts to different types of events that \
will drive the interface as users interact with it.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    ButtonBox[
     StyleBox["\[FirstPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageFirst"]}],
     ButtonNote->"First Slide"], 
    ButtonBox[
     StyleBox["\[LeftPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPagePrevious"]}],
     ButtonNote->"Previous Slide"], 
    ButtonBox[
     StyleBox["\[RightPointer]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageNext"]}],
     ButtonNote->"Next Slide"], 
    ButtonBox[
     StyleBox["\[LastPage]", "SR"],
     BaseStyle->"SlideHyperlink",
     ButtonFunction:>FrontEndExecute[{
        FrontEndToken[
         FrontEnd`SelectedNotebook[], "ScrollPageLast"]}],
     ButtonNote->"Last Slide"], " ", 
    ButtonBox[
     StyleBox[
      RowBox[{
       CounterBox["SlideShowNavigationBar"], 
       RowBox[{" ", "of", " "}], 
       CounterBox["SlideShowNavigationBar", "LastSlide"]}], "SR"],
     ButtonFrame->"None"]}
  }]]]], "SlideShowNavigationBar",
 Magnification->1],

Cell[CellGroupData[{

Cell["Where to go from here", "Section",
 CellTags->"LastSlide"],

Cell["\<\
After working through this slide show you may want to look more at the \
documentation. In particular the following might be useful.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The Main Guide",
 BaseStyle->"Link",
 ButtonData->"paclet:GUIKit/guide/GUIKitPackage"]], "Subsubsection",
 CellChangeTimes->{{3.3787232590201864`*^9, 3.3787232831451864`*^9}}],

Cell[TextData[{
 ButtonBox["The Main Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/guide/GUIKitPackage"],
 " is the main guide page for ",
 StyleBox["GUIKit,",
  FontSlant->"Italic"],
 " it is an entry point for all the documentation."
}], "Text",
 CellChangeTimes->{{3.3787234937389364`*^9, 3.3787235187233114`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The Examples Section",
 BaseStyle->"Link",
 ButtonData->"paclet:GUIKit/tutorial/Examples"]], "Subsubsection",
 CellChangeTimes->{{3.3787232590201864`*^9, 3.3787232831451864`*^9}}],

Cell[TextData[{
 "The ",
 ButtonBox["Examples",
  BaseStyle->"Link",
  ButtonData:>"paclet:GUIKit/tutorial/Examples"],
 " section shows many different interfaces from simple worked examples useful \
for learning the functionality, to large complete applications that are \
useful in their own right."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The Widget Guide",
 BaseStyle->"Link",
 ButtonData->"paclet:GUIKit/guide/Widgets"]], "Subsubsection",
 CellChangeTimes->{{3.3787232590201864`*^9, 3.3787232831451864`*^9}}],

Cell[TextData[{
 "The ",
 ButtonBox["Widget Guide",
  BaseStyle->"Link",
  ButtonData:>"paclet:GUIKit/guide/Widgets"],
 " shows a visual tour of each of the widgets, with a visual list of useful \
properties and events."
}], "Text",
 CellChangeTimes->{3.3787233036608114`*^9, 3.3787233798326864`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["The GUIKit Site",
 BaseStyle->"Link",
 ButtonData->"http://www.wolfram.com/solutions/guikit/"],
 FontSlant->"Italic"]], "Subsubsection"],

Cell[TextData[{
 ButtonBox["http://www.wolfram.com/solutions/guikit/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/guikit/"], None}],
 " has further information and updates on the ",
 StyleBox["GUIKit`", "MR"],
 " package."
}], "Text"],

Cell[" ", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
ClosingAutoSave->False,
ScreenStyleEnvironment->"SlideShow",
PrintingStyleEnvironment->"Printout",
WindowToolbars->{},
WindowSize->{909, 521},
WindowMargins->{{317, Automatic}, {Automatic, 232}},
WindowTitle->"GUIKit Construction",
ScrollingOptions->{"VerticalScrollRange"->Fit},
PrintingCopies->1,
PrintingPageRange->{1, 6},
Magnification->1,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 10, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    CellGroupData[{
      Cell["Style Definitions for On-line Help", "Subtitle"], 
      Cell[
      "These styles are carefully tuned for all aspects of the online help. \
It's recommended that they remain unchanged.", "Text"], 
      Cell[
       CellGroupData[{
         Cell["Style Environment Names", "Section"], 
         Cell[
          StyleData[All, "Working"], PageWidth -> WindowWidth, ShowAutoStyles -> 
          False, ScriptMinSize -> 9, 
          OpenSpecialOptions -> {"ListAllFileTypes" -> False}], 
         Cell[
          StyleData[All, "Brackets"], PageWidth -> WindowWidth, 
          ShowAutoStyles -> False, ScriptMinSize -> 9], 
         Cell[
          StyleData[All, "SlideShow"], PageWidth -> WindowWidth, 
          ScrollingOptions -> {"PagewiseDisplay" -> True}, ScriptMinSize -> 
          9], 
         Cell[
          StyleData[All, "Printout"], PageWidth -> PaperWidth, 
          ShowCellBracket -> False, ShowAutoStyles -> False, ScriptMinSize -> 
          5, PrivateFontOptions -> {"FontType" -> "Outline"}], 
         Cell[
          StyleData[All, "EnhancedPrintout"], PageWidth -> PaperWidth, 
          ShowCellBracket -> False, ScriptMinSize -> 5, 
          OpenSpecialOptions -> {"ListAllFileTypes" -> False}, FontFamily -> 
          "Palatino", PrivateFontOptions -> {"FontType" -> "Outline"}], 
         Cell[
          StyleData[All, "EnhancedPrintoutNonGray"], PageWidth -> PaperWidth, 
          ShowCellBracket -> False, ScriptMinSize -> 5, 
          OpenSpecialOptions -> {"ListAllFileTypes" -> False}, FontFamily -> 
          "Palatino", PrivateFontOptions -> {"FontType" -> "Outline"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell["Notebook Options", "Section"], 
         Cell[
         "  The options defined for the style below will be used at the \
Notebook level.  ", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Notebook"], PageHeaders -> {{
                Cell[
                 TextData[{
                   CounterBox["Page"]}], "PageNumber"], None, 
                Cell[
                 TextData[{"Printed from the ", 
                   StyleBox["Mathematica", FontSlant -> "Italic"], 
                   " Help Browser"}], "PageHeader"]}, {
                Cell[
                 TextData[{"Printed from the ", 
                   StyleBox["Mathematica", FontSlant -> "Italic"], 
                   " Help Browser"}], "PageHeader"], None, 
                Cell[
                 TextData[{
                   CounterBox["Page"]}], "PageNumber"]}}, 
             PageFooters -> {{None, 
                Cell[
                 
                 TextData[{
                  "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, 
                Cell[
                 
                 TextData[{
                  "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}}, PageHeaderLines -> {True, True}, 
             PageFooterLines -> {True, True}, 
             PrintingOptions -> {"FacingPages" -> True}, CellLabelAutoDelete -> 
             False, CellFrameLabelMargins -> 6, StyleMenuListing -> None], 
            Cell[
             StyleData["Notebook", "Printout"], PageHeaders -> {{
                Cell[
                 TextData[{
                   CounterBox["Page"]}], "PageNumber"], None, 
                Cell[
                 TextData[{"Printed from the ", 
                   StyleBox["Mathematica", FontSlant -> "Italic"], 
                   " Help Browser"}], "PageHeader"]}, {
                Cell[
                 TextData[{"Printed from the ", 
                   StyleBox["Mathematica", FontSlant -> "Italic"], 
                   " Help Browser"}], "PageHeader"], None, 
                Cell[
                 TextData[{
                   CounterBox["Page"]}], "PageNumber"]}}, 
             PageFooters -> {{None, 
                Cell[
                 
                 TextData[{
                  "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, 
                Cell[
                 
                 TextData[{
                  "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}}, PageHeaderLines -> {True, True}, 
             PageFooterLines -> {True, True}, 
             PrintingOptions -> {"FacingPages" -> True}], 
            Cell[
             StyleData["Notebook", "EnhancedPrintout"], 
             PageFooters -> {{None, None, None}, {None, None, None}}, 
             PageHeaderLines -> {True, True}, 
             PrintingOptions -> {
              "FacingPages" -> True, "FirstPageHeader" -> False, 
               "PageSize" -> {602, 672}, "PrintRegistrationMarks" -> True, 
               "PrintingMargins" -> {{62, 62}, {62, 72}}}]}, Closed]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell["Headings", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Chapter"], CellFrame -> {{0, 0}, {0.5, 0}}, 
             CellMargins -> {{12, Inherited}, {10, 40}}, 
             CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> 
             False, DefaultNewInlineCellStyle -> "None", 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             LanguageCategory -> "NaturalLanguage", CounterIncrements -> 
             "Title", 
             CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
               "Figure", 0}, {"Subtitle", 0}, {"Subsubtitle", 0}}, FontFamily -> 
             "Helvetica", FontSize -> 18, FontWeight -> "Plain"], 
            Cell[
             StyleData["Chapter", "Printout"], 
             CellMargins -> {{2, 10}, {6, 30}}, FontSize -> 14], 
            Cell[
             StyleData["Chapter", "EnhancedPrintout"], 
             CellMargins -> {{2, 10}, {6, 30}}, FontFamily -> "Futura", 
             FontSize -> 14], 
            Cell[
             StyleData["Chapter", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 10}, {6, 30}}, FontFamily -> "Futura", 
             FontSize -> 14]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Section"], CellMargins -> {{10, 4}, {12, 18}}, 
             CellGroupingRules -> {"SectionGrouping", 30}, 
             ConversionRules :> {
              "HTML" -> {
                "<FONT SIZE=\"+2\" FACE=\"Helvetica, Arial\"><P><B>", 
                 "</B></P></FONT>\n"}}, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             CounterIncrements -> "Section", FontFamily -> "Helvetica", 
             FontSize -> 20, FontWeight -> "Bold"], 
            Cell[
             StyleData["Section", "SlideShow"], 
             CellFrame -> {{0, 0}, {0, 0.5}}, CellMargins -> {{0, 0}, {5, 0}},
              PageBreakBelow -> False, CellFrameMargins -> {{70, 36}, {3, 7}},
              FontFamily -> "Helvetica", FontSize -> 18, FontWeight -> 
             "Plain", FontColor -> GrayLevel[1], Background -> 
             RGBColor[0.819608, 0.427451, 0.0235294]], 
            Cell[
             StyleData["Section", "Printout"], 
             CellMargins -> {{2, 0}, {0, 18}}, PageBreakBelow -> False, 
             FontSize -> 18], 
            Cell[
             StyleData["Section", "EnhancedPrintout"], 
             CellFrame -> {{0, 0}, {0.5, 0}}, 
             CellMargins -> {{2, Inherited}, {8, 30}}, 
             CellGroupingRules -> {"SectionGrouping", 30}, PageBreakBelow -> 
             False, CellFrameMargins -> 8, CounterIncrements -> "Section", 
             CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}}, 
             FontFamily -> "Futura", FontSize -> 16], 
            Cell[
             StyleData["Section", "EnhancedPrintoutNonGray"], 
             CellFrame -> {{0, 0}, {0.5, 0}}, 
             CellMargins -> {{2, Inherited}, {8, 30}}, 
             CellGroupingRules -> {"SectionGrouping", 30}, PageBreakBelow -> 
             False, CellFrameMargins -> 8, CounterIncrements -> "Section", 
             CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}}, 
             FontFamily -> "Futura", FontSize -> 16]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subsection"], CellDingbat -> "\[FilledSquare]", 
             CellMargins -> {{24, 4}, {0, 18}}, 
             CellElementSpacings -> {"ClosedGroupTopMargin" -> 18}, 
             CellGroupingRules -> {"SectionGrouping", 40}, 
             ConversionRules :> {
              "HTML" -> {
                "<LI TYPE=\"SQUARE\"><FONT SIZE=\"+1\" FACE=\"Helvetica, \
Arial\"><P><B>", "</B></P></FONT>\n"}}, CellFrameLabelMargins -> 6, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             FontFamily -> "Helvetica", FontSize -> 16, FontWeight -> "Bold"],
             
            Cell[
             StyleData["Subsection", "SlideShow"], CellDingbat -> None, 
             CellMargins -> {{70, 0}, {4, 12}}, FontSize -> 12], 
            Cell[
             StyleData["Subsection", "Printout"], 
             CellMargins -> {{9, 0}, {7, 24}}, FontSize -> 12], 
            Cell[
             StyleData["Subsection", "EnhancedPrintout"], 
             CellMargins -> {{9, 0}, {7, 20}}, FontFamily -> "Futura", 
             FontSize -> 12], 
            Cell[
             StyleData["Subsection", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{9, 0}, {7, 20}}, FontFamily -> "Futura", 
             FontSize -> 12]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subsubsection"], CellMargins -> {{10, 4}, {0, 18}}, 
             CellElementSpacings -> {"ClosedGroupTopMargin" -> 18}, 
             CellGroupingRules -> {"SectionGrouping", 50}, 
             ConversionRules :> {
              "HTML" -> {
                "<FONT FACE=\"Helvetica, Arial\"><P><B>", 
                 "</B></P></FONT>\n"}}, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> "Bold"],
             
            Cell[
             StyleData["Subsubsection", "Printout"], 
             CellMargins -> {{2, 0}, {7, 18}}, FontSize -> 10], 
            Cell[
             StyleData["Subsubsection", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {7, 18}}, FontFamily -> "Futura", 
             FontSize -> 10], 
            Cell[
             StyleData["Subsubsection", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {7, 18}}, FontFamily -> "Futura", 
             FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SubsubsectionColor"], 
             CellMargins -> {{10, 4}, {0, 18}}, 
             CellElementSpacings -> {"ClosedGroupTopMargin" -> 18}, 
             CellGroupingRules -> {"SectionGrouping", 50}, 
             ConversionRules :> {
              "HTML" -> {
                "<FONT FACE=\"Helvetica, Arial\" COLOR=\"660099\"><P><B>", 
                 "</B></P></FONT>\n"}}, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
             12, FontWeight -> "Bold", FontColor -> 
             RGBColor[0.297993, 0, 0.454994]], 
            Cell[
             StyleData["SubsubsectionColor", "Printout"], 
             CellMargins -> {{2, 0}, {0, 18}}, PageBreakBelow -> False, 
             FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SubsectionIcon"], ShowGroupOpener -> True, 
             CellMargins -> {{24, 4}, {0, 18}}, 
             CellElementSpacings -> {"ClosedGroupTopMargin" -> 8}, 
             CellGroupingRules -> {"SectionGrouping", 40}, 
             ConversionRules :> {
              "HTML" -> {
                "<LI TYPE=\"SQUARE\"><FONT FACE=\"Helvetica, Arial\"><P><B>", 
                 "</B></P></FONT>\n"}}, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             CounterIncrements -> "Section", FontFamily -> "Helvetica", 
             FontSize -> 16, FontWeight -> "Bold"], 
            Cell[
             StyleData["SubsectionIcon", "Printout"], CellDingbat -> 
             "\[FilledSquare]", ShowGroupOpener -> False, 
             CellMargins -> {{16, 0}, {0, 18}}, PageBreakBelow -> False, 
             FontSize -> 14]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SubsubsectionIcon"], ShowGroupOpener -> True, 
             CellMargins -> {{24, 4}, {0, 8}}, 
             CellElementSpacings -> {"ClosedGroupTopMargin" -> 4}, 
             CellGroupingRules -> {"SectionGrouping", 50}, 
             ConversionRules :> {
              "HTML" -> {
                "<LI TYPE=\"SQUARE\"><FONT FACE=\"Helvetica, Arial\"><P><B>", 
                 "</B></P></FONT>\n"}}, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             CounterIncrements -> "Subsection", 
             CounterAssignments -> {{"Subsubsection", 0}}, FontFamily -> 
             "Helvetica", FontSize -> 12, FontWeight -> "Bold"], 
            Cell[
             StyleData["SubsubsectionIcon", "Printout"], ShowGroupOpener -> 
             False, CellMargins -> {{2, 0}, {0, 18}}, PageBreakBelow -> False,
              FontSize -> 10]}, Closed]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Text", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Text"], CellMargins -> {{10, 4}, {0, 8}}, 
             ConversionRules :> {"HTML" -> {"<P>", "</P>"}}, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", Inherited}, 
             Hyphenation -> True, ParagraphSpacing -> {0, 8}, FontSize -> 12],
             
            Cell[
             StyleData["Text", "SlideShow"], 
             CellMargins -> {{70, 48}, {2, 7}}, Hyphenation -> False, 
             FontSize -> 12], 
            Cell[
             StyleData["Text", "Printout"], CellMargins -> {{2, 2}, {6, 6}}, 
             TextJustification -> 1, FontSize -> 10], 
            Cell[
             StyleData["Text", "EnhancedPrintout"], 
             CellMargins -> {{2, 2}, {6, 6}}, TextJustification -> 1, 
             FontFamily -> "Palatino", FontSize -> 10], 
            Cell[
             StyleData["Text", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 2}, {6, 6}}, TextJustification -> 1, 
             FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["CompactText"], CellMargins -> {{10, 4}, {0, 8}}, 
             ConversionRules :> {
              "HTML" -> {"<FONT SIZE=\"-1\">", "</FONT>\n"}}, Hyphenation -> 
             True, ParagraphSpacing -> {0, 0}, StyleMenuListing -> None, 
             FontSize -> 10], 
            Cell[
             StyleData["CompactText", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 8], 
            Cell[
             StyleData["CompactText", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 8], 
            Cell[
             StyleData["CompactText", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 8]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Compact12Text"], CellMargins -> {{10, 4}, {0, 8}}, 
             ConversionRules :> {"HTML" -> {"<P>", "</P>"}}, Hyphenation -> 
             True, ParagraphSpacing -> {0, 0}, StyleMenuListing -> None], 
            Cell[
             StyleData["Compact12Text", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10], 
            Cell[
             StyleData["Compact12Text", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10], 
            Cell[
             StyleData["Compact12Text", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TextSans"], CellMargins -> {{10, 4}, {0, 8}}, 
             ConversionRules :> {
              "HTML" -> {
                "<FONT SIZE=\"-1\" FACE=\"Helvetica, Arial\">", "</FONT>\n"}},
              CellHorizontalScrolling -> True, Hyphenation -> True, 
             ParagraphSpacing -> {0, 8}, StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 10], 
            Cell[
             StyleData["TextSans", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 8], 
            Cell[
             StyleData["TextSans", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 8], 
            Cell[
             StyleData["TextSans", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 8]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ItemizedText"], CellMargins -> {{20, 4}, {0, 5}}, 
             ConversionRules :> {"HTML" -> {"<BLOCKQUOTE>", "</BLOCKQUOTE>"}},
              Hyphenation -> True, LineSpacing -> {1, 3}, 
             ParagraphIndent -> -21, CounterIncrements -> "ItemizedText", 
             StyleMenuListing -> None], 
            Cell[
             StyleData["ItemizedText", "Printout"], ParagraphIndent -> -19, 
             FontSize -> 11], 
            Cell[
             StyleData["ItemizedText", "EnhancedPrintout"], 
             ParagraphIndent -> -18, FontFamily -> "Palatino", FontSize -> 
             10], 
            Cell[
             StyleData["ItemizedText", "EnhancedPrintoutNonGray"], 
             ParagraphIndent -> -18, FontFamily -> "Palatino", FontSize -> 
             10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ItemizedTextNote"], CellMargins -> {{41, 4}, {0, 4}}, 
             ConversionRules :> {"HTML" -> {"<BLOCKQUOTE>", "</BLOCKQUOTE>"}},
              Hyphenation -> True, LineSpacing -> {1, 2}, CounterIncrements -> 
             "Text", StyleMenuListing -> None], 
            Cell[
             StyleData["ItemizedTextNote", "Printout"], 
             CellMargins -> {{38, 4}, {0, 4}}, FontSize -> 11], 
            Cell[
             StyleData["ItemizedTextNote", "EnhancedPrintout"], 
             CellMargins -> {{38, 4}, {0, 4}}, FontFamily -> "Palatino", 
             FontSize -> 10], 
            Cell[
             StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{38, 4}, {0, 4}}, FontFamily -> "Palatino", 
             FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["IndentedText"], CellMargins -> {{20, 4}, {0, 6}}, 
             ConversionRules :> {"HTML" -> {"<BLOCKQUOTE>", "</BLOCKQUOTE>"}},
              LineSpacing -> {1, 3}, CounterIncrements -> "Text", 
             StyleMenuListing -> None], 
            Cell[
             StyleData["IndentedText", "SlideShow"], 
             CellMargins -> {{80, 24}, {5, 5}}, Hyphenation -> False, 
             FontSize -> 13], 
            Cell[
             StyleData["IndentedText", "Printout"], FontSize -> 11], 
            Cell[
             StyleData["IndentedText", "EnhancedPrintout"], FontFamily -> 
             "Palatino", FontSize -> 10], 
            Cell[
             StyleData["IndentedText", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Palatino", FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MathCaption"], CellDingbat -> "\[Placeholder]", 
             CellMargins -> {{19, 62}, {0, 14}}, 
             ConversionRules :> {
              "HTML" -> {
                "<LI TYPE=\"SQUARE\"><P><FONT COLOR=\"000066\">", 
                 "</FONT></P></LI>"}}, PageBreakBelow -> False, 
             CellFrameLabelMargins -> 4, Hyphenation -> True, 
             LineSpacing -> {1, 1}, ParagraphSpacing -> {0, 8}, FontColor -> 
             RGBColor[0, 0, 0.4]], 
            Cell[
             StyleData["MathCaption", "SlideShow"], ShowCellBracket -> False, 
             CellMargins -> {{36, 36}, {6, 6}}], 
            Cell[
             StyleData["MathCaption", "Printout"], 
             CellMargins -> {{9, 0}, {0, 14}}, FontSize -> 9, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["MathCaption", "EnhancedPrintout"], 
             CellMargins -> {{9, 0}, {0, 14}}, FontSize -> 9, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["MathCaption", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{9, 0}, {0, 14}}, FontSize -> 9, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SmallText"], CellMargins -> {{10, 4}, {0, 8}}, 
             ConversionRules :> {
              "HTML" -> {"<FONT SIZE=\"1\"><P>", "</P></FONT>"}}, Hyphenation -> 
             True, LineSpacing -> {1, 3}, ParagraphSpacing -> {0.7, 0}, 
             CounterIncrements -> "SmallText", FontSize -> 9], 
            Cell[
             StyleData["SmallText", "Printout"], 
             CellMargins -> {{2, 2}, {5, 5}}, TextJustification -> 1, 
             FontSize -> 7], 
            Cell[
             StyleData["SmallText", "EnhancedPrintout"], 
             CellMargins -> {{2, 2}, {5, 5}}, TextJustification -> 1, 
             FontFamily -> "Palatino", FontSize -> 7], 
            Cell[
             StyleData["SmallText", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 2}, {5, 5}}, TextJustification -> 1, 
             FontFamily -> "Palatino", FontSize -> 7]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Input/Output", "Section"], 
         Cell[
         "The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    ", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Input"], ShowCellBracket -> True, 
             CellMargins -> {{46, 4}, {3, 8}}, Evaluatable -> True, 
             CellGroupingRules -> "InputGrouping", PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, CellLabelAutoDelete -> False, 
             CellLabelMargins -> {{14, Inherited}, {Inherited, Inherited}}, 
             DefaultFormatType -> DefaultInputFormatType, 
             ShowSpecialCharacters -> Automatic, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             "Mathematica", FormatType -> StandardForm, ShowStringCharacters -> 
             True, NumberMarks -> True, FontWeight -> "Bold"], 
            Cell[
             StyleData["Input", "SlideShow"], CellFrame -> {{2, 2}, {0, 2}}, 
             ShowCellBracket -> True, CellMargins -> {{70, 50}, {0, 6}}, 
             PageBreakWithin -> False, GroupPageBreakWithin -> False, 
             CellFrameMargins -> {{5, 5}, {2, 5}}, CellFrameColor -> 
             RGBColor[0.869993, 0.449989, 0.219989], Background -> 
             RGBColor[1, 1, 0.8]], 
            Cell[
             StyleData["Input", "Printout"], ShowCellBracket -> False, 
             CellMargins -> {{39, 0}, {4, 6}}, FontSize -> 9], 
            Cell[
             StyleData["Input", "EnhancedPrintout"], ShowCellBracket -> False,
              CellMargins -> {{39, 0}, {4, 6}}, FontSize -> 9], 
            Cell[
             StyleData["Input", "EnhancedPrintoutNonGray"], ShowCellBracket -> 
             False, CellMargins -> {{39, 0}, {4, 6}}, FontSize -> 9]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Output"], ShowCellBracket -> True, 
             CellMargins -> {{47, 4}, {4, 2}}, CellEditDuplicate -> True, 
             CellGroupingRules -> "OutputGrouping", CellHorizontalScrolling -> 
             True, PageBreakWithin -> False, GroupPageBreakWithin -> False, 
             GeneratedCell -> True, CellAutoOverwrite -> True, 
             CellLabelAutoDelete -> False, 
             CellLabelMargins -> {{14, Inherited}, {Inherited, Inherited}}, 
             DefaultFormatType -> DefaultOutputFormatType, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             None, FormatType -> StandardForm], 
            Cell[
             StyleData["Output", "SlideShow"], CellFrame -> {{2, 2}, {2, 0}}, 
             ShowCellBracket -> True, CellMargins -> {{70, 50}, {6, 0}}, 
             PageBreakWithin -> False, GroupPageBreakWithin -> False, 
             CellFrameMargins -> {{8, 8}, {8, 4}}, CellFrameColor -> 
             RGBColor[0.869993, 0.449989, 0.219989], Background -> 
             RGBColor[1, 1, 0.8]], 
            Cell[
             StyleData["Output", "Printout"], ShowCellBracket -> False, 
             CellMargins -> {{39, 0}, {6, 4}}, FontSize -> 9], 
            Cell[
             StyleData["Output", "EnhancedPrintout"], ShowCellBracket -> 
             False, CellMargins -> {{39, 0}, {6, 4}}, FontSize -> 9], 
            Cell[
             StyleData["Output", "EnhancedPrintoutNonGray"], ShowCellBracket -> 
             False, CellMargins -> {{39, 0}, {6, 4}}, FontSize -> 9]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InputOnly"], ShowCellBracket -> True, 
             CellMargins -> {{46, 4}, {8, 8}}, Evaluatable -> True, 
             CellGroupingRules -> "InputGrouping", PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, CellLabelAutoDelete -> False, 
             CellLabelMargins -> {{14, Inherited}, {Inherited, Inherited}}, 
             DefaultFormatType -> DefaultInputFormatType, 
             ShowSpecialCharacters -> Automatic, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             "Mathematica", FormatType -> StandardForm, ShowStringCharacters -> 
             True, NumberMarks -> True, StyleMenuListing -> None, FontWeight -> 
             "Bold"], 
            Cell[
             StyleData["InputOnly", "SlideShow"], CellFrame -> 2, 
             ShowCellBracket -> True, CellMargins -> {{70, 57}, {4, 4}}, 
             PageBreakWithin -> False, GroupPageBreakWithin -> False, 
             CellFrameColor -> RGBColor[0.869993, 0.449989, 0.219989], 
             Background -> RGBColor[1, 1, 0.8]], 
            Cell[
             StyleData["InputOnly", "Printout"], ShowCellBracket -> False, 
             CellMargins -> {{39, 0}, {6, 6}}, FontSize -> 9], 
            Cell[
             StyleData["InputOnly", "EnhancedPrintout"], ShowCellBracket -> 
             False, CellMargins -> {{39, 0}, {6, 6}}, FontSize -> 9], 
            Cell[
             StyleData["InputOnly", "EnhancedPrintoutNonGray"], 
             ShowCellBracket -> False, CellMargins -> {{39, 0}, {6, 6}}, 
             FontSize -> 9]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Message"], ShowCellBracket -> True, 
             CellMargins -> {{47, 4}, {4, 2}}, CellGroupingRules -> 
             "OutputGrouping", PageBreakWithin -> False, GroupPageBreakWithin -> 
             False, GeneratedCell -> True, CellAutoOverwrite -> True, 
             ShowCellLabel -> False, 
             CellLabelMargins -> {{14, Inherited}, {Inherited, Inherited}}, 
             DefaultFormatType -> DefaultOutputFormatType, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             None, FormatType -> InputForm, StyleMenuListing -> None, 
             FontColor -> RGBColor[0, 0, 1]], 
            Cell[
             StyleData["Message", "SlideShow"], 
             CellMargins -> {{70, 30}, {4, 4}}, FontSize -> 10, FontColor -> 
             RGBColor[0.699992, 0.4, 0]], 
            Cell[
             StyleData["Message", "Printout"], ShowCellBracket -> False, 
             CellMargins -> {{39, Inherited}, {Inherited, Inherited}}, 
             FontSize -> 9, FontColor -> GrayLevel[0]], 
            Cell[
             StyleData["Message", "EnhancedPrintout"], ShowCellBracket -> 
             False, CellMargins -> {{39, Inherited}, {Inherited, Inherited}}, 
             FontFamily -> "Courier", FontSize -> 9, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["Message", "EnhancedPrintoutNonGray"], ShowCellBracket -> 
             False, CellMargins -> {{39, Inherited}, {Inherited, Inherited}}, 
             FontFamily -> "Courier", FontSize -> 9, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Print"], ShowCellBracket -> True, 
             CellMargins -> {{47, 4}, {4, 2}}, CellGroupingRules -> 
             "OutputGrouping", PageBreakWithin -> False, GroupPageBreakWithin -> 
             False, GeneratedCell -> True, CellAutoOverwrite -> True, 
             ShowCellLabel -> False, 
             CellLabelMargins -> {{14, Inherited}, {Inherited, Inherited}}, 
             DefaultFormatType -> DefaultOutputFormatType, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             None, FormatType -> InputForm, StyleMenuListing -> None], 
            Cell[
             StyleData["Print", "SlideShow"], 
             CellMargins -> {{100, 50}, {6, 6}}], 
            Cell[
             StyleData["Print", "Printout"], ShowCellBracket -> False, 
             CellMargins -> {{57, Inherited}, {Inherited, Inherited}}, 
             FontSize -> 9], 
            Cell[
             StyleData["Print", "EnhancedPrintout"], ShowCellBracket -> False,
              CellMargins -> {{57, Inherited}, {Inherited, Inherited}}, 
             FontFamily -> "Courier", FontSize -> 9], 
            Cell[
             StyleData["Print", "EnhancedPrintoutNonGray"], ShowCellBracket -> 
             False, CellMargins -> {{57, Inherited}, {Inherited, Inherited}}, 
             FontFamily -> "Courier", FontSize -> 9]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Graphics"], ShowCellBracket -> True, 
             CellMargins -> {{47, 4}, {4, 2}}, CellGroupingRules -> 
             "GraphicsGrouping", PageBreakWithin -> False, GeneratedCell -> 
             True, CellAutoOverwrite -> True, ShowCellLabel -> False, 
             DefaultFormatType -> DefaultFormatTypeForOutput, 
             LanguageCategory -> None, FormatType -> InputForm, 
             StyleMenuListing -> None, FontWeight -> "Plain"], 
            Cell[
             StyleData["Graphics", "SlideShow"], 
             CellFrame -> {{2, 2}, {2, 0}}, ShowCellBracket -> True, 
             CellMargins -> {{70, 50}, {6, 0}}, PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, 
             CellFrameMargins -> {{8, 8}, {4, 4}}, CellFrameColor -> 
             RGBColor[0.869993, 0.449989, 0.219989], Background -> 
             RGBColor[1, 1, 0.8]], 
            Cell[
             StyleData["Graphics", "Printout"], ShowCellBracket -> False, 
             CellMargins -> {{39, Inherited}, {Inherited, Inherited}}, 
             ImageSize -> {250, 250}, FontSize -> 9], 
            Cell[
             StyleData["Graphics", "EnhancedPrintout"], ShowCellBracket -> 
             False, CellMargins -> {{39, Inherited}, {Inherited, Inherited}}, 
             ImageSize -> {250, 250}, FontFamily -> "Courier", FontSize -> 9],
             
            Cell[
             StyleData["Graphics", "EnhancedPrintoutNonGray"], 
             ShowCellBracket -> False, 
             CellMargins -> {{39, Inherited}, {Inherited, Inherited}}, 
             ImageSize -> {250, 250}, FontFamily -> "Courier", FontSize -> 
             9]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["CellLabel"], LanguageCategory -> None, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
             9, FontWeight -> "Plain", FontColor -> RGBColor[0, 0, 1]], 
            Cell[
             StyleData["CellLabel", "SlideShow"], FontColor -> 
             RGBColor[0.699992, 0.4, 0]], 
            Cell[
             StyleData["CellLabel", "Printout"], FontFamily -> "Courier", 
             FontSize -> 8, FontSlant -> "Italic", FontColor -> GrayLevel[0]],
             
            Cell[
             StyleData["CellLabel", "EnhancedPrintout"], FontFamily -> 
             "Courier", FontSize -> 8, FontSlant -> "Italic", FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["CellLabel", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Courier", FontSize -> 8, FontSlant -> "Italic", FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Name"], StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
             "Italic", FontColor -> RGBColor[0, 0, 1]], 
            Cell[
             StyleData["Name", "Printout"], FontSize -> 7, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["Name", "EnhancedPrintout"], FontSize -> 7, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["Name", "EnhancedPrintoutNonGray"], FontSize -> 7, 
             FontColor -> GrayLevel[0]]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Hyperlinks", "Section"], 
         Cell[
         "The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks. The others point to the various sections of the help \
browser. These styles will modify individual words or letters in a cell \
exclusive of the cell tag.", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Hyperlink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`NotebookLocate[#2]}]& ), ButtonNote -> 
               ButtonData}], 
            Cell[
             StyleData["Hyperlink", "Printout"], FontSize -> 11, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["Hyperlink", "EnhancedPrintout"], FontFamily -> 
             "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["Hyperlink", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MainBookLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["MainBook", #]}]& )}], 
            Cell[
             StyleData["MainBookLink", "Printout"], FontSize -> 11, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["MainBookLink", "EnhancedPrintout"], FontFamily -> 
             "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["MainBookLink", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MainBookLinkMR"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, FontFamily -> "Courier", 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["MainBook", #]}]& )}], 
            Cell[
             StyleData["MainBookLinkMR", "Printout"], FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["MainBookLinkMR", "EnhancedPrintout"], FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["MainBookLinkMR", "EnhancedPrintoutNonGray"], FontSize -> 
             10, FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["AddOnsLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, FontFamily -> "Courier", 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["AddOns", #]}]& )}], 
            Cell[
             StyleData["AddOnsLink", "Printout"], FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["AddOnsLink", "EnhancedPrintout"], FontFamily -> 
             "WRICourier", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["AddOnsLink", "EnhancedPrintoutNonGray"], FontFamily -> 
             "WRICourier", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["AddOnsLinkText"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, FontFamily -> "Times", 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["AddOns", #]}]& )}], 
            Cell[
             StyleData["AddOnsLinkText", "Printout"], FontSize -> 11, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["AddOnsLinkText", "EnhancedPrintout"], FontFamily -> 
             "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"], 
             FontFamily -> "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["RefGuideLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, FontFamily -> "Courier", 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["RefGuide", #]}]& )}], 
            Cell[
             StyleData["RefGuideLink", "Printout"], FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["RefGuideLink", "EnhancedPrintout"], FontFamily -> 
             "WRICourier", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["RefGuideLink", "EnhancedPrintoutNonGray"], FontFamily -> 
             "WRICourier", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["RefGuideLinkText"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["RefGuide", #]}]& )}], 
            Cell[
             StyleData["RefGuideLinkText", "Printout"], FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["RefGuideLinkText", "EnhancedPrintout"], FontSize -> 
             10, FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["RefGuideLinkText", "EnhancedPrintoutNonGray"], 
             FontSize -> 10, FontVariations -> {"Underline" -> False}, 
             FontColor -> GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["GettingStartedLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["GettingStarted", #]}]& )}], 
            Cell[
             StyleData["GettingStartedLink", "Printout"], FontSize -> 11, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["GettingStartedLink", "EnhancedPrintout"], FontFamily -> 
             "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"], 
             FontFamily -> "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["OtherInformationLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["OtherInformation", #]}]& )}], 
            Cell[
             StyleData["OtherInformationLink", "Printout"], FontSize -> 11, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["OtherInformationLink", "EnhancedPrintout"], 
             FontFamily -> "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"], 
             FontFamily -> "Palatino", FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["OtherInformationLinkMR"], StyleMenuListing -> None, 
             FontFamily -> "Courier", FontVariations -> {"Underline" -> True},
              FontColor -> RGBColor[0, 0, 1], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFrame -> "None", 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["OtherInformation", #]}]& )}], 
            Cell[
             StyleData["OtherInformationLinkMR", "Printout"], FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["OtherInformationLinkMR", "EnhancedPrintout"], 
             FontSize -> 10, FontVariations -> {"Underline" -> False}, 
             FontColor -> GrayLevel[0]], 
            Cell[
             StyleData["OtherInformationLinkMR", "EnhancedPrintoutNonGray"], 
             FontSize -> 10, FontVariations -> {"Underline" -> False}, 
             FontColor -> GrayLevel[0]]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Palette Styles", "Section"], 
         Cell[
         "The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.", "Text"], 
         Cell[
          StyleData["Paste"], StyleMenuListing -> None, 
          ButtonStyleMenuListing -> Automatic, 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               FrontEnd`NotebookApply[
                FrontEnd`InputNotebook[], #, After]}]& )}], 
         Cell[
          StyleData["Evaluate"], StyleMenuListing -> None, 
          ButtonStyleMenuListing -> Automatic, 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               FrontEnd`NotebookApply[
                FrontEnd`InputNotebook[], #, All], 
               SelectionEvaluate[
                FrontEnd`InputNotebook[], All]}]& )}], 
         Cell[
          StyleData["EvaluateCell"], StyleMenuListing -> None, 
          ButtonStyleMenuListing -> Automatic, 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               FrontEnd`NotebookApply[
                FrontEnd`InputNotebook[], #, All], 
               FrontEnd`SelectionMove[
                FrontEnd`InputNotebook[], All, Cell, 1], 
               FrontEnd`SelectionEvaluateCreateCell[
                FrontEnd`InputNotebook[], All]}]& )}], 
         Cell[
          StyleData["CopyEvaluate"], StyleMenuListing -> None, 
          ButtonStyleMenuListing -> Automatic, 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               FrontEnd`SelectionCreateCell[
                FrontEnd`InputNotebook[], All], 
               FrontEnd`NotebookApply[
                FrontEnd`InputNotebook[], #, All], 
               FrontEnd`SelectionEvaluate[
                FrontEnd`InputNotebook[], All]}]& )}], 
         Cell[
          StyleData["CopyEvaluateCell"], StyleMenuListing -> None, 
          ButtonStyleMenuListing -> Automatic, 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               FrontEnd`SelectionCreateCell[
                FrontEnd`InputNotebook[], All], 
               FrontEnd`NotebookApply[
                FrontEnd`InputNotebook[], #, All], 
               FrontEnd`SelectionEvaluateCreateCell[
                FrontEnd`InputNotebook[], All]}]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Inline Formatting", "Section"], 
         Cell[
         "These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["JT"], StyleMenuListing -> None, FontFamily -> 
             "JFontText"], 
            Cell[
             StyleData["JT", "Printout"]], 
            Cell[
             StyleData["JT", "EnhancedPrintout"]], 
            Cell[
             StyleData["JT", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["JS"], StyleMenuListing -> None, FontFamily -> 
             "JFontSans"], 
            Cell[
             StyleData["JS", "Printout"]], 
            Cell[
             StyleData["JS", "EnhancedPrintout"]], 
            Cell[
             StyleData["JS", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["JSB"], StyleMenuListing -> None, FontFamily -> 
             "JFontSansBold"], 
            Cell[
             StyleData["JSB", "Printout"]], 
            Cell[
             StyleData["JSB", "EnhancedPrintout"]], 
            Cell[
             StyleData["JSB", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["RM"], StyleMenuListing -> None, FontWeight -> "Plain",
              FontSlant -> "Plain"], 
            Cell[
             StyleData["RM", "Printout"]], 
            Cell[
             StyleData["RM", "EnhancedPrintout"]], 
            Cell[
             StyleData["RM", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["BF"], ConversionRules :> {"HTML" -> {"<B>", "</B>"}}, 
             StyleMenuListing -> None, FontWeight -> "Bold"], 
            Cell[
             StyleData["BF", "Printout"]], 
            Cell[
             StyleData["BF", "EnhancedPrintout"]], 
            Cell[
             StyleData["BF", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["IT"], ConversionRules :> {"HTML" -> {"<I>", "</I>"}}, 
             StyleMenuListing -> None, FontSlant -> "Italic"], 
            Cell[
             StyleData["IT", "Printout"]], 
            Cell[
             StyleData["IT", "EnhancedPrintout"]], 
            Cell[
             StyleData["IT", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TR"], StyleMenuListing -> None, FontFamily -> "Times",
              FontWeight -> "Plain", FontSlant -> "Plain"], 
            Cell[
             StyleData["TR", "Printout"]], 
            Cell[
             StyleData["TR", "EnhancedPrintout"]], 
            Cell[
             StyleData["TR", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TI"], ConversionRules :> {"HTML" -> {"<I>", "</I>"}}, 
             StyleMenuListing -> None, FontFamily -> "Times", FontSlant -> 
             "Italic"], 
            Cell[
             StyleData["TI", "Printout"]], 
            Cell[
             StyleData["TI", "EnhancedPrintout"]], 
            Cell[
             StyleData["TI", "EnhancedPrintoutNonGray"]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TB"], ConversionRules :> {"HTML" -> {"<B>", "</B>"}}, 
             StyleMenuListing -> None, FontFamily -> "Times", FontWeight -> 
             "Bold", FontSlant -> "Plain"], 
            Cell[
             StyleData["TB", "Printout"]], 
            Cell[
             StyleData["TB", "EnhancedPrintout"], FontFamily -> "Palatino"], 
            Cell[
             StyleData["TB", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Palatino"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TBI"], 
             ConversionRules :> {"HTML" -> {"<B><I>", "</B></I>"}}, 
             StyleMenuListing -> None, FontFamily -> "Times", FontWeight -> 
             "Bold", FontSlant -> "Italic"], 
            Cell[
             StyleData["TBI", "Printout"]], 
            Cell[
             StyleData["TBI", "EnhancedPrintout"], FontFamily -> "Palatino"], 
            
            Cell[
             StyleData["TBI", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Palatino"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MR"], 
             ConversionRules :> {"HTML" -> {"<TT>", "</TT>"}}, Hyphenation -> 
             True, HyphenationOptions -> {"HyphenationCharacter" -> " "}, 
             StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
             "Plain", FontSlant -> "Plain"], 
            Cell[
             StyleData["MR", "Printout"]], 
            Cell[
             StyleData["MR", "EnhancedPrintout"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"], 
            Cell[
             StyleData["MR", "EnhancedPrintoutNonGray"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MO"], 
             ConversionRules :> {"HTML" -> {"<TT><I>", "</TT></I>"}}, 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, 
             StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
             "Plain", FontSlant -> "Italic"], 
            Cell[
             StyleData["MO", "Printout"]], 
            Cell[
             StyleData["MO", "EnhancedPrintout"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"], 
            Cell[
             StyleData["MO", "EnhancedPrintoutNonGray"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MB"], 
             ConversionRules :> {"HTML" -> {"<TT><B>", "</TT></B>"}}, 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, 
             StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
             "Bold", FontSlant -> "Plain"], 
            Cell[
             StyleData["MB", "Printout"]], 
            Cell[
             StyleData["MB", "EnhancedPrintout"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"], 
            Cell[
             StyleData["MB", "EnhancedPrintoutNonGray"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MBO"], 
             ConversionRules :> {"HTML" -> {"<TT><I><B>", "</TT></I></B>"}}, 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, 
             StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
             "Bold", FontSlant -> "Italic"], 
            Cell[
             StyleData["MBO", "Printout"]], 
            Cell[
             StyleData["MBO", "EnhancedPrintout"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"], 
            Cell[
             StyleData["MBO", "EnhancedPrintoutNonGray"], 
             HyphenationOptions -> {"HyphenationCharacter" -> ""}, FontFamily -> 
             "WriCourier"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SR"], 
             ConversionRules :> {
              "HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontWeight -> 
             "Plain", FontSlant -> "Plain"], 
            Cell[
             StyleData["SR", "Printout"]], 
            Cell[
             StyleData["SR", "EnhancedPrintout"], FontFamily -> "Futura"], 
            Cell[
             StyleData["SR", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Futura"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SO"], 
             ConversionRules :> {
              "HTML" -> {"<I><Font=Futura>", "</I></Font>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontWeight -> 
             "Plain", FontSlant -> "Italic"], 
            Cell[
             StyleData["SO", "Printout"], 
             ConversionRules :> {
              "HTML" -> {"<I><Font=Futura>", "</I></Font>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontWeight -> 
             "Plain", FontSlant -> "Italic"], 
            Cell[
             StyleData["SO", "EnhancedPrintout"], FontFamily -> "Futura"], 
            Cell[
             StyleData["SO", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Futura"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SB"], 
             ConversionRules :> {
              "HTML" -> {"<B><Font=Futura>", "</B></Font>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontWeight -> 
             "Bold", FontSlant -> "Plain"], 
            Cell[
             StyleData["SB", "Printout"], 
             ConversionRules :> {
              "HTML" -> {"<B><Font=Futura>", "</B></Font>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontWeight -> 
             "Bold", FontSlant -> "Plain"], 
            Cell[
             StyleData["SB", "EnhancedPrintout"], FontFamily -> "Futura"], 
            Cell[
             StyleData["SB", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Futura"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SBO"], 
             ConversionRules :> {
              "HTML" -> {"<B><I><Font=Futura>", "</B></I></Font>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontWeight -> 
             "Bold", FontSlant -> "Italic"], 
            Cell[
             StyleData["SBO", "Printout"], 
             ConversionRules :> {
              "HTML" -> {"<B><I><Font=Futura>", "</B></I></Font>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontWeight -> 
             "Bold", FontSlant -> "Italic"], 
            Cell[
             StyleData["SBO", "EnhancedPrintout"], FontFamily -> "Futura"], 
            Cell[
             StyleData["SBO", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Futura"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["M4"], ShowCellBracket -> True, StyleMenuListing -> 
             None, FontFamily -> "Math4", CharacterEncoding -> "Math4"], 
            Cell[
             StyleData["M4", "Printout"], ShowCellBracket -> True, 
             StyleMenuListing -> None, FontFamily -> "Math4", 
             CharacterEncoding -> "Math4"], 
            Cell[
             StyleData["M4", "EnhancedPrintout"], ShowCellBracket -> True, 
             StyleMenuListing -> None, FontFamily -> "Math4", 
             CharacterEncoding -> "Math4"], 
            Cell[
             StyleData["M4", "EnhancedPrintoutNonGray"], ShowCellBracket -> 
             True, StyleMenuListing -> None, FontFamily -> "Math4", 
             CharacterEncoding -> "Math4"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SO10"], 
             ConversionRules :> {
              "HTML" -> {"<Font=Helvetica, Arial><I>", "</Font></I>"}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
             10, FontWeight -> "Plain", FontSlant -> "Italic"], 
            Cell[
             StyleData["SO10", "Printout"], StyleMenuListing -> None, 
             FontFamily -> "Helvetica", FontSize -> 8, FontWeight -> "Plain", 
             FontSlant -> "Italic"], 
            Cell[
             StyleData["SO10", "EnhancedPrintout"], StyleMenuListing -> None, 
             FontFamily -> "Futura", FontSize -> 8, FontWeight -> "Plain", 
             FontSlant -> "Italic"], 
            Cell[
             StyleData["SO10", "EnhancedPrintoutNonGray"], StyleMenuListing -> 
             None, FontFamily -> "Futura", FontSize -> 8, FontWeight -> 
             "Plain", FontSlant -> "Italic"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["C1"], StyleMenuListing -> None, FontColor -> 
             RGBColor[0.4, 0, 1]], 
            Cell[
             StyleData["C1", "Printout"], FontColor -> GrayLevel[0]], 
            Cell[
             StyleData["C1", "EnhancedPrintout"], FontColor -> GrayLevel[0]], 
            
            Cell[
             StyleData["C1", "EnhancedPrintoutNonGray"], FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["C1MR"], StyleMenuListing -> None, FontFamily -> 
             "Courier", FontColor -> RGBColor[0.4, 0, 1]], 
            Cell[
             StyleData["C1MR", "Printout"], FontColor -> GrayLevel[0]], 
            Cell[
             StyleData["C1MR", "EnhancedPrintout"], FontColor -> 
             GrayLevel[0]], 
            Cell[
             StyleData["C1MR", "EnhancedPrintoutNonGray"], FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
          StyleData["KeyStroke"], Magnification -> 1.2]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Emphasis Boxes and Pictures", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Box"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, StyleMenuListing -> None, 
             Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["Box", "Printout"], CellMargins -> {{2, 0}, {0, 8}}, 
             FontSize -> 10, Background -> GrayLevel[0.900008]], 
            Cell[
             StyleData["Box", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["Box", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DoubleBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, StyleMenuListing -> None, 
             Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Top}}, "RowsIndexed" -> {}}, 
               GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["DoubleBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["DoubleBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["DoubleBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["1ColumnBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["1ColumnBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["1ColumnBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["1ColumnBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["2ColumnBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.31], {
                    Scaled[0.67]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["2ColumnBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["2ColumnBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["2ColumnBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["2ColumnEvenBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.46]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["2ColumnEvenBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["2ColumnEvenBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["2ColumnEvenBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["2ColumnSmallBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[1.0499999999999998`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["2ColumnSmallBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["2ColumnSmallBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["2ColumnSmallBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["3ColumnBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.32]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["3ColumnBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["3ColumnBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["3ColumnBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["3ColumnSmallBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {Right, Center, {Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.24]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[1.0499999999999998`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["3ColumnSmallBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["3ColumnSmallBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["3ColumnSmallBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["4ColumnBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.13], 
                   Scaled[0.35], 
                   Scaled[0.13], {
                    Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["4ColumnBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["4ColumnBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["4ColumnBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["5ColumnBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.202]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
                  "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["5ColumnBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["5ColumnBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["5ColumnBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["6ColumnBox"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, Background -> RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {BoxFrame -> 0.5, FrameMargins -> True}, 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.12], 
                   Scaled[0.22], 
                   Scaled[0.12], 
                   Scaled[0.12], 
                   Scaled[0.22], {
                    Scaled[0.12]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["6ColumnBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["6ColumnBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["6ColumnBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ItemizedNoteBox"], CellFrame -> 0.5, 
             CellMargins -> {{41, 4}, {4, 8}}, CellHorizontalScrolling -> 
             True, LineIndent -> 0, StyleMenuListing -> None, Background -> 
             RGBColor[1, 0.6, 0.6], 
             FrameBoxOptions -> {FrameMargins -> {{1, 1}, {1.5, 1.5}}}, 
             GridBoxOptions -> {GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["ItemizedNoteBox", "Printout"], FontSize -> 10, 
             Background -> GrayLevel[0.900008]], 
            Cell[
             StyleData["ItemizedNoteBox", "EnhancedPrintout"], 
             CellMargins -> {{37, 4}, {6, 6}}, FontSize -> 10, Background -> 
             GrayLevel[0.900008]], 
            Cell[
             StyleData["ItemizedNoteBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{37, 4}, {6, 6}}, FontSize -> 10, Background -> 
             GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DefinitionBox"], CellFrame -> 0.5, 
             CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
             True, PageBreakWithin -> False, AutoIndent -> False, AutoSpacing -> 
             False, LineIndent -> 0, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.4], {
                    Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["DefinitionBox", "Printout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DefinitionBox3Col"], CellFrame -> 0.5, 
             CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
             True, PageBreakWithin -> False, AutoIndent -> False, AutoSpacing -> 
             False, LineIndent -> 0, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.35], 
                   Scaled[0.2], {
                    Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["DefinitionBox3Col", "SlideShow"], CellFrame -> 2, 
             CellMargins -> {{70, 50}, {4, 4}}, 
             CellFrameMargins -> {{5, 5}, {3, 3}}, CellFrameColor -> 
             RGBColor[0.869993, 0.449989, 0.219989], FontSize -> 12, 
             Background -> RGBColor[1, 1, 0.8]], 
            Cell[
             StyleData["DefinitionBox3Col", "Printout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox3Col", "EnhancedPrintout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DefinitionBox4Col"], CellFrame -> 0.5, 
             CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
             True, PageBreakWithin -> False, AutoIndent -> False, AutoSpacing -> 
             False, LineIndent -> 0, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.15], 
                   Scaled[0.35], 
                   Scaled[0.15], {
                    Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["DefinitionBox4Col", "Printout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox4Col", "EnhancedPrintout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DefinitionBox5Col"], CellFrame -> 0.5, 
             CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
             True, PageBreakWithin -> False, AutoIndent -> False, AutoSpacing -> 
             False, LineIndent -> 0, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.2]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["DefinitionBox5Col", "Printout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox5Col", "EnhancedPrintout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DefinitionBox6Col"], CellFrame -> 0.5, 
             CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
             True, PageBreakWithin -> False, AutoIndent -> False, AutoSpacing -> 
             False, LineIndent -> 0, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.13], 
                   Scaled[0.24], 
                   Scaled[0.13], 
                   Scaled[0.13], 
                   Scaled[0.24], {
                    Scaled[0.13]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["DefinitionBox6Col", "Printout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox6Col", "EnhancedPrintout"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]], 
            Cell[
             StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 4}, {0, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TopBox"], CellFrame -> {{0.5, 0.5}, {0, 0.5}}, 
             CellMargins -> {{11, 4}, {0, 8}}, CellHorizontalScrolling -> 
             True, PageBreakBelow -> False, AutoIndent -> False, AutoSpacing -> 
             False, LineIndent -> 0, StyleMenuListing -> None, FontWeight -> 
             "Plain", Background -> RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.31], {
                    Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["TopBox", "Printout"], CellMargins -> {{2, 0}, {0, 8}},
              Background -> GrayLevel[1]], 
            Cell[
             StyleData["TopBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontFamily -> "Palatino", 
             Background -> GrayLevel[1]], 
            Cell[
             StyleData["TopBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontFamily -> "Palatino", 
             Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MiddleBox"], CellFrame -> {{0.5, 0.5}, {0, 0}}, 
             CellMargins -> {{11, 4}, {0, -7}}, CellHorizontalScrolling -> 
             True, PageBreakAbove -> False, PageBreakBelow -> False, 
             AutoIndent -> False, AutoSpacing -> False, LineIndent -> 0, 
             StyleMenuListing -> None, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.31], {
                    Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["MiddleBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, 2}}, Background -> GrayLevel[1]], 
            Cell[
             StyleData["MiddleBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 4}}, FontFamily -> "Palatino", 
             Background -> GrayLevel[1]], 
            Cell[
             StyleData["MiddleBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 4}}, FontFamily -> "Palatino", 
             Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["BottomBox"], CellFrame -> {{0.5, 0.5}, {0.5, 0}}, 
             CellMargins -> {{11, 4}, {0, -7}}, CellHorizontalScrolling -> 
             True, PageBreakAbove -> False, PageBreakBelow -> False, 
             AutoIndent -> False, AutoSpacing -> False, LineIndent -> 0, 
             StyleMenuListing -> None, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.31], {
                    Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["BottomBox", "Printout"], 
             CellMargins -> {{2, 0}, {0, -5}}, FontSize -> 10, Background -> 
             GrayLevel[1], 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{2.2}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["BottomBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, -5}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1], 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{2.2}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["BottomBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, -5}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1], 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{2.2}}, "RowsIndexed" -> {}}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TopSpanBox"], CellFrame -> {{0.5, 0.5}, {0, 0.5}}, 
             CellMargins -> {{11, 4}, {-2, 8}}, CellHorizontalScrolling -> 
             True, PageBreakBelow -> False, AutoIndent -> False, AutoSpacing -> 
             False, LineIndent -> 0, StyleMenuListing -> None, FontWeight -> 
             "Plain", Background -> RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.9], {
                    Scaled[0.03]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["TopSpanBox", "Printout"], 
             CellMargins -> {{2, 0}, {-2, 8}}, FontSize -> 10, Background -> 
             GrayLevel[1]], 
            Cell[
             StyleData["TopSpanBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {-4, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]], 
            Cell[
             StyleData["TopSpanBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {-4, 8}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MiddleSpanBox"], CellFrame -> {{0.5, 0.5}, {0, 0}}, 
             CellMargins -> {{11, 4}, {0, 0}}, CellHorizontalScrolling -> 
             True, PageBreakAbove -> False, PageBreakBelow -> False, 
             AutoIndent -> False, AutoSpacing -> False, LineIndent -> 0, 
             StyleMenuListing -> None, FontWeight -> "Plain", Background -> 
             RGBColor[1, 0.6, 0.6], 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.9], {
                    Scaled[0.03]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.6]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["MiddleSpanBox", "Printout"], 
             CellMargins -> {{2, 0}, {-5, 0}}, FontSize -> 10, Background -> 
             GrayLevel[1], 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.8}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["MiddleSpanBox", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {-7, 0}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1], 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.8}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {-7, 0}}, FontFamily -> "Palatino", 
             FontSize -> 10, Background -> GrayLevel[1], 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.8}}, "RowsIndexed" -> {}}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Picture"], CellMargins -> {{12, Inherited}, {0, 8}}, 
             CellHorizontalScrolling -> True, StyleMenuListing -> None], 
            Cell[
             StyleData["Picture", "Printout"], 
             CellMargins -> {{2, Inherited}, {0, 8}}, Magnification -> 0.65], 
            
            Cell[
             StyleData["Picture", "EnhancedPrintout"], 
             CellMargins -> {{2, Inherited}, {0, 8}}, Magnification -> 0.65], 
            
            Cell[
             StyleData["Picture", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, Inherited}, {0, 8}}, Magnification -> 0.65]},
            Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ItemizedPicture"], CellMargins -> {{41, 4}, {4, 4}}, 
             CellGroupingRules -> "GraphicsGrouping", CellHorizontalScrolling -> 
             True, StyleMenuListing -> None], 
            Cell[
             StyleData["ItemizedPicture", "Printout"], 
             CellMargins -> {{77, 2}, {4, -4}}, Magnification -> 0.5], 
            Cell[
             StyleData["ItemizedPicture", "EnhancedPrintout"], 
             CellMargins -> {{75, 2}, {4, -6}}, Magnification -> 0.5], 
            Cell[
             StyleData["ItemizedPicture", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{75, 2}, {4, -6}}, Magnification -> 0.5]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["PictureGroup"], CellMargins -> {{41, 4}, {0, 4}}, 
             CellGroupingRules -> "GraphicsGrouping", CellHorizontalScrolling -> 
             True, StyleMenuListing -> None], 
            Cell[
             StyleData["PictureGroup", "Printout"], 
             CellElementSpacings -> {"ClosedCellHeight" -> 2}, CellOpen -> 
             False, FontSize -> 12], 
            Cell[
             StyleData["PictureGroup", "EnhancedPrintout"], 
             CellElementSpacings -> {"ClosedCellHeight" -> 2}, CellOpen -> 
             False, FontSize -> 12], 
            Cell[
             StyleData["PictureGroup", "EnhancedPrintoutNonGray"], 
             CellElementSpacings -> {"ClosedCellHeight" -> 2}, CellOpen -> 
             False, FontSize -> 12]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Sound"], ShowCellBracket -> True, 
             CellMargins -> {{10, Inherited}, {0, 8}}, StyleMenuListing -> 
             None], 
            Cell[
             StyleData["Sound", "Printout"], CellMargins -> {{2, 0}, {0, 8}}, 
             FontSize -> 10], 
            Cell[
             StyleData["Sound", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10], 
            Cell[
             StyleData["Sound", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Caption"], CellMargins -> {{10, 4}, {0, 3}}, 
             PageBreakAbove -> False, StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 9], 
            Cell[
             StyleData["Caption", "Printout"], 
             CellMargins -> {{2, 4}, {2, 0}}, FontSize -> 7], 
            Cell[
             StyleData["Caption", "EnhancedPrintout"], 
             CellMargins -> {{5, 4}, {2, -2}}, FontFamily -> "Futura", 
             FontSize -> 7], 
            Cell[
             StyleData["Caption", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{5, 4}, {2, -2}}, FontFamily -> "Futura", 
             FontSize -> 7]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Tables", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["2ColumnTable"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.34], {
                    Scaled[0.64]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["2ColumnTable", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}], 
            Cell[
             StyleData["2ColumnTable", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}], 
            Cell[
             StyleData["2ColumnTable", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["2ColumnEvenTable"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.49]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["2ColumnEvenTable", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}], 
            Cell[
             StyleData["2ColumnEvenTable", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}], 
            Cell[
             StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["3ColumnTable"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, LineIndent -> 0, 
             StyleMenuListing -> None, 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.28], 
                   Scaled[0.28], {
                    Scaled[0.43]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["3ColumnTable", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}], 
            Cell[
             StyleData["3ColumnTable", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}], 
            Cell[
             StyleData["3ColumnTable", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Formulas and Programming", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineFormula"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             "Formula", ScriptLevel -> 1, SingleLetterItalics -> True, 
             SpanMaxSize -> Infinity, StyleMenuListing -> None, 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["InlineFormula", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10], 
            Cell[
             StyleData["InlineFormula", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10], 
            Cell[
             StyleData["InlineFormula", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineOutput"], CellMargins -> {{10, 4}, {0, 8}}, 
             CellHorizontalScrolling -> True, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             None, StyleMenuListing -> None, FontFamily -> "Courier"], 
            Cell[
             StyleData["InlineOutput", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9.5], 
            Cell[
             StyleData["InlineOutput", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9.5], 
            Cell[
             StyleData["InlineOutput", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9.5]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DisplayFormula"], 
             CellMargins -> {{42, Inherited}, {Inherited, 10}}, 
             CellHorizontalScrolling -> True, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             "Formula", ScriptLevel -> 0, SingleLetterItalics -> True, 
             SpanMaxSize -> Infinity, StyleMenuListing -> None, 
             UnderoverscriptBoxOptions -> {LimitsPositioning -> True}, 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["DisplayFormula", "Printout"]], 
            Cell[
             StyleData["DisplayFormula", "EnhancedPrintout"], FontFamily -> 
             "Palatino"], 
            Cell[
             StyleData["DisplayFormula", "EnhancedPrintoutNonGray"], 
             FontFamily -> "Palatino"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DisplayMath"], CellMargins -> {{42, 10}, {7, 7}}, 
             Evaluatable -> False, CellGroupingRules -> "InputGrouping", 
             CellHorizontalScrolling -> True, PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, DefaultFormatType -> 
             DefaultInputFormatType, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, 
             AutoItalicWords -> {}, LanguageCategory -> "Formula", FormatType -> 
             InputForm, ShowStringCharacters -> True, NumberMarks -> True, 
             CounterIncrements -> "Input"], 
            Cell[
             StyleData["DisplayMath", "Printout"], 
             CellMargins -> {{39, 0}, {6, 6}}, FontSize -> 9], 
            Cell[
             StyleData["DisplayMath", "EnhancedPrintout"], 
             CellMargins -> {{39, 0}, {4, 6}}, FontFamily -> "WRICourier", 
             FontSize -> 9], 
            Cell[
             StyleData["DisplayMath", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{39, 0}, {4, 6}}, FontFamily -> "WRICourier", 
             FontSize -> 9]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["NumberedEquation"], CellMargins -> {{45, 10}, {7, 7}},
              CellFrameLabels -> {{None, 
                Cell[
                 TextData[{"(", 
                   CounterBox["NumberedEquation"], ")"}]]}, {None, None}}, 
             DefaultFormatType -> DefaultInputFormatType, LanguageCategory -> 
             "Formula", CounterIncrements -> "NumberedEquation", 
             FormatTypeAutoConvert -> False], 
            Cell[
             StyleData["NumberedEquation", "Printout"], 
             CellMargins -> {{39, 55}, {0, 10}}, FontSize -> 10], 
            Cell[
             StyleData["NumberedEquation", "EnhancedPrintout"], 
             CellMargins -> {{39, 55}, {0, 10}}, FontFamily -> "Palatino", 
             FontSize -> 10], 
            Cell[
             StyleData["NumberedEquation", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{39, 55}, {0, 10}}, FontFamily -> "Palatino", 
             FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["EquationNumber"], LineSpacing -> {1.83, 0}, 
             LanguageCategory -> "Formula"], 
            Cell[
             StyleData["EquationNumber", "Printout"], 
             LineSpacing -> {1.7, 0}], 
            Cell[
             StyleData["EquationNumber", "EnhancedPrintout"], 
             LineSpacing -> {1.7, 0}, FontFamily -> "Palatino"], 
            Cell[
             StyleData["EquationNumber", "EnhancedPrintoutNonGray"], 
             LineSpacing -> {1.7, 0}, FontFamily -> "Palatino"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Program"], 
             CellMargins -> {{16, Inherited}, {Inherited, 10}}, 
             CellHorizontalScrolling -> True, LanguageCategory -> "Formula", 
             FontFamily -> "Courier"], 
            Cell[
             StyleData["Program", "Printout"], 
             CellMargins -> {{42, 30}, {Inherited, 4}}, FontSize -> 9.5], 
            Cell[
             StyleData["Program", "EnhancedPrintout"], 
             CellMargins -> {{42, 30}, {Inherited, 4}}, FontFamily -> 
             "WRICourier", FontSize -> 9.5], 
            Cell[
             StyleData["Program", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{42, 30}, {Inherited, 4}}, FontFamily -> 
             "WRICourier", FontSize -> 9.5]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Unique Help Browser Styles", "Section"], 
         Cell[
          CellGroupData[{
            Cell["Standard Styles\n", "Subsection"], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["InspectorLevel1"], ShowGroupOpener -> True, 
                CellMargins -> {{12, 10}, {2, 7}}, 
                CellGroupingRules -> {"SectionGrouping", 60}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -38, StyleMenuListing -> None, FontFamily -> 
                "Helvetica", FontSize -> 16, FontWeight -> "Bold"], 
               Cell[
                StyleData["InspectorLevel1", "Brackets"], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}], 
               Cell[
                StyleData["InspectorLevel1", "SlideShow"], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}], 
               Cell[
                StyleData["InspectorLevel1", "Printout"], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 14]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["InspectorLevel2"], ShowGroupOpener -> True, 
                CellMargins -> {{10, 4}, {0, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
                14, FontWeight -> "Bold"], 
               Cell[
                StyleData["InspectorLevel2", "Brackets"], ShowGroupOpener -> 
                True, CellMargins -> {{48, 10}, {2, 12}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -27, FontFamily -> "Helvetica", FontSize -> 
                14, FontWeight -> "Bold"], 
               Cell[
                StyleData["InspectorLevel2", "SlideShow"], ShowGroupOpener -> 
                True, CellMargins -> {{48, 10}, {2, 12}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -27, FontFamily -> "Helvetica", FontSize -> 
                14, FontWeight -> "Bold"], 
               Cell[
                StyleData["InspectorLevel2", "Printout"], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 12]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ObjectName"], CellMargins -> {{10, 4}, {1, 10}}, 
                CellGroupingRules -> {"SectionGrouping", 50}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                16, FontWeight -> "Bold"], 
               Cell[
                StyleData["ObjectName", "Brackets"], 
                CellMargins -> {{72, 4}, {1, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                12, FontWeight -> "Bold"], 
               Cell[
                StyleData["ObjectName", "SlideShow"], 
                CellMargins -> {{72, 4}, {1, 14}}, 
                CellGroupingRules -> {"SectionGrouping", 90}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                12, FontWeight -> "Bold"], 
               Cell[
                StyleData["ObjectName", "Printout"], 
                CellMargins -> {{2, 0}, {1, 10}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 12]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["SubObjectNameClosed"], ShowGroupOpener -> True, 
                CellMargins -> {{10, 4}, {1, 10}}, 
                PrivateCellOptions -> {"DefaultCellGroupOpen" -> False}, 
                CellGroupingRules -> {"SectionGrouping", 90}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                14, FontWeight -> "Bold"], 
               Cell[
                StyleData["SubObjectNameClosed", "Brackets"], 
                CellMargins -> {{72, 4}, {1, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                12, FontWeight -> "Bold"], 
               Cell[
                StyleData["SubObjectNameClosed", "SlideShow"], 
                CellMargins -> {{72, 4}, {1, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                12, FontWeight -> "Bold"], 
               Cell[
                StyleData["SubObjectNameClosed", "Printout"], 
                CellMargins -> {{2, 0}, {1, 10}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 12]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["SubObjectName"], ShowGroupOpener -> True, 
                CellMargins -> {{24, 4}, {1, 10}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                16, FontWeight -> "Bold"], 
               Cell[
                StyleData["SubObjectName", "Brackets"], ShowGroupOpener -> 
                True, CellMargins -> {{90, 4}, {1, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontFamily -> "Courier", FontSize -> 12], 
               Cell[
                StyleData["SubObjectName", "SlideShow"], ShowGroupOpener -> 
                True, CellMargins -> {{90, 4}, {1, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontFamily -> "Courier", FontSize -> 12], 
               Cell[
                StyleData["SubObjectName", "Printout"], 
                CellMargins -> {{2, 0}, {1, 10}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontFamily -> "Courier", FontSize -> 12]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["GroupObjectName"], ShowGroupOpener -> True, 
                CellMargins -> {{10, 4}, {0, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                16, FontWeight -> "Bold"], 
               Cell[
                StyleData["GroupObjectName", "Brackets"], ShowGroupOpener -> 
                True, CellMargins -> {{72, 10}, {2, 12}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -27, CounterIncrements -> "Outline2", 
                FontFamily -> "Courier", FontSize -> 12, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["GroupObjectName", "SlideShow"], ShowGroupOpener -> 
                True, CellMargins -> {{72, 10}, {2, 12}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -27, CounterIncrements -> "Outline2", 
                FontFamily -> "Courier", FontSize -> 12, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["GroupObjectName", "Printout"], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 14]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["GroupObjectNameClosed"], ShowGroupOpener -> True, 
                CellMargins -> {{10, 4}, {0, 14}}, 
                PrivateCellOptions -> {"DefaultCellGroupOpen" -> False}, 
                CellGroupingRules -> {"SectionGrouping", 80}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                16, FontWeight -> "Bold"], 
               Cell[
                StyleData["GroupObjectNameClosed", "Brackets"], 
                ShowGroupOpener -> True, CellMargins -> {{72, 10}, {2, 12}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -27, CounterIncrements -> "Outline2", 
                FontFamily -> "Courier", FontSize -> 12, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["GroupObjectNameClosed", "SlideShow"], 
                ShowGroupOpener -> True, CellMargins -> {{72, 10}, {2, 12}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -27, CounterIncrements -> "Outline2", 
                FontFamily -> "Courier", FontSize -> 12, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["GroupObjectNameClosed", "Printout"], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 14]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ObjectNameWarningMessages"], 
                CellMargins -> {{10, 4}, {1, 10}}, 
                CellGroupingRules -> {"SectionGrouping", 65}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                16, FontWeight -> "Bold"], 
               Cell[
                StyleData["ObjectNameWarningMessages", "Brackets"], 
                CellMargins -> {{10, 4}, {1, 10}}, 
                CellGroupingRules -> {"SectionGrouping", 65}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontFamily -> "Courier", FontSize -> 16, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["ObjectNameWarningMessages", "SlideShow"], 
                CellMargins -> {{10, 4}, {1, 10}}, 
                CellGroupingRules -> {"SectionGrouping", 65}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontFamily -> "Courier", FontSize -> 16, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["ObjectNameWarningMessages", "Printout"], 
                CellMargins -> {{2, 0}, {1, 10}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 12]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Command"], CellMargins -> {{10, 4}, {0, 14}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                CounterIncrements -> "Section", StyleMenuListing -> None, 
                FontFamily -> "Helvetica", FontSize -> 16, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["Command", "Printout"], 
                CellMargins -> {{2, 0}, {0, 14}}, PageBreakBelow -> False, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 14]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["CharacterName"], CellFrame -> {{0, 0}, {0.5, 0.5}},
                 CellMargins -> {{10, 4}, {0, 4}}, CellFrameMargins -> 4, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None], 
               Cell[
                StyleData["CharacterName", "Brackets"], 
                CellMargins -> {{72, 4}, {1, 14}}, 
                CellGroupingRules -> {"SectionGrouping", 90}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                12, FontWeight -> "Bold"], 
               Cell[
                StyleData["CharacterName", "SlideShow"], 
                CellMargins -> {{72, 4}, {1, 14}}, 
                CellGroupingRules -> {"SectionGrouping", 90}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Courier", FontSize -> 
                12, FontWeight -> "Bold"], 
               Cell[
                StyleData["CharacterName", "Printout"], 
                CellMargins -> {{2, 0}, {0, 4}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 10]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Usage"], CellFrame -> {{0, 0}, {0.5, 0.5}}, 
                CellMargins -> {{10, 4}, {0, 4}}, CellFrameMargins -> 5, 
                Hyphenation -> True, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 6}, ParagraphIndent -> -10, 
                StyleMenuListing -> None], 
               Cell[
                StyleData["Usage", "Brackets"], 
                CellFrame -> {{0, 0}, {0.5, 0.5}}, 
                CellMargins -> {{72, 4}, {0, 4}}, CellFrameMargins -> 5, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 6}, ParagraphIndent -> -10, 
                StyleMenuListing -> None], 
               Cell[
                StyleData["Usage", "SlideShow"], 
                CellFrame -> {{0, 0}, {0.5, 0.5}}, 
                CellMargins -> {{72, 4}, {0, 4}}, CellFrameMargins -> 5, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 6}, ParagraphIndent -> -10, 
                StyleMenuListing -> None], 
               Cell[
                StyleData["Usage", "Printout"], 
                CellMargins -> {{2, 0}, {0, 4}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontSize -> 10, FontWeight -> 
                "Plain"]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ErrorMessage"], CellFrame -> {{0, 0}, {0.5, 0.5}}, 
                ShowCellBracket -> True, CellMargins -> {{10, 4}, {0, 4}}, 
                CellGroupingRules -> "OutputGrouping", PageBreakWithin -> 
                False, GroupPageBreakWithin -> False, GeneratedCell -> True, 
                CellAutoOverwrite -> True, ShowCellLabel -> False, 
                CellLabelMargins -> {{14, Inherited}, {Inherited, Inherited}},
                 CellFrameMargins -> 5, DefaultFormatType -> 
                DefaultOutputFormatType, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FormatType -> InputForm, StyleMenuListing -> None, FontColor -> 
                RGBColor[0, 0, 1]], 
               Cell[
                StyleData["ErrorMessage", "Brackets"], 
                CellMargins -> {{72, 4}, {0, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None], 
               Cell[
                StyleData["ErrorMessage", "SlideShow"], 
                CellMargins -> {{72, 4}, {0, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None], 
               Cell[
                StyleData["ErrorMessage", "Printout"], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 9, FontColor -> GrayLevel[0]]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Notes"], CellMargins -> {{10, 4}, {0, 8}}, 
                CellHorizontalScrolling -> True, Hyphenation -> True, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 6}, ParagraphIndent -> -10, 
                StyleMenuListing -> None, FontFamily -> "Times"], 
               Cell[
                StyleData["Notes", "Brackets"], 
                CellMargins -> {{72, 4}, {0, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 6}, ParagraphIndent -> -10, 
                StyleMenuListing -> None, FontFamily -> "Times"], 
               Cell[
                StyleData["Notes", "SlideShow"], 
                CellMargins -> {{72, 4}, {0, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 6}, ParagraphIndent -> -10, 
                StyleMenuListing -> None, FontFamily -> "Times"], 
               Cell[
                StyleData["Notes", "Printout"], 
                CellMargins -> {{2, 0}, {0, 8}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 9]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["NotesList"], CellMargins -> {{20, 4}, {2, 8}}, 
                CellHorizontalScrolling -> True, Hyphenation -> True, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ScriptLevel -> 1, SingleLetterItalics -> True, 
                StyleMenuListing -> None, FontFamily -> "Times"], 
               Cell[
                StyleData["NotesList", "Brackets"], 
                CellMargins -> {{82, 4}, {2, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ScriptLevel -> 1, SingleLetterItalics -> True, 
                StyleMenuListing -> None, FontFamily -> "Times"], 
               Cell[
                StyleData["NotesList", "SlideShow"], 
                CellMargins -> {{82, 4}, {2, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ScriptLevel -> 1, SingleLetterItalics -> True, 
                StyleMenuListing -> None, FontFamily -> "Times"], 
               Cell[
                StyleData["NotesList", "Printout"], 
                CellMargins -> {{12, 0}, {2, 8}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 9]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ExampleSection"], CellFrame -> {{0, 0}, {0, 0.5}}, 
                ShowGroupOpener -> True, CellMargins -> {{11, 4}, {0, 10}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                CellFrameMargins -> 12, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontSize -> 13, FontWeight -> 
                "Bold", FontSlant -> "Italic", FontColor -> 
                RGBColor[0, 0, 0.4]], 
               Cell[
                StyleData["ExampleSection", "Printout"], 
                CellMargins -> {{3, 0}, {0, 10}}, PageBreakBelow -> False, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 9, FontColor -> GrayLevel[0]]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ExampleText"], CellMargins -> {{20, 40}, {0, 18}}, 
                Hyphenation -> True, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 6}, StyleMenuListing -> None, 
                FontColor -> RGBColor[0, 0, 0.4]], 
               Cell[
                StyleData["ExampleText", "Printout"], 
                CellMargins -> {{2, 80}, {0, 8}}, PageBreakBelow -> False, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 8, FontColor -> GrayLevel[0]]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ExampleSubsection"], ShowCellBracket -> True, 
                CellMargins -> {{20, 4}, {0, 16}}, 
                CellGroupingRules -> {"SectionGrouping", 80}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
                10, FontWeight -> "Bold"], 
               Cell[
                StyleData["ExampleSubsection", "Printout"], 
                CellMargins -> {{12, 0}, {0, 16}}, PageBreakBelow -> False, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 7]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["LineHead"], CellFrame -> {{0, 0}, {0.5, 0}}, 
                CellMargins -> {{10, 4}, {8, 18}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                CounterIncrements -> "Subsection", 
                CounterAssignments -> {{"Subsubsection", 0}}, 
                StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
                12, FontWeight -> "Bold"], 
               Cell[
                StyleData["LineHead", "Printout"], 
                CellMargins -> {{2, 0}, {8, 18}}, PageBreakBelow -> False, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 10]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["FlushInput"], CellMargins -> {{10, 4}, {1, 4}}, 
                Evaluatable -> True, CellGroupingRules -> "InputGrouping", 
                CellHorizontalScrolling -> True, PageBreakWithin -> False, 
                GroupPageBreakWithin -> False, CellLabelAutoDelete -> False, 
                CellLabelMargins -> {{23, Inherited}, {Inherited, Inherited}},
                 DefaultFormatType -> DefaultInputFormatType, 
                ShowSpecialCharacters -> Automatic, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FormatType -> StandardForm, ShowStringCharacters -> True, 
                NumberMarks -> True, StyleMenuListing -> None, FontWeight -> 
                "Bold"], 
               Cell[
                StyleData["FlushInput", "Printout"], 
                CellMargins -> {{2, 0}, {1, 4}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 10]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["FlushOutput"], 
                CellMargins -> {{10, Inherited}, {Inherited, Inherited}}, 
                CellEditDuplicate -> True, CellGroupingRules -> 
                "OutputGrouping", CellHorizontalScrolling -> True, 
                PageBreakWithin -> False, GroupPageBreakWithin -> False, 
                GeneratedCell -> True, CellAutoOverwrite -> True, 
                CellLabelAutoDelete -> False, 
                CellLabelMargins -> {{23, Inherited}, {Inherited, Inherited}},
                 DefaultFormatType -> DefaultOutputFormatType, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FormatType -> StandardForm, StyleMenuListing -> None], 
               Cell[
                StyleData["FlushOutput", "Printout"], 
                CellMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 10]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["DialogItem"], CellDingbat -> "\[EmptyDiamond]", 
                CellMargins -> {{20, 4}, {0, 12}}, 
                CellGroupingRules -> {"SectionGrouping", 70}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
                10, FontWeight -> "Bold"], 
               Cell[
                StyleData["DialogItem", "Printout"], 
                CellMargins -> {{12, 0}, {0, 12}}, PageBreakBelow -> False, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 8]}, Closed]], 
            Cell[
             StyleData["GroupDivider"], 
             CellMargins -> {{10, Inherited}, {Inherited, Inherited}}, 
             CellEditDuplicate -> True, 
             CellGroupingRules -> {"TitleGrouping", 0}, 
             HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
             StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Highlight"], CellMargins -> {{10, 4}, {0, 18}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
                12, Background -> GrayLevel[0.900008]], 
               Cell[
                StyleData["Highlight", "Printout"], 
                CellMargins -> {{2, 0}, {0, 18}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                LineSpacing -> {1, 3}]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["UserNotes"], CellFrame -> {{2, 0}, {0, 0.25}}, 
                CellMargins -> {{10, 4}, {0, 4}}, Hyphenation -> True, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -7, StyleMenuListing -> None, FontFamily -> 
                "Helvetica", FontSize -> 10], 
               Cell[
                StyleData["UserNotes", "Printout"], 
                CellMargins -> {{2, 0}, {0, 4}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                LineSpacing -> {1, 3}, FontSize -> 8]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["MoreInfo"], CellMargins -> {{10, 4}, {0, 4}}, 
                Hyphenation -> True, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -7, StyleMenuListing -> None, FontFamily -> 
                "Helvetica", FontSize -> 10, FontColor -> GrayLevel[1], 
                Background -> RGBColor[0.700008, 0.4, 0.100008]], 
               Cell[
                StyleData["MoreInfo", "Printout"], 
                CellMargins -> {{2, 0}, {0, 4}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                LineSpacing -> {1, 3}, FontSize -> 8]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["UserTips"], CellFrame -> {{2, 0}, {0, 0.25}}, 
                CellMargins -> {{10, 4}, {0, 4}}, Hyphenation -> True, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphIndent -> -7, StyleMenuListing -> None, FontFamily -> 
                "Helvetica", FontSize -> 10, FontColor -> GrayLevel[1], 
                Background -> RGBColor[0.2, 0.500008, 0.700008]], 
               Cell[
                StyleData["UserTips", "Printout"], 
                CellMargins -> {{2, 0}, {0, 4}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                LineSpacing -> {1, 3}, FontSize -> 8, Background -> 
                GrayLevel[0.700008]]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Theorem"], CellFrame -> {{4, 0}, {0, 0}}, 
                CellMargins -> {{12, 62}, {0, 14}}, CellFrameMargins -> 4, 
                CellFrameColor -> RGBColor[0, 0, 0.8], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                LineSpacing -> {1, 1}, ParagraphSpacing -> {0, 8}], 
               Cell[
                StyleData["Theorem", "Printout"], 
                CellMargins -> {{2, 0}, {0, 14}}, CellFrameMargins -> 3, 
                CellFrameColor -> GrayLevel[0.8], 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 9, FontColor -> GrayLevel[0]]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Commentary"], CellFrame -> {{2, 0}, {0, 0}}, 
                CellMargins -> {{36, 10}, {7, 7}}, PageBreakBelow -> False, 
                CellFrameMargins -> 8, CellFrameColor -> RGBColor[0, 0.2, 1], 
                LineSpacing -> {1, 3}, FontSlant -> "Italic"], 
               Cell[
                StyleData["Commentary", "Printout"], 
                CellMargins -> {{36, 0}, {6, 6}}, CellFrameColor -> 
                GrayLevel[0.8], FontSize -> 10], 
               Cell[
                StyleData["Commentary", "EnhancedPrintout"], 
                CellMargins -> {{36, 0}, {6, 6}}, CellFrameColor -> 
                GrayLevel[0.8], FontFamily -> "Palatino", FontSize -> 10], 
               Cell[
                StyleData["Commentary", "EnhancedPrintoutNonGray"], 
                CellMargins -> {{36, 0}, {6, 6}}, CellFrameColor -> 
                GrayLevel[0.8], FontFamily -> "Palatino", FontSize -> 10]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Level1Icon"], ShowGroupOpener -> True, 
                CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 8}, StyleMenuListing -> None], 
               Cell[
                StyleData["Level1Icon", "Printout"], 
                CellMargins -> {{2, 0}, {0, 8}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 10]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Level2Icon"], ShowGroupOpener -> True, 
                CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                True, HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                ParagraphSpacing -> {0, 8}, StyleMenuListing -> None], 
               Cell[
                StyleData["Level2Icon", "Printout"], 
                CellMargins -> {{2, 0}, {0, 8}}, 
                HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
                FontSize -> 10]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Manual.nb Merge", "Subsection"], 
            Cell[
             CellGroupData[{
               Cell["Function List", "Subsubsection"], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionName"], CellDingbat -> 
                   "\[FilledSquare]", CellMargins -> {{24, 10}, {10, 12}}, 
                   CellGroupingRules -> {"SectionGrouping", 40}, 
                   PageBreakBelow -> False, StyleMenuListing -> None, 
                   FontFamily -> "Courier", FontSize -> 14, FontWeight -> 
                   "Bold", CellTags -> "FunctionName"], 
                  Cell[
                   StyleData["FunctionName", "Printout"], 
                   CellMargins -> {{9, 0}, {10, 10}}, FontSize -> 12], 
                  Cell[
                   StyleData["FunctionName", "EnhancedPrintout"], 
                   CellMargins -> {{9, 0}, {10, 10}}, FontFamily -> "Courier",
                    FontSize -> 12], 
                  Cell[
                   StyleData["FunctionName", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{9, 0}, {10, 10}}, FontFamily -> "Courier",
                    FontSize -> 12]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["SubsectionIcon"], ShowGroupOpener -> True, 
                   CellMargins -> {{24, 10}, {0, 30}}, 
                   CellGroupingRules -> {"SectionGrouping", 50}, 
                   PageBreakBelow -> False, StyleMenuListing -> None, 
                   FontSize -> 14, FontWeight -> "Bold", CellTags -> 
                   "FunctionSection"], 
                  Cell[
                   StyleData["SubsectionIcon", "Printout"], 
                   CellMargins -> {{20, 0}, {0, 20}}, FontSize -> 13], 
                  Cell[
                   StyleData["SubsectionIcon", "EnhancedPrintout"], 
                   CellMargins -> {{20, 0}, {0, 20}}, FontFamily -> 
                   "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData["SubsectionIcon", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{20, 0}, {0, 20}}, FontFamily -> 
                   "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionSubsection"], CellDingbat -> 
                   "\[FilledSquare]", CellMargins -> {{36, 10}, {0, 6}}, 
                   CellGroupingRules -> {"SectionGrouping", 60}, 
                   PageBreakBelow -> False, StyleMenuListing -> None, 
                   FontWeight -> "Bold", CellTags -> "FunctionSubsection"], 
                  Cell[
                   StyleData["FunctionSubsection", "Printout"], 
                   CellMargins -> {{30, 0}, {0, 6}}], 
                  Cell[
                   StyleData["FunctionSubsection", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {0, 6}}, FontFamily -> "Palatino",
                    FontSize -> 11], 
                  Cell[
                   StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
                    CellMargins -> {{30, 0}, {0, 6}}, FontFamily -> 
                   "Palatino", FontSize -> 11]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["SubsubsectionIcon"], ShowGroupOpener -> True, 
                   CellMargins -> {{36, 10}, {0, 6}}, 
                   CellGroupingRules -> {"SectionGrouping", 60}, 
                   PageBreakBelow -> False, StyleMenuListing -> None, 
                   FontWeight -> "Bold", CellTags -> "SubsubsectionIcon"], 
                  Cell[
                   StyleData["SubsubsectionIcon", "Printout"], 
                   CellMargins -> {{30, 0}, {0, 6}}, FontSize -> 11], 
                  Cell[
                   StyleData["SubsubsectionIcon", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {0, 6}}, FontFamily -> "Palatino",
                    FontSize -> 9], 
                  Cell[
                   StyleData["SubsubsectionIcon", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{30, 0}, {0, 6}}, FontFamily -> "Palatino",
                    FontSize -> 9]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionDescription"], 
                   CellMargins -> {{36, 10}, {4, 0}}, LineSpacing -> {1, 3}, 
                   ParagraphSpacing -> {0.7, 0}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None, FontWeight -> "Plain"], 
                  Cell[
                   StyleData["FunctionDescription", "Printout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, FontSize -> 11], 
                  Cell[
                   StyleData["FunctionDescription", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData[
                   "FunctionDescription", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionDescriptionRuled"], 
                   CellFrame -> {{0, 0}, {0.25, 0.25}}, 
                   CellMargins -> {{36, 10}, {4, 0}}, LineSpacing -> {1, 3}, 
                   ParagraphSpacing -> {0.7, 0}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["FunctionDescriptionRuled", "Printout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, FontSize -> 11], 
                  Cell[
                   StyleData["FunctionDescriptionRuled", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData[
                   "FunctionDescriptionRuled", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionDescriptionRuleTop"], 
                   CellFrame -> {{0, 0}, {0, 0.25}}, 
                   CellMargins -> {{36, 10}, {4, 0}}, LineSpacing -> {1, 3}, 
                   ParagraphSpacing -> {0.7, 0}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["FunctionDescriptionRuleTop", "Printout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, FontSize -> 11], 
                  Cell[
                   StyleData[
                   "FunctionDescriptionRuleTop", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData[
                   "FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionDescriptionRuleBottom"], 
                   CellFrame -> {{0, 0}, {0.25, 0}}, 
                   CellMargins -> {{36, 10}, {4, 0}}, LineSpacing -> {1, 3}, 
                   ParagraphSpacing -> {0.7, 0}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["FunctionDescriptionRuleBottom", "Printout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, FontSize -> 11], 
                  Cell[
                   StyleData[
                   "FunctionDescriptionRuleBottom", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData[
                   "FunctionDescriptionRuleBottom", 
                    "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{30, 0}, {4, 0}}, TextJustification -> 0, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionExample"], 
                   CellMargins -> {{36, 10}, {4, 0}}, StyleMenuListing -> 
                   None, FontSize -> 10], 
                  Cell[
                   StyleData["FunctionExample", "Printout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, FontSize -> 9], 
                  Cell[
                   StyleData["FunctionExample", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {4, 0}}, FontFamily -> "Palatino",
                    FontSize -> 9], 
                  Cell[
                   StyleData["FunctionExample", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{30, 0}, {4, 0}}, FontFamily -> "Palatino",
                    FontSize -> 9]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["FunctionTextNote"], 
                   CellMargins -> {{36, 4}, {0, 4}}, LineSpacing -> {1, 3}, 
                   ParagraphSpacing -> {0, 4}, LineIndent -> 0, 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["FunctionTextNote", "Printout"], 
                   CellMargins -> {{36, 4}, {0, 4}}, FontSize -> 9], 
                  Cell[
                   StyleData["FunctionTextNote", "EnhancedPrintout"], 
                   CellMargins -> {{36, 4}, {0, 4}}, FontFamily -> "Palatino",
                    FontSize -> 8], 
                  Cell[
                   StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{36, 4}, {0, 4}}, FontFamily -> "Palatino",
                    FontSize -> 8]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["3ColumnFunctionTable"], 
                   CellMargins -> {{36, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, PageBreakWithin -> False, AutoIndent -> False, 
                   AutoSpacing -> False, LineIndent -> 0, StyleMenuListing -> 
                   None, GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {
                    Scaled[0.28], 
                    Scaled[0.28], {
                    Scaled[0.43]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["3ColumnFunctionTable", "Printout"], 
                   CellMargins -> {{30, 0}, {0, 8}}, FontSize -> 10], 
                  Cell[
                   StyleData["3ColumnFunctionTable", "EnhancedPrintout"], 
                   CellMargins -> {{30, 0}, {0, 8}}, FontSize -> 10], 
                  Cell[
                   StyleData[
                   "3ColumnFunctionTable", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{30, 0}, {0, 8}}, FontSize -> 10]}, 
                 Closed]]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell["Browser Emulation", "Subsubsection"], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["TextNormal"], CellMargins -> {{12, 10}, {7, 7}},
                    LineSpacing -> {1, 3}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None, FontFamily -> "Times", FontSize -> 
                   12], 
                  Cell[
                   StyleData["TextNormal", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 6}}, FontSize -> 10]}, 
                 Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["BrowserEmulation"], 
                   CellMargins -> {{12, 1}, {7, 24}}, 
                   CellGroupingRules -> {"SectionGrouping", 70}, 
                   LineSpacing -> {1, 3}, StyleMenuListing -> None, 
                   FontFamily -> "Helvetica", 
                   GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxDividers -> {
                    "Columns" -> {{True}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {True, {False}, True}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.25]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.35], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.35]}, "ColumnsIndexed" -> {}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["Text", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 6}}, FontSize -> 10]}, 
                 Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["CategoryDefs"], 
                   CellMargins -> {{300, 10}, {7, 7}}, LineSpacing -> {1, 3}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   Background -> RGBColor[1, 0.8, 0.6], 
                   GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxDividers -> {
                    "Columns" -> {False, {True}, False}, 
                    "ColumnsIndexed" -> {}, "Rows" -> {False, {True}, False}, 
                    "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["Text", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 6}}, FontSize -> 10]}, 
                 Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Category1"], ShowCellBracket -> False, 
                   ShowGroupOpener -> True, CellMargins -> {{12, 10}, {7, 7}},
                    CellGroupingRules -> {"SectionGrouping", 50}, 
                   StyleMenuListing -> None, FontSize -> 16, FontWeight -> 
                   "Bold"], 
                  Cell[
                   StyleData["Category1", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 6}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Category2"], ShowCellBracket -> False, 
                   ShowGroupOpener -> True, CellMargins -> {{85, 10}, {7, 7}},
                    CellGroupingRules -> {"SectionGrouping", 60}, 
                   StyleMenuListing -> None, FontSize -> 14, FontWeight -> 
                   "Bold", FontColor -> RGBColor[0, 0, 0.500008]], 
                  Cell[
                   StyleData["Category2", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 6}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Category3"], ShowCellBracket -> False, 
                   ShowGroupOpener -> True, 
                   CellMargins -> {{157, 10}, {7, 7}}, 
                   CellGroupingRules -> {"SectionGrouping", 70}, 
                   StyleMenuListing -> None, FontSize -> 12, FontWeight -> 
                   "Bold", FontColor -> RGBColor[0.2, 0, 0.4]], 
                  Cell[
                   StyleData["Category3", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 6}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Category4"], ShowCellBracket -> False, 
                   ShowGroupOpener -> True, 
                   CellMargins -> {{230, 10}, {7, 7}}, 
                   CellGroupingRules -> {"SectionGrouping", 80}, 
                   StyleMenuListing -> None, FontWeight -> "Bold", FontColor -> 
                   RGBColor[0, 0.300008, 0.4]], 
                  Cell[
                   StyleData["Category4", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 6}}]}, Closed]]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell["Misc", "Subsubsection"], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["4ColumnTable"], 
                   CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, PageBreakWithin -> False, AutoIndent -> False, 
                   AutoSpacing -> False, LineIndent -> 0, StyleMenuListing -> 
                   None, GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.25]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["4ColumnTable", "Printout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["4ColumnTable", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["4ColumnTable", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["5ColumnTable"], 
                   CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, PageBreakWithin -> False, AutoIndent -> False, 
                   AutoSpacing -> False, LineIndent -> 0, StyleMenuListing -> 
                   None, GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.2]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["5ColumnTable", "Printout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["5ColumnTable", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["5ColumnTable", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["6ColumnTable"], 
                   CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, PageBreakWithin -> False, AutoIndent -> False, 
                   AutoSpacing -> False, LineIndent -> 0, StyleMenuListing -> 
                   None, GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.16]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["6ColumnTable", "Printout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["6ColumnTable", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["6ColumnTable", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["7ColumnTable"], 
                   CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, PageBreakWithin -> False, AutoIndent -> False, 
                   AutoSpacing -> False, LineIndent -> 0, StyleMenuListing -> 
                   None, GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["7ColumnTable", "Printout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["7ColumnTable", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["7ColumnTable", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["8ColumnTable"], 
                   CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, PageBreakWithin -> False, AutoIndent -> False, 
                   AutoSpacing -> False, LineIndent -> 0, StyleMenuListing -> 
                   None, GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {{
                    Scaled[0.12]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["8ColumnTable", "Printout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["8ColumnTable", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["8ColumnTable", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ABItemizedText"], 
                   CellMargins -> {{20, 4}, {0, 5}}, Hyphenation -> True, 
                   LineSpacing -> {1, 3}, ParagraphIndent -> -21, 
                   CounterIncrements -> "ItemizedText", StyleMenuListing -> 
                   None], 
                  Cell[
                   StyleData["ABItemizedText", "Printout"], 
                   ParagraphIndent -> -21, FontSize -> 11], 
                  Cell[
                   StyleData["ABItemizedText", "EnhancedPrintout"], 
                   ParagraphIndent -> -21, FontFamily -> "Palatino", FontSize -> 
                   10], 
                  Cell[
                   StyleData["ABItemizedText", "EnhancedPrintoutNonGray"], 
                   ParagraphIndent -> -21, FontFamily -> "Palatino", FontSize -> 
                   10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ChapNumber"], 
                   CellMargins -> {{12, Inherited}, {20, 40}}, 
                   CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> 
                   False, DefaultNewInlineCellStyle -> "None", 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, LanguageCategory -> "NaturalLanguage", 
                   CounterIncrements -> "Title", 
                   CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
                    "Figure", 0}, {"Subtitle", 0}, {"Subsubtitle", 0}}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   FontSize -> 42, FontWeight -> "Plain"], 
                  Cell[
                   StyleData["ChapNumber", "Printout"], 
                   CellMargins -> {{2, 10}, {15, 30}}, FontSize -> 36], 
                  Cell[
                   StyleData["ChapNumber", "EnhancedPrintout"], 
                   CellMargins -> {{2, 10}, {15, 30}}, FontFamily -> "Futura",
                    FontSize -> 36], 
                  Cell[
                   StyleData["ChapNumber", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 10}, {15, 30}}, FontFamily -> "Futura",
                    FontSize -> 36]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ChapTitle"], 
                   CellMargins -> {{12, Inherited}, {80, 10}}, 
                   CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> 
                   False, DefaultNewInlineCellStyle -> "None", 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, LanguageCategory -> "NaturalLanguage", 
                   CounterIncrements -> "Title", 
                   CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
                    "Figure", 0}, {"Subtitle", 0}, {"Subsubtitle", 0}}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   FontSize -> 36, FontWeight -> "Bold"], 
                  Cell[
                   StyleData["ChapTitle", "Printout"], 
                   CellMargins -> {{2, 10}, {80, 6}}, FontSize -> 30], 
                  Cell[
                   StyleData["ChapTitle", "EnhancedPrintout"], 
                   CellMargins -> {{2, 10}, {80, 6}}, FontFamily -> "Futura", 
                   FontSize -> 30], 
                  Cell[
                   StyleData["ChapTitle", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 10}, {80, 6}}, FontFamily -> "Futura", 
                   FontSize -> 30]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Item1"], CellMargins -> {{28, 4}, {4, 4}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   ParagraphIndent -> -23, CounterIncrements -> "Item1", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["Item1", "Printout"], 
                   CellMargins -> {{12, 0}, {0, 8}}], 
                  Cell[
                   StyleData["Item1", "EnhancedPrintout"], 
                   CellMargins -> {{12, 0}, {0, 8}}, FontSize -> 10], 
                  Cell[
                   StyleData["Item1", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{12, 0}, {0, 8}}, FontSize -> 10]}, 
                 Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Item1Continued"], 
                   CellMargins -> {{71, 4}, {2, 2}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   CounterIncrements -> "Item1Continued", StyleMenuListing -> 
                   None], 
                  Cell[
                   StyleData["Item1Continued", "Printout"], 
                   CellMargins -> {{12, 0}, {0, 8}}], 
                  Cell[
                   StyleData["Item1Continued", "EnhancedPrintout"], 
                   CellMargins -> {{12, 0}, {0, 8}}], 
                  Cell[
                   StyleData["Item1Continued", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{12, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Item2"], CellMargins -> {{42, 4}, {3, 3}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   ParagraphIndent -> -21, CounterIncrements -> "Item2", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["Item2", "Printout"], 
                   CellMargins -> {{40, 0}, {0, 4}}, ParagraphIndent -> -18, 
                   FontSize -> 10], 
                  Cell[
                   StyleData["Item2", "EnhancedPrintout"], 
                   CellMargins -> {{40, 0}, {0, 4}}, ParagraphIndent -> -18, 
                   FontSize -> 10], 
                  Cell[
                   StyleData["Item2", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{40, 0}, {0, 4}}, ParagraphIndent -> -18, 
                   FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Item2Continued"], 
                   CellMargins -> {{92, 4}, {2, 2}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   CounterIncrements -> "Item2Continued", StyleMenuListing -> 
                   None], 
                  Cell[
                   StyleData["Item2Continued", "Printout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["Item2Continued", "EnhancedPrintout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["Item2Continued", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{27, 0}, {0, 4}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Item3"], CellMargins -> {{94, 4}, {2, 2}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   ParagraphIndent -> -23, CounterIncrements -> "Item3", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["Item3", "Printout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["Item3", "EnhancedPrintout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["Item3", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{27, 0}, {0, 4}}, StyleMenuListing -> 
                   None]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Item3Continued"], 
                   CellMargins -> {{117, 4}, {2, 2}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   CounterIncrements -> "Item3Continued", StyleMenuListing -> 
                   None], 
                  Cell[
                   StyleData["Item3Continued", "Printout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["Item3Continued", "EnhancedPrintout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["Item3Continued", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{27, 0}, {0, 4}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ItemizedBottomBox"], 
                   CellFrame -> {{0.5, 0.5}, {0.5, 0}}, 
                   CellMargins -> {{37, 4}, {4, 0}}, CellHorizontalScrolling -> 
                   True, LineIndent -> 0, StyleMenuListing -> None, 
                   Background -> RGBColor[1, 0.6, 0.6], 
                   GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {
                    Scaled[0.31], {
                    Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["ItemizedBottomBox", "Printout"], FontSize -> 10,
                    Background -> GrayLevel[0.900008]], 
                  Cell[
                   StyleData["ItemizedBottomBox", "EnhancedPrintout"], 
                   CellMargins -> {{37, 4}, {6, 0}}, FontSize -> 10, 
                   Background -> GrayLevel[0.900008]], 
                  Cell[
                   StyleData["ItemizedBottomBox", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{37, 4}, {6, 0}}, FontSize -> 10, 
                   Background -> GrayLevel[1]]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ItemizedBulletText"], 
                   CellMargins -> {{20, 4}, {0, 5}}, Hyphenation -> True, 
                   LineSpacing -> {1, 3}, ParagraphIndent -> -22, 
                   CounterIncrements -> "ItemizedBulletText", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["ItemizedBulletText", "Printout"], 
                   ParagraphIndent -> -20, FontSize -> 11], 
                  Cell[
                   StyleData["ItemizedBulletText", "EnhancedPrintout"], 
                   ParagraphIndent -> -19, FontFamily -> "Palatino", FontSize -> 
                   10], 
                  Cell[
                   StyleData["ItemizedBulletText", "EnhancedPrintoutNonGray"],
                    ParagraphIndent -> -19, FontFamily -> "Palatino", 
                   FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ItemizedNote"], 
                   CellMargins -> {{41, 4}, {0, 12}}, Hyphenation -> True, 
                   LineSpacing -> {1, 2}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["ItemizedNote", "Printout"], 
                   CellMargins -> {{38, 4}, {0, 9}}, FontSize -> 11], 
                  Cell[
                   StyleData["ItemizedNote", "EnhancedPrintout"], 
                   CellMargins -> {{38, 4}, {0, 0}}, TextJustification -> 1, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData["ItemizedNote", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{38, 4}, {0, 0}}, TextJustification -> 1, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ItemizedNoteBelow"], 
                   CellMargins -> {{41, 4}, {0, 8}}, Hyphenation -> True, 
                   LineSpacing -> {1, 2}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["ItemizedNoteBelow", "Printout"], 
                   CellMargins -> {{38, 4}, {0, 12}}, FontSize -> 11], 
                  Cell[
                   StyleData["ItemizedNoteBelow", "EnhancedPrintout"], 
                   CellMargins -> {{38, 4}, {0, 8}}, TextJustification -> 1, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData["ItemizedNoteBelow", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{38, 4}, {0, 8}}, TextJustification -> 1, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ItemizedTextBelowPic"], 
                   CellMargins -> {{20, 4}, {0, 8}}, Hyphenation -> True, 
                   LineSpacing -> {1, 3}, ParagraphIndent -> -22, 
                   CounterIncrements -> "ItemizedText", StyleMenuListing -> 
                   None], 
                  Cell[
                   StyleData["ItemizedTextBelowPic", "Printout"], 
                   CellMargins -> {{20, 4}, {2, 12}}, ParagraphIndent -> -18, 
                   FontSize -> 11], 
                  Cell[
                   StyleData["ItemizedTextBelowPic", "EnhancedPrintout"], 
                   CellMargins -> {{20, 4}, {2, 12}}, ParagraphIndent -> -17, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData[
                   "ItemizedTextBelowPic", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{20, 4}, {2, 12}}, ParagraphIndent -> -17, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ItemizedTextNote2"], 
                   CellMargins -> {{41, 4}, {0, 4}}, Hyphenation -> True, 
                   LineSpacing -> {1, 2}, CounterIncrements -> "Text", 
                   StyleMenuListing -> None], 
                  Cell[
                   StyleData["ItemizedTextNote2", "Printout"], 
                   CellMargins -> {{38, 4}, {0, 2}}, FontSize -> 11], 
                  Cell[
                   StyleData["ItemizedTextNote2", "EnhancedPrintout"], 
                   CellMargins -> {{38, 4}, {0, 2}}, FontFamily -> "Palatino",
                    FontSize -> 10], 
                  Cell[
                   StyleData["ItemizedTextNote2", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{38, 4}, {0, 2}}, FontFamily -> "Palatino",
                    FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["ItemizedTopBox"], 
                   CellFrame -> {{0.5, 0.5}, {0, 0.5}}, 
                   CellMargins -> {{37, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, LineIndent -> 0, StyleMenuListing -> None, 
                   Background -> RGBColor[1, 0.6, 0.6], 
                   GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {
                    Scaled[0.31], {
                    Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["ItemizedTopBox", "Printout"], FontSize -> 10, 
                   Background -> GrayLevel[0.900008]], 
                  Cell[
                   StyleData["ItemizedTopBox", "EnhancedPrintout"], 
                   CellMargins -> {{37, 4}, {0, 6}}, FontSize -> 10, 
                   Background -> GrayLevel[0.900008]], 
                  Cell[
                   StyleData["ItemizedTopBox", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{37, 4}, {0, 6}}, FontSize -> 10, 
                   Background -> GrayLevel[1]]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["MiddleSpacedBox"], 
                   CellFrame -> {{0.5, 0.5}, {0, 0}}, 
                   CellMargins -> {{11, 4}, {0, -7}}, CellHorizontalScrolling -> 
                   True, PageBreakAbove -> False, PageBreakBelow -> False, 
                   AutoIndent -> False, AutoSpacing -> False, LineIndent -> 0,
                    StyleMenuListing -> None, FontWeight -> "Plain", 
                   Background -> RGBColor[1, 0.6, 0.6], 
                   GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxItemSize -> {"Columns" -> {
                    Scaled[0.31], {
                    Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                    "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["MiddleSpacedBox", "Printout"], 
                   CellMargins -> {{2, 0}, {0, 0}}, Background -> 
                   GrayLevel[1], 
                   GridBoxOptions -> {
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.8}}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["MiddleSpacedBox", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {0, 0}}, FontFamily -> "Palatino", 
                   Background -> GrayLevel[1], 
                   GridBoxOptions -> {
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.8}}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {0, 0}}, FontFamily -> "Palatino", 
                   Background -> GrayLevel[1], 
                   GridBoxOptions -> {
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.8}}, "RowsIndexed" -> {}}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["NumberedItem1"], 
                   CellMargins -> {{48, 4}, {4, 4}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   ParagraphIndent -> -23, CounterIncrements -> 
                   "NumberedItem1", StyleMenuListing -> None], 
                  Cell[
                   StyleData["NumberedItem1", "Printout"], 
                   CellMargins -> {{12, 0}, {0, 8}}], 
                  Cell[
                   StyleData["NumberedItem1", "EnhancedPrintout"], 
                   CellMargins -> {{12, 0}, {0, 8}}], 
                  Cell[
                   StyleData["NumberedItem1", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{12, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["NumberedItem2"], 
                   CellMargins -> {{71, 4}, {3, 3}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   ParagraphIndent -> -21, CounterIncrements -> 
                   "NumberedItem2", StyleMenuListing -> None], 
                  Cell[
                   StyleData["NumberedItem2", "Printout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["NumberedItem2", "EnhancedPrintout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["NumberedItem2", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{27, 0}, {0, 4}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["NumberedItem3"], 
                   CellMargins -> {{94, 4}, {2, 2}}, 
                   CellGroupingRules -> {"SectionGrouping", 15}, 
                   ParagraphIndent -> -23, CounterIncrements -> 
                   "NumberedItem3", StyleMenuListing -> None], 
                  Cell[
                   StyleData["NumberedItem3", "Printout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["NumberedItem3", "EnhancedPrintout"], 
                   CellMargins -> {{27, 0}, {0, 4}}], 
                  Cell[
                   StyleData["NumberedItem3", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{27, 0}, {0, 4}}, StyleMenuListing -> 
                   None]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["PageHeaderBold"], 
                   CellMargins -> {{0, 0}, {2, 0}}, StyleMenuListing -> None, 
                   FontSize -> 8, FontWeight -> "Bold", FontSlant -> 
                   "Italic"], 
                  Cell[
                   StyleData["Header", "Printout"]], 
                  Cell[
                   StyleData["Header", "EnhancedPrintout"], FontFamily -> 
                   "Futura"], 
                  Cell[
                   StyleData["Header", "EnhancedPrintoutNonGray"], FontFamily -> 
                   "Futura"]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["S9"], 
                   ConversionRules :> {
                    "HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   FontSize -> 9, FontWeight -> "Plain"], 
                  Cell[
                   StyleData["S9", "Printout"], FontSize -> 9, FontWeight -> 
                   "Plain"], 
                  Cell[
                   StyleData["S9", "EnhancedPrintout"], FontFamily -> 
                   "Futura", FontSize -> 9, FontWeight -> "Plain"], 
                  Cell[
                   StyleData["S9", "EnhancedPrintoutNonGray"], FontFamily -> 
                   "Futura", FontSize -> 9, FontWeight -> "Plain"]}, Closed]],
                
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["S10"], 
                   ConversionRules :> {
                    "HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   FontSize -> 10, FontWeight -> "Plain"], 
                  Cell[
                   StyleData["S10", "Printout"], FontSize -> 10, FontWeight -> 
                   "Plain"], 
                  Cell[
                   StyleData["S10", "EnhancedPrintout"], FontFamily -> 
                   "Futura", FontSize -> 10, FontWeight -> "Plain"], 
                  Cell[
                   StyleData["S10", "EnhancedPrintoutNonGray"], FontFamily -> 
                   "Futura", FontSize -> 10, FontWeight -> "Plain"]}, 
                 Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["SB9"], 
                   ConversionRules :> {
                    "HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   FontSize -> 9, FontWeight -> "Bold", 
                   PrivateFontOptions -> {"OperatorSubstitution" -> False}], 
                  Cell[
                   StyleData["SB9", "Printout"], FontSize -> 7], 
                  Cell[
                   StyleData["SB9", "EnhancedPrintout"], FontFamily -> 
                   "Futura", FontSize -> 7], 
                  Cell[
                   StyleData["SB9", "EnhancedPrintoutNonGray"], FontFamily -> 
                   "Futura", FontSize -> 7]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["SB10"], 
                   ConversionRules :> {
                    "HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   FontSize -> 10, FontWeight -> "Bold"], 
                  Cell[
                   StyleData["SB10", "Printout"], FontSize -> 7], 
                  Cell[
                   StyleData["SB10", "EnhancedPrintout"], FontFamily -> 
                   "Futura", FontSize -> 7], 
                  Cell[
                   StyleData["SB10", "EnhancedPrintoutNonGray"], FontFamily -> 
                   "Futura", FontSize -> 7]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["SingleRowTable"], 
                   CellMargins -> {{10, 4}, {0, 8}}, CellHorizontalScrolling -> 
                   True, PageBreakWithin -> False, AutoIndent -> False, 
                   AutoSpacing -> False, LineIndent -> 0, StyleMenuListing -> 
                   None, GridBoxOptions -> {
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}, 
                    GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.6]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}}], 
                  Cell[
                   StyleData["SingleRowTable", "Printout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["SingleRowTable", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {0, 8}}], 
                  Cell[
                   StyleData["SingleRowTable", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {0, 8}}]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Subsubsubsection"], 
                   CellMargins -> {{10, 4}, {0, 18}}, 
                   CellElementSpacings -> {"ClosedGroupTopMargin" -> 18}, 
                   ConversionRules :> {
                    "HTML" -> {
                    "<FONT FACE=\"Helvetica, Arial\"><P><B>", 
                    "</B></P></FONT>\n"}}, 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, StyleMenuListing -> None, FontSize -> 12, 
                   FontWeight -> "Bold"], 
                  Cell[
                   StyleData["Subsubsubsection", "Printout"], 
                   CellMargins -> {{2, 0}, {7, 18}}, FontSize -> 10], 
                  Cell[
                   StyleData["Subsubsubsection", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {7, 18}}, FontFamily -> "Palatino",
                    FontSize -> 10], 
                  Cell[
                   StyleData["Subsubsubsection", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {7, 18}}, FontFamily -> "Palatino",
                    FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Subsubtitle"], 
                   CellMargins -> {{12, Inherited}, {20, 15}}, 
                   CellGroupingRules -> {"TitleGrouping", 20}, PageBreakBelow -> 
                   False, DefaultNewInlineCellStyle -> "None", 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, LanguageCategory -> "NaturalLanguage", 
                   CounterIncrements -> "Subsubtitle", 
                   CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
                    "Figure", 0}}, StyleMenuListing -> None, FontFamily -> 
                   "Helvetica", FontSize -> 14, FontSlant -> "Italic"], 
                  Cell[
                   StyleData["Subsubtitle", "Printout"], 
                   CellMargins -> {{2, 10}, {8, 10}}, FontSize -> 12], 
                  Cell[
                   StyleData["Subsubtitle", "EnhancedPrintout"], 
                   CellMargins -> {{2, 10}, {8, 10}}, FontFamily -> "Futura", 
                   FontSize -> 12], 
                  Cell[
                   StyleData["Subsubtitle", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 10}, {8, 10}}, FontFamily -> "Futura", 
                   FontSize -> 12]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Subtitle"], 
                   CellMargins -> {{12, Inherited}, {20, 15}}, 
                   CellGroupingRules -> {"TitleGrouping", 10}, PageBreakBelow -> 
                   False, DefaultNewInlineCellStyle -> "None", 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, LanguageCategory -> "NaturalLanguage", 
                   CounterIncrements -> "Subtitle", 
                   CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
                    "Figure", 0}, {"Subsubtitle", 0}}, StyleMenuListing -> 
                   None, FontFamily -> "Helvetica", FontSize -> 24], 
                  Cell[
                   StyleData["Subtitle", "Printout"], 
                   CellMargins -> {{2, 10}, {10, 15}}, FontSize -> 24], 
                  Cell[
                   StyleData["Subtitle", "EnhancedPrintout"], 
                   CellMargins -> {{2, 10}, {10, 15}}, FontFamily -> "Futura",
                    FontSize -> 24], 
                  Cell[
                   StyleData["Subtitle", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 10}, {10, 15}}, FontFamily -> "Futura",
                    FontSize -> 24]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["TextBelow"], CellMargins -> {{10, 4}, {0, 14}}, 
                   ConversionRules :> {"HTML" -> {"<P>", "</P>"}}, 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, Hyphenation -> True, 
                   ParagraphSpacing -> {0, 8}, StyleMenuListing -> None, 
                   FontSize -> 12], 
                  Cell[
                   StyleData["TextBelow", "Printout"], 
                   CellMargins -> {{2, 2}, {6, 12}}, TextJustification -> 1, 
                   FontSize -> 10], 
                  Cell[
                   StyleData["TextBelow", "EnhancedPrintout"], 
                   CellMargins -> {{2, 2}, {6, 12}}, TextJustification -> 1, 
                   FontFamily -> "Palatino", FontSize -> 10], 
                  Cell[
                   StyleData["TextBelow", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 2}, {6, 12}}, TextJustification -> 1, 
                   FontFamily -> "Palatino", FontSize -> 10]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Title"], 
                   CellMargins -> {{12, Inherited}, {20, 40}}, 
                   CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> 
                   False, DefaultNewInlineCellStyle -> "None", 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, LanguageCategory -> "NaturalLanguage", 
                   CounterIncrements -> "Title", 
                   CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
                    "Figure", 0}, {"Subtitle", 0}, {"Subsubtitle", 0}}, 
                   StyleMenuListing -> None, FontFamily -> "Helvetica", 
                   FontSize -> 36, FontWeight -> "Bold"], 
                  Cell[
                   StyleData["Title", "Printout"], 
                   CellMargins -> {{2, 10}, {15, 30}}, FontSize -> 30], 
                  Cell[
                   StyleData["Title", "EnhancedPrintout"], 
                   CellMargins -> {{2, 10}, {15, 30}}, FontFamily -> "Futura",
                    FontSize -> 30], 
                  Cell[
                   StyleData["Title", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 10}, {15, 30}}, FontFamily -> "Futura",
                    FontSize -> 30]}, Closed]], 
               Cell[
                CellGroupData[{
                  Cell[
                   StyleData["Undersubsection"], 
                   CellMargins -> {{10, 4}, {0, 18}}, 
                   CellElementSpacings -> {"ClosedGroupTopMargin" -> 18}, 
                   ConversionRules :> {
                    "HTML" -> {
                    "<FONT FACE=\"Helvetica, Arial\"><P><B>", 
                    "</B></P></FONT>\n"}}, 
                   InputAutoReplacements -> {"TeX" -> StyleBox[
                    RowBox[{"T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                    RowBox[{"L", 
                    StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                    AdjustmentBox[
                    "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
                    "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
                    Inherited}, StyleMenuListing -> None, FontFamily -> 
                   "Helvetica", FontSize -> 12, FontWeight -> "Bold"], 
                  Cell[
                   StyleData["Undersubsection", "Printout"], 
                   CellMargins -> {{2, 0}, {7, 10}}, FontSize -> 10], 
                  Cell[
                   StyleData["Undersubsection", "EnhancedPrintout"], 
                   CellMargins -> {{2, 0}, {7, 8}}, FontFamily -> "Futura", 
                   FontSize -> 10], 
                  Cell[
                   StyleData["Undersubsection", "EnhancedPrintoutNonGray"], 
                   CellMargins -> {{2, 0}, {7, 8}}, FontFamily -> "Futura", 
                   FontSize -> 10]}, Closed]]}, Closed]]}, Closed]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell["AuthorTools", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["BilateralCell"], CellMargins -> {{10, 4}, {0, 8}}, 
             FontSize -> 12], 
            Cell[
             StyleData["BilateralCell", "SlideShow"], 
             CellMargins -> {{36, 24}, {4, 4}}, Background -> 
             GrayLevel[0.900008], 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.4], {
                    Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["BilateralCell", "Printout"], 
             CellMargins -> {{2, 2}, {6, 6}}, TextJustification -> 1, 
             FontSize -> 10], 
            Cell[
             StyleData["BilateralCell", "EnhancedPrintout"], 
             CellMargins -> {{2, 2}, {6, 6}}, TextJustification -> 1, 
             FontFamily -> "Palatino", FontSize -> 10], 
            Cell[
             StyleData["BilateralCell", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 2}, {6, 6}}, TextJustification -> 1, 
             FontFamily -> "Palatino", FontSize -> 10]}, Closed]]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell["Slide Show Styles", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SlideShowNavigationBar"], CellFrame -> True, 
             ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 30}}, 
             CellElementSpacings -> {"CellMinHeight" -> 0.8125}, 
             CellGroupingRules -> {"SectionGrouping", 30}, CellFrameMargins -> 
             False, CellFrameColor -> GrayLevel[1], CellFrameLabelMargins -> 
             False, TextAlignment -> Center, CounterIncrements -> 
             "SlideShowNavigationBar", FontSize -> 10, Magnification -> 1, 
             Background -> GrayLevel[0.8], 
             GridBoxOptions -> {
              BaselinePosition -> Center, 
               GridBoxAlignment -> {
                "Columns" -> {
                  Center, Center, Center, Center, Center, Center, Right, {
                   Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
                 "RowsIndexed" -> {}}, 
               GridBoxItemSize -> {
                "Columns" -> {3.5, 3.5, 3.5, 3.5, 13, 5, {4}}, 
                 "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["SlideShowNavigationBar", "SlideShow"], 
             ShowCellBracket -> False, CellMargins -> {{-1, -1}, {-1, -1}}, 
             PageBreakAbove -> True, CellFrameMargins -> {{1, 1}, {0, 0}}], 
            Cell[
             StyleData["SlideShowNavigationBar", "Printout"], 
             CellMargins -> {{18, 4}, {4, 4}}, LineSpacing -> {1, 3}, 
             FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SlideShowSection"], CellFrame -> {{0, 0}, {0, 0.5}}, 
             CellMargins -> {{0, 0}, {10, 0}}, 
             CellGroupingRules -> {"SectionGrouping", 40}, PageBreakBelow -> 
             False, FontFamily -> "Helvetica", FontSize -> 18, FontWeight -> 
             "Plain", FontColor -> GrayLevel[1], Background -> 
             RGBColor[0.408011, 0.440726, 0.8]], 
            Cell[
             StyleData["SlideShowSection", "SlideShow"], ShowCellBracket -> 
             False, PageBreakAbove -> True], 
            Cell[
             StyleData["SlideShowSection", "Printout"], 
             CellMargins -> {{18, 30}, {0, 30}}, CellFrameMargins -> 5, 
             FontSize -> 14]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SlideHyperlink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, FontSize -> 26, FontColor -> 
             GrayLevel[0.400015], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`NotebookLocate[#2]}]& ), ButtonMargins -> 0.5, 
               ButtonMinHeight -> 0.85, ButtonNote -> None}], 
            Cell[
             StyleData["SlideHyperlink", "SlideShow"]], 
            Cell[
             StyleData["SlideHyperlink", "Printout"], FontSize -> 10, 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Contents and Index", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ContentsTitle"], ShowGroupOpener -> False, 
             CellMargins -> {{10, 4}, {0, 18}}, 
             CellGroupingRules -> {"SectionGrouping", 60}, 
             LineSpacing -> {1, 11}, StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 26, FontWeight -> "Bold"], 
            Cell[
             StyleData["ContentsTitle", "Printout"], 
             CellMargins -> {{2, 0}, {0, 18}}, PageBreakBelow -> False, 
             FontSize -> 18], 
            Cell[
             StyleData["ContentsTitle", "EnhancedPrintout"], 
             CellMargins -> {{2, 0}, {0, 18}}, PageBreakBelow -> False, 
             FontFamily -> "Futura", FontSize -> 18], 
            Cell[
             StyleData["ContentsTitle", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{2, 0}, {0, 18}}, PageBreakBelow -> False, 
             FontFamily -> "Futura", FontSize -> 18]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ContentsSection"], ShowGroupOpener -> True, 
             CellMargins -> {{35, 4}, {3, 18}}, 
             CellGroupingRules -> {"SectionGrouping", 70}, StyleMenuListing -> 
             None, FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
             "Bold"], 
            Cell[
             StyleData["ContentsSection", "Printout"], 
             CellMargins -> {{20, 0}, {3, 18}}, PageBreakBelow -> False, 
             FontSize -> 11], 
            Cell[
             StyleData["ContentsSection", "EnhancedPrintout"], 
             CellMargins -> {{20, 0}, {3, 18}}, PageBreakBelow -> False, 
             FontFamily -> "Futura", FontSize -> 11], 
            Cell[
             StyleData["ContentsSection", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{20, 0}, {3, 18}}, PageBreakBelow -> False, 
             FontFamily -> "Futura", FontSize -> 11]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["IndexSection"], CellDingbat -> "\[FilledSquare]", 
             CellMargins -> {{20, 4}, {5, 20}}, StyleMenuListing -> None, 
             FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> "Bold"],
             
            Cell[
             StyleData["IndexSection", "Printout"], 
             CellMargins -> {{12, 0}, {5, 20}}, PageBreakBelow -> False, 
             FontSize -> 12]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Contents"], ShowGroupOpener -> False, 
             CellMargins -> {{50, 4}, {0, 5}}, 
             CellGroupingRules -> {"SectionGrouping", 90}, StyleMenuListing -> 
             None], 
            Cell[
             StyleData["Contents", "Printout"], 
             CellMargins -> {{40, 4}, {0, 5}}, FontSize -> 11], 
            Cell[
             StyleData["Contents", "EnhancedPrintout"], 
             CellMargins -> {{40, 5}, {0, 5}}, FontFamily -> "Palatino", 
             FontSize -> 11], 
            Cell[
             StyleData["Contents", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{40, 5}, {0, 5}}, FontFamily -> "Palatino", 
             FontSize -> 11]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Index"], CellMargins -> {{21, 4}, {0, 0}}, 
             ParagraphIndent -> -48, StyleMenuListing -> None], 
            Cell[
             StyleData["Index", "Printout"], CellMargins -> {{13, 0}, {0, 0}},
              FontSize -> 10], 
            Cell[
             StyleData["Index", "EnhancedPrintout"], 
             CellMargins -> {{13, 0}, {0, 0}}, FontFamily -> "Palatino", 
             FontSize -> 10], 
            Cell[
             StyleData["Index", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{13, 0}, {0, 0}}, FontFamily -> "Palatino", 
             FontSize -> 10]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["IndexSubentry"], CellMargins -> {{36, 4}, {0, 0}}, 
             ParagraphIndent -> -48, StyleMenuListing -> None], 
            Cell[
             StyleData["IndexSubentry", "Printout"], 
             CellMargins -> {{24, 0}, {0, 0}}, FontSize -> 10], 
            Cell[
             StyleData["IndexSubentry", "EnhancedPrintout"], 
             CellMargins -> {{24, 0}, {0, 0}}, FontFamily -> "Palatino", 
             FontSize -> 10], 
            Cell[
             StyleData["IndexSubentry", "EnhancedPrintoutNonGray"], 
             CellMargins -> {{24, 0}, {0, 0}}, FontFamily -> "Palatino", 
             FontSize -> 10]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Horizontal Lines", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Line1"], CellFrame -> {{0, 0}, {0, 0.5}}, 
             CellMargins -> {{10, 4}, {-16, 9}}, StyleMenuListing -> None, 
             FontSize -> 2], 
            Cell[
             StyleData["Line1", "Printout"], 
             CellMargins -> {{2, 0}, {-16, 9}}]}, Closed]], 
         Cell["\nThe item above is horizontal 0.5 pt line", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ProgramTop"], CellFrame -> {{0.5, 0.5}, {0, 0.5}}, 
             CellMargins -> {{10, 4}, {-18, 18}}, LineSpacing -> {1, -4}, 
             StyleMenuListing -> None, FontSize -> 4], 
            Cell[
             StyleData["ProgramTop", "Printout"], 
             CellMargins -> {{2, 0}, {-18, 18}}]}, Closed]], 
         Cell["\nThe item above is a ProgramTop line\n", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ProgramBottom"], CellFrame -> {{0.5, 0.5}, {0.5, 0}}, 
             CellMargins -> {{10, 4}, {-10, -2}}, LineSpacing -> {1, -4}, 
             StyleMenuListing -> None, FontSize -> 4], 
            Cell[
             StyleData["ProgramBottom", "Printout"], 
             CellMargins -> {{2, 0}, {-10, -2}}]}, Closed]], 
         Cell["\nThe item above is a ProgramBottom line\n", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SessionLabel"], CellFrame -> {{0.5, 0}, {0, 0.5}}, 
             CellMargins -> {{10, 4}, {-4, 18}}, LineSpacing -> {1, -3}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
             9], 
            Cell[
             StyleData["SessionLabel", "Printout"], 
             CellMargins -> {{2, 0}, {-4, 18}}, FontSize -> 7]}, Closed]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell["Page Headers and Footers", "Section"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["PageHeader"], CellMargins -> {{0, 0}, {2, 0}}, 
             StyleMenuListing -> None, FontSize -> 8, FontSlant -> "Italic"], 
            
            Cell[
             StyleData["PageHeader", "Printout"]], 
            Cell[
             StyleData["PageHeader", "EnhancedPrintout"], FontFamily -> 
             "Futura"], 
            Cell[
             StyleData["PageHeader", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Futura"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["PageNumber"], CellMargins -> {{0, 0}, {2, 0}}, 
             StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 
             8, FontWeight -> "Bold"], 
            Cell[
             StyleData["PageNumber", "Printout"]], 
            Cell[
             StyleData["PageNumber", "EnhancedPrintout"], FontFamily -> 
             "Futura"], 
            Cell[
             StyleData["PageNumber", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Futura"]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["PageFooter"], StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 6], 
            Cell[
             StyleData["PageFooter", "Printout"]], 
            Cell[
             StyleData["PageFooter", "EnhancedPrintout"], FontFamily -> 
             "Futura"], 
            Cell[
             StyleData["PageFooter", "EnhancedPrintoutNonGray"], FontFamily -> 
             "Futura"]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Automatic Styles", "Section"], 
         Cell[
         "The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).", "Text"], 
         Cell[
          StyleData["UnmatchedBracket"], StyleMenuListing -> None]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "6.0 for Microsoft Windows (32-bit) (April 10, 2007)", StyleDefinitions -> 
  "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ShiftReturn"->{
  Cell[49160, 906, 139, 5, 37, "Section",
   CellTags->"ShiftReturn"]},
 "FunctionSyntax"->{
  Cell[52348, 1020, 63, 1, 36, "Section",
   CellTags->"FunctionSyntax"],
  Cell[56166, 1144, 74, 1, 36, "Section",
   CellTags->"FunctionSyntax"]},
 "NumericalValues"->{
  Cell[63605, 1312, 75, 1, 36, "Section",
   CellTags->"NumericalValues"],
  Cell[67527, 1425, 79, 1, 36, "Section",
   CellTags->"NumericalValues"],
  Cell[70625, 1527, 68, 1, 36, "Section",
   CellTags->"NumericalValues"],
  Cell[74143, 1637, 80, 1, 36, "Section",
   CellTags->"NumericalValues"]},
 "LastSlide"->{
  Cell[90798, 2091, 64, 1, 36, "Section",
   CellTags->"LastSlide"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ShiftReturn", 321942, 6820},
 {"FunctionSyntax", 322035, 6823},
 {"NumericalValues", 322206, 6828},
 {"LastSlide", 322523, 6837}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[1868, 62, 130, 4, 44, "Chapter"],
Cell[2001, 68, 290, 11, 28, "Text"],
Cell[2294, 81, 384, 13, 47, "Text"],
Cell[2681, 96, 215, 7, 28, "Text"],
Cell[2899, 105, 2156, 50, 38, "Text"],
Cell[5058, 157, 42799, 706, 147, 42603, 699, "GraphicsData", "Bitmap", "Text",
 
 Evaluatable->False],
Cell[47860, 865, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[49160, 906, 139, 5, 37, "Section",
 CellTags->"ShiftReturn"],
Cell[49302, 913, 136, 3, 24, "Text"],
Cell[49441, 918, 192, 6, 24, "Text"],
Cell[49636, 926, 16, 0, 24, "Text"],
Cell[49655, 928, 93, 5, 24, "Text"],
Cell[49751, 935, 246, 7, 24, "Text"],
Cell[50000, 944, 201, 5, 24, "Text"],
Cell[50204, 951, 251, 7, 24, "Text"],
Cell[50458, 960, 240, 4, 24, "Text"],
Cell[50701, 966, 332, 10, 24, "Text"]
}, Open  ]],
Cell[51048, 979, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[52348, 1020, 63, 1, 36, "Section",
 CellTags->"FunctionSyntax"],
Cell[52414, 1023, 138, 5, 24, "Text"],
Cell[52555, 1030, 99, 2, 44, "InputOnly"],
Cell[52657, 1034, 140, 3, 24, "Text"],
Cell[CellGroupData[{
Cell[52822, 1041, 1014, 26, 111, "Input"],
Cell[53839, 1069, 879, 25, 54, "Output"]
}, Open  ]],
Cell[54733, 1097, 118, 3, 24, "Text"]
}, Open  ]],
Cell[54866, 1103, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[56166, 1144, 74, 1, 36, "Section",
 CellTags->"FunctionSyntax"],
Cell[56243, 1147, 286, 7, 24, "Text"],
Cell[CellGroupData[{
Cell[56554, 1158, 120, 3, 31, "Input"],
Cell[56677, 1163, 243, 6, 35, "Output"]
}, Open  ]],
Cell[56935, 1172, 199, 4, 24, "Text"],
Cell[57137, 1178, 4990, 85, 89, 4881, 81, "GraphicsData", "Bitmap", "Text",
 Evaluatable->False],
Cell[62130, 1265, 160, 3, 24, "Text"]
}, Open  ]],
Cell[62305, 1271, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[63605, 1312, 75, 1, 36, "Section",
 CellTags->"NumericalValues"],
Cell[63683, 1315, 266, 6, 40, "Text"],
Cell[CellGroupData[{
Cell[63974, 1325, 148, 3, 31, "Input"],
Cell[64125, 1330, 124, 3, 35, "Output"]
}, Open  ]],
Cell[64264, 1336, 136, 4, 24, "Text"],
Cell[CellGroupData[{
Cell[64425, 1344, 191, 4, 31, "Input"],
Cell[64619, 1350, 1455, 24, 149, "Output"]
}, Open  ]],
Cell[66089, 1377, 123, 4, 24, "Text"]
}, Open  ]],
Cell[66227, 1384, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[67527, 1425, 79, 1, 36, "Section",
 CellTags->"NumericalValues"],
Cell[67609, 1428, 252, 5, 40, "Text"],
Cell[CellGroupData[{
Cell[67886, 1437, 442, 12, 51, "Input"],
Cell[68331, 1451, 342, 7, 54, "Output"]
}, Open  ]],
Cell[68688, 1461, 200, 5, 24, "Text"],
Cell[CellGroupData[{
Cell[68913, 1470, 145, 3, 31, "Input"],
Cell[69061, 1475, 237, 7, 35, "Output"]
}, Open  ]]
}, Open  ]],
Cell[69325, 1486, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[70625, 1527, 68, 1, 36, "Section",
 CellTags->"NumericalValues"],
Cell[70696, 1530, 259, 6, 40, "Text"],
Cell[CellGroupData[{
Cell[70980, 1540, 1418, 36, 131, "Input"],
Cell[72401, 1578, 243, 6, 35, "Output"],
Cell[72647, 1586, 48, 0, 27, "Print"],
Cell[72698, 1588, 48, 0, 27, "Print"],
Cell[72749, 1590, 48, 0, 27, "Print"]
}, Open  ]],
Cell[72812, 1593, 16, 0, 24, "Text"]
}, Open  ]],
Cell[72843, 1596, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[74143, 1637, 80, 1, 36, "Section",
 CellTags->"NumericalValues"],
Cell[74226, 1640, 169, 3, 24, "Text"],
Cell[74398, 1645, 1289, 34, 124, "InputOnly"],
Cell[75690, 1681, 151, 4, 24, "Text"]
}, Open  ]],
Cell[75856, 1688, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[77156, 1729, 50, 0, 36, "Section"],
Cell[77209, 1731, 143, 3, 24, "Text"],
Cell[77355, 1736, 1654, 40, 244, "InputOnly"],
Cell[79012, 1778, 198, 4, 40, "Text"],
Cell[79213, 1784, 5368, 91, 89, 5259, 87, "GraphicsData", "Bitmap", "Text",
 Evaluatable->False]
}, Open  ]],
Cell[84596, 1878, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[85896, 1919, 33, 0, 36, "Section"],
Cell[85932, 1921, 574, 20, 25, "Text"],
Cell[86509, 1943, 133, 3, 24, "Text"],
Cell[86645, 1948, 106, 3, 24, "Text"]
}, Open  ]],
Cell[86766, 1954, 1275, 37, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[88066, 1995, 45, 0, 36, "Section"],
Cell[88114, 1997, 151, 4, 24, "Text"],
Cell[CellGroupData[{
Cell[88290, 2005, 83, 1, 33, "Subsubsection"],
Cell[88376, 2008, 202, 4, 40, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88615, 2017, 99, 1, 33, "Subsubsection"],
Cell[88717, 2020, 177, 3, 24, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88931, 2028, 98, 1, 33, "Subsubsection"],
Cell[89032, 2031, 131, 3, 24, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89200, 2039, 97, 1, 33, "Subsubsection"],
Cell[89300, 2042, 153, 3, 24, "Text"]
}, Open  ]]
}, Open  ]],
Cell[89480, 2049, 1293, 38, 30, "SlideShowNavigationBar"],
Cell[CellGroupData[{
Cell[90798, 2091, 64, 1, 36, "Section",
 CellTags->"LastSlide"],
Cell[90865, 2094, 156, 3, 24, "Text"],
Cell[CellGroupData[{
Cell[91046, 2101, 200, 3, 33, "Subsubsection"],
Cell[91249, 2106, 329, 9, 24, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91615, 2120, 204, 3, 33, "Subsubsection"],
Cell[91822, 2125, 312, 8, 40, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92171, 2138, 196, 3, 33, "Subsubsection"],
Cell[92370, 2143, 300, 8, 24, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92707, 2156, 170, 3, 33, "Subsubsection"],
Cell[92880, 2161, 275, 8, 24, "Text"],
Cell[93158, 2171, 17, 0, 24, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
