(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8834,        283]
NotebookOptionsPosition[      6162,        206]
NotebookOutlinePosition[      7959,        249]
CellTagsIndexPosition[      7916,        246]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: SimpleDialogApp"
}], "Title",
 CellID->554471618],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->257231707],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->546153860],

Cell[BoxData[
 RowBox[{
  RowBox[{"SimpleDialogApp", "[", "]"}], ":=", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/SimpleDialogApp\>\"", "]"}]}]], "Input",\

 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->126615127],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->198556321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Get", "[", "\"\<Wolfram/Example/SimpleDialogApp.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[4]:=",
 CellID->283939802],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Frame\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"title\"\>", "\[Rule]", "\<\"Simple Dialog App\"\>"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"TextField\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Initial app text\"\>"}], 
        "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"appTextField\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Dialog\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"title\"\>", "\[Rule]", "\<\"Simple Dialog\"\>"}], ",", 
         RowBox[{"\<\"modal\"\>", "\[Rule]", "True"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextField\"\>", ",", 
           RowBox[{"{", 
            
            RowBox[{"\<\"text\"\>", 
             "\[Rule]", "\<\"Initial dialog text\"\>"}], "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"dialogTextField\"\>"}]}], "]"}], 
         ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Done\"\>"}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"InvokeMethod", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"myDialog\"\>", ",", "\<\"dispose\"\>"}], "}"}], 
                "]"}]}], "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"InvokeMethod", "[", "\<\"center\"\>", "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"myDialog\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Button\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Run Modal Dialog\"\>"}], ",",
          
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"SetPropertyValue", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"dialogTextField\"\>", ",", "\<\"text\"\>"}], 
                "}"}], ",", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"appTextField\"\>", ",", "\<\"text\"\>"}], "}"}],
                 "]"}]}], "]"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"myDialog\"\>", ",", "\<\"show\"\>"}], "}"}], 
              "]"}]}], "]"}]}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"myDialog\"\>", ",", "\<\"windowClosed\"\>"}], "}"}], ",",
        
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"SetPropertyValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"appTextField\"\>", ",", "\<\"text\"\>"}], "}"}], ",",
            
           RowBox[{"PropertyValue", "[", 
            RowBox[{"{", 
             RowBox[{"\<\"dialogTextField\"\>", ",", "\<\"text\"\>"}], "}"}], 
            "]"}]}], "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Name", "\[Rule]", "\<\"myFrame\"\>"}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->6721128]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->131479991],

Cell["\<\
This example illustrates how to use modal dialogs initiated from another \
window, optionally setting up property values on widgets in the modal dialog, \
and, when the modal dialog is closed, retrieving values from the widgets in \
the modal dialog.\
\>", "Text",
 CellID->377554588],

Cell[TextData[{
 StyleBox["NOTE",
  FontWeight->"Bold"],
 ": This modal dialog will be modal to other user interface definitions, but \
not modal to interactions with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or the kernel. Modal interactions with the kernel are determined by \
using",
 " ",
 StyleBox["GUI", "MR"],
 StyleBox["Run", "Output"],
 " or ",
 StyleBox["GUIRunModal", "Output"],
 "."
}], "Text",
 CellID->462815191],

Cell[BoxData[
 RowBox[{
  RowBox[{"SimpleDialogApp", "[", "]"}], ";"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[3]:=",
 CellID->208511899]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: SimpleDialogApp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 36.9109972}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example illustrates how to use modal dialogs initiated from another \
window, optionally setting up property values on widgets in the modal dialog, \
and, when the modal dialog is closed, retrieving values from the widgets in \
the modal dialog. NOTE: This modal dialog will be modal to other user \
interface definitions, but not modal to interactions with Mathematica or the \
kernel. Modal interactions with the kernel are determined by using GUIRun or \
GUIRunModal.", "synonyms" -> {}, "title" -> "GUIKit Example: SimpleDialogApp",
     "type" -> "Tutorial", "uri" -> "GUIKit/tutorial/SimpleDialogApp"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 121, 5, 70, "Title",
 CellID->554471618],
Cell[CellGroupData[{
Cell[877, 38, 52, 1, 70, "SubsectionOpener",
 CellID->257231707],
Cell[932, 41, 166, 5, 70, "Input",
 InitializationCell->True,
 CellID->546153860],
Cell[1101, 48, 257, 9, 70, "Input",
 InitializationCell->True,
 CellID->126615127],
Cell[CellGroupData[{
Cell[1383, 61, 61, 1, 70, "SubsubsectionOpener",
 CellID->198556321],
Cell[CellGroupData[{
Cell[1469, 66, 360, 11, 70, "Input",
 CellID->283939802],
Cell[1832, 79, 3279, 80, 70, "Output",
 CellID->6721128]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[5172, 166, 46, 1, 70, "Section",
 CellID->131479991],
Cell[5221, 169, 294, 6, 70, "Text",
 CellID->377554588],
Cell[5518, 177, 439, 16, 70, "Text",
 CellID->462815191],
Cell[5960, 195, 148, 5, 70, "Input",
 CellID->208511899]
}, Open  ]]
}, Open  ]],
Cell[6135, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

