(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46728,       1607]
NotebookOptionsPosition[     31494,       1096]
NotebookOutlinePosition[     40209,       1373]
CellTagsIndexPosition[     39790,       1357]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["XML Reference", "Title",
 CellTags->"XMLIntro",
 CellID->92849764],

Cell["\<\
This tutorial documents the XML representation of the user interface \
definition, GUIKitXML for short.\
\>", "Text",
 CellTags->"XMLIntro",
 CellID->791206465],

Cell[BoxData[GridBox[{
   {Cell["Element", "TableHeader"], Cell["Description", "TableHeader"]},
   {
    RowBox[{
     RowBox[{"<", 
      RowBox[{"widget", " ", "src"}]}], "=", 
     RowBox[{
      RowBox[{
       StyleBox["file", "TI"], "|", 
       RowBox[{"class", ":", 
        RowBox[{
         StyleBox["className", "TI"], ">", "<", 
         RowBox[{"widget", " ", "class"}]}]}]}], "=", 
      RowBox[{
       StyleBox["className", "TI"], ">"}]}]}], "\[SpanFromLeft]"},
   {"", Cell["create a new widget", "TableText"]},
   {
    RowBox[{
     RowBox[{"<", 
      RowBox[{"widget", " ", "ref"}]}], "=", 
     RowBox[{
      StyleBox["id", "TI"], ">"}]}], Cell[
    "look up an existing widget", "TableText"]},
   {
    RowBox[{"<", "group", ">"}], Cell[
    "add custom layout features to how widgets will display", "TableText"]},
   {
    RowBox[{"<", "args", ">"}], Cell[
    "specify constructor arguments", "TableText"]},
   {
    RowBox[{"<", "string", ">"}], Cell[
    "create a new string object or look one up", "TableText"]},
   {
    RowBox[{
     RowBox[{"<", 
      RowBox[{"property", " ", "name"}]}], "=", 
     RowBox[{
      StyleBox["name", "TI"], ">"}]}], Cell[
    "set or get a widget property", "TableText"]},
   {
    RowBox[{"<", "bindevent", ">"}], Cell[
    "bind an event from one widget to a listener  or to a script", 
     "TableText"]},
   {
    RowBox[{
     RowBox[{"<", 
      RowBox[{"invokemethod", " ", "name"}]}], "=", 
     RowBox[{
      StyleBox["method", "TI"], ">"}]}], Cell[
    "call a widget method", "TableText"]},
   {
    RowBox[{"<", "script", ">"}], Cell["\<\
define a script to be used elsewhere, either on load or during an event\
\>", "TableText"]},
   {
    RowBox[{
     RowBox[{"<", 
      RowBox[{"expose", " ", "ref"}]}], "=", 
     RowBox[{
      StyleBox["id", "TI"], ">"}]}], Cell["\<\
Add a widget from an inner XML file to the registry of accessible widgets in \
the parent XML file\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}}},
 CellID->24460338],

Cell[CellGroupData[{

Cell["DTD", "Section",
 CellTags->"DTD:Tag",
 CellID->119915775],

Cell[TextData[{
 "This is a DTD representing the current ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " XML definitions."
}], "Text",
 CellTags->"DTD",
 CellID->524543224],

Cell["\<\
<?xml encoding=\"UTF-8\"?>

<!--
   GUIKit` XML Markup Language, GUIKitXML DTD
   Copyright 2004, Wolfram Research, Inc.
-->

<!ENTITY % common-elems \
\"widget|group|string|integer|double|null|true|false|invokemethod|property|\
script|space|fill|align\">
<!ENTITY % invokemethod-valued-elems \"%common-elems;\">
<!ENTITY % bindevent-valued-elems \
\"widget|script|invokemethod|property|bindevent\">
<!ENTITY % stmt-elems \"%common-elems;|bindevent\">

<!-- layout can exist as either a simple attribute or as a subelement
\t   on widget and group.  The subelement trumps the attribute if
\t   both exist 
\t-->

<!ELEMENT widget (layout?,args?,expose*,(%stmt-elems;)*)>
<!ATTLIST widget
  src NMTOKEN #IMPLIED
  ref CDATA #IMPLIED
  class NMTOKEN #IMPLIED
  id CDATA #IMPLIED
  layout CDATA #IMPLIED>

<!ELEMENT group (layout?,(%stmt-elems;)*)>
<!ATTLIST group
  layout CDATA #IMPLIED
  id CDATA #IMPLIED
  root CDATA #IMPLIED>
  
<!--  value should be in integer pixel units -->
<!ELEMENT space EMPTY >
<!ATTLIST space
  value CDATA #REQUIRED>
  
<!ELEMENT fill EMPTY >

<!--  ref should be a widget reference string
\t    from and to can be either \"Before\" or \"After\"
 -->
<!ELEMENT align EMPTY >
<!ATTLIST align
  ref CDATA #IMPLIED
  from CDATA #IMPLIED
  to CDATA #IMPLIED>
  
<!ELEMENT layout (grouping?,alignment?,stretching?,spacing?,border?)>

<!--  grouping either specifies a simple attribute type of
\t    None, Automatic, Column, Row, Grid  or a
\t    subelement that resolves to a Java layout manager widget
\t    equivalent to just using a \"layout\" property on the container
 -->
<!ELEMENT grouping (%common-elems;) >
<!ATTLIST grouping
  type CDATA #IMPLIED>

<!-- alignment type can be Automatic, Left, Center, Right, Top or Bottom
\t   and can specify different values for both axes such as
\t   \"Automatic, Top\" or \"Left,Center\"
\t-->
<!ELEMENT alignment EMPTY >
<!ATTLIST alignment
  type CDATA #REQUIRED>
  
<!-- stretching type can be Automatic, None, WidgetAlignments, True, Maximize
\t   and can specify different values for both axes such as
\t   \"None,True\"
\t-->
<!ELEMENT stretching EMPTY >
<!ATTLIST stretching
  type CDATA #REQUIRED>
  
<!--  value should be in integer pixel units -->
<!ELEMENT spacing EMPTY >
<!ATTLIST spacing
  value CDATA #REQUIRED>
  
<!ELEMENT border (((border+)|%common-elems;)?) >
<!ATTLIST border
  type CDATA #IMPLIED
  title CDATA #IMPLIED
  left CDATA #IMPLIED
  right CDATA #IMPLIED
  top CDATA #IMPLIED
  bottom CDATA #IMPLIED>
  
<!-- Versions:

\t\tCreate and configure an widget:
\t\t
         <widget src=\"filename | URL\" [id=\"name-to-register-as\"]> ... \
</widget>
         <widget src=\"class:a.b.C\" [id=\"name-to-register-as\"]> ... \
</widget>
         <widget class=\"a.b.C\" [id=\"name-to-register-as\"]> ... </widget>
         
         src=\"class:className\" is identical to using class=\"className\".
         The arguments define the constructor args.
         The arguments to the inner GUIKitXML file can be accessed via the \
names:
         \"#1\", \"#2\", ..., \"#n\".

\t\tConfigure an existing widget:
       
         <widget ref=\"name-to-look-up\" [class=\"a.b.C\"] > ... </widget>
         
\t   The class attrib is optional because the API doesn't need it,
\t   but a possible compiler may.
     If id attribute is present then register the widget. 
 -->

<!-- constructor arguments -->
<!ELEMENT args (%common-elems;)*>
<!ATTLIST args
  ref CDATA #IMPLIED>
<!-- Versions:
      <args ref=\"\"/> provides a way of referencing a 
      vector or collection of widgets to use as arguments.
      
      Most importantly, used with <args ref=\"##\"/>
      to specify that the array of arguments passed to the script
      should be used as arguments to the constructor of the wrapping widget.
      A useful pattern for building reusable GUIKit widgets in 
      self contained files.
      
 -->
     
<!ELEMENT property (%common-elems;)?>
<!ATTLIST property
  target CDATA #IMPLIED
  name NMTOKEN #REQUIRED
  index NMTOKEN #IMPLIED
  value CDATA #IMPLIED
  id CDATA #IMPLIED
  invokeThread NMTOKEN #IMPLIED
  invokeWait NMTOKEN #IMPLIED>
<!-- Versions:
       Get: <property [target=\"t\"] name=\"foo\" [index=\"num\"] \
[id=\"name\"]/>
       Set: <property [target=\"t\"] name=\"foo\" [index=\"num\"] \
[id=\"name\"]>
               some-element
            </property>
            or
            <property [target=\"t\"] name=\"foo\" [index=\"num\"] \
value=\"stuff\"
                      [id=\"name\"]/>
            where stuff is either is one of the valid elements.
     If index is given, then property is an indexed property.
     XML and Mathematica is 1-based, Java is 0-based
     Set version of property returns nothing (i.e., void) and hence only
     makes sense as a direct child of <widget>. If id attribute is present
     then register the property value. -->

<!ELEMENT bindevent (%bindevent-valued-elems;)+>
<!ATTLIST bindevent
  target CDATA #IMPLIED
  name NMTOKEN #REQUIRED
  filter NMTOKEN #IMPLIED
  id CDATA #IMPLIED
  invokeThread NMTOKEN #IMPLIED
  invokeWait NMTOKEN #IMPLIED>

<!-- Versions:
       <bindevent [target=\"t\"] name=\"e\" [filter=\"f\"]>
         <widget ... />
       </bindevent>

     This is the conventional event binding. The target t is the
     target of the binding, not the target of the actual firing of
     the event. Bind the child widget as a listener for e events from
     target t. The child widget must implement the appropriate listener
     interface. The filter f is optional and used in rare cases only if (e = \
propertyChange or
     vetoableChange) as that allows property
     and vetoable change listeners to register for specific properties
     rather than any property. The filter will name a property in
     these cases. 
     name=\"mouse\" filter=\"mouseEntered\" can instead just be specified by \
name=\"mouseEntered\" now
     
     Missing target attribute makes the context widget be
     the target.


       <bindevent [target=\"t\"] name=\"e\" [filter=\"f\"]>
         <script [language=\"mathematica\"]>
\t   ...
         </script>
       </bindevent>

     When event e occurs in source, process the script. If
     filter is specified, then only events delivered which match
     that filter cause the script to be processed. In general, the
     filter attribute is used to name a method in a listener type
     that has multiple methods (e.g., WindowEvent in AWT). For event
     name = propertyChange or vetoableChange, the filter is the name
     of the property for which the binding should be done. JDK1.2
     has direct support for these types of property and vetoable
     change listeners, but others will require the
     propchange/vetochange event processor to do the filtering work.
     Missing target attribute makes the context widget be the target.
     See the <script> element for a description of how to access the
     arguments to the script (such as an event widget, or any
     arbitrary list of event arguments).-->


<!ELEMENT script (#PCDATA|%stmt-elems;)*>
<!ATTLIST script
  language NMTOKEN #IMPLIED
  src NMTOKEN #IMPLIED>
<!--
     The script contained in the element is processed by a scripting
     engine capable of processing the language described by the language
     attribute. The value of the language attribute can be anything
     supported by the widget scripting framework. The src attribute can
     give a URL or relative file from which the script is to be loaded.

     The arguments to the <script> element can be accessed via the names:
     \"#1\", \"#2\", \"#3\", ..., \"#n\"

     Example:
       <widget class=\"java.awt.Button\">
         <bindevent name=\"action\">
           <script>
\t           <invokemethod target=\"demomgr\" name=\"load\">
\t             <property target=\"#1\" name=\"actionCommand\"/>
\t           </invokemethod>
\t     **************************************************
\t     above will call the \"load\" method of the widget named
\t     \"demomgr\" with the \"actionCommand\" property of the
\t     actionevent widget generated by the event source.
\t     Note that the widget \"#0\" in this case will be
\t     java.lang.String(\"actionPerformed\"), which is the
\t     name of the method via which the event was delivered.
 \t     **************************************************
\t          </script>
         </bindevent>
       </widget>
     -->


<!-- call a method -->
<!ELEMENT invokemethod (%invokemethod-valued-elems;)*>
<!ATTLIST invokemethod
  target CDATA #IMPLIED
  name NMTOKEN #REQUIRED
  id CDATA #IMPLIED
  invokeThread NMTOKEN #IMPLIED
  invokeWait NMTOKEN #IMPLIED>
<!-- The arguments to the method are the children widgets and the signature
     of the method to call is defined by the children's types.
     If id attribute is present then register the return value. -->


<!ELEMENT string (#PCDATA)>
<!ATTLIST string
  value CDATA #IMPLIED
  id CDATA #IMPLIED>
<!-- treat the pcdata as a string. empty <string/> is 'new String(\"\")'.
     If id attribute is present then register the string. -->

<!ELEMENT integer (#PCDATA)>
<!ATTLIST integer
  value CDATA #IMPLIED
  id CDATA #IMPLIED>
<!-- treat the pcdata as a integer.
     If id attribute is present then register the integer. -->
     
<!ELEMENT double (#PCDATA)>
<!ATTLIST double
  value CDATA #IMPLIED
  id CDATA #IMPLIED>
<!-- treat the pcdata as a double.
     If id attribute is present then register the double. -->
     
<!ELEMENT null (#PCDATA)>
<!ATTLIST null
  class CDATA #IMPLIED
  id CDATA #IMPLIED>
<!-- null. If id attribute is present then register the Null. -->
    
<!ELEMENT true EMPTY>
<!-- Boolean.TRUE -->
<!ELEMENT false EMPTY>
<!-- Boolean.FALSE  -->
     
<!ELEMENT expose EMPTY >
<!ATTLIST expose
  ref CDATA #REQUIRED
  as CDATA #IMPLIED>
  
<!-- expose can be child elements of <widget class=\"*.xml\"> to expose 
     widgets registered in the child xml document to the parent documents
     widget registry, optionally using a different ref than the child by
     specifying an as attribute. -->\
\>", "Program",
 CellTags->"DTD",
 CellID->275003088]
}, Open  ]],

Cell[CellGroupData[{

Cell["<args>", "Section",
 CellTags->"ArgsElement",
 CellID->115393119],

Cell[TextData[{
 "Use the ",
 StyleBox["<args>", "InlineCode"],
 " element to specify that the containing widgets should be used as arguments \
to the parent ",
 StyleBox["<widget>", "InlineCode"],
 " new instance object constructor."
}], "Text",
 CellTags->"ArgsElement",
 CellID->163316244],

Cell[TextData[{
 "This is a very common use of the ",
 StyleBox["<args>", "InlineCode"],
 " element to specify the set of widgets to use based on a widget name \
reference."
}], "Text",
 CellTags->"ArgsElement",
 CellID->198908421],

Cell[TextData[{
 "<widget class=\"javax.swing.JButton\">\n\t",
 StyleBox["<args ref=\"##\"/>",
  FontWeight->"Bold"],
 "\n</",
 "widget",
 ">"
}], "Program",
 CellTags->"ArgsElement",
 CellID->214803806],

Cell["\<\
Here you specify the title of a frame using an argument to the object's \
constructor.\
\>", "Text",
 CellTags->"ArgsElement",
 CellID->8412600],

Cell[TextData[{
 "<",
 "widget",
 " src=\"Frame\">\n  ",
 StyleBox["<args>",
  FontWeight->"Bold"],
 "\n    <string value=\"Calc with Mathematica\"/>\n  ",
 StyleBox["</args>",
  FontWeight->"Bold"],
 "\n  ..."
}], "Program",
 CellTags->"ArgsElement",
 CellID->31192227]
}, Open  ]],

Cell[CellGroupData[{

Cell["<bindevent>", "Section",
 CellTags->"BindEventElement",
 CellID->437984276],

Cell[TextData[{
 "Use the ",
 StyleBox["<bindevent>", "InlineCode"],
 " element to associate script code or other method calls to occur when an \
event is triggered from the targeted widget. Here are two forms of \
associating code with an event action."
}], "Text",
 CellTags->"BindEventElement",
 CellID->216669503],

Cell["\<\
<bindevent [target=\"t\"] name=\"e\" [filter=\"f\"]>
  <script>
  ...
  </script>
</bindevent>\
\>", "Program",
 CellTags->"BindEventElement",
 CellID->216597859],

Cell[TextData[{
 "When event ",
 Cell[BoxData["e"], "InlineFormula"],
 " occurs, process the script. If filter is specified, then only events \
delivered that match that filter cause the script to be processed. In \
general, the filter attribute is used to name a method in a listener type \
that has multiple methods (e.g., WindowEvent in AWT). For event ",
 StyleBox["name=\"propertyChange\"", "InlineCode"],
 " or ",
 StyleBox["name=\"vetoableChange\"", "InlineCode"],
 ", the filter is the name of the property for which the binding should be \
done. With a missing target attribute, the wrapping context ",
 StyleBox["<widget>", "InlineCode"],
 " is the target. See the ",
 StyleBox["<script>", "InlineCode"],
 " element for a description of how to access the arguments to the script; \
this includes special names in the widget registry, such as ",
 StyleBox["\"##\"", "InlineCode"],
 " and ",
 StyleBox["\"#1\"", "InlineCode"],
 ", ",
 StyleBox["\"#2\"", "InlineCode"],
 ", and so forth."
}], "Text",
 CellTags->"BindEventElement",
 CellID->8948362],

Cell["\<\
<bindevent [target=\"t\"] name=\"e\" [filter=\"f\"]>
  <widget ... />
</bindevent>\
\>", "Program",
 CellTags->"BindEventElement",
 CellID->246207025],

Cell[TextData[{
 "In the previous case, the ",
 StyleBox["<widget>", "InlineCode"],
 " must resolve to a widget that implements the appropriate listener \
interface."
}], "Text",
 CellTags->"BindEventElement",
 CellID->741108461],

Cell[TextData[{
 "In the following example, the script makes use of the specially registered \
event objects that are defined every time a script within a ",
 StyleBox["<bindevent>", "InlineCode"],
 " element is triggered, such as ",
 StyleBox["\"#\"", "InlineCode"],
 ", which resolves to a ",
 StyleBox["MouseEvent", "InlineCode"],
 " instance."
}], "Text",
 CellTags->"BindEventElement",
 CellID->33493158],

Cell[TextData[{
 "<widget src=\"MathCanvas\" id=\"canvas\">\n  ",
 StyleBox["<bindevent name=\"mouseDragged\">",
  FontWeight->"Bold"],
 "\n    <script>\n      mouseDraggedFunc[ \n        WidgetReference[\"#\"] @  \
getX[], \n        WidgetReference[\"#\"] @ getY[] ];\n     </script>\n  ",
 StyleBox["</bindevent>",
  FontWeight->"Bold"],
 "\n</widget>"
}], "Program",
 CellTags->"BindEventElement",
 CellID->379819604],

Cell[TextData[{
 "Here you bind a simple script to the common ",
 StyleBox["Button", "InlineCode"],
 " action event."
}], "Text",
 CellTags->"BindEventElement",
 CellID->279216043],

Cell[TextData[{
 "<widget src=\"Button\">\n  ",
 StyleBox["<bindevent name=\"action\">",
  FontWeight->"Bold"],
 "\n    <script>incrementFieldValue[];</script>\n  ",
 StyleBox["</bindevent>",
  FontWeight->"Bold"],
 "\n</",
 "widget",
 ">"
}], "Program",
 CellTags->"BindEventElement",
 CellID->41951831]
}, Open  ]],

Cell[CellGroupData[{

Cell["<invokemethod>", "Section",
 CellTags->"CallElement",
 CellID->458446325],

Cell[TextData[{
 "Use the ",
 StyleBox["<invokemethod>", "InlineCode"],
 " element to make a method call on a widget. It can be a simple no-argument \
call where the method is specified only with a name attribute, or it could \
include child elements representing the arguments to the method."
}], "Text",
 CellTags->"CallElement",
 CellID->103296],

Cell["Here is a simple no-argument method call.", "Text",
 CellTags->"CallElement",
 CellID->692665399],

Cell[TextData[StyleBox["<invokemethod name=\"doLayout\"/>",
 FontWeight->"Bold"]], "Program",
 CellTags->"CallElement",
 CellID->163235237],

Cell[TextData[{
 "Here is an example that requires child elements to specify the arguments to \
the method call. If no target attribute exists, then the target of the method \
call is the wrapping widget instance of the ",
 StyleBox["<invokemethod>", "InlineCode"],
 "."
}], "Text",
 CellTags->"CallElement",
 CellID->15380220],

Cell[TextData[{
 "  ",
 StyleBox["<invokemethod target=\"frame\" name=\"setSize\">",
  FontWeight->"Bold"],
 "\n  \t<integer value=\"400\"/>\n  \t<integer value=\"400\"/>\n  ",
 StyleBox["</invokemethod>",
  FontWeight->"Bold"]
}], "Program",
 CellTags->"CallElement",
 CellID->114959301]
}, Open  ]],

Cell[CellGroupData[{

Cell["<expose>", "Section",
 CellTags->"ExposeElement",
 CellID->116596268],

Cell[TextData[{
 "Use the ",
 StyleBox["<expose>", "InlineCode"],
 " element when you want to allow external access to widgets from within \
included interface definitions. Normally only the root widget is \
automatically available when wrapping other definitions. ",
 StyleBox["<expose>", "InlineCode"],
 " allows you to not only percolate up access to other widgets, but also \
redefine the widget reference name by which they can be found in the wrapping \
interface. Renaming references is especially handy when exposing them if \
there is a need to expose multiple instances of the same interface, but \
provide access to each instance with a different name."
}], "Text",
 CellTags->"ExposeElement",
 CellID->708726566],

Cell[TextData[{
 "In this example definition, normally only the top-level component \
referenced by ",
 StyleBox["\"frame\"", "InlineCode"],
 " would be available to users of this definition. Knowing that the external \
definition ",
 StyleBox["\"progressbar2base\"", "InlineCode"],
 " also contains another widget referenced by the id ",
 StyleBox["\"bar\"", "InlineCode"],
 ", you can use an ",
 StyleBox["<expose>", "InlineCode"],
 " element in this definition to also allow users access to the widget in ",
 StyleBox["\"progressbar2base\"", "InlineCode"],
 " found using the name ",
 StyleBox["\"bar\"", "InlineCode"],
 "."
}], "Text",
 CellTags->"ExposeElement",
 CellID->281501268],

Cell[TextData[{
 "<?xml version=\"1.0\"?>\n<widget src=\"progressbar2base\" id=\"frame\">\n   \
<args>\n    <string value=\"Wrapped Progress\" />\n    <string  \
value=\"Wrapped complete:\" />\n    <integer value=\"20\" />\n  </args>\n  ",
 StyleBox["<expose ref=\"bar\"/>",
  FontWeight->"Bold"],
 "\n</",
 "widget",
 ">"
}], "Program",
 CellTags->"ExposeElement",
 CellID->18570922],

Cell[TextData[{
 "You could also choose to expose the ",
 StyleBox["\"bar\"", "InlineCode"],
 " widget with a different name using the optional ",
 StyleBox["as=", "InlineCode"],
 " attribute, such as allowing access to the widget as the name ",
 StyleBox["\"progressBar\"", "InlineCode"],
 "."
}], "Text",
 CellTags->"ExposeElement",
 CellID->4379100],

Cell[TextData[{
 "<?xml version=\"1.0\"?>\n<widget src=\"progressbar2base\" id=\"frame\">\n   \
<args>\n    <string value=\"Wrapped Progress\" />\n    <string  \
value=\"Wrapped complete:\" />\n    <integer value=\"20\" />\n  </args>\n  ",
 StyleBox["<expose ref=\"bar\" as=\"progressBar\"/>",
  FontWeight->"Bold"],
 "\n</widget>"
}], "Program",
 CellTags->"ExposeElement",
 CellID->114598805]
}, Open  ]],

Cell[CellGroupData[{

Cell["<group>", "Section",
 CellTags->"GroupElement",
 CellID->257806278],

Cell[TextData[{
 "The ",
 StyleBox["<group>", "InlineCode"],
 " element is used to nest widget groups and customize how the interface will \
be displayed. More examples will be forthcoming."
}], "Text",
 CellTags->"GroupElement",
 CellID->306210113],

Cell[TextData[{
 "<",
 StyleBox["group",
  FontWeight->"Bold"],
 ">\n <widget src=\"Button\">\n  <property name=\"label\" value=\"++\"/>\n  \
</widget>\n <widget src=\"Button\">\n  <property name=\"label\"  \
value=\"--\"/>\n </widget>\n</",
 StyleBox["group",
  FontWeight->"Bold"],
 ">"
}], "Program",
 CellTags->"GroupElement",
 CellID->378647251]
}, Open  ]],

Cell[CellGroupData[{

Cell["<widget>", "Section",
 CellTags->"WidgetElement",
 CellID->860127732],

Cell[TextData[{
 "The ",
 StyleBox["<widget>", "InlineCode"],
 " element is used both for defining a new instance to be created based on \
the contents of the ",
 StyleBox["<widget>", "InlineCode"],
 " element or alternatively to specify a reference to an existing widget \
instance by using the ",
 StyleBox["ref=\"name\"", "InlineCode"],
 " attribute."
}], "Text",
 CellTags->"WidgetElement",
 CellID->161701940],

Cell["Here are some patterns used when creating new instances.", "Text",
 CellTags->"WidgetElement",
 CellID->669966069],

Cell["\<\
<widget src=\"filename | URL\" [id=\"name-to-register-as\"]> 
  ... 
</widget>

<widget src=\"class:a.b.C\" [id=\"name-to-register-as\"]> 
  ...
</widget>

<widget class=\"a.b.C\" [id=\"name-to-register-as\"]> 
  ... 
</widget>\
\>", "Program",
 CellTags->"WidgetElement",
 CellID->213899178],

Cell[TextData[{
 "The two forms ",
 StyleBox["src=\"class:a.b.C\"", "InlineCode"],
 " and ",
 StyleBox["class=\"a.b.C\"", "InlineCode"],
 " are simply alternate forms of the same functionality."
}], "Text",
 CellTags->"WidgetElement",
 CellID->471252451],

Cell["\<\
Here are patterns used for configuring or looking up existing widget \
instances.\
\>", "Text",
 CellTags->"WidgetElement",
 CellID->1203720],

Cell["\<\
<widget ref=\"name-to-look-up\"> 
  ... 
</widget>\
\>", "Program",
 CellTags->"WidgetElement",
 CellID->43432884],

Cell[TextData[{
 "This definition creates a new widget instance using the ",
 StyleBox["src",
  FontSlant->"Italic"],
 " attribute to find the resource that defines what eventual widget class is \
created."
}], "Text",
 CellTags->"WidgetElement",
 CellID->62715263],

Cell[TextData[{
 StyleBox["<widget src=\"Button\">",
  FontWeight->"Bold"],
 "\n  <property name=\"label\" value=\"++\"/>\n",
 StyleBox["</widget>",
  FontWeight->"Bold"]
}], "Program",
 CellTags->"WidgetElement",
 CellID->226908892],

Cell[TextData[{
 "Here you refer to another widget in this definition named ",
 StyleBox["\"frame\"", "InlineCode"],
 " as an argument when constructing a new instance of the ",
 StyleBox["FileDialog", "InlineCode"],
 "."
}], "Text",
 CellTags->"WidgetElement",
 CellID->676268560],

Cell[TextData[{
 "<widget src=\"FileDialog\">\n  <args>\n    ",
 StyleBox["<widget ref=\"frame\"/>",
  FontWeight->"Bold"],
 "\n    <string value=\"Save As\"/>\n    <property  \
target=\"class:java.awt.FileDialog\" name=\"SAVE\"/>\n  </args>\n</widget>"
}], "Program",
 CellTags->"WidgetElement",
 CellID->7407267]
}, Open  ]],

Cell[CellGroupData[{

Cell["<property>", "Section",
 CellTags->"PropertyElement",
 CellID->763957438],

Cell[TextData[{
 "Use the ",
 StyleBox["<property>", "InlineCode"],
 " element to get a widget property value or to set a property value. You use \
the ",
 StyleBox["<property>", "InlineCode"],
 " element along with child elements or the ",
 StyleBox["value=\"\"", "InlineCode"],
 " attribute to set a property value."
}], "Text",
 CellTags->"PropertyElement",
 CellID->229723491],

Cell["Here is the pattern for getting a property value.", "Text",
 CellTags->"PropertyElement",
 CellID->172984288],

Cell["\<\
<property [target=\"t\"] name=\"foo\" [index=\"num\"] [id=\"name\"]/>\
\>", "Program",
 CellTags->"PropertyElement",
 CellID->81098920],

Cell["\<\
Either of these two patterns can be used to set a property value.\
\>", "Text",
 CellTags->"PropertyElement",
 CellID->236737579],

Cell["\<\
<property [target=\"t\"] name=\"foo\" [index=\"num\"] [id=\"name\"]>
  some-element
</property>

<property [target=\"t\"] name=\"foo\" [index=\"num\"] value=\"stuff\" \
[id=\"name\"]/>\
\>", "Program",
 CellTags->"PropertyElement",
 CellID->1455385],

Cell[TextData[{
 "If the target attribute is absent, the target of the property request is \
the wrapping widget instance.\nNote that indices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and XML Widget definitions are 1-based, while Java and direct calls to \
Java objects using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " follow the 0-based Java convention."
}], "Text",
 CellTags->"PropertyElement",
 CellID->45754750],

Cell["\<\
Here you set the text property of a textfield using the value attribute.\
\>", "Text",
 CellTags->"PropertyElement",
 CellID->59293905],

Cell[TextData[{
 "<widget src=\"TextField\" id=\"textField\">\n  ",
 StyleBox["<property name=\"text\" value=\"1\"/>",
  FontWeight->"Bold"],
 "\n</widget>"
}], "Program",
 CellTags->"PropertyElement",
 CellID->62182118],

Cell[TextData[{
 "In this case, the value for the \"layout\" property is created from the \
child elements of the ",
 StyleBox["<property>", "InlineCode"],
 " element."
}], "Text",
 CellTags->"PropertyElement",
 CellID->28101274],

Cell[TextData[{
 StyleBox["<property name=\"layout\">",
  FontWeight->"Bold"],
 "\n  <widget src=\"GridLayout\"/>\n",
 StyleBox["</property>",
  FontWeight->"Bold"]
}], "Program",
 CellTags->"PropertyElement",
 CellID->19644789]
}, Open  ]],

Cell[CellGroupData[{

Cell["<script>", "Section",
 CellTags->"ScriptElement",
 CellID->246849078],

Cell[TextData[{
 "Use the ",
 StyleBox["<script>", "InlineCode"],
 " element to associate scripting code either as general code to be executed \
when the widget definition is read in, or, if bound to a specific event, to \
be executed each time the event occurs.",
 " ",
 "By default, the language of a ",
 StyleBox["<script>", "InlineCode"],
 " element is ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code unless an alternate language is specified. You can use ",
 StyleBox["language=\"xml\"", "InlineCode"],
 " to specify that GUIKitXML child elements of the ",
 StyleBox["<script>", "InlineCode"],
 " element define the code to execute."
}], "Text",
 CellTags->"ScriptElement",
 CellID->324482418],

Cell[TextData[{
 "Since scripting language code is usually not XML compliant syntax, consider \
wrapping the text content of the ",
 StyleBox["<script>", "InlineCode"],
 " element with a CDATA section."
}], "Text",
 CellTags->"ScriptElement",
 CellID->12053372],

Cell[TextData[{
 "In this case you define a top-level ",
 StyleBox["<script>", "InlineCode"],
 " that sets up a function definition when the widget is instantiated."
}], "Text",
 CellTags->"ScriptElement",
 CellID->53275793],

Cell[TextData[{
 "<widget src=\"Frame\">\n  <property name=\"layout\">\n    <widget  \
src=\"GridLayout\"/>\n  </property>\n  \n  ",
 StyleBox["<script>",
  FontWeight->"Bold"],
 "<![CDATA[\n  \n    incrementFieldValue[] :=\n       \
SetPropertyValue[{\"textField\", \"text\"},\n        ToString[  \
ToExpression[PropertyValue[{\"textField\", \"text\"}]] + 1, InputForm] ]\n\n  \
 ]]>",
 StyleBox["</script>",
  FontWeight->"Bold"],
 "\n</widget>"
}], "Program",
 CellTags->"ScriptElement",
 CellID->411571613],

Cell["\<\
Here you bind some script code to execute each time the button's action is \
triggered.\
\>", "Text",
 CellTags->"ScriptElement",
 CellID->15756351],

Cell[TextData[{
 "<widget src=\"Button\">\n  <bindevent name=\"action\">\n    ",
 StyleBox["<script>",
  FontWeight->"Bold"],
 "incrementFieldValue[];",
 StyleBox["</script>",
  FontWeight->"Bold"],
 "\n  </bindevent>\n </",
 "widget",
 ">"
}], "Program",
 CellTags->"ScriptElement",
 CellID->445271649]
}, Open  ]],

Cell[CellGroupData[{

Cell["<string>", "Section",
 CellTags->"StringElement",
 CellID->48844498],

Cell[TextData[{
 "The <string> element is available to provide convenient ways of defining \
string instances, both as child PCDATA or with a value attribute. The use of \
",
 StyleBox["<string/>", "InlineCode"],
 " is equivalent to ",
 StyleBox["\"\"", "InlineCode"],
 "."
}], "Text",
 CellTags->"StringElement",
 CellID->123029943],

Cell["Here are two alternate forms of the same string instance.", "Text",
 CellTags->"StringElement",
 CellID->53154743],

Cell["\<\
<string value=\"content\"/>
<string>content</string>\
\>", "Program",
 CellTags->"StringElement",
 CellID->275143550],

Cell[TextData[{
 "Making a ",
 StyleBox["<string>", "InlineCode"],
 " element available eliminates the use of the ",
 StyleBox["<widget>", "InlineCode"],
 " element just to define a string as well as issues that arise by trying to \
have the ",
 StyleBox["<args>", "InlineCode"],
 " element take both PCDATA and other elements, along with the sensitivity \
issues of whitespace."
}], "Text",
 CellTags->"StringElement",
 CellID->7351959]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XML Reference - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 47.5198290}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This tutorial documents the XML representation of the user interface \
definition, GUIKitXML for short. This is a DTD representing the current \
GUIKit XML definitions. Use the <args> element to specify that the containing \
widgets should be used as arguments to the parent <widget> new instance \
object constructor.", "synonyms" -> {}, "title" -> "XML Reference", "type" -> 
    "Tutorial", "uri" -> "GUIKit/tutorial/XMLReference"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "XMLIntro"->{
  Cell[731, 29, 72, 2, 70, "Title",
   CellTags->"XMLIntro",
   CellID->92849764],
  Cell[806, 33, 170, 5, 70, "Text",
   CellTags->"XMLIntro",
   CellID->791206465]},
 "DTD:Tag"->{
  Cell[3170, 112, 64, 2, 70, "Section",
   CellTags->"DTD:Tag",
   CellID->119915775]},
 "DTD"->{
  Cell[3237, 116, 174, 7, 70, "Text",
   CellTags->"DTD",
   CellID->524543224],
  Cell[3414, 125, 10161, 304, 70, "Program",
   CellTags->"DTD",
   CellID->275003088]},
 "ArgsElement"->{
  Cell[13612, 434, 71, 2, 70, "Section",
   CellTags->"ArgsElement",
   CellID->115393119],
  Cell[13686, 438, 292, 9, 70, "Text",
   CellTags->"ArgsElement",
   CellID->163316244],
  Cell[13981, 449, 231, 7, 70, "Text",
   CellTags->"ArgsElement",
   CellID->198908421],
  Cell[14215, 458, 203, 9, 70, "Program",
   CellTags->"ArgsElement",
   CellID->214803806],
  Cell[14421, 469, 154, 5, 70, "Text",
   CellTags->"ArgsElement",
   CellID->8412600],
  Cell[14578, 476, 270, 12, 70, "Program",
   CellTags->"ArgsElement",
   CellID->31192227]},
 "BindEventElement"->{
  Cell[14885, 493, 81, 2, 70, "Section",
   CellTags->"BindEventElement",
   CellID->437984276],
  Cell[14969, 497, 317, 8, 70, "Text",
   CellTags->"BindEventElement",
   CellID->216669503],
  Cell[15289, 507, 172, 8, 70, "Program",
   CellTags->"BindEventElement",
   CellID->216597859],
  Cell[15464, 517, 1056, 25, 70, "Text",
   CellTags->"BindEventElement",
   CellID->8948362],
  Cell[16523, 544, 160, 6, 70, "Program",
   CellTags->"BindEventElement",
   CellID->246207025],
  Cell[16686, 552, 229, 7, 70, "Text",
   CellTags->"BindEventElement",
   CellID->741108461],
  Cell[16918, 561, 409, 11, 70, "Text",
   CellTags->"BindEventElement",
   CellID->33493158],
  Cell[17330, 574, 420, 11, 70, "Program",
   CellTags->"BindEventElement",
   CellID->379819604],
  Cell[17753, 587, 180, 6, 70, "Text",
   CellTags->"BindEventElement",
   CellID->279216043],
  Cell[17936, 595, 304, 12, 70, "Program",
   CellTags->"BindEventElement",
   CellID->41951831]},
 "CallElement"->{
  Cell[18277, 612, 79, 2, 70, "Section",
   CellTags->"CallElement",
   CellID->458446325],
  Cell[18359, 616, 348, 8, 70, "Text",
   CellTags->"CallElement",
   CellID->103296],
  Cell[18710, 626, 103, 2, 70, "Text",
   CellTags->"CallElement",
   CellID->692665399],
  Cell[18816, 630, 139, 3, 70, "Program",
   CellTags->"CallElement",
   CellID->163235237],
  Cell[18958, 635, 327, 8, 70, "Text",
   CellTags->"CallElement",
   CellID->15380220],
  Cell[19288, 645, 288, 9, 70, "Program",
   CellTags->"CallElement",
   CellID->114959301]},
 "ExposeElement"->{
  Cell[19613, 659, 75, 2, 70, "Section",
   CellTags->"ExposeElement",
   CellID->116596268],
  Cell[19691, 663, 724, 14, 70, "Text",
   CellTags->"ExposeElement",
   CellID->708726566],
  Cell[20418, 679, 687, 18, 70, "Text",
   CellTags->"ExposeElement",
   CellID->281501268],
  Cell[21108, 699, 384, 11, 70, "Program",
   CellTags->"ExposeElement",
   CellID->18570922],
  Cell[21495, 712, 352, 10, 70, "Text",
   CellTags->"ExposeElement",
   CellID->4379100],
  Cell[21850, 724, 394, 9, 70, "Program",
   CellTags->"ExposeElement",
   CellID->114598805]},
 "GroupElement"->{
  Cell[22281, 738, 73, 2, 70, "Section",
   CellTags->"GroupElement",
   CellID->257806278],
  Cell[22357, 742, 249, 7, 70, "Text",
   CellTags->"GroupElement",
   CellID->306210113],
  Cell[22609, 751, 350, 12, 70, "Program",
   CellTags->"GroupElement",
   CellID->378647251]},
 "WidgetElement"->{
  Cell[22996, 768, 75, 2, 70, "Section",
   CellTags->"WidgetElement",
   CellID->860127732],
  Cell[23074, 772, 414, 12, 70, "Text",
   CellTags->"WidgetElement",
   CellID->161701940],
  Cell[23491, 786, 120, 2, 70, "Text",
   CellTags->"WidgetElement",
   CellID->669966069],
  Cell[23614, 790, 302, 14, 70, "Program",
   CellTags->"WidgetElement",
   CellID->213899178],
  Cell[23919, 806, 254, 8, 70, "Text",
   CellTags->"WidgetElement",
   CellID->471252451],
  Cell[24176, 816, 151, 5, 70, "Text",
   CellTags->"WidgetElement",
   CellID->1203720],
  Cell[24330, 823, 124, 6, 70, "Program",
   CellTags->"WidgetElement",
   CellID->43432884],
  Cell[24457, 831, 265, 8, 70, "Text",
   CellTags->"WidgetElement",
   CellID->62715263],
  Cell[24725, 841, 233, 8, 70, "Program",
   CellTags->"WidgetElement",
   CellID->226908892],
  Cell[24961, 851, 281, 8, 70, "Text",
   CellTags->"WidgetElement",
   CellID->676268560],
  Cell[25245, 861, 314, 8, 70, "Program",
   CellTags->"WidgetElement",
   CellID->7407267]},
 "PropertyElement"->{
  Cell[25596, 874, 79, 2, 70, "Section",
   CellTags->"PropertyElement",
   CellID->763957438],
  Cell[25678, 878, 380, 11, 70, "Text",
   CellTags->"PropertyElement",
   CellID->229723491],
  Cell[26061, 891, 115, 2, 70, "Text",
   CellTags->"PropertyElement",
   CellID->172984288],
  Cell[26179, 895, 145, 4, 70, "Program",
   CellTags->"PropertyElement",
   CellID->81098920],
  Cell[26327, 901, 139, 4, 70, "Text",
   CellTags->"PropertyElement",
   CellID->236737579],
  Cell[26469, 907, 259, 9, 70, "Program",
   CellTags->"PropertyElement",
   CellID->1455385],
  Cell[26731, 918, 439, 12, 70, "Text",
   CellTags->"PropertyElement",
   CellID->45754750],
  Cell[27173, 932, 145, 4, 70, "Text",
   CellTags->"PropertyElement",
   CellID->59293905],
  Cell[27321, 938, 220, 7, 70, "Program",
   CellTags->"PropertyElement",
   CellID->62182118],
  Cell[27544, 947, 229, 7, 70, "Text",
   CellTags->"PropertyElement",
   CellID->28101274],
  Cell[27776, 956, 228, 8, 70, "Program",
   CellTags->"PropertyElement",
   CellID->19644789]},
 "ScriptElement"->{
  Cell[28041, 969, 75, 2, 70, "Section",
   CellTags->"ScriptElement",
   CellID->246849078],
  Cell[28119, 973, 710, 19, 70, "Text",
   CellTags->"ScriptElement",
   CellID->324482418],
  Cell[28832, 994, 261, 7, 70, "Text",
   CellTags->"ScriptElement",
   CellID->12053372],
  Cell[29096, 1003, 224, 6, 70, "Text",
   CellTags->"ScriptElement",
   CellID->53275793],
  Cell[29323, 1011, 510, 14, 70, "Program",
   CellTags->"ScriptElement",
   CellID->411571613],
  Cell[29836, 1027, 158, 5, 70, "Text",
   CellTags->"ScriptElement",
   CellID->15756351],
  Cell[29997, 1034, 303, 12, 70, "Program",
   CellTags->"ScriptElement",
   CellID->445271649]},
 "StringElement"->{
  Cell[30337, 1051, 74, 2, 70, "Section",
   CellTags->"StringElement",
   CellID->48844498],
  Cell[30414, 1055, 333, 10, 70, "Text",
   CellTags->"StringElement",
   CellID->123029943],
  Cell[30750, 1067, 120, 2, 70, "Text",
   CellTags->"StringElement",
   CellID->53154743],
  Cell[30873, 1071, 127, 5, 70, "Program",
   CellTags->"StringElement",
   CellID->275143550],
  Cell[31003, 1078, 437, 12, 70, "Text",
   CellTags->"StringElement",
   CellID->7351959]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"XMLIntro", 33045, 1132},
 {"DTD:Tag", 33227, 1139},
 {"DTD", 33325, 1143},
 {"ArgsElement", 33513, 1150},
 {"BindEventElement", 34083, 1169},
 {"CallElement", 35067, 1200},
 {"ExposeElement", 35632, 1219},
 {"GroupElement", 36213, 1238},
 {"WidgetElement", 36513, 1248},
 {"PropertyElement", 37558, 1282},
 {"ScriptElement", 38621, 1316},
 {"StringElement", 39298, 1338}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 72, 2, 70, "Title",
 CellTags->"XMLIntro",
 CellID->92849764],
Cell[806, 33, 170, 5, 70, "Text",
 CellTags->"XMLIntro",
 CellID->791206465],
Cell[979, 40, 2166, 68, 70, "DefinitionBox",
 CellID->24460338],
Cell[CellGroupData[{
Cell[3170, 112, 64, 2, 70, "Section",
 CellTags->"DTD:Tag",
 CellID->119915775],
Cell[3237, 116, 174, 7, 70, "Text",
 CellTags->"DTD",
 CellID->524543224],
Cell[3414, 125, 10161, 304, 70, "Program",
 CellTags->"DTD",
 CellID->275003088]
}, Open  ]],
Cell[CellGroupData[{
Cell[13612, 434, 71, 2, 70, "Section",
 CellTags->"ArgsElement",
 CellID->115393119],
Cell[13686, 438, 292, 9, 70, "Text",
 CellTags->"ArgsElement",
 CellID->163316244],
Cell[13981, 449, 231, 7, 70, "Text",
 CellTags->"ArgsElement",
 CellID->198908421],
Cell[14215, 458, 203, 9, 70, "Program",
 CellTags->"ArgsElement",
 CellID->214803806],
Cell[14421, 469, 154, 5, 70, "Text",
 CellTags->"ArgsElement",
 CellID->8412600],
Cell[14578, 476, 270, 12, 70, "Program",
 CellTags->"ArgsElement",
 CellID->31192227]
}, Open  ]],
Cell[CellGroupData[{
Cell[14885, 493, 81, 2, 70, "Section",
 CellTags->"BindEventElement",
 CellID->437984276],
Cell[14969, 497, 317, 8, 70, "Text",
 CellTags->"BindEventElement",
 CellID->216669503],
Cell[15289, 507, 172, 8, 70, "Program",
 CellTags->"BindEventElement",
 CellID->216597859],
Cell[15464, 517, 1056, 25, 70, "Text",
 CellTags->"BindEventElement",
 CellID->8948362],
Cell[16523, 544, 160, 6, 70, "Program",
 CellTags->"BindEventElement",
 CellID->246207025],
Cell[16686, 552, 229, 7, 70, "Text",
 CellTags->"BindEventElement",
 CellID->741108461],
Cell[16918, 561, 409, 11, 70, "Text",
 CellTags->"BindEventElement",
 CellID->33493158],
Cell[17330, 574, 420, 11, 70, "Program",
 CellTags->"BindEventElement",
 CellID->379819604],
Cell[17753, 587, 180, 6, 70, "Text",
 CellTags->"BindEventElement",
 CellID->279216043],
Cell[17936, 595, 304, 12, 70, "Program",
 CellTags->"BindEventElement",
 CellID->41951831]
}, Open  ]],
Cell[CellGroupData[{
Cell[18277, 612, 79, 2, 70, "Section",
 CellTags->"CallElement",
 CellID->458446325],
Cell[18359, 616, 348, 8, 70, "Text",
 CellTags->"CallElement",
 CellID->103296],
Cell[18710, 626, 103, 2, 70, "Text",
 CellTags->"CallElement",
 CellID->692665399],
Cell[18816, 630, 139, 3, 70, "Program",
 CellTags->"CallElement",
 CellID->163235237],
Cell[18958, 635, 327, 8, 70, "Text",
 CellTags->"CallElement",
 CellID->15380220],
Cell[19288, 645, 288, 9, 70, "Program",
 CellTags->"CallElement",
 CellID->114959301]
}, Open  ]],
Cell[CellGroupData[{
Cell[19613, 659, 75, 2, 70, "Section",
 CellTags->"ExposeElement",
 CellID->116596268],
Cell[19691, 663, 724, 14, 70, "Text",
 CellTags->"ExposeElement",
 CellID->708726566],
Cell[20418, 679, 687, 18, 70, "Text",
 CellTags->"ExposeElement",
 CellID->281501268],
Cell[21108, 699, 384, 11, 70, "Program",
 CellTags->"ExposeElement",
 CellID->18570922],
Cell[21495, 712, 352, 10, 70, "Text",
 CellTags->"ExposeElement",
 CellID->4379100],
Cell[21850, 724, 394, 9, 70, "Program",
 CellTags->"ExposeElement",
 CellID->114598805]
}, Open  ]],
Cell[CellGroupData[{
Cell[22281, 738, 73, 2, 70, "Section",
 CellTags->"GroupElement",
 CellID->257806278],
Cell[22357, 742, 249, 7, 70, "Text",
 CellTags->"GroupElement",
 CellID->306210113],
Cell[22609, 751, 350, 12, 70, "Program",
 CellTags->"GroupElement",
 CellID->378647251]
}, Open  ]],
Cell[CellGroupData[{
Cell[22996, 768, 75, 2, 70, "Section",
 CellTags->"WidgetElement",
 CellID->860127732],
Cell[23074, 772, 414, 12, 70, "Text",
 CellTags->"WidgetElement",
 CellID->161701940],
Cell[23491, 786, 120, 2, 70, "Text",
 CellTags->"WidgetElement",
 CellID->669966069],
Cell[23614, 790, 302, 14, 70, "Program",
 CellTags->"WidgetElement",
 CellID->213899178],
Cell[23919, 806, 254, 8, 70, "Text",
 CellTags->"WidgetElement",
 CellID->471252451],
Cell[24176, 816, 151, 5, 70, "Text",
 CellTags->"WidgetElement",
 CellID->1203720],
Cell[24330, 823, 124, 6, 70, "Program",
 CellTags->"WidgetElement",
 CellID->43432884],
Cell[24457, 831, 265, 8, 70, "Text",
 CellTags->"WidgetElement",
 CellID->62715263],
Cell[24725, 841, 233, 8, 70, "Program",
 CellTags->"WidgetElement",
 CellID->226908892],
Cell[24961, 851, 281, 8, 70, "Text",
 CellTags->"WidgetElement",
 CellID->676268560],
Cell[25245, 861, 314, 8, 70, "Program",
 CellTags->"WidgetElement",
 CellID->7407267]
}, Open  ]],
Cell[CellGroupData[{
Cell[25596, 874, 79, 2, 70, "Section",
 CellTags->"PropertyElement",
 CellID->763957438],
Cell[25678, 878, 380, 11, 70, "Text",
 CellTags->"PropertyElement",
 CellID->229723491],
Cell[26061, 891, 115, 2, 70, "Text",
 CellTags->"PropertyElement",
 CellID->172984288],
Cell[26179, 895, 145, 4, 70, "Program",
 CellTags->"PropertyElement",
 CellID->81098920],
Cell[26327, 901, 139, 4, 70, "Text",
 CellTags->"PropertyElement",
 CellID->236737579],
Cell[26469, 907, 259, 9, 70, "Program",
 CellTags->"PropertyElement",
 CellID->1455385],
Cell[26731, 918, 439, 12, 70, "Text",
 CellTags->"PropertyElement",
 CellID->45754750],
Cell[27173, 932, 145, 4, 70, "Text",
 CellTags->"PropertyElement",
 CellID->59293905],
Cell[27321, 938, 220, 7, 70, "Program",
 CellTags->"PropertyElement",
 CellID->62182118],
Cell[27544, 947, 229, 7, 70, "Text",
 CellTags->"PropertyElement",
 CellID->28101274],
Cell[27776, 956, 228, 8, 70, "Program",
 CellTags->"PropertyElement",
 CellID->19644789]
}, Open  ]],
Cell[CellGroupData[{
Cell[28041, 969, 75, 2, 70, "Section",
 CellTags->"ScriptElement",
 CellID->246849078],
Cell[28119, 973, 710, 19, 70, "Text",
 CellTags->"ScriptElement",
 CellID->324482418],
Cell[28832, 994, 261, 7, 70, "Text",
 CellTags->"ScriptElement",
 CellID->12053372],
Cell[29096, 1003, 224, 6, 70, "Text",
 CellTags->"ScriptElement",
 CellID->53275793],
Cell[29323, 1011, 510, 14, 70, "Program",
 CellTags->"ScriptElement",
 CellID->411571613],
Cell[29836, 1027, 158, 5, 70, "Text",
 CellTags->"ScriptElement",
 CellID->15756351],
Cell[29997, 1034, 303, 12, 70, "Program",
 CellTags->"ScriptElement",
 CellID->445271649]
}, Open  ]],
Cell[CellGroupData[{
Cell[30337, 1051, 74, 2, 70, "Section",
 CellTags->"StringElement",
 CellID->48844498],
Cell[30414, 1055, 333, 10, 70, "Text",
 CellTags->"StringElement",
 CellID->123029943],
Cell[30750, 1067, 120, 2, 70, "Text",
 CellTags->"StringElement",
 CellID->53154743],
Cell[30873, 1071, 127, 5, 70, "Program",
 CellTags->"StringElement",
 CellID->275143550],
Cell[31003, 1078, 437, 12, 70, "Text",
 CellTags->"StringElement",
 CellID->7351959]
}, Open  ]]
}, Open  ]],
Cell[31467, 1094, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

