
Begin[ "System`"]		(* Everything in System context *)
   
General::writewarn = "Defining rule for `1`."

(*
General::spell1 = 
	"Possible spelling error: new symbol name \"`1`\" is similar to existing symbol \"`2`\"."

General::spell = 
	"Possible spelling error: new symbol name \"`1`\" is similar to existing symbols `2`."
*)

Off[General::newsym]

Off[DumpGet::valwarn]

General::sysmain = 
	"Error loading the main binary file `1`.
	 Get[\"sysmake.m\"] must be run before continuing."

Begin[ "System`Private`"]

If[  Hold[ $InstallationDirectory] === Hold @@ { $InstallationDirectory},
	$InstallationDirectory = DirectoryName[ $Input, 5]]


If[ Hold[ $SystemFileDir] === Hold @@ { $SystemFileDir},
	$SystemFileDir = 
   	 	ToFileName[ {$InstallationDirectory, "SystemFiles", "Kernel", 
				"SystemResources", $SystemID}]]

$MessagesDir = 
    ToFileName[ {$InstallationDirectory, "SystemFiles", "Kernel", "TextResources"}]

(*
When the mainload.mx system can save a symbol with
a value these should be moved into mainload.mx.
*)

System`FileInformation = Developer`FileInformation

System`NotebookInformation = Developer`NotebookInformation

If[ $OperatingSystem === "MacOS" , SetDirectory[ $InstallationDirectory]]

If [ $OperatingSystem === "MacOSX" && Environment["LANG"] === "ja_JP",
	$SystemCharacterEncoding = "ShiftJIS" ]


(*
 Utility function for building MX files for an Application
*)

System`Private`BuildApplicationMXFunction[ {appName_, context_, outputMX_, path_}] :=
	Module[{outFile, app},
		Print[ "FF " , path, " ", context];
		app = appName <> "`";
		Get[app];
		CreateDirectory[ ToFileName[{path, appName, "Kernel","SystemResources"}, $SystemID],
				CreateIntermediateDirectories -> True];
		outFile = ToFileName[{path, appName, "Kernel","SystemResources", $SystemID}, outputMX];
		Print[ "Out file is ", outFile];
		Share[];
		DumpSave[outFile, context]
	]



Which[ 
    Names[ "System`$SystemInstall"] =!= {},
    	System`Private`$SysmakeError = 0;
    	AppendTo[ $Path, 
    	    ToFileName[ 
    	    	{$InstallationDirectory, "AddOns", "StandardPackages"},"StartUp"]];
    	Get[ "sysmake.m"];
    	Exit[System`Private`$SysmakeError],
    
    ListQ[ System`Private`BuildApplicationMX],
	   	System`Private`BuildApplicationMXFunction[System`Private`BuildApplicationMX];
    	Exit[],

    True,
    	If[ DumpGet[ 
    	    	StringJoin[ $SystemFileDir, ContextToFileName[ "mainload`"], "x"]] 
			=!= Null,
    	    Message[ General::sysmain, "mainload`"]];
	]



Off[ Get::noopen]
Off[ General::initg]
Off[ General::initc]
Off[ General::spell]
Off[ General::spell1]
Off[ General::obspkgfn]


$CharacterEncoding = $SystemCharacterEncoding;



SetDirectory[ ToFileName[{$InstallationDirectory, "SystemFiles", "CharacterEncodings"}]];

System`$CharacterEncodings = DeleteCases[ StringTake[#, {1, -3}] & /@ FileNames[ "*.m"], "UTF-8" ];

Protect[ System`$CharacterEncodings];

ResetDirectory[];


Internal`AddHandler["MessageTextFilter", Internal`MessageButtonHandler]

(*
 Set $Path
*)

$Path =
	Which[
 		$LicenseType === "Trial" || $LicenseType === "Player",
 		{
		ToFileName[ {$InstallationDirectory, "SystemFiles"}, "Links"],
        ToFileName[ {$InstallationDirectory, "AddOns"}, "Packages"],
        ToFileName[ {$InstallationDirectory, "AddOns"}, "LegacyPackages"],
        ToFileName[ {$InstallationDirectory, "SystemFiles"}, "Autoload"],
        ToFileName[ {$InstallationDirectory, "AddOns"}, "Applications"],
        ToFileName[ {$InstallationDirectory, "AddOns"}, "ExtraPackages"],
        ToFileName[ {$InstallationDirectory, "SystemFiles","Kernel"}, "Packages"],
        ToFileName[ {$InstallationDirectory, "Documentation",$Language}, "System"]
 		},
 		True,
		{
      	ToFileName[ {$InstallationDirectory, "SystemFiles"}, "Links"],
        ToFileName[ $UserBaseDirectory, "Kernel"],
    	ToFileName[ $UserBaseDirectory, "Autoload"],
    	ToFileName[ $UserBaseDirectory, "Applications"],
    	ToFileName[ $BaseDirectory, "Kernel"],
    	ToFileName[ $BaseDirectory, "Autoload"],
    	ToFileName[ $BaseDirectory, "Applications"],
    	".", 
    	HomeDirectory[],
		ToFileName[ {$InstallationDirectory, "AddOns"}, "Packages"],
    	ToFileName[ {$InstallationDirectory, "AddOns"}, "LegacyPackages"],
    	ToFileName[ {$InstallationDirectory, "SystemFiles"}, "Autoload"],
    	ToFileName[ {$InstallationDirectory, "AddOns"}, "Autoload"],
    	ToFileName[ {$InstallationDirectory, "AddOns"}, "Applications"],
    	ToFileName[ {$InstallationDirectory, "AddOns"}, "ExtraPackages"],
    	ToFileName[ {$InstallationDirectory, "SystemFiles","Kernel"}, "Packages"],
    	ToFileName[ {$InstallationDirectory, "Documentation",$Language}, "System"]
    	}];

$Epilog := Get[ "end`"] ;
 

Begin[ "Global`"];


If[MathLink`NotebookFrontEndLinkQ[$ParentLink],
    System`Private`origFrontEnd = MathLink`SetFrontEnd[$ParentLink],
(* else *)
    System`Private`origFrontEnd = Null
]


(*
 Set up autoloading, using the new Package`DeclareLoad functionality.
*)

Package`DeclareLoad[
	{System`InstallService, WebServices`$InstalledServices,
	 WebServices`$PrintServiceRequest, WebServices`$PrintServiceResponse,
	 WebServices`$PrintShortErrorMessages, WebServices`$PrintWSDLDebug,
	 WebServices`FromServiceResponse, WebServices`InstallServiceOperation,
	 WebServices`InvokeServiceOperation, WebServices`ToServiceRequest
	}, 
	"WebServices`", {"WebServices`"}]
  
  
(*
 Utility function for loading init.m files.
*)

System`Private`loadInitFile[ System`Private`dir_] :=
	Module[ {System`Private`tmp},
		If[ (System`Private`tmp = FileNames[ "init.m", System`Private`dir]) =!= {},
			System`Private`tmp = First[ System`Private`tmp];
			Get[ System`Private`tmp];
			True,
			False]
	]

(*
 Load init.m from $InstallationDirectory/Configuration/Kernel.
*)

System`Private`loadInitFile[ ToFileName[{$InstallationDirectory, "Configuration"}, "Kernel"]];
	
(*
 If -noinit is not set then load
 
  Load init.m from $BaseDirectory/Kernel.
  Load init.m from $UserBaseDirectory/Kernel.
  Load any -initfile files
*)

If[ !MemberQ[ $CommandLine, "-noinit"],

	If[ !($LicenseType === "Trial" || $LicenseType === "Player"),
		System`Private`loadInitFile[ ToFileName[{$BaseDirectory}, "Kernel"]];
		System`Private`loadInitFile[ ToFileName[{$UserBaseDirectory}, "Kernel"]]];
		
		If[ MemberQ[ $CommandLine, "-initfile"],
			Do[ If[Part[$CommandLine,System`Private`tmp] === "-initfile" && 
				StringQ[ Part[ $CommandLine,System`Private`tmp+1]] , 
				Get[ Part[ $CommandLine, System`Private`tmp+1]]],
				{System`Private`tmp, Length[ $CommandLine]-1}]];
		If[ StringQ[ System`Private`tmp], Get[ System`Private`tmp]];
		]

(*
 Load init.m files from Autoload directories.
*)

Map[ If[ (System`Private`tmp = FileNames[ "init.m", ToFileName[ {#}, "Kernel"]]) =!= {}, 
	Get[ First[ System`Private`tmp]],
	If[ (System`Private`tmp = FileNames[ "init.m", #]) =!= {}, 
				Get[ First[ System`Private`tmp]]]]&,
		Select[
			Which[
				$LicenseType === "Trial" || $LicenseType === "Player",
				FileNames[ "*", 
					ToFileName[ {$InstallationDirectory, "AddOns", "Autoload"}]] 
				,
				True,
				Join[
 	 		    	FileNames[ "*", 
						ToFileName[ {$InstallationDirectory, "AddOns", "Autoload"}]], 
 	 		    	FileNames[ "*", 
				 		ToFileName[ {$BaseDirectory, "Autoload"}]],
 	 		    	FileNames[ "*", 
						ToFileName[ {$UserBaseDirectory,"Autoload"}]]
						]],
			(FileType[#] === Directory)&]]
			
System`Private`$InitsLoaded = True;

If[System`Private`origFrontEnd =!= Null,
    MathLink`RestoreFrontEnd[System`Private`origFrontEnd]
]



End[]

On[ Get::noopen]
On[ General::initg]
On[ General::initc]
Off[ Series::esss]
Off[Integrate::gener]

End[]

End[]


Null


