(* ::Package:: *)

(* :Title: Master Declarations File for Algebra *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 11 December 2004 at 21:08 *)

Message[General::obspkg,"Algebra`"];

If[! MemberQ[$Packages, "Algebra`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "Algebra`"];
     Protect @@ System`Private`p
];


(* Declarations for package Algebra`FiniteFields` *)

DeclarePackage["Algebra`FiniteFields`",
     {"Characteristic", "ElementToPolynomial", "ExtensionDegree", "FieldExp", 
      "FieldInd", "FieldIrreducible", "FromElementCode", "FunctionOfCode", 
      "FunctionOfCoefficients", "GF", "IrreduciblePolynomial", "PerfectPowerQ", 
      "PolynomialToElement", "PowerList", "PowerListQ", "PowerListToField", 
      "ReduceElement", "SetFieldFormat", "Successor", "ToElementCode"}]


(* Declarations for package Algebra`InequalitySolve` *)

DeclarePackage["Algebra`InequalitySolve`",{"InequalitySolve"}]


(* Declarations for package Algebra`PolynomialContinuedFractions` *)

DeclarePackage["Algebra`PolynomialContinuedFractions`",
     {"FromPolynomialContinuedFraction", "PolynomialContinuedFraction"}]


(* Declarations for package Algebra`Quaternions` *)

DeclarePackage["Algebra`Quaternions`",
     {"AbsIJK", "AdjustedSignIJK", "FromQuaternion", "IntegerQuaternionQ", "J", 
      "LeftAssociates", "LeftGCD", "PrimaryLeftAssociate", 
      "PrimaryRightAssociate", "Quaternion", "QuaternionQ", "Quaternions", 
      "RightAssociates", "RightGCD", "ScalarQ", "ToQuaternion", 
      "UnitQuaternionQ", "UnitQuaternions"}]


(* Declarations for package Algebra`ReIm` *)

DeclarePackage["Algebra`ReIm`",{"RealValued"}]


(* Declarations for package Algebra`RootIsolation` *)

DeclarePackage["Algebra`RootIsolation`",
     {"ComplexRootIntervals", "ContractInterval",
      "RealRootIntervals"}]

(* End of Master package *)

Null

