(* ::Package:: *)

(* :Title: Master Declarations File for DiscreteMath *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 11 December 2004 at 21:09 *)

Message[General::obspkg,"DiscreteMath`"];

If[! MemberQ[$Packages, "DiscreteMath`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "DiscreteMath`"];
     Protect @@ System`Private`p
];

(* Declarations for package DiscreteMath`CombinatorialFunctions` *)

DeclarePackage["DiscreteMath`CombinatorialFunctions`",
     {"CatalanNumber", "Hofstadter", "Subfactorial"}]


(* Declarations for package DiscreteMath`Combinatorica` *)

DeclarePackage["DiscreteMath`Combinatorica`",
     {"AcyclicQ", "AddEdge", "AddEdges", "AddVertex", "AddVertices", 
      "Algorithm", "AllPairsShortestPath", "AlternatingGroup", 
      "AlternatingGroupIndex", "AlternatingPaths", "AnimateGraph", 
      "AntiSymmetricQ", "Approximate", "ApproximateVertexCover", 
      "ArticulationVertices", "Automorphisms", "Backtrack", 
      "BellmanFord", "BiconnectedComponents", "BiconnectedQ", "BinarySearch", 
      "BinarySubsets", "BipartiteMatching", "BipartiteMatchingAndCover", 
      "BipartiteQ", "BooleanAlgebra", "BreadthFirstTraversal", "Brelaz", 
      "BrelazColoring", "Bridges", "ButterflyGraph", "CageGraph", 
      "CartesianProduct", "ChangeEdges", "ChangeVertices", "ChromaticNumber", 
      "ChromaticPolynomial", "ChvatalGraph", "CirculantGraph", 
      "CircularEmbedding", "CircularVertices", "CliqueQ", 
      "CoarserSetPartitionQ", "CodeToLabeledTree", "Cofactor", 
      "CompleteBinaryTree", "CompleteGraph", "CompleteKaryTree", 
      "CompleteKPartiteGraph", "CompleteQ", "Compositions", 
      "ConnectedComponents", "ConnectedQ", "ConstructTableau", "Contract", 
      "CostOfPath", "CoxeterGraph", "CubeConnectedCycle", "CubicalGraph", 
      "Cut", "Cycle", "CycleIndex", "Cycles", "CycleStructure", "Cyclic", 
      "CyclicGroup", "CyclicGroupIndex", "DeBruijnGraph", "DeBruijnSequence", 
      "Degrees", "DegreeSequence", "DegreesOf2Neighborhood", "DeleteCycle", 
      "DeleteEdge", "DeleteEdges", "DeleteFromTableau", "DeleteVertex", 
      "DeleteVertices", "DepthFirstTraversal", "DerangementQ", "Derangements", 
      "Diameter", "Dihedral", "DihedralGroup", "DihedralGroupIndex", 
      "Dijkstra", "DilateVertices", "Directed", "Distances", 
      "DistinctPermutations", "Distribution", "DodecahedralGraph", 
      "DominatingIntegerPartitionQ", "DominationLattice", "DurfeeSquare", 
      "Eccentricity", "Edge", "EdgeChromaticNumber", "EdgeColor", 
      "EdgeColoring", "EdgeConnectivity", "EdgeDirection", "EdgeLabel", 
      "EdgeLabelColor", "EdgeLabelPosition", "Edges", "EdgeStyle", 
      "EdgeWeight", "EmptyGraph", "EmptyQ", "EncroachingListSet", 
      "EquivalenceClasses", "EquivalenceRelationQ", "Equivalences", 
      "Euclidean", "Eulerian", "EulerianCycle", "EulerianQ", 
      "ExactRandomGraph", "ExpandGraph", "ExtractCycles", "FerrersDiagram", 
      "FindCycle", "FindSet", "FiniteGraphs", "FirstLexicographicTableau", 
      "FolkmanGraph", "FranklinGraph", "FromAdjacencyLists", 
      "FromAdjacencyMatrix", "FromCycles", "FromInversionVector", 
      "FromOrderedPairs", "FromUnorderedPairs", "FruchtGraph", 
      "FunctionalGraph", "GeneralizedPetersenGraph", "GetEdgeLabels", 
      "GetEdgeWeights", "GetVertexLabels", "GetVertexWeights", "Girth", 
      "Graph", "GraphCenter", "GraphComplement", "GraphDifference", "GraphicQ", 
      "GraphIntersection", "GraphJoin", "GraphOptions", "GraphPolynomial", 
      "GraphPower", "GraphProduct", "GraphSum", "GraphUnion", "GrayCode", 
      "GrayCodeKSubsets", "GrayCodeSubsets", "GrayGraph", "Greedy", 
      "GreedyVertexCover", "GridGraph", "GrotztschGraph", "HamiltonianCycle", 
      "HamiltonianPath", "HamiltonianQ", "Harary", "HasseDiagram", "Heapify", 
      "HeapSort", "HeawoodGraph", "HerschelGraph", "HideCycles", "Highlight", 
      "HighlightedEdgeColors", "HighlightedEdgeStyle", 
      "HighlightedVertexColors", "HighlightedVertexStyle", "Hypercube", 
      "IcosahedralGraph", "IdenticalQ", "IdentityPermutation", 
      "IncidenceMatrix", "InDegree", "IndependentSetQ", "Index", 
      "InduceSubgraph", "InitializeUnionFind", "InsertIntoTableau", 
      "IntervalGraph", "Invariants", "InversePermutation", "InversionPoset", 
      "Inversions", "InvolutionQ", "Involutions", "IsomorphicQ", "Isomorphism", 
      "IsomorphismQ", "Josephus", "KnightsTourGraph", "KSetPartitions", 
      "KSubsetGroup", "KSubsetGroupIndex", "KSubsets", "LabeledTreeToCode", 
      "LastLexicographicTableau", "LeviGraph", "LexicographicPermutations", 
      "LexicographicSubsets", "LineGraph", "ListGraphs", "ListNecklaces", 
      "LNorm", "LongestIncreasingSubsequence", "LoopPosition", "LowerLeft", 
      "LowerRight", "M", "MakeDirected", "MakeGraph", "MakeSimple", 
      "MakeUndirected", "MaximalMatching", "MaximumAntichain", "MaximumClique", 
      "MaximumIndependentSet", "MaximumSpanningTree", "McGeeGraph", 
      "MeredithGraph", "MinimumChainPartition", "MinimumChangePermutations", 
      "MinimumSpanningTree", "MinimumVertexColoring", "MinimumVertexCover", 
      "MultipleEdgesQ", "MultiplicationTable", "MycielskiGraph", 
      "NecklacePolynomial", "Neighborhood", "NetworkFlow", "NetworkFlowEdges", 
      "NextBinarySubset", "NextComposition", "NextGrayCodeSubset", 
      "NextKSubset", "NextLexicographicSubset", "NextPartition", 
      "NextPermutation", "NextSubset", "NextTableau", "NoMultipleEdges", 
      "NonLineGraphs", "NoPerfectMatchingGraph", "NormalDashed", 
      "NormalizeVertices", "NoSelfLoops", "NthPair", "NthPermutation", 
      "NthSubset", "NumberOf2Paths", "NumberOfCompositions", 
      "NumberOfDerangements", "NumberOfDirectedGraphs", "NumberOfGraphs", 
      "NumberOfInvolutions", "NumberOfKPaths", "NumberOfNecklaces", 
      "NumberOfPartitions", "NumberOfPermutationsByCycles", 
      "NumberOfPermutationsByInversions", "NumberOfPermutationsByType", 
      "NumberOfSpanningTrees", "NumberOfTableaux", "OctahedralGraph", 
      "OddGraph", "One", "Optimum", "OrbitInventory", "OrbitRepresentatives", 
      "Orbits", "Ordered", "OrientGraph", "OutDegree", "PairGroup", 
      "PairGroupIndex", "Parent", "ParentsToPaths", "PartialOrderQ", 
      "PartitionLattice", "PartitionQ", "Partitions", "PathConditionGraph", 
      "PerfectQ", "PermutationGraph", "PermutationGroupQ", "PermutationQ", 
      "PermutationToTableaux", "PermutationType", "PermutationWithCycle", 
      "Permute", "PermuteSubgraph", "PetersenGraph", "PlanarQ", 
      "PointsAndLines", "Polya", "PseudographQ", "RadialEmbedding", "Radius", 
      "RandomComposition", "RandomGraph", "RandomHeap",  
      "RandomKSetPartition", "RandomKSubset", "RandomPartition", 
      "RandomPermutation", "RandomPermutation1", "RandomPermutation2", 
      "RandomRGF", "RandomSetPartition", "RandomSubset", "RandomTableau", 
      "RandomTree", "RandomVertices", "RankBinarySubset", "RankedEmbedding", 
      "RankGraph", "RankGrayCodeSubset", "RankKSetPartition", "RankKSubset", 
      "RankPermutation", "RankRGF", "RankSetPartition", "RankSubset", 
      "ReadGraph", "RealizeDegreeSequence", "ReflexiveQ", "RegularGraph", 
      "RegularQ", "RemoveMultipleEdges", "RemoveSelfLoops", 
      "ResidualFlowGraph", "RevealCycles", "ReverseEdges", "RGFQ", "RGFs", 
      "RGFToSetPartition", "RobertsonGraph", "RootedEmbedding", 
      "RotateVertices", "Runs", "SamenessRelation", "SelectionSort", 
      "SelfComplementaryQ", "SelfLoopsQ", "SetEdgeLabels", "SetEdgeWeights", 
      "SetGraphOptions", "SetPartitionListViaRGF", "SetPartitionQ", 
      "SetPartitions", "SetPartitionToRGF", "SetVertexLabels", 
      "SetVertexWeights", "ShakeGraph", "ShortestPath", 
      "ShortestPathSpanningTree", "ShowGraph", "ShowGraphArray", 
      "ShowLabeledGraph", "ShuffleExchangeGraph", "SignaturePermutation", 
      "Simple", "SimpleQ", "SmallestCyclicGroupGraph", "Spectrum", 
      "SpringEmbedding", "StableMarriage", "Star", "StirlingFirst", 
      "StirlingSecond", "Strings", "Strong", "StronglyConnectedComponents", 
      "SymmetricGroup", "SymmetricGroupIndex", "SymmetricQ", "TableauClasses", 
      "TableauQ", "Tableaux", "TableauxToPermutation", "TetrahedralGraph", 
      "Thick", "ThickDashed", "Thin", "ThinDashed", "ThomassenGraph", 
      "ToAdjacencyLists", "ToAdjacencyMatrix", "ToCanonicalSetPartition", 
      "ToCycles", "ToInversionVector", "ToOrderedPairs", "TopologicalSort", 
      "ToUnorderedPairs", "TransitiveClosure", "TransitiveQ", 
      "TransitiveReduction", "TranslateVertices", "TransposePartition", 
      "TransposeTableau", "TravelingSalesman", "TravelingSalesmanBounds", 
      "Tree", "TreeIsomorphismQ", "TreeQ", "TreeToCertificate", 
      "TriangleInequalityQ", "Turan", "TutteGraph", "TwoColoring", "Type", 
      "Undirected", "UndirectedQ", "UnionSet", "Uniquely3ColorableGraph", 
      "UnitransitiveGraph", "UnrankBinarySubset", "UnrankGrayCodeSubset", 
      "UnrankKSetPartition", "UnrankKSubset", "UnrankPermutation", "UnrankRGF", 
      "UnrankSetPartition", "UnrankSubset", "UnweightedQ", "UpperLeft", 
      "UpperRight", "V", "VertexColor", "VertexColoring", "VertexConnectivity", 
      "VertexConnectivityGraph", "VertexCover", "VertexCoverQ", "VertexLabel", 
      "VertexLabelColor", "VertexLabelPosition", "VertexNumber", 
      "VertexNumberColor", "VertexNumberPosition", "VertexStyle", 
      "VertexWeight", "Vertices", "WaltherGraph", "Weak", 
      "WeaklyConnectedComponents", "WeightingFunction", "WeightRange", "Wheel", 
      "WriteGraph", "Zoom"}]


(* Declarations for package DiscreteMath`ComputationalGeometry` *)

DeclarePackage["DiscreteMath`ComputationalGeometry`",
     {"AllPoints", "BoundedDiagram", "ConvexHull", "DelaunayTriangulation", 
      "DelaunayTriangulationQ", "DiagramPlot", "Hull", "LabelPoints", 
      "NearestNeighbor", "PlanarGraphPlot", "Ray", "TileAreas", 
      "TriangularSurfacePlot", "TrimPoints", "VoronoiDiagram"}]


(* Declarations for package DiscreteMath`GraphPlot` *)

DeclarePackage["DiscreteMath`GraphPlot`",
     {"Aggressive", "EdgeStyleFunction", "GraphCoordinates", 
      "GraphCoordinates3D", "GraphDistance", "GraphPlot", "GraphPlot3D", 
      "GraphToSparseArray", "Loops", "MaximalBipartiteMatching", 
      "MaximalIndependentEdgeSet", "MaximalIndependentVertexSet", "MinCut", 
      "Multiedges", "PseudoDiameter", "RootPosition", "StrongComponents", 
      "TreePlot", "TreeSizeFunction", "VertexCoordinates", "VertexList", 
      "VertexStyleFunction", "Weighted"}]


(* Declarations for package DiscreteMath`IntegerPartitions` *)

DeclarePackage["DiscreteMath`IntegerPartitions`",
     {"ConstrainedIntegerPartitionsP", "FerrersPlot", "FerrersPlotColumns", 
      "FerrersPlotLabel", "FerrersPlotPointSize", "IntegerPartitionQ", 
      "IntegerPartitions", "MultiplicityFromRepetition", 
      "NextIntegerPartition", "PreviousIntegerPartition", 
      "RandomIntegerPartition", "RepetitionFromMultiplicity", 
      "RestrictedIntegerPartitionsP", "TransposeIntegerPartition"}]


(* Declarations for package DiscreteMath`Tree` *)

DeclarePackage["DiscreteMath`Tree`",
     {"ExprPlot", "MakeTree", "TreeFind", "TreePlot"}]


(* End of Master package *)

Null

