(* ::Package:: *)

(* :Title: Orthogonalization *)

(* :Author: John M. Novak *)

(* :Summary:
This is a stub compatability layer for the old Orthogonalization.m functionality.
*)

(* :Context: LinearAlgebra`Orthogonalization` *)

(* :Package Version: 2.0 *)

(* :Copyright: Copyright 1991-2007, Wolfram Research, Inc. *)

(* :History: 
    Version 1.0 by John M. Novak (Wolfram Research), January 1991.
    Version 1.1 by John M. Novak, February 1991. Adds ability to handle
        function spaces and ability to generate normalized basis.
    Version 1.2 by John M. Novak, February 1999. In a small cleanup for
        handling linearly dependent case, uses a Developer` context function
    Version 1.2.1 by John M. Novak, May 1999. Modify previous version
        by emitting a message when linearly dependent case found,
        or zero-magnitude vector found under Projection or Normalize.
    Version 1.3 by John M. Novak, September 2000. Add Householder
        orthogonalization.
    Version 2.0 by John M. Novak, June 2006. Convert to compatability
        stub, since all functionality is now in the kernel.
*)

(* :Mathematica Version: 6.0 *)

Message[General::obspkg, "LinearAlgebra`Orthogonalization`"]
BeginPackage["LinearAlgebra`Orthogonalization`"]


(* Usage messages *)

GramSchmidt::usage =
"GramSchmidt[vectors] is an obsolete function. Use Orthogonalize[vectors] instead."

Householder::usage =
"Householder[vecs] is an obsolete function. Use Orthogonalize[vecs, \
Method -> \"Householder\"] instead."

InnerProduct::usage =
"InnerProduct is an obsolete option. Use the final argument to \
Orthogonalize and related functions instead."

Normalized::usage =
"Normalized is an obsolete option."

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] :=
        (Message[fun::obspkgfn, fun, context];
         )

(* handle InnerProduct option for these funcs. *)

prot = Unprotect[Normalize, Projection];

Options[Normalize] = {InnerProduct -> Automatic};

Options[Projection] = {InnerProduct -> Automatic};

Normalize[vec_]/;((InnerProduct/.Options[Normalize]) =!= Automatic) :=
    Normalize[vec, FilterRules[InnerProduct, Options[Normalize]]]

Normalize[vec_, opts__?OptionQ] :=
    (issueObsoleteFunMessage[Normalize,"LinearAlgebra`Orthogonalization`"];
	Module[{ip, ipvec},
        {ip} = {InnerProduct}/.Flatten[{opts, Options[Normalize]}];
        If[ip === Automatic,
            Normalize[vec],
            With[{newp = ip},
                Normalize[vec, Sqrt[newp[#1, #1]]&]
            ]
        ]
    ])

Projection[v1_, v2_]/;((InnerProduct/.Options[Projection]) =!= Automatic) :=
    Projection[v1, v2, FilterRules[InnerProduct, Options[Projection]]]

Projection[v1_, v2_, opts__?OptionQ] :=
    (issueObsoleteFunMessage[Projection,"LinearAlgebra`Orthogonalization`"];
	Module[{ip, ipvec},
        {ip} = {InnerProduct}/.Flatten[{opts, Options[Projection]}];
        If[ip === Automatic,
            Projection[v1, v2],
            Projection[v1, v2, ip]
        ]
    ])

Protect @@ prot;

(* handle GramSchmidt & Householder *)
Options[GramSchmidt] = {InnerProduct -> Automatic, Normalized -> True};

GramSchmidt[vecs_List, opts___?OptionQ] :=
    (issueObsoleteFunMessage[GramSchmidt,"LinearAlgebra`Orthogonalization`"];
	Module[{normalized, ip, gs},
        {normalized, ip} = {Normalized, InnerProduct}/.
            Flatten[{opts, Options[GramSchmidt]}];
        If[!TrueQ[normalized],
            gs = LinearAlgebra`Internal`Orthogonalize[vecs, ip, 
                 "Normalized"->False, "Reduced"->True]
            , (* else *)
            gs = LinearAlgebra`Internal`Orthogonalize[vecs, ip, 
                 "Reduced"->True]
        ];
        If [Length[gs] === Length[vecs],
           gs
           , (* else *)
           Join[gs, 
                If [Developer`PackedArrayQ[gs], 
                    Developer`ToPackedArray[#], #]&[
                    Table[N[0, Precision[gs]], {Length[vecs] - Length[gs]},
                          {Length[First[vecs]]}
                    ]
                ]
           ]
        ]
    ])

Householder[vecs_?(MatrixQ[#, NumericQ]&)] :=
    (issueObsoleteFunMessage[Householder,"LinearAlgebra`Orthogonalization`"];
	Orthogonalize[vecs, Method -> "Householder"])

End[]

EndPackage[]
