(* ::Package:: *)

(* :Title: Master Declarations File for NumberTheory *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 11 December 2004 at 21:09 *)

Message[General::obspkg,"NumberTheory`"];

If[! MemberQ[$Packages, "NumberTheory`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "NumberTheory`"];
     Protect @@ System`Private`p
];

(* Declarations for package NumberTheory`FactorIntegerECM` *)

DeclarePackage["NumberTheory`FactorIntegerECM`",
     {"CurveCountLimit", "CurveNumber", "FactorIntegerECM", "FactorSize"}]


(* Declarations for package NumberTheory`Frobenius` *)

DeclarePackage["NumberTheory`Frobenius`",
     {"FrobeniusInstance", "FrobeniusF"}]


(* Declarations for package NumberTheory`NumberTheoryFunctions` *)

DeclarePackage["NumberTheory`NumberTheoryFunctions`",
     {"AliquotCycle", "AliquotSequence", "Biunitary", 
      "ClassList", "ClassNumber", "Exponential", 
      "FundamentalDiscriminantQ", "Infinitary", 
      "LeastPrimeFactor", "MaxTerms", "ModifiedExponential",  
      "OrderedSumOfSquaresRepresentations", "PreviousPrime", "PrimeFactorList", 
      "QuadraticRepresentation", 
      "ShowProgress", "SqrtMod", "SqrtModList", "SumOfFactors", 
      "SumOfFactorsType", "SumOfSquaresR", "SumOfSquaresRepresentations", 
      "TermIncrement", "Unitary", "WhichRootOfUnity"}]


(* Declarations for package NumberTheory`PrimeQ` *)

DeclarePackage["NumberTheory`PrimeQ`",
     {"Certificate", "CertificateDiscriminant", "CertificateK", "CertificateM", 
      "CertificateNextPrime", "CertificatePoint", "CertificatePrime", 
      "HilbertPolynomial", "ModularInvariantj", "PointEC", "PointECQ", 
      "PollardPTest", "PollardRhoTest", "PrimeQCertificate", 
      "PrimeQCertificateCheck", "PrimeQMessages", "ProvablePrimeQ", 
      "SmallPrime", "TrialDivisionLimit"}]


(* Declarations for package NumberTheory`PrimitiveElement` *)

DeclarePackage["NumberTheory`PrimitiveElement`",{"PrimitiveElement"}]


(* Declarations for package NumberTheory`Recognize` *)

DeclarePackage["NumberTheory`Recognize`",{"Recognize"}]


(* End of Master package *)

Null

