(* :Title: Ramanujan.m *)

(* :Summary:
    The Ramanujan package is obsolete. The functionality is provided
    in the kernel.
*)

(* :Copyright: Copyright 1991-2007,  Wolfram Research Inc. *)

Message[General::obspkg, "NumberTheory`Ramanujan`"];

BeginPackage["NumberTheory`Ramanujan`"]

RamanujanTauDirichletSeries::usage =
"RamanujanTauDirichletSeries[s] gives the Ramanujan Dirichlet L-function L(s)."

RamanujanTauGeneratingFunction::usage =
"RamanujanTauGeneratingFunction[x] gives the generating function of the \
Ramanujan tau function."

Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] :=
        (Message[fun::obspkgfn, fun, context];
         )

RamanujanTauDirichletSeries[e___] := 
	(issueObsoleteFunMessage[RamanujanTauDirichletSeries, "NumberTheory`Ramanujan`"];
	With[{res = RamanujanTauL[e]},
		res /; FreeQ[res, $Failed | RamanujanTauL]
	])

RamanujanTauGeneratingFunction[x_ /; PossibleZeroQ[x]] :=
    (issueObsoleteFunMessage[RamanujanTauGeneratingFunction, "NumberTheory`Ramanujan`"];
    N[0, Precision[x]])

RamanujanTauGeneratingFunction[x_ /; (1/2 < Abs[x] < 1)] :=
    (issueObsoleteFunMessage[RamanujanTauGeneratingFunction, "NumberTheory`Ramanujan`"];
    (2*Pi/#)^12*(EllipticThetaPrime[1, 0, Sqrt[Exp[4*Pi^2/#]]]^8)/256 & [Log[x]])

RamanujanTauGeneratingFunction[x_ /; (0 < Abs[x] <= 1/2)] :=
    (issueObsoleteFunMessage[RamanujanTauGeneratingFunction, "NumberTheory`Ramanujan`"];
    (EllipticThetaPrime[1, 0, Sqrt[x]]^8)/256)

End[]

EndPackage[]
