(* :Title: DataSmoothing.m *)

(* :Summary:
    The DataSmoothing package is obsolete. The functionality is provided
    in the kernel.
*)

(* :Copyright: Copyright 1991-2007,  Wolfram Research Inc. *)

Message[General::obspkg,"Statistics`DataSmoothing`"]

BeginPackage["Statistics`DataSmoothing`"]


ExponentialSmoothing::usage = 
"ExponentialSmoothing[datalist, a] smooths datalist using an exponentially \
weighted average with smoothing constant a, taking the first entry of datalist \
as the starting value.  ExponentialSmoothing[datalist, a, y0] smooths datalist \
taking the starting value to be y0.  If yt is the smoothed result at time t, \
then the result at time t+1 is given by yt + a*(datalist[[t+1]] - yt), \
where a is the smoothing constant (0 < a < 1)."


Begin["`Private`"]

issueObsoleteFunMessage[fun_, context_] :=Message[General::obspkgfn, fun, context]


ExponentialSmoothing[data_,alpha_]:=(
	issueObsoleteFunMessage[ExponentialSmoothing, "Statistics`DataSmoothing`"];
	ExponentialMovingAverage[data,alpha])

(*
ExponentialSmoothing::arg3="ExponentialSmoothing with three arguments is obsolete. \
Use ExponentialMovingAverage and prepend y to data instead."
*)

ExponentialSmoothing[data_,alpha_,y_]:=(
	issueObsoleteFunMessage[ExponentialSmoothing, "Statistics`DataSmoothing`"];
	Drop[ExponentialMovingAverage[Prepend[data,y],alpha],1])

End[]

EndPackage[]
