(* :Title: Master Declarations File for Statistics *)

(* :Summary:
This file contains declarations of all the major symbols
contained in files in this directory.  When loaded, it sets
up the symbols with attribute Stub, so the correct package
will be loaded when the symbol is called.
*)

(* :Author: This file was created by an automated system written in
	Mathematica by John M. Novak *)

(* :History: File created on 11 December 2004 at 21:09 *)

If[! MemberQ[$Packages, "Statistics`"],
     System`Private`p = Unprotect[$Packages];
     PrependTo[$Packages, "Statistics`"];
     Protect @@ System`Private`p
];

Message[General::obspkg,"Statistics`"]

(* Declarations for package Statistics`ANOVA` *)

DeclarePackage["Statistics`ANOVA`",
     {"ANOVA", "Bonferroni", "CellMeans", "Duncan", "Dunnett", "PostTests", 
      "StudentNewmanKeuls", "Tukey"}]


(* Load package Statistics`ClusterAnalysis` *)

Needs["Statistics`ClusterAnalysis`"]

(* Declarations for package Statistics`Common`DistributionsCommon` *)

DeclarePackage["Statistics`Common`DistributionsCommon`",
     {"Domain", "DomainQ", "ParameterQ", 
      "RandomArray", "RegionProbability"}]


(* Declarations for package Statistics`Common`MultivariateCommon` *)

DeclarePackage["Statistics`Common`MultivariateCommon`",
     {"CorrelationMatrix", "CovarianceMatrix", "Ellipsoid", "Polytope"}]


(* Declarations for package Statistics`Common`PopulationsCommon` *)

DeclarePackage["Statistics`Common`PopulationsCommon`",
     {"EqualVariances", "KnownStandardDeviation", "KnownVariance"}]


(* Declarations for package Statistics`Common`RegressionCommon` *)

DeclarePackage["Statistics`Common`RegressionCommon`",
     {"AdjustedRSquared", "ANOVATable", "BasisNames", "BestFit", 
      "BestFitParameters", "BestFitParametersDelta", "CatcherMatrix", "CookD", 
      "CovarianceMatrixDetRatio", "DurbinWatsonD", "EigenstructureTable", 
      "EstimatedVariance", "FitResiduals", "HatDiagonal", "JackknifedVariance", 
      "MeanPredictionCITable", "ParameterCITable", "ParameterConfidenceRegion", 
      "ParameterTable", "PartialSumOfSquares", "PredictedResponse", 
      "PredictedResponseDelta", "RegressionReport", "RegressionReportValues", 
      "RSquared", "SequentialSumOfSquares", "SinglePredictionCITable", 
      "StandardizedResiduals", "StudentizedResiduals", "SummaryReport", 
      "VarianceInflation", "Weights"}]


(* Declarations for package Statistics`ConfidenceIntervals` *)

DeclarePackage["Statistics`ConfidenceIntervals`",
     {"ChiSquareCI", "ConfidenceLevel", "FRatioCI", "MeanCI", 
      "MeanDifferenceCI", "NormalCI", "StudentTCI", "VarianceCI", 
      "VarianceRatioCI"}]


(* Load package Statistics`ContinuousDistributions` *)

Needs["Statistics`ContinuousDistributions`"]


(* Declarations for package Statistics`DataManipulation` *)

DeclarePackage["Statistics`DataManipulation`",
     {"BooleanSelect", "CategoryCounts", 
      "CategoryLists", "ColumnDrop", "ColumnJoin", "ColumnTake", 
      "CumulativeSums", "DropNonNumeric", "DropNonNumericColumn", 
      "Frequencies", "QuantileForm", "RangeCounts", 
      "RangeLists", "RowJoin"}]


(* Declarations for package Statistics`DataSmoothing` *)

DeclarePackage["Statistics`DataSmoothing`",
     {"ExponentialSmoothing"}]


(* Declarations for package Statistics`DescriptiveStatistics` *)

DeclarePackage["Statistics`DescriptiveStatistics`",
     {"CoefficientOfVariation", "DispersionReport", 
      "InterpolatedQuantile", 
      "KurtosisExcess", "LocationReport", "MLE",
      "PearsonSkewness1", 
      "PearsonSkewness2", "QuantileQ",  
      "SampleRange", "ShapeReport", 
      "StandardDeviationMLE", "StandardErrorOfSampleMean", 
      "VarianceMLE", "VarianceOfSampleMean", 
      "ZeroMean"}]


(* Load Statistics`DiscreteDistributions` *)

Needs["Statistics`DiscreteDistributions`"]


(* Declarations for package Statistics`HypothesisTests` *)

DeclarePackage["Statistics`HypothesisTests`",
     {"ChiSquarePValue", "FRatioPValue", "FullReport", "LargeSampleSize", 
      "MeanDifferenceTest", "MeanTest", "NormalPValue", "OneSidedPValue", 
      "PValueTable", "ResultOfTest", "SignificanceLevel", "StudentTPValue", 
      "TwoSided", "TwoSidedPValue", "VarianceRatioTest", "VarianceTest"}]


(* Declarations for package Statistics`LinearRegression` *)

DeclarePackage["Statistics`LinearRegression`",
     {"DesignedRegress", "Regress"}]


(* Declarations for package Statistics`MultiDescriptiveStatistics` *)

DeclarePackage["Statistics`MultiDescriptiveStatistics`",
     {"AssociationMatrix", "ConvexHullArea", "ConvexHullMedian",  
      "CovarianceMatrixMLE", "CovarianceMatrixOfSampleMean", 
      "CovarianceMLE", "DispersionMatrix", "EllipsoidQuantile", 
      "EllipsoidQuartiles", "EstimateDOF", "GeneralizedVariance", 
      "KendallRankCorrelation", "MedianMethod", "MultivariateKurtosis", 
      "MultivariateKurtosisExcess", "MultivariateMeanDeviation", 
      "MultivariateMedianDeviation", "MultivariateMode", 
      "MultivariatePearsonSkewness1", "MultivariatePearsonSkewness2", 
      "MultivariateSkewness", "MultivariateTrimmedMean", "PolytopeQuantile", 
      "PolytopeQuartiles", "PrincipalComponents", "ScaleMethod", 
      "SimplexMedian", "SpatialMedian", "SpearmanRankCorrelation", 
      "TotalVariation"}]


(* Declarations for package Statistics`MultiDiscreteDistributions` *)

DeclarePackage["Statistics`MultiDiscreteDistributions`",
     {"MultinomialDistribution", "MultiPoissonDistribution", 
      "NegativeMultinomialDistribution"}]


(* Declarations for package Statistics`MultinormalDistribution` *)

DeclarePackage["Statistics`MultinormalDistribution`",
     {"HotellingTSquareDistribution", "MultinormalDistribution", 
      "MultivariateTDistribution", "QuadraticFormDistribution", 
      "WishartDistribution"}]


(* Declarations for package Statistics`NonlinearFit` *)

DeclarePackage["Statistics`NonlinearFit`",
     {"AsymptoticCorrelationMatrix", "AsymptoticCovarianceMatrix", 
      "FitCurvatureTable", "LevenbergMarquardt", "NonlinearFit", 
      "NonlinearRegress", "ParameterBias", "ShowProgress", "StartingParameters"}
      ]


(* Load package Statistics`NormalDistribution` *)

Needs["Statistics`NormalDistribution`"]


(* Declarations for package Statistics`StatisticsPlots` *)

DeclarePackage["Statistics`StatisticsPlots`",
     {"BoxExtraSpacing", "BoxLabels", "BoxLineStyle", "BoxMedianStyle", 
      "BoxOrientation", "BoxOutliers", "BoxOutlierShapes", "BoxQuantile", 
      "BoxWhiskerPlot", "DataLabels", "DataRanges", "DataSpacing", "DataTicks", 
      "PairwiseScatterPlot", "PlotDirection", "ParetoPlot", 
      "QuantilePlot", "ReferenceLineStyle",
      "ColumnLabels", "IncludeEmptyStems", "IncludeStemCounts", "IncludeStemUnits", 
      "Leaves", "StemExponent", "StemLeafPlot"}
      ]


(* End of Master package *)

Null

