(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6405,        224]
NotebookOptionsPosition[      3982,        151]
NotebookOutlinePosition[      5204,        183]
CellTagsIndexPosition[      5161,        180]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Analysis of Variance Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["ANOVA",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " perform an analysis of variance"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1410407681],

Cell[CellGroupData[{

Cell["Diagnostic Options", "GuideFunctionsSubsection",
 CellID->557424193],

Cell[TextData[{
 Cell[TextData[ButtonBox["PostTests",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/PostTests"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " which significance tests to perform"
}], "GuideText",
 CellID->1304743537],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellMeans",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/CellMeans"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to return cell means"
}], "GuideText",
 CellID->869106842]
}, Open  ]],

Cell[CellGroupData[{

Cell["Significance Tests", "GuideFunctionsSubsection",
 CellID->1422481421],

Cell[TextData[{
 Cell[TextData[ButtonBox["Bonferroni",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/Bonferroni"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Duncan",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/Duncan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dunnett",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/Dunnett"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StudentNewmanKeuls",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/StudentNewmanKeuls"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tukey",
  BaseStyle->"Link",
  ButtonData->"paclet:ANOVA/ref/Tukey"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58503702]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->"paclet:ANOVA/tutorial/ANOVA"]], "GuideTutorial",
 CellID->421954457]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], "GuideMoreAbout",\

 CellID->98196295],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/guide/HypothesisTestingPackage"]], \
"GuideMoreAbout",
 CellID->86224133],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "GuideMoreAbout",
 CellID->774336447],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "GuideMoreAbout",
 CellID->15039546]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Analysis of Variance Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 41.5506474}", "context" -> "ANOVA`", 
    "keywords" -> {
     "analysis of variance", "ANOVA", "linear models", 
      "categorical linear regression"}, "index" -> True, "label" -> 
    "ANOVA Package Guide", "language" -> "en", "paclet" -> "ANOVA Package", 
    "status" -> "None", "summary" -> 
    "ANOVA -- perform an analysis of variance, PostTests -- which \
significance tests to perform, CellMeans -- whether to return cell means", 
    "synonyms" -> {}, "title" -> "Analysis of Variance Package", "type" -> 
    "Guide", "uri" -> "ANOVA/guide/AnalysisOfVariancePackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[692, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[751, 31, 255, 8, 70, "GuideText",
 CellID->203374175],
Cell[1009, 41, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1410407681],
Cell[CellGroupData[{
Cell[1093, 46, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->557424193],
Cell[1170, 49, 268, 8, 70, "GuideText",
 CellID->1304743537],
Cell[1441, 59, 260, 8, 70, "GuideText",
 CellID->869106842]
}, Open  ]],
Cell[CellGroupData[{
Cell[1738, 72, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->1422481421],
Cell[1816, 75, 1061, 29, 70, "InlineGuideFunctionListing",
 CellID->58503702]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2926, 110, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[2991, 113, 158, 3, 70, "GuideTutorial",
 CellID->421954457]
}, Open  ]],
Cell[CellGroupData[{
Cell[3186, 121, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3251, 124, 186, 5, 70, "GuideMoreAbout",
 CellID->98196295],
Cell[3440, 131, 189, 5, 70, "GuideMoreAbout",
 CellID->86224133],
Cell[3632, 138, 165, 3, 70, "GuideMoreAbout",
 CellID->774336447],
Cell[3800, 143, 140, 3, 70, "GuideMoreAbout",
 CellID->15039546]
}, Open  ]],
Cell[3955, 149, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

