(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11597,        392]
NotebookOptionsPosition[      9201,        312]
NotebookOutlinePosition[     10400,        348]
CellTagsIndexPosition[     10315,        343]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ANOVA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Analysis of Variance Package" :> 
          Documentation`HelpLookup["paclet:ANOVA/tutorial/ANOVA"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Analysis of Variance Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Duncan" :> Documentation`HelpLookup["paclet:ANOVA/ref/Duncan"],
           "Dunnett" :> Documentation`HelpLookup["paclet:ANOVA/ref/Dunnett"], 
          "StudentNewmanKeuls" :> 
          Documentation`HelpLookup["paclet:ANOVA/ref/StudentNewmanKeuls"], 
          "Tukey" :> Documentation`HelpLookup["paclet:ANOVA/ref/Tukey"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Duncan\"\>", 
       2->"\<\"Dunnett\"\>", 3->"\<\"StudentNewmanKeuls\"\>", 
       4->"\<\"Tukey\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bonferroni", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bonferroni"], "InlineFormula"],
     " \[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["PostTests",
       BaseStyle->"Link",
       ButtonData->"paclet:ANOVA/ref/PostTests"]], "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["ANOVA",
       BaseStyle->"Link",
       ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData["Bonferroni"], "InlineFormula"],
 " test scales the significance level ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " by the number of hypotheses tested to obtain an overall error rate of at \
most ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->107327516]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15782017],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->189295576],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->297600826],

Cell[TextData[{
 "Analysis of variance with ",
 Cell[BoxData["Bonferroni"], "InlineFormula"],
 " test:"
}], "ExampleText",
 CellID->392528177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"PostTests", "\[Rule]", "Bonferroni"}], ",", 
   RowBox[{"CellMeans", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258866397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "2", "10.333333333333334`", "5.166666666666667`", 
        "15.5`", "0.026209787902323756`"},
       {"\<\"Error\"\>", "3", "1.`", 
        "0.3333333333333333`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "5", 
        "11.333333333333334`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       2, 10.3333333333333, 5.16666666666667, 15.5, 0.0262097879023238}, {
       3, 1., 0.333333333333333}, {5, 11.3333333333333}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Bonferroni", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.28], {
             Offset[0.7]}, 
            Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[1.2]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{456, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175526787]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Duncan",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/Duncan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dunnett",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/Dunnett"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentNewmanKeuls",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/StudentNewmanKeuls"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tukey",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/Tukey"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->"paclet:ANOVA/tutorial/ANOVA"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bonferroni - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 42.8006794}", "context" -> "ANOVA`", 
    "keywords" -> {}, "index" -> True, "label" -> "ANOVA Package Symbol", 
    "language" -> "en", "paclet" -> "ANOVA Package", "status" -> "None", 
    "summary" -> 
    "Bonferroni is a possible value for the PostTests option for ANOVA.", 
    "synonyms" -> {}, "title" -> "Bonferroni", "type" -> "Symbol", "uri" -> 
    "ANOVA/ref/Bonferroni"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3733, 124, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15782017]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10173, 336}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1497, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2120, 62, 53, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2176, 65, 641, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2854, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3332, 107, 364, 12, 70, "Notes",
 CellID->107327516]
}, Closed]],
Cell[CellGroupData[{
Cell[3733, 124, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15782017],
Cell[CellGroupData[{
Cell[4117, 138, 148, 5, 70, "ExampleSection",
 CellID->189295576],
Cell[4268, 145, 128, 3, 70, "Input",
 CellID->297600826],
Cell[4399, 150, 142, 5, 70, "ExampleText",
 CellID->392528177],
Cell[CellGroupData[{
Cell[4566, 159, 630, 20, 47, "Input",
 CellID->258866397],
Cell[5199, 181, 2091, 54, 101, "Output",
 CellID->175526787]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7351, 242, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7670, 253, 977, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8684, 293, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9005, 304, 154, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9174, 310, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

