(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9371,        321]
NotebookOptionsPosition[      6949,        241]
NotebookOutlinePosition[      8177,        277]
CellTagsIndexPosition[      8093,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ANOVA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Analysis of Variance Package" :> 
          Documentation`HelpLookup["paclet:ANOVA/tutorial/ANOVA"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Analysis of Variance Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PostTests" :> 
          Documentation`HelpLookup["paclet:ANOVA/ref/PostTests"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PostTests\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellMeans", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["CellMeans"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ANOVA",
       BaseStyle->"Link",
       ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
     " which specifies whether cell means should be included in the output."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CellMeans", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that a table containing means for the various levels of main \
effects and interactions should be included in the output."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->290583843],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->540405882],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->280241309],

Cell["Analysis of variance without cell means:", "ExampleText",
 CellID->392528177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"CellMeans", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258866397],

Cell[BoxData[
 RowBox[{"ANOVA", "\[Rule]", 
  InterpretationBox[GridBox[{
     {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
     {"\<\"Model\"\>", "2", "331.`", "165.5`", "38.19230769230769`", 
      "0.007346447250706656`"},
     {"\<\"Error\"\>", "3", "13.`", 
      "4.333333333333333`", "\<\"\"\>", "\<\"\"\>"},
     {"\<\"Total\"\>", "5", "344.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[2.1]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   TableForm[{{2, 331., 165.5, 38.1923076923077, 0.00734644725070666}, {
     3, 13., 4.33333333333333}, {5, 344.}}, 
    TableHeadings -> {{"Model", "Error", "Total"}, {
      "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]], "Output",
 ImageSize->{449, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144369692]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PostTests",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/PostTests"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->"paclet:ANOVA/tutorial/ANOVA"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellMeans - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 43.1288128}", "context" -> "ANOVA`", 
    "keywords" -> {}, "index" -> True, "label" -> "ANOVA Package Symbol", 
    "language" -> "en", "paclet" -> "ANOVA Package", "status" -> "None", 
    "summary" -> 
    "CellMeans is an option for ANOVA which specifies whether cell means \
should be included in the output.", "synonyms" -> {}, "title" -> "CellMeans", 
    "type" -> "Symbol", "uri" -> "ANOVA/ref/CellMeans"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3264, 112, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->290583843]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7950, 265}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1170, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1793, 58, 52, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1848, 61, 533, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2418, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2896, 98, 331, 9, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[3264, 112, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->290583843],
Cell[CellGroupData[{
Cell[3649, 126, 148, 5, 70, "ExampleSection",
 CellID->540405882],
Cell[3800, 133, 128, 3, 70, "Input",
 CellID->280241309],
Cell[3931, 138, 83, 1, 70, "ExampleText",
 CellID->392528177],
Cell[CellGroupData[{
Cell[4039, 143, 575, 19, 28, "Input",
 CellID->258866397],
Cell[4617, 164, 1190, 29, 78, "Output",
 CellID->144369692]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5868, 200, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6187, 211, 208, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[6432, 222, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6753, 233, 154, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[6922, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

