(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12986,        441]
NotebookOptionsPosition[     10584,        367]
NotebookOutlinePosition[     11894,        400]
CellTagsIndexPosition[     11851,        397]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sound" :> Documentation`HelpLookup["paclet:ref/Sound"], 
          "FrequencyModulation" :> 
          Documentation`HelpLookup[
           "paclet:Audio/ref/FrequencyModulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Sound\"\>", 
       2->"\<\"FrequencyModulation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AmplitudeModulation", "ObjectName",
 CellID->30134],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AmplitudeModulation", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["c", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["m", "TI"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["i", "TI"]], ",", 
        StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " object that is an amplitude modulated sinusoid, having carrier and \
modulating frequencies ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["c", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["m", "TI"]]], "InlineFormula"],
     ", measured in hertz, a modulation index of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", and a duration of ",
     Cell[BoxData[
      StyleBox["dur", "TI"]], "InlineFormula"],
     " seconds."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AmplitudeModulation", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["c", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["m", "TI"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["i", "TI"]], ",", 
        StyleBox["dur", "TI"], ",", 
        RowBox[{
         ButtonBox["RingModulation",
          BaseStyle->"Link",
          ButtonData->"paclet:Audio/ref/RingModulation"], "->", 
         ButtonBox["True",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a ring modulated sinusoid"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24585]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Sounds created using amplitude modulation contain three frequencies: the \
carrier frequency, and the sum and difference of the carrier and modulating \
frequencies. \
\>", "Notes",
 CellID->5992],

Cell["The following options can be given:", "Notes",
 CellID->2161],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayFunction"], 
    ButtonBox["Identity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Identity"], Cell[
    "function to apply to sound before returning it", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlayRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlayRange"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], Cell[
    "range of sound amplitude levels to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RingModulation",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/RingModulation"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to use ring modulation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleDepth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleDepth"], "8", Cell[
    "number of bits used to encode sound amplitude", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleRate"], "8192", Cell[
    "sampling rate per second", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->16726],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RingModulation",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/RingModulation"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that the ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object created by ",
 Cell[BoxData["AmplitudeModulation"], "InlineFormula"],
 " will contain only two frequencies: the sum and the difference of the \
carrier and modulating frequencies."
}], "Notes",
 CellID->15962],

Cell[TextData[{
 "The expression used by ",
 Cell[BoxData["AmplitudeModulation"], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["m", "i"], "cos", " ", 
       RowBox[{"(", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         SubscriptBox["f", "m"], " ", "t"}], ")"}]}], " ", "+", "1"}], ")"}], 
    " ", "cos", " ", 
    RowBox[{"(", 
     RowBox[{"2", " ", "\[Pi]", " ", 
      SubscriptBox["f", "c"], " ", "t"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->11559],

Cell[TextData[{
 "The expression used by ",
 Cell[BoxData["AmplitudeModulation"], "InlineFormula"],
 " with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RingModulation",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/RingModulation"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "i"], " ", "cos", " ", 
    RowBox[{"(", 
     RowBox[{"2", " ", "\[Pi]", " ", 
      SubscriptBox["f", "m"], " ", "t"}], ")"}], " ", "cos", " ", 
    RowBox[{"(", 
     RowBox[{"2", " ", "\[Pi]", " ", 
      SubscriptBox["f", "c"], " ", "t"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->22629],

Cell[TextData[{
 "The depth or intensity of the modulation is controlled by the modulation \
index ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13353],

Cell[TextData[{
 "The carrier is said to be overmodulated when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "i"], " ", ">", "1"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->31509],

Cell[TextData[{
 "The best way to understand the effect of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is to try it out with different values, usually between 0.1 and 2.0. "
}], "Notes",
 CellID->32661]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1402],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrequencyModulation",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/FrequencyModulation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5761]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28280],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->21527]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AmplitudeModulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 50.5040016}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "AmplitudeModulation[f_c, f_m, m_i, dur] creates a Sound object that is \
an amplitude modulated sinusoid, having carrier and modulating frequencies \
f_c and f_m, measured in hertz, a modulation index of m_i, and a duration of \
dur seconds. AmplitudeModulation[f_c, f_m, m_i, dur, RingModulation -> True] \
creates a ring modulated sinusoid", "synonyms" -> {}, "title" -> 
    "AmplitudeModulation", "type" -> "Symbol", "uri" -> 
    "Audio/ref/AmplitudeModulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1270, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1893, 60, 57, 1, 70, "ObjectName",
 CellID->30134],
Cell[1953, 63, 2184, 69, 70, "Usage",
 CellID->24585]
}, Open  ]],
Cell[CellGroupData[{
Cell[4174, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4652, 154, 206, 5, 70, "Notes",
 CellID->5992],
Cell[4861, 161, 67, 1, 70, "Notes",
 CellID->2161],
Cell[4931, 164, 1584, 41, 70, "3ColumnTableMod",
 CellID->16726],
Cell[6518, 207, 629, 20, 70, "Notes",
 CellID->15962],
Cell[7150, 229, 587, 21, 70, "Notes",
 CellID->11559],
Cell[7740, 252, 764, 26, 70, "Notes",
 CellID->22629],
Cell[8507, 280, 235, 9, 70, "Notes",
 CellID->13353],
Cell[8745, 291, 219, 9, 70, "Notes",
 CellID->31509],
Cell[8967, 302, 264, 8, 70, "Notes",
 CellID->32661]
}, Closed]],
Cell[CellGroupData[{
Cell[9268, 315, 310, 9, 70, "SeeAlsoSection",
 CellID->1402],
Cell[9581, 326, 472, 17, 70, "SeeAlso",
 CellID->5761]
}, Open  ]],
Cell[CellGroupData[{
Cell[10090, 348, 314, 9, 70, "TutorialsSection",
 CellID->28280],
Cell[10407, 359, 135, 3, 70, "Tutorials",
 CellID->21527]
}, Open  ]],
Cell[10557, 365, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

