(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13714,        438]
NotebookOptionsPosition[     11191,        368]
NotebookOutlinePosition[     12837,        405]
CellTagsIndexPosition[     12794,        402]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sound" :> Documentation`HelpLookup["paclet:ref/Sound"], 
          "AmplitudeModulation" :> 
          Documentation`HelpLookup[
           "paclet:Audio/ref/AmplitudeModulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Sound\"\>", 
       2->"\<\"AmplitudeModulation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FrequencyModulation", "ObjectName",
 CellID->28470],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FrequencyModulation", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["c", "TI"]], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["m", "TI"]], ",", 
          StyleBox["pd", "TI"]}], "}"}], ",", 
        StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " object that is a frequency-modulated sinusoid, having carrier and \
modulating frequencies ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["c", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["m", "TI"]]], "InlineFormula"],
     ", measured in hertz, peak deviation ",
     Cell[BoxData[
      StyleBox["pd", "TI"]], "InlineFormula"],
     " hertz, and a duration of ",
     Cell[BoxData[
      StyleBox["dur", "TI"]], "InlineFormula"],
     " seconds."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FrequencyModulation", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["c", "TI"]], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["pd", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["pd", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dur", "TI"], ",", 
        RowBox[{
         ButtonBox["ModulationType",
          BaseStyle->"Link",
          ButtonData->"paclet:Audio/ref/ModulationType"], "->", 
         ButtonBox["Cascade",
          BaseStyle->"Link",
          ButtonData->"paclet:Audio/ref/Cascade"]}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]creates a cascade frequency-modulated sinusoid, where \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pd", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the peak deviation associated with modulating frequency ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FrequencyModulation", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["c", "TI"]], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["pd", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["pd", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dur", "TI"], ",", 
        RowBox[{
         ButtonBox["ModulationType",
          BaseStyle->"Link",
          ButtonData->"paclet:Audio/ref/ModulationType"], "->", 
         ButtonBox["Parallel",
          BaseStyle->"Link",
          ButtonData->"paclet:Audio/ref/Parallel"]}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]creates a parallel frequency-modulated sinusoid, where \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pd", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the peak deviation associated with modulating frequency ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16109]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->1669],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayFunction"], 
    ButtonBox["Identity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Identity"], Cell[
    "function to apply to sound before returning it", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ModulationType",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/ModulationType"], 
    ButtonBox["Standard",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/Standard"], Cell[
    "the type of modulation to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlayRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlayRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "range of sound amplitude levels to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleDepth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleDepth"], "8", Cell[
    "number of bits used to encode sound amplitude", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleRate"], "8192", Cell[
    "sampling rate per second", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->3573],

Cell[TextData[{
 "The expression used by ",
 Cell[BoxData["FrequencyModulation"], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{
     RowBox[{"2", " ", "\[Pi]", " ", 
      SubscriptBox["f", "c"], "  ", "t"}], "+", 
     FractionBox[
      RowBox[{"pd", " ", 
       RowBox[{"sin", "(", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         SubscriptBox["f", "m"], " ", "t"}], ")"}]}], 
      SubscriptBox["f", "m"]]}], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->5553],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cascade",
   BaseStyle->"Link",
   ButtonData->"paclet:Audio/ref/Cascade"]], "InlineFormula"],
 " frequency modulation is a type of frequency modulation where the \
modulating frequency is itself modulated, thus cascading the modulation."
}], "Notes",
 CellID->14919],

Cell[TextData[{
 "In contrast to cascade frequency modulation, ",
 Cell[BoxData[
  ButtonBox["Parallel",
   BaseStyle->"Link",
   ButtonData->"paclet:Audio/ref/Parallel"]], "InlineFormula"],
 " frequency modulation is a technique where the carrier frequency is \
modulated by two or more modulating frequencies that do not modulate each \
other."
}], "Notes",
 CellID->5975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26542],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AmplitudeModulation",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/AmplitudeModulation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29442]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25886],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->15507]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrequencyModulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 50.8790112}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "FrequencyModulation[f_c, {f_m, pd}, dur] creates a Sound object that is \
a frequency-modulated sinusoid, having carrier and modulating frequencies f_c \
and f_m, measured in hertz, peak deviation pd hertz, and a duration of dur \
seconds. FrequencyModulation[f_c, {{f_1, pd_1}, {f_2, pd_2}, ...}, dur, \
ModulationType -> Cascade] creates a cascade frequency-modulated sinusoid, \
where pd_i is the peak deviation associated with modulating frequency f_i. \
FrequencyModulation[f_c, {{f_1, pd_1}, {f_2, pd_2}, ...}, dur, ModulationType \
-> Parallel] creates a parallel frequency-modulated sinusoid, where pd_i is \
the peak deviation associated with modulating frequency f_i.", 
    "synonyms" -> {}, "title" -> "FrequencyModulation", "type" -> "Symbol", 
    "uri" -> "Audio/ref/FrequencyModulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1270, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1893, 60, 57, 1, 70, "ObjectName",
 CellID->28470],
Cell[1953, 63, 4469, 140, 70, "Usage",
 CellID->16109]
}, Open  ]],
Cell[CellGroupData[{
Cell[6459, 208, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6937, 225, 67, 1, 70, "Notes",
 CellID->1669],
Cell[7007, 228, 1593, 41, 70, "3ColumnTableMod",
 CellID->3573],
Cell[8603, 271, 542, 18, 70, "Notes",
 CellID->5553],
Cell[9148, 291, 311, 8, 70, "Notes",
 CellID->14919],
Cell[9462, 301, 374, 10, 70, "Notes",
 CellID->5975]
}, Closed]],
Cell[CellGroupData[{
Cell[9873, 316, 311, 9, 70, "SeeAlsoSection",
 CellID->26542],
Cell[10187, 327, 473, 17, 70, "SeeAlso",
 CellID->29442]
}, Open  ]],
Cell[CellGroupData[{
Cell[10697, 349, 314, 9, 70, "TutorialsSection",
 CellID->25886],
Cell[11014, 360, 135, 3, 70, "Tutorials",
 CellID->15507]
}, Open  ]],
Cell[11164, 366, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

