(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9255,        312]
NotebookOptionsPosition[      7265,        250]
NotebookOutlinePosition[      8437,        281]
CellTagsIndexPosition[      8394,        278]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sound" :> Documentation`HelpLookup["paclet:ref/Sound"], 
          "Waveform" :> 
          Documentation`HelpLookup["paclet:Audio/ref/Waveform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sound\"\>", 
       2->"\<\"Waveform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ListWaveform", "ObjectName",
 CellID->23677],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListWaveform", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["freq", "TI"], ",", 
        StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " object with fundamental frequency of ",
     Cell[BoxData[
      StyleBox["freq", "TI"]], "InlineFormula"],
     " hertz, lasting for ",
     Cell[BoxData[
      StyleBox["dur", "TI"]], "InlineFormula"],
     " seconds, with a spectrum in which relative frequency ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " has relative amplitude ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18074]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Relative frequencies ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are measured relative to the fundamental frequency ",
 Cell[BoxData[
  StyleBox["freq", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27733],

Cell[TextData[{
 Cell[BoxData["ListWaveform"], "InlineFormula"],
 " allows you to create a waveform with a specific spectrum."
}], "Notes",
 CellID->9186],

Cell["The following options can be given:", "Notes",
 CellID->17455],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayFunction"], 
    ButtonBox["Identity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Identity"], Cell[
    "function to apply to sound before returning it", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlayRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlayRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "range of sound amplitude levels to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleDepth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleDepth"], "8", Cell[
    "number of bits used to encode sound amplitude", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleRate"], "8192", Cell[
    "sampling rate per second", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->2779]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29995],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Waveform",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/Waveform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2767],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->28413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListWaveform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 51.0665160}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "ListWaveform[{{f_1, a_1}, {f_2, a_2}, ...}, freq, dur] creates a Sound \
object with fundamental frequency of freq hertz, lasting for dur seconds, \
with a spectrum in which relative frequency f_i has relative amplitude a_i.", 
    "synonyms" -> {}, "title" -> "ListWaveform", "type" -> "Symbol", "uri" -> 
    "Audio/ref/ListWaveform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1225, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1848, 59, 50, 1, 70, "ObjectName",
 CellID->23677],
Cell[1901, 62, 1715, 54, 70, "Usage",
 CellID->18074]
}, Open  ]],
Cell[CellGroupData[{
Cell[3653, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4131, 138, 292, 11, 70, "Notes",
 CellID->27733],
Cell[4426, 151, 154, 4, 70, "Notes",
 CellID->9186],
Cell[4583, 157, 68, 1, 70, "Notes",
 CellID->17455],
Cell[4654, 160, 1279, 33, 70, "3ColumnTableMod",
 CellID->2779]
}, Closed]],
Cell[CellGroupData[{
Cell[5970, 198, 311, 9, 70, "SeeAlsoSection",
 CellID->29995],
Cell[6284, 209, 451, 17, 70, "SeeAlso",
 CellID->21043]
}, Open  ]],
Cell[CellGroupData[{
Cell[6772, 231, 313, 9, 70, "TutorialsSection",
 CellID->2767],
Cell[7088, 242, 135, 3, 70, "Tutorials",
 CellID->28413]
}, Open  ]],
Cell[7238, 248, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

