(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7081,        248]
NotebookOptionsPosition[      5316,        190]
NotebookOutlinePosition[      6331,        219]
CellTagsIndexPosition[      6288,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrequencyModulation" :> 
          Documentation`HelpLookup["paclet:Audio/ref/FrequencyModulation"], 
          "ModulationType" :> 
          Documentation`HelpLookup["paclet:Audio/ref/ModulationType"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FrequencyModulation\"\>", 
       2->"\<\"ModulationType\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Standard", "ObjectName",
 CellID->1859],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Standard"], "InlineFormula"],
     " \[LineSeparator]is a setting of ",
     Cell[BoxData[
      ButtonBox["ModulationType",
       BaseStyle->"Link",
       ButtonData->"paclet:Audio/ref/ModulationType"]], "InlineFormula"],
     ", an option of function ",
     Cell[BoxData[
      ButtonBox["FrequencyModulation",
       BaseStyle->"Link",
       ButtonData->"paclet:Audio/ref/FrequencyModulation"]], "InlineFormula"],
     
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ModulationType",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/ModulationType"], "->", "Standard"}]], 
  "InlineFormula"],
 " specifies to use standard frequency modulation."
}], "Notes",
 CellID->4726],

Cell[TextData[{
 Cell[BoxData["Standard"], "InlineFormula"],
 " is the default setting of option ",
 Cell[BoxData[
  ButtonBox["ModulationType",
   BaseStyle->"Link",
   ButtonData->"paclet:Audio/ref/ModulationType"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17468],

Cell[TextData[{
 Cell[BoxData["Standard"], "InlineFormula"],
 " frequency modulation is described by two parameters: the modulating \
frequency and the peak deviation. Both are measured in hertz."
}], "Notes",
 CellID->5590]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22567],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrequencyModulation",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/FrequencyModulation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ModulationType",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/ModulationType"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24388]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31987],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->16846]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Standard - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 0.2542512}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "Standard is a setting of ModulationType, an option of function \
FrequencyModulation.", "synonyms" -> {}, "title" -> "Standard", "type" -> 
    "Symbol", "uri" -> "Audio/ref/Standard"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1303, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1926, 60, 45, 1, 70, "ObjectName",
 CellID->1859],
Cell[1974, 63, 679, 21, 70, "Usage",
 CellID->10239]
}, Open  ]],
Cell[CellGroupData[{
Cell[2690, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3168, 106, 269, 9, 70, "Notes",
 CellID->4726],
Cell[3440, 117, 270, 9, 70, "Notes",
 CellID->17468],
Cell[3713, 128, 224, 5, 70, "Notes",
 CellID->5590]
}, Closed]],
Cell[CellGroupData[{
Cell[3974, 138, 311, 9, 70, "SeeAlsoSection",
 CellID->22567],
Cell[4288, 149, 497, 17, 70, "SeeAlso",
 CellID->24388]
}, Open  ]],
Cell[CellGroupData[{
Cell[4822, 171, 314, 9, 70, "TutorialsSection",
 CellID->31987],
Cell[5139, 182, 135, 3, 70, "Tutorials",
 CellID->16846]
}, Open  ]],
Cell[5289, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

