(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17380,        545]
NotebookOptionsPosition[     14388,        445]
NotebookOutlinePosition[     15687,        482]
CellTagsIndexPosition[     15602,        477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart3D" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart3D"], 
         "PercentileBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/PercentileBarChart"], 
         "StackedBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/StackedBarChart"], 
         "Rectangle" :> Documentation`HelpLookup["paclet:ref/Rectangle"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"BarChart3D\"\>", 
      2->"\<\"PercentileBarChart\"\>", 3->"\<\"StackedBarChart\"\>", 
      4->"\<\"Rectangle\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarChart", "ObjectName",
 CellID->16234],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BarChart", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a bar chart of the values ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BarChart", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a bar chart of the data in the lists."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BarChart"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " with the following additions:"
}], "Notes",
 CellID->20425],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style for the bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "fraction of bar width to space bars in a group", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarGroupSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarGroupSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "spacing between groups of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarLabels"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "labels at tick marks for each bar (or group) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarValues",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarValues"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to show the length of each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edges are drawn around each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", "0.5", "]"}], Cell[
    "style for the bar edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarOrientation"], "Vertical", Cell[
    "determines horizontal or vertical orientation", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1300],

Cell[TextData[{
 "Each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is a list of numbers, or numeric values. For example: ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "7", ",", 
    RowBox[{"-", "4"}], ",", "2", ",", "3"}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11121],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " need not have the same length."
}], "Notes",
 CellID->1599734575]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363908284],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->35450747],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->205407995],

Cell["Chart a list of values:", "ExampleText",
 CellID->925491420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", 
    RowBox[{"-", "1.3"}], ",", "2.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1366135831],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktv4jAQNgGWdlVtj9t9VO2dFrrnShzbw/KQtse+xKJKcKi6ov0B/Jqe
Vvtn9u9UTT0BgzNxGifExIZB4Dyc+b7JeDweG3f6T8O7+/7TaNA/PB/3/wxH
g8fDs4cxv1UuMVYaMsb+7zF+7vOz4AefEf8x9hnKsrjnB4eeoRqo+Bc8MZlM
mo0L/mWnUMD1TOJWiTOXur585l92CoWjUiErWKUZWaE208xD0h4//ZAJcQtJ
laGoLK4Zq2bCnQJNP564NMCjp3+VH/8Wag9TuOARovWze8G69ROKFmQFt6RM
207ECTkOi9icLWYEUqEIVkM4OOZnGzmmgVGiyYlHT3/9kSOKV/WXiclqPBln
uRFDHLOh2OvpbkitsxXqs/dr8yM48AlC+cILqD9AaMcIpxmy1hGqbUvXTMHy
PUDnFaFrHTb5LmbtqKRSsNZlmySyddF1A7F95YWnsGQd2eZHLmzf0LvtI1bA
87TZfvo4vqVtwff56rParvzU0l5osh9t+dExGk6zR+laxMYV9R0HkeH4i83z
gZS6fErQZVdH13KzcfGevMWaCV8T80bsX6vRAveT1bEC6bq/I7GSFxErsZLv
Eit5kUusqpkAZLrFZWrRTBavluH/pGzSC1bxdizSxwY7idVJW/wJ61HsvEis
jhajBUVWYnWZlXyXWMmLiNUGVvIiU3kSkKp2ohWTUW4j1ugOq2JyOT29QjOU
mL2nRdnphniXmEnE/cOSDwvu/fmhAqjtOhIqtZILqNRKLqBuZiupMrm4tWYz
IzLeH4lzynVnhdzvyggbZDara0ecR5nNq+JWaG3ua5sbZVxDpVZyAZVaaXNR
bW97GJ8qmitk+Y2McgaXvNfU7RWWj9iySl6RXbW4+O8cceUnXrU9Iu1uYD3k
pLUmPRTcD/SlQMg0h/1SZAWynd1WUI1JcXN9/cgjIyXtdtJDTTtX10PFcR2/
sZiLv/BjS/XfSwQBRjqV7aDozS2ebp/TQjZpprt4EnvDogbORuiMld4A6Dvg
hg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92672703]
}, Open  ]],

Cell["Chart several sets of values:", "ExampleText",
 CellID->1283849086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1101372124],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnctu00AUhqexA4u0AUpBLCtVFLEJ24oFCCEoCFEWkSpBYBFVQAJCRW0f
IBteALFjichz8R4gmXPsXKaO3VzqJmPni9LxZTz+z/95fJ9JXzZPWu+/NE/a
B83N3aPm11b74Hjz6eGRzPJWjFlpGWP+3DIyHshY+KeftvxFo+lje5J6UuCj
DH0ZtnrTj8LcV5p6/fUF4VL9aUnN51j+g8RSrdj0p4lKtRO0S6mRxZeOaz5M
LPVBE384neZor6fdtoZDSldjZTTZH5NjvB7C/qi1lCqU00ueitcfceCfq6QO
X0dhTamzEU7fq9XfNbryNRVN/E6nE+XLyFq38c349dpja87PhszZqw3nNLqH
plyr7wT9T+1+3aw2jrvGk7Ge1s1QSxY/pSXa47TKAy1dc31H1pyktxbqDWI3
NzLTC/0NqYhYohb0ob+89K1j46UgOuLGj4cQz5J4/DwFXehCF7rQhS50oQvd
RdBVuFClzkIXuktKVyTka1YlKfXniZKKVeA7M99tWMISlrCEJSxhCcslvgul
Pp6pJZ+qzI3aKMiaRUFFKlAcT9EbaJl1+MEPfvCDXz75BdF5cPAUSnRVugLB
swl6gwjMNdjBDnawyw27Ke59YUZ9gx3sYAc72MEOdrArHLu0XovhtJm5XxRs
R/qc2f2dDGQzJHspRlLrcVkm1yE6I9HLMaKlgLoK2aog2HCKZmb9eOfF09LZ
WjRJ68x/zj65S0jP8WtOSEEKUpCCFKQgxRtHpwlRlyAFKUhBClKQghSkIAUp
t0jN+y7mSsdqmW/7cozLImrQHbjABS5wgQtc4AIXuMAFLk7cH01y33JxFKpa
cIE14vZCnL/BJS5V3fIU3xOK6HEbT3haqKeR3iPlgb9eRrxFaSFcj+19UGzH
2sbaN6NtrYvp1O6zo7VZq/hW4Zyqs6QW4MXbpoV2ah2P4z1NinhcKuI5FU94
whOeltGTWiqKlyJuHzzhCU94whOe8ISnWT1xnYcnPOEJT3jC03Se9FeYomf5
omVr58mRlb++lF4cuwJa+u2BF7zgZXYv2u71eo5i3iXWTGJN+/1gHU1qZeG0
lyl/WxIv7njRVllPcuXBy/XeEY88V/XJOmZpK6lSzvaHPJ0fiJVYiZVY+888
XI8xTzyJlViJlViJlVjzFCvXAS7Gqk9w3zoU03diIRZiIZaMzyFz5OHbsVQl
88f8tL2BtvmFqgOquv3vXsjan+durZm8NZxeNYt3YrlUtfu8p74py6Wzuala
NTbtv+W5vMex1vms9VkQHel/z1T678SltNDkS8+mQSkXSv3r1agXibma7E+Q
088Yt6xZ+Q//mr16\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263917740]
}, Open  ]],

Cell["The sets need not have the same length:", "ExampleText",
 CellID->713561762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2.1", ",", "0.5", ",", "0.9", ",", "1.7"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1313504266],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM9u00AQhzdx2grBgQshvfVU6KXc4AKhgEQPVblUqoQqDlGFlBwQqPQB
cuGOeIg+Fy+AeIQwY3ups10r/+1N9osa2+vZ3fl9s/Fm40xz2rvuf/7Sux5c
9vaOr3rf+oPL73vvv17JqaRhTKNvjPndMXI8kqP0qY+BPLPD8qPnsk2kwSvZ
t2Tfzctv1JrYnkapXYsHaasXHqstG0/rrlM+csr73l4ntXqZa3a9+Xt77dHc
lGLxvGp/O1dvrtZu3vtRvvfHTQlM67bsj7vtp3j+6f/Rswx27xs9a89aPXSs
ujmfYDFJHh57WKilPW+Vtxzja90hbi3UUvcfM1kz+rmflofD4aeLG/kzbd1o
Wc6fHb4zj28uftiyVn3g1H+U1n92eCbn5azpeOuLvYb6anoyV/SJSsRRKVzj
26NsxnCv6zgi4c6DUEMNNdTrS63Q8dDGOcZQQw011FBDDXX41KzJoIYaaqih
hhrqsKhZnUANNdRQQw011FDXT82aDGqooYYa6vCpy3KGtRxvbuF4pumOE4Mm
MSEmU8ZkS4r3KojFrhqSrIKa/X2ull/nijrmjH1bX86rqV0Te5G56uz0mmJQ
ePfYyUc/DvKqVwtQQgkllNXeZ2IMoYQSSiihhBLKuilZ80AJJZRQQgkllDFQ
suaBEkoooYQSytgpQ1kN7ErzefNNwh23RcYVKqiggmpWqixhyj7cPMoQ8+mW
w+2SpqlkYzl1oWWSwb167rF8WelClxntdK1R4NVNFbziR121vf6WP86nS+b4
sFE6p/nl43qUue9LqEAFKvyfXWOPASpQgYp1UMFshQpUoAIVzJmoQAUqUMGc
iQpUxKSi/Nu5tBzMPWj3Lv62U3bt4arUb4BOglUXXgz1BRru69D97ii875LK
frck5lkPFahgvYoKVKACFeHOmfqrfweVsP7EC142zMsqrsrNjBRe8LIZXrjm
8bK+Xlpmuv8QWY13ey+8UKg0TzxTUX++eqYjcbw0vTom3c1Wk13F6/7XDH1P
y6imP3mzO30so9cFM/Nve5rlKqJVeSttpJ8PO1L5r7cv3ZyvwGIa/wA5hxAG
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->740840669]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4559],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart3D",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PercentileBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/PercentileBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackedBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/StackedBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13056]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarChart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 7.0513002}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarChart[{y_1, y_2, ...}] generates a bar chart of the values y_1, y_2, \
.... BarChart[{list_1, list_2, ...}] generates a bar chart of the data in the \
lists.", "synonyms" -> {}, "title" -> "BarChart", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/BarChart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7088, 229, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->363908284]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15459, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 969, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1592, 48, 46, 1, 70, "ObjectName",
 CellID->16234],
Cell[1641, 51, 1380, 44, 70, "Usage",
 CellID->31886]
}, Open  ]],
Cell[CellGroupData[{
Cell[3058, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3536, 117, 272, 9, 70, "Notes",
 CellID->20425],
Cell[3811, 128, 2681, 71, 70, "3ColumnTableMod",
 CellID->1300],
Cell[6495, 201, 357, 13, 70, "Notes",
 CellID->11121],
Cell[6855, 216, 196, 8, 70, "Notes",
 CellID->1599734575]
}, Closed]],
Cell[CellGroupData[{
Cell[7088, 229, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363908284],
Cell[CellGroupData[{
Cell[7473, 243, 147, 5, 70, "ExampleSection",
 CellID->35450747],
Cell[7623, 250, 132, 3, 70, "Input",
 CellID->205407995],
Cell[7758, 255, 66, 1, 70, "ExampleText",
 CellID->925491420],
Cell[CellGroupData[{
Cell[7849, 260, 196, 6, 28, "Input",
 CellID->1366135831],
Cell[8048, 268, 1253, 25, 232, "Output",
 Evaluatable->False,
 CellID->92672703]
}, Open  ]],
Cell[9316, 296, 73, 1, 70, "ExampleText",
 CellID->1283849086],
Cell[CellGroupData[{
Cell[9414, 301, 217, 7, 28, "Input",
 CellID->1101372124],
Cell[9634, 310, 1571, 30, 245, "Output",
 Evaluatable->False,
 CellID->263917740]
}, Open  ]],
Cell[11220, 343, 82, 1, 70, "ExampleText",
 CellID->713561762],
Cell[CellGroupData[{
Cell[11327, 348, 320, 11, 28, "Input",
 CellID->1313504266],
Cell[11650, 361, 1311, 26, 245, "Output",
 Evaluatable->False,
 CellID->740840669]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13022, 394, 310, 9, 70, "SeeAlsoSection",
 CellID->4559],
Cell[13335, 405, 1011, 35, 70, "SeeAlso",
 CellID->13056]
}, Open  ]],
Cell[14361, 443, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

