(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10282,        342]
NotebookOptionsPosition[      7719,        256]
NotebookOutlinePosition[      8957,        292]
CellTagsIndexPosition[      8873,        287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "BarChart3D" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart3D"], 
         "BarEdgeStyle" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarEdgeStyle"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"BarChart3D\"\>", 3->"\<\"BarEdgeStyle\"\>"}, "\<\"see also\"\>",
       
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarEdges", "ObjectName",
 CellID->29754],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarEdges"], "InlineFormula"],
     " \[LineSeparator]is an option for bar charts that determines whether \
edges are to be drawn around the bars."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22308]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used:", "Notes",
 CellID->8500],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "draw edges around each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["draw no edges", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->2186]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47072276],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->662488777],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->343006746],

Cell["Include edges around the bars:", "ExampleText",
 CellID->773345995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"BarEdges", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"BarStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1667974843],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF9PwjAQL27gqzFqeOSTaHzRJ/8kJsRXQtRNYzTIq3Ff1Tfjl8Be14Xt
oKybQLvxI6ztcbv7Xa9XuisbV6Np9PA6msbj0eByMnqP4vHH4OJtIj8KOkJ0
IiHEd1/I9ky21EGvWB5pk7euZRnI055kHco60vS54t5QGWRaZuqsjJaleGH8
06VSEaOfraTiJdh7Rsv42RzzbKnUIxXhnDb16Fpjx7l67qUDJkPFsIQjAu3C
rJk7ixC6ZsmCveFCD0JHklTfy6NTC+tI0UkiFK4aKaFpxT/R/ETzbzU/0fxj
G76vVuVioTdLI4yP/3Ys4fHadlQCbXsfgQpUzBigAhUzBqhA9R8VM6Y9qKY8
l2h3eU4x69tnNuzBJmubupI8dGALxY0v8cNtcL+LsK+948aSXfp+w3oFVKBW
RcWMASpQMWOAClTMGKCW51tplb54LuwuD+SWqBSskBu6ycDs7Mpy9zsJ33fk
jy/g/jPXN90xsB4kPt9910pKfbcRWpukFREFrYgoaPVZKyJqfVrNuYaiN3al
xa8le4zm/O2hUp7w2aI+0gBvbxx5BrD5jMD06996kJo0l/HdCK2IKGj1XSsi
ane1Yux91xpa/uawHrQs/8gR3uxkFzKBJBHyLW6pqIy38MxjaT9/neqt+uSg
pVaLfXw7TTzyNy1FQn5a1lYpeBweb44UfMevGky7h7brT1qlZdnTAXY6bff+
fqy08ZWX97OejVwr0f/xYn7NLrtvv/oabtp58y86MUfh8WZJwXfweH2pQCyu
JfXXkcZlr7k1qrtUZ2GdX5XZ17jnjYphzf7lZFfkyPOzeHTMOdTi/34lOn+1
fgof\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62768293]
}, Open  ]],

Cell["Do not include edges around the bars:", "ExampleText",
 CellID->1055106321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"BarEdges", "\[Rule]", "False"}], ",", 
   RowBox[{"BarStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1131004420],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWk1Pg0AQXQptr8Z4qLf+Eo0XPVkTTRqvpFFBYzS1Z+Nf9Wj8EXUGaFge
LOwCbalsE3Z2ujOzsw94DB/X/ip4ePVX4cKfXi399yBcfEwv35b0l+sI4QRC
iO+JoP6aetHGv5C2uIu9GbUumT2R9EgGiX4Rjd5w626irCOrjU6teIHxs0Kv
APRnLa+wYO6BMjO0xjnPC70eufFSXbWiWTJ3KMkUpSPw4WZeMSLcBMJNV7Li
GYZqz0y+Xm4F3p48Wd7T5tSa64SaO5KnJG8lOdlGNAn7UbJHEe/yCLhf27Zm
4/1mcKjWFjmLnEVOj/vk6w7r5jyYZeEx+A46HGtI6rFBDMalKT7oW/+qNU6y
MYtgz4OuWlvkLHIWuTIejUX8w2uBOS9jhIhaG9xR6MWrvuaY5/V1EHF07riK
PfE4aWrFRruZqatWFgGLQJcQUHN7pGszBXLVCHQcrx+FefxzhzkwQPVxQIY2
Z2zV3Ub/jlV7tloE7No8zRq8nO8lZWuVqZqpc+9cKvP4bdXf9I0GeGvU01kP
3LOmozzYbsR9jdqV9DtXZC9VlYnnayziturpdNZXt6b8yXghw2B+5XOiN+s6
q5Q5qOp5tZqTVBXjfz2m+rSSQ8q1Oytxhd53Hu1WGY2rFOmcHhb65nnL/Jkh
N/Oa+Uq+JbVQaoV7KR3hHn4dJZw/953dng==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->172091357]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8141],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart3D",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarEdgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26695]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarEdges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 7.3169320}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarEdges is an option for bar charts that determines whether edges are \
to be drawn around the bars.", "synonyms" -> {}, "title" -> "BarEdges", 
    "type" -> "Symbol", "uri" -> "BarCharts/ref/BarEdges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3106, 107, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->47072276]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8731, 280}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 831, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1454, 47, 46, 1, 70, "ObjectName",
 CellID->29754],
Cell[1503, 50, 390, 11, 70, "Usage",
 CellID->22308]
}, Open  ]],
Cell[CellGroupData[{
Cell[1930, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2408, 83, 67, 1, 70, "Notes",
 CellID->8500],
Cell[2478, 86, 591, 16, 70, "2ColumnTableMod",
 CellID->2186]
}, Closed]],
Cell[CellGroupData[{
Cell[3106, 107, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47072276],
Cell[CellGroupData[{
Cell[3490, 121, 148, 5, 70, "ExampleSection",
 CellID->662488777],
Cell[3641, 128, 132, 3, 70, "Input",
 CellID->343006746],
Cell[3776, 133, 73, 1, 70, "ExampleText",
 CellID->773345995],
Cell[CellGroupData[{
Cell[3874, 138, 289, 8, 28, "Input",
 CellID->1667974843],
Cell[4166, 148, 1070, 22, 246, "Output",
 Evaluatable->False,
 CellID->62768293]
}, Open  ]],
Cell[5251, 173, 81, 1, 70, "ExampleText",
 CellID->1055106321],
Cell[CellGroupData[{
Cell[5357, 178, 285, 8, 28, "Input",
 CellID->1131004420],
Cell[5645, 188, 920, 19, 246, "Output",
 Evaluatable->False,
 CellID->172091357]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6626, 214, 310, 9, 70, "SeeAlsoSection",
 CellID->8141],
Cell[6939, 225, 738, 26, 70, "SeeAlso",
 CellID->26695]
}, Open  ]],
Cell[7692, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

