(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10397,        338]
NotebookOptionsPosition[      7976,        259]
NotebookOutlinePosition[      9329,        297]
CellTagsIndexPosition[      9245,        292]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "StackedBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/StackedBarChart"], 
         "PercentileBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/PercentileBarChart"], 
         "PlotLabel" :> Documentation`HelpLookup["paclet:ref/PlotLabel"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"StackedBarChart\"\>", 3->"\<\"PercentileBarChart\"\>", 
      4->"\<\"PlotLabel\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarLabels", "ObjectName",
 CellID->5645],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarLabels"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BarChart",
       BaseStyle->"Link",
       ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["StackedBarChart",
       BaseStyle->"Link",
       ButtonData->"paclet:BarCharts/ref/StackedBarChart"]], "InlineFormula"],
     
     ", and ",
     Cell[BoxData[
      ButtonBox["PercentileBarChart",
       BaseStyle->"Link",
       ButtonData->"paclet:BarCharts/ref/PercentileBarChart"]], 
      "InlineFormula"],
     ", that allows a label to be placed at the tick mark for each bar (or \
group of bars for multiple data sets). Labels are specified in a list."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11740304],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->178240157],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"BarLabels", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " the bars are numbered:"
}], "ExampleText",
 CellID->2076194790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"BarLabels", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->920850714],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1OwkAQXmiBqzFqOPIE8AYaL3oSSEiIifHQELXVGA1yNfI0vpc340vg
Tn9CGVi6lJ9dykfs7o6zM9/sdJbtbFtuvJH/8OqNgoHXuB56734w+GhcvQ3l
v5ySECVfCPFTF7I9ka3woE8gj6jJW21ZOrLbk6xdWfsxfRlyO1Q6iZZJ2Cuh
ZSleGP98oZTP6GctqWABdllpGe/NMS8WSj1S4U5p1YjaMXaQqqdeOmIyVPQz
OMKJXZg0U70IoaKWnLHXnRuBa0iS6lt5lHJhnYR0q9m7v/uWf6JDBdEx/yzk
j8fjmN8N+ZKO+ac6fFutSsVCdRJFGD//u7GEx2vRUQm06GMEKlAxY4AKVMwY
oALVflTMmOKgqvJcos3lObNZX43ZUIZN2jZVJHlswBaKG1vih9tgfhehFnvH
jCWH9P2G9QqoQF0VFTMGqEDFjAEqUDFjgJqdb0VV9OG5sLk8kFsSpmAW3FHW
syvJ3XsSvm7IH1/AXTPXVz0xsBkkPt9t10pKbbcRWvdJKyIKWhFR0GqzVkTU
5rSqc42Q3tqVFr+WrDKa83eHSnnCZ4HGSCd4d+eRZwDbzwhUd/82g7RPcxnf
jdCKiIJW27Uiog5XK8697VpdzXsOm0FL8o8UYc1O9kwm0GrSjQPRpWJlvLl3
HjPH+WdU76pvDmpq1djH19PEI3/bUiRkp2VFlYLH4fH9kYLv+FWDavdQd/2J
qqjMejtAT6fu3t+vlja+8vJx5rORayV6HS+m1+ys5/ZXX8NVO2/2RSfmKDy+
X1LwHTyeX8oRer+zYzbL3Fr2mlqjKgt1zqzzyzL7HM+8UdHPOb6U7JIcedqL
R8eUQy3+61ei9A/iU+yz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->605395305]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"BarLabels", "->", 
   StyleBox["list", "TI"]}]], "InlineFormula"],
 " labels the bars with the items in the list:"
}], "ExampleText",
 CellID->144055427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"BarLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", " ", "\"\<b\>\"", ",", "\"\<c\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278346884],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMtOwkAUHSiPrTFqWPIF8A1sdKWQkBAT44IQQ1kYDbI18jWujGv9HHfG
n8C500Hai6XT8pihnIbOo3fmnDvTO53eactlf+Lf3fcno0G/fjHuP/qjwVP9
/GEsD3kFIQq+EOKrJmR6JlNqp20k9yDJU20ZerKYL+OijEc6binpFYVegCJ0
KVGao9KhYagEJVt/qMUU5dfhCR8d6tZEW/HJSr2pox+6zLvKHbEyFPQSJMLT
6s6ToVKEXI6vGWlbaam1JUs1Kb6WeyET14nKNxvd25tX+RNtCiiv5WdKPp1O
tbyj5DKv5acmcle1CtlCZRZYFj//u9GE22veWYk0720EK1gxYsAKVowYsILV
fVaMmPywxvm5lLfn50S9virToQidjHUqy+yxBV3IblyxH66D/VWEqu4dO5oc
0vUN8xVYwZqWFSMGrGDFiAErWDFiwJrsbwVRsHFf2J4fyDVRLpgDT5TN9Jr7
7l1JX7PUHy/gXdPXj3tjYDNMfLy7jkqgrusI1H1ChUUBFRYFVJdRYVGbQ433
NVR+a3da/F6ywvJcvjtW8hOec9RGOsG7O4/cA9i+RxD39G8zTPs0lnFtBCos
Cqiuo8KiDhcV59511JLhM4fNsM39j1DGmZXsiCfQbNCDA9GhIDXf0jePie38
sYqb9stBQ1SDdXwzJG75265FldzULK+10OPo8f2phb7jdw1xq4em808QBWHS
1wFmmKZrf99GaHzm5e3MpiNHpfw6vRies5Pe208/h8etvLlnnRij6PH9qoW+
Q49nr+UJs//Zsetlbs17Dc1R5X8xI/P8Ks8+wztvFPQyti9Ud4WPvCjFrWMh
oRT/BytR+AU0ncXa\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->420175957]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->703],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackedBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/StackedBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PercentileBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/PercentileBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28908]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarLabels - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 8.6763418}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarLabels is an option for BarChart, StackedBarChart, and \
PercentileBarChart, that allows a label to be placed at the tick mark for \
each bar (or group of bars for multiple data sets). Labels are specified in a \
list.", "synonyms" -> {}, "title" -> "BarLabels", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/BarLabels"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2646, 84, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9111, 285}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 963, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1586, 48, 46, 1, 70, "ObjectName",
 CellID->5645],
Cell[1635, 51, 974, 28, 70, "Usage",
 CellID->14053]
}, Open  ]],
Cell[CellGroupData[{
Cell[2646, 84, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3023, 98, 147, 5, 70, "ExampleSection",
 CellID->11740304],
Cell[3173, 105, 132, 3, 70, "Input",
 CellID->178240157],
Cell[3308, 110, 248, 9, 70, "ExampleText",
 CellID->2076194790],
Cell[CellGroupData[{
Cell[3581, 123, 237, 7, 28, "Input",
 CellID->920850714],
Cell[3821, 132, 1087, 22, 246, "Output",
 Evaluatable->False,
 CellID->605395305]
}, Open  ]],
Cell[4923, 157, 195, 6, 70, "ExampleText",
 CellID->144055427],
Cell[CellGroupData[{
Cell[5143, 167, 325, 10, 28, "Input",
 CellID->278346884],
Cell[5471, 179, 1083, 22, 246, "Output",
 Evaluatable->False,
 CellID->420175957]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6615, 208, 309, 9, 70, "SeeAlsoSection",
 CellID->703],
Cell[6927, 219, 1007, 35, 70, "SeeAlso",
 CellID->28908]
}, Open  ]],
Cell[7949, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

