(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9933,        330]
NotebookOptionsPosition[      7329,        243]
NotebookOutlinePosition[      8606,        280]
CellTagsIndexPosition[      8522,        275]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "BarStyle" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarStyle"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"BarStyle\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarOrientation", "ObjectName",
 CellID->31888],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarOrientation"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BarChart",
       BaseStyle->"Link",
       ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
     " that determines whether the bars are oriented vertically or \
horizontally."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used:", "Notes",
 CellID->3603],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Horizontal", Cell[
    "use horizontal bar orientation", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Vertical", Cell[
    "use vertical bar orientation", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->7681]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->530462787],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->485695257],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->438086604],

Cell["Chart with vertical bars:", "ExampleText",
 CellID->2050599905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"BarOrientation", "\[Rule]", "Vertical"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1766468675],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1OwkAQXmiBqzFqOPIE8AYaL3oSSEiIifHQELXVGA1yNfI0vpc340vg
Tn9CGVi6lJ9dykfs7o6zM9/sdJbtbFtuvJH/8OqNgoHXuB56734w+GhcvQ3l
v5ySECVfCPFTF7I9ka3woE8gj6jJW21ZOrLbk6xdWfsxfRlyO1Q6iZZJ2Cuh
ZSleGP98oZTP6GctqWABdllpGe/NMS8WSj1S4U5p1YjaMXaQqqdeOmIyVPQz
OMKJXZg0U70IoaKWnLHXnRuBa0iS6lt5lHJhnYR0q9m7v/uWf6JDBdEx/yzk
j8fjmN8N+ZKO+ac6fFutSsVCdRJFGD//u7GEx2vRUQm06GMEKlAxY4AKVMwY
oALVflTMmOKgqvJcos3lObNZX43ZUIZN2jZVJHlswBaKG1vih9tgfhehFnvH
jCWH9P2G9QqoQF0VFTMGqEDFjAEqUDFjgJqdb0VV9OG5sLk8kFsSpmAW3FHW
syvJ3XsSvm7IH1/AXTPXVz0xsBkkPt9t10pKbbcRWvdJKyIKWhFR0GqzVkTU
5rSqc42Q3tqVFr+WrDKa83eHSnnCZ4HGSCd4d+eRZwDbzwhUd/82g7RPcxnf
jdCKiIJW27Uiog5XK8697VpdzXsOm0FL8o8UYc1O9kwm0GrSjQPRpWJlvLl3
HjPH+WdU76pvDmpq1djH19PEI3/bUiRkp2VFlYLH4fH9kYLv+FWDavdQd/2J
qqjMejtAT6fu3t+vlja+8vJx5rORayV6HS+m1+ys5/ZXX8NVO2/2RSfmKDy+
X1LwHTyeX8oRer+zYzbL3Fr2mlqjKgt1zqzzyzL7HM+8UdHPOb6U7JIcedqL
R8eUQy3+61ei9A/iU+yz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->259584174]
}, Open  ]],

Cell["Chart with horizontal bars:", "ExampleText",
 CellID->1776807920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"BarOrientation", "\[Rule]", "Horizontal"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->716592921],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmc9PwjAUx7t1A7x78MgfIAMv+h/oyZMJMTGaLIQEDgZEDsaTf41/mHgz
/A3zdW3j9tbS8UPoWBf2aPs+r31vncuXeRvPR8PneD4exO2bWTwdjQev7evJ
DIaoR4g3IoQszwi0E2ilJzvGcPImbvlgfcAo61HJJ4SNdRU+sKmvB2025Gvi
sE/GRdAONHEqn4yTc6ryDDgX8i/hkONBdqhTGGmi+SLUp4WILiIaqH+Osi9m
ESEC54BX8AszUKsq7mw9Q9UqxjMU8+0hIlRcM18WtLNKQzHrxdoVBppIc2W0
9JrbVpadXZWFucLCXZuL2CQP8/XiVcvnbEN8y2drE/V1/qiEn2b8/JnIUtA/
+1UtuUnsYN9DOL10qIUqxf2TA/tty6fq+fI/U0ydWn7VDp0fXn/f+ah37dLQ
v9qSV6/KzFNdPR/pQaZglnnP48MnfMiEGdqN7sQcP45ylKN2QMkfhPwISsXg
36N0j1FSG74cPLOs+gtLRdh6DzjKUUdK6ZWF4JmxTg/VxwMbBx+yAPOe94j9
/UL7++YoRzlqB1Sg0HtqUmrETMcYo9Nt30q68J+KUmtsFqV4j2mOWaH1bNlP
RznqSCmh4hZgkEoQPDPWaZv6eISKS8D0WYPCRgkave0U+52A6ad77khHOrIa
JFWonxW0JMUoVmeGyD+VlnDlyPh7Jb9KnelXMb31+5fK1sqwKveFIx1ZW1Jo
0wRMH85W3itimLFOtR29h3i/SP9sWQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->121693954]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21833],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21014]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarOrientation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 8.8950974}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarOrientation is an option for BarChart that determines whether the \
bars are oriented vertically or horizontally.", "synonyms" -> {}, "title" -> 
    "BarOrientation", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/BarOrientation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3010, 104, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->530462787]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8379, 268}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 689, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1312, 44, 52, 1, 70, "ObjectName",
 CellID->31888],
Cell[1367, 47, 550, 16, 70, "Usage",
 CellID->6433]
}, Open  ]],
Cell[CellGroupData[{
Cell[1954, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2432, 85, 67, 1, 70, "Notes",
 CellID->3603],
Cell[2502, 88, 471, 11, 70, "2ColumnTableMod",
 CellID->7681]
}, Closed]],
Cell[CellGroupData[{
Cell[3010, 104, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->530462787],
Cell[CellGroupData[{
Cell[3395, 118, 148, 5, 70, "ExampleSection",
 CellID->485695257],
Cell[3546, 125, 132, 3, 70, "Input",
 CellID->438086604],
Cell[3681, 130, 69, 1, 70, "ExampleText",
 CellID->2050599905],
Cell[CellGroupData[{
Cell[3775, 135, 242, 7, 28, "Input",
 CellID->1766468675],
Cell[4020, 144, 1087, 22, 246, "Output",
 Evaluatable->False,
 CellID->259584174]
}, Open  ]],
Cell[5122, 169, 71, 1, 70, "ExampleText",
 CellID->1776807920],
Cell[CellGroupData[{
Cell[5218, 174, 243, 7, 28, "Input",
 CellID->716592921],
Cell[5464, 183, 977, 20, 258, "Output",
 Evaluatable->False,
 CellID->121693954]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6502, 210, 311, 9, 70, "SeeAlsoSection",
 CellID->21833],
Cell[6816, 221, 471, 17, 70, "SeeAlso",
 CellID->21014]
}, Open  ]],
Cell[7302, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

