(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14315,        456]
NotebookOptionsPosition[     11294,        352]
NotebookOutlinePosition[     12518,        388]
CellTagsIndexPosition[     12433,        383]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "PercentileBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/PercentileBarChart"], 
         "StackedBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/StackedBarChart"]}, #,
         2]& , Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"PercentileBarChart\"\>", 
      3->"\<\"StackedBarChart\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarStyle", "ObjectName",
 CellID->20839],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarStyle"], "InlineFormula"],
     " \[LineSeparator]is an option for bar charts that determines the \
default style for the bars. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
If there is only one data set, the styles are cycled among the bars. If there \
are multiple data sets, the styles are cycled among the sets.\
\>", "Notes",
 CellID->25778],

Cell["\<\
If the value is a function, the function is applied to the height of each \
bar.\
\>", "Notes",
 CellID->28782]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8139561],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->16884373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->76746118],

Cell["Use a custom color for the chart:", "ExampleText",
 CellID->323780985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], 
   ",", " ", 
   RowBox[{"BarStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->710901771],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXE1OwkAUftCSqPEALonEBBNcSdUT6MormDTGhC6MBlkYV9zJO5kYD1Hn
tTOhDq+lFijT8pHQmemb9/3MDLWU2vtwNnl6DmfRY9i/m4avk+jxrX/7MlW7
vA5RZ0JEXyek6rGqJW9+ReqdVu3aUG091S1Qpa/KsW7fcNQz+TFd6v3Xquyq
cpBkn1u9gkybdO+8OFevBBbyF22iU5HHzpNwfIG/LL6Ux66zPJQzSlXwx8I4
GT5TermjPl5ilfBt/dK4pWqHureZ6yCW10Rg9UuzOZSurQOrP28eUoGeHkD1
6uX3+uPJ30I/LsNURiHGYdKez+cJXjIDpNtJ/EjHSceHOk5WvK58Mb4fHgtW
Vjsc2p8quIIruIIruIIruKrTFZtqj5t2zhFcwRVcwRVcwRVcwRVclT2rvVDB
Y1WOdOmGuuyYf0AVVEEVVEEVVO2ZKhbljho3xwiqoAqqoKoJqnzhjgw3lKWy
ElHOauxaqjwnVdqqWHVPNd/jxbft3ajItj9rWlVF9yLVpKHgXqF6FNjHIrCC
FaxgXWZl0rZ7BCtYwQpWsBpWc9Sv8htcOS8/QAUqUPcSlUFd1whUoDYFddVV
yCaxSNejN4Oc/f9ZvurGV0C/N4SsYYXreZvSvm2Gema3SZ8qoAIV50BABSpQ
m4JqjirSr7rltPDmDJnIbECmSXRbJTJdy1z1FKCSKP4iS376z65xenrHoFS+
t95o6DHlbXUU/hbaXWsUmrUSkYm/EMhEJlY6MpGJlY5MnPWv5yp7zj9SyVWY
//l001LPVJXmLY1wLbJq1PkFsHBlfA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->284767700]
}, Open  ]],

Cell["For a single set of data, the styles cycle:", "ExampleText",
 CellID->1602174722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], 
   ",", " ", 
   RowBox[{"BarStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Yellow", ",", "Green"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1557945116],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXN1OwjAUPrCRqPEBvCQSE0jwSqY+gV75CiaLMWEXRoNcGK/2Tr6TifEh
Zs/ahtF1MAeMbnwkrO3a8/2cdmMMsodwPn1+CefRU9i/n4Vv0+jpvX/3OhO7
vA5RZ0pE32ck6omopW9+ReItq2ZtKLaeGBaI0hflRLVvudfT8Qldqf03ouyK
cpBGj4xRQaZNanRRP1evLSzkL9pE51YeM86G41v4y+Lb4th1locKslQFf2LJ
k+bTpVeY9UmO1YZv6rflTaodqtF6roPEviYCY5yM5i65to6M8bx5lAI9lUDx
6hWPWvLk72Acl6GUsRLjOG3HcZzipTNAqp32n8jxcXrIcQZ5w+2l/vriR2Tp
PwyPK1ZWOxyaRxVcwRVcwRVcwRVc1emKTbXHTTvnCK7gCq7gCq7gCq7gCq7W
udJXtZei81SUY1W6oS6b80+ogiqogiqogqoDU8Wi3FHjZo6gCqqgCqqaoMqn
/D8y3FAmZaWinNXYNVR5Tqo0VbHqnmh+JItv2/tRkW1/1bSqFoz5VVWThhX/
FapHgXkuAitYwQrWPCuTtt0jWMEKVrCCVbPqs36V3+DKefkFKlCBepCoDOq6
RqACtSmo6+5CNonFdj96O8gaUd914zugP1tCVrCUv5+3Le27Zqhndpt0VAEV
qLgGAipQgdoUVH1Wsf2qW04Lby4QicgGROpAt1Ui0rXIdU8BKoniL6LsT//Z
N05P7RiUivc2y4bKKW+ro/C30O5GWWjWSkQkPiEQiUisdEQiEisdkbjq38xV
9pp/zMEVmP/5dNNSz1S1zZvs4Vpk1KjzB/AI+9A=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23053708]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 " to combine styles:"
}], "ExampleText",
 CellID->453102921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], 
   ",", " ", 
   RowBox[{"BarStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Yellow", ",", 
      RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1303712746],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMFOwkAQXWhJ1PgBHonEBBM8SdUjJz35CyYNMaEHo0EOxlP/yX8yMX5E
3eluQ12mZS1Qt+UR6O52dt68N7uUspTeh4vZ41O4iKZh/24evsyi6Wv/9nku
d3kdITozIcTniZD1RNbSFz0i+VJVszaUW092C2Tpy3Ks2zdk9TL/RFzq/dey
7MpykHqfG72CXFvo3kV2ql4xUYS/bAtxysYx/Tgcn4lvi8/5kep8HFGQpSr4
YyZPWbys9AqzPl6JyuGb/Lm8KbZD3Tsb6yDh50Rg9FPeZFJz68DoT5sHRdDT
CZSPXnGvX5r8HfSjMlQ0SjEO03Ycx0lCTxqBWLdT+5G2T7R9qO0Tw16XP2vf
D40lM6sdCs13FVRBFVRBFVRBFVTVqYpEtUdNO8cIqqAKqqAKqqAKqqAKqmzP
ai+k8ViWI126wS6f83ewAiuwAiuwAqs9Y0Wk3GHjZo7ACqzACqyawMpnrshw
g5milV3y5CbHrsHKc5KlyYpY92TzLVl+2/4fFvn2R02zquxapJo4lFwrVA8D
81iEqIiKqIi6GpWCtl0joiIqoiIqoppH/Sq/wdlp+QYqUIG6l6gE6jpHoAK1
KajrViGbFIVbj94Ocv7/s7TqRiugX1tC1rDMet62uO86Qj2j26R3FVCBinMg
oAIVqE1BzY4q3K+6dlxocwZPeDbAM3N0myU8XfNcdxcgS5S1d//5b5ye3jGw
8vc2y4bOKW2ro9C30O5GWWjWTIQnPiHgCU/MdHjCEzMdnjjr30xV/px/JJ2r
RP7j3U2t7qnKjZuyUC0yaqLzA71Az6k=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->145813696]
}, Open  ]],

Cell["For multiple data sets, each set gets its own style:", "ExampleText",
 CellID->1943560750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"BarStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->379832496],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3U1u00AYgOFJ4hQhmqQbJDagrBBICEQXsIFQWMCKSkioEsuoQkoWCFR6
AF+FM3AkDhLmG3tiZ2rXduz4J3mr1vZ4/p+ME8fxpJ/n14vvP+bXy8v59NPV
/Ndiefl7+vHnld416CnVWyil/j1Qenult8yf/Cz1X7Dpbr3Sy4FO9lavPb2e
heH3Ejuw+VcmXoJPTa7XCbE2rBJyz5zwmRN+nFhqVq43YZvd2pJLe5fQ5r4O
xvdL2z9sVZrb1llY+lm4TnaTHigvCie723Li+5+sHz3bB7tOevRsfJBLdgWP
/omTThYXQUMGIYfdjKWSkobpOTf6493ooddQTll/CzpUsJ57Juz7/io4pEbG
R8J6v6/UWPYO9JYO671qIsnCeElyXE1+k7mK/MdBfhWlryJ/2B6Vkh/1ZtRj
x/HRKngWcI9dpKuQdp9LUUUVVVRRRRXVw1EVVDQZo6iiiiqqqKKKKqqooorq
dqq8p2KMoooqqqiiiiqqqKKKKqqotkuVd6qMUVRRRRVVVFFFtYxq2iwUE1bM
GdiRuheJbs4WUJjXYn7kGLszsDCv3vyOY9zXi6EO3sW6FmvG927NmXHHjLv9
kuacG1VUUUUVVVQPV5XP3BijqKKKKqqoolqHquya6KgJkgUlTXq9mCJXUE6i
XqB20Gq7fq+zX1p5x5h9TjLX7mWtU4xRy1CTqBMbH9Y7Qg011FBDDTXUUEMN
tVaqZb2TQosxhhpqqKGGGmrl1G7MZBquBcOIIvcI47p29SKxcvNmME02lVkC
nio2WwDLdEtraI/5rDlGWCZbil3RuRVtsTyRCPtZ06oq/8Pwe7iuPyhgVPvr
tzt7rWuvMs0Idu28ESWUUEIJJZQ2lUzYD+/97MxnCbsUkaSPGCeooIIKKqig
ggoqnVbhnJYxggoqqKCCCiqooILKPqpwps8YQQUVVFBBpWmVtP95IZvcr5eq
5kUiZb/rfD/VfNRS7sVV6jS3Rivv1vbX36aVu+fnKT0etPwZJpa+VF/dPrZ5
pJfos3PXcr/lx/T2Pd3FuYTcpX/aydaf02paTatLtLqKa2IYb9FqX+5B1qX4
XWj18xytkleRfrh+WUutf6iFWlpbi1TS9T5QC7VQC8c8tRxCLUWvyOdvRXCy
O5bFLd88nXat7vZrtVmt+JsR355a499UINdfn+1Nz2qrNcf/JK2mpqJHJKXu
Z6l5XvGbbiOlUiqlcqRSat5S5Rrml61yy+J+oznzjPPmW3kIOYOTXPvTd8rZ
5tw0KtstzZz45j3DNr8jWVRUtiwuCuS1Xwr6tab6kvPmebcQpZatZeqW6v0H
MROuOQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->284132492]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29916],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PercentileBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/PercentileBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackedBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/StackedBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24587]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 14.5514922}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarStyle is an option for bar charts that determines the default style \
for the bars. ", "synonyms" -> {}, "title" -> "BarStyle", "type" -> "Symbol", 
    "uri" -> "BarCharts/ref/BarStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2770, 98, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8139561]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12293, 376}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 864, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1487, 47, 46, 1, 70, "ObjectName",
 CellID->20839],
Cell[1536, 50, 376, 11, 70, "Usage",
 CellID->16590]
}, Open  ]],
Cell[CellGroupData[{
Cell[1949, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2427, 83, 182, 4, 70, "Notes",
 CellID->25778],
Cell[2612, 89, 121, 4, 70, "Notes",
 CellID->28782]
}, Closed]],
Cell[CellGroupData[{
Cell[2770, 98, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8139561],
Cell[CellGroupData[{
Cell[3153, 112, 147, 5, 70, "ExampleSection",
 CellID->16884373],
Cell[3303, 119, 131, 3, 70, "Input",
 CellID->76746118],
Cell[3437, 124, 76, 1, 70, "ExampleText",
 CellID->323780985],
Cell[CellGroupData[{
Cell[3538, 129, 267, 8, 28, "Input",
 CellID->710901771],
Cell[3808, 139, 1038, 21, 251, "Output",
 Evaluatable->False,
 CellID->284767700]
}, Open  ]],
Cell[4861, 163, 87, 1, 70, "ExampleText",
 CellID->1602174722],
Cell[CellGroupData[{
Cell[4973, 168, 323, 10, 28, "Input",
 CellID->1557945116],
Cell[5299, 180, 1045, 21, 251, "Output",
 Evaluatable->False,
 CellID->23053708]
}, Open  ]],
Cell[6359, 204, 207, 8, 70, "ExampleText",
 CellID->453102921],
Cell[CellGroupData[{
Cell[6591, 216, 372, 11, 28, "Input",
 CellID->1303712746],
Cell[6966, 229, 1038, 21, 251, "Output",
 Evaluatable->False,
 CellID->145813696]
}, Open  ]],
Cell[8019, 253, 96, 1, 70, "ExampleText",
 CellID->1943560750],
Cell[CellGroupData[{
Cell[8140, 258, 411, 13, 28, "Input",
 CellID->379832496],
Cell[8554, 273, 1563, 30, 248, "Output",
 Evaluatable->False,
 CellID->284132492]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10178, 310, 311, 9, 70, "SeeAlsoSection",
 CellID->29916],
Cell[10492, 321, 760, 26, 70, "SeeAlso",
 CellID->24587]
}, Open  ]],
Cell[11267, 350, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

