(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9375,        317]
NotebookOptionsPosition[      7011,        239]
NotebookOutlinePosition[      8285,        276]
CellTagsIndexPosition[      8201,        271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "GeneralizedBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/GeneralizedBarChart"],
          "Text" :> Documentation`HelpLookup["paclet:ref/Text"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"GeneralizedBarChart\"\>", 
      3->"\<\"Text\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarValues", "ObjectName",
 CellID->31529],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarValues"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BarChart",
       BaseStyle->"Link",
       ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["GeneralizedBarChart",
       BaseStyle->"Link",
       ButtonData->"paclet:BarCharts/ref/GeneralizedBarChart"]], 
      "InlineFormula"],
     " that allows the length of the bar to be displayed above each bar."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->11348],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "show the length of the bar above each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "do not show the length", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->30493]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->167868075],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->13747032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->63933185],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"BarValues", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " adds heights above each bar:"
}], "ExampleText",
 CellID->1077547928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1.5"}], "}"}], ",", " ", 
   RowBox[{"BarValues", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2.2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512437895],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1O20AQ3sQJETekCrW98QItUPUIolKhnHpJUIuEEIoQUqISQIAqjjlU
vEcL4kjbt+pbuDPrNdjDGpbYxj98Uby7s7PzfeP9y3qM+Nw/HeyN+qfD3f7c
+nH/aDDcPZn7dHhMVV5DqcZAKfXvlaKyTyV98WdIV1CUpS6lHjXbp7xlcpbf
a22PUy9E8bU2lClVh0K/aLUaCfnAyUq2+kZJM9Ez2XpfyO+sVoypWrdy0h11
DfeByUexXrq/h22lacO2Q1dDF2cE76yWx+Px9tYVfdUGJywb/Uutn3/bM/qe
1pMc0yfbt8EKVrCmYmXSut8jWMEK1uqwYk8CK1jBWiZW7ElgBStYy8SKPQms
YHVlVV6QqbAYiQFzPLRdjFexyG1H+NCET84+tUl8UYAvXFeW+SN9aBXjU2Sl
dUzvFOPJc9rfwFpfVpz0wApWsGJ3ACtYwVp+VuxJYAUrWMvEij0JrGB1jywG
WfCRUd/iIp7SEx1sjEVBi4k1VtuvMHq+SeavC+qP80rzRqPeU779nUA2THI/
AGo+qCt+cGZYzQX9g5A/ZsbCoPmhP8091JWF5xTvDGu5oFdpdT1PVAYtu49A
BSpmP1CBWgVUrCmgZoeaHPXRcm7PtPKpfUrIUl93Vo7H/HBloyr6qg1OHmTj
AZ5kHL8not0nu6G6/MWgG9JjV0VdrZb84JfBtoIXJkJcFu3lrH1zg+ryi+SO
lo+PaVDDFZRNP8p5Pj/xeDcjq2cylPLP67RWLnOzSvcDK4wurDAnqm3VUm5v
mB1Pk+YZJiKkev9nP/kmv0flc/tXMj/T1Z6waz7oDydfUtta2rlaOrzJvG0t
RzxbzbUf/E+3C6v2d0RWsVZc+Ue0/mXF+CvknylaXd/p5WS/uVcvn6AHXTWh
wsyBxn8ylYq9\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 232},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266175849]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23836],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralizedBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/GeneralizedBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->815]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarValues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 14.8483748}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarValues is an option for BarChart and GeneralizedBarChart that allows \
the length of the bar to be displayed above each bar.", "synonyms" -> {}, 
    "title" -> "BarValues", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/BarValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3455, 117, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->167868075]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8058, 264}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 813, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1436, 46, 47, 1, 70, "ObjectName",
 CellID->31529],
Cell[1486, 49, 724, 21, 70, "Usage",
 CellID->12468]
}, Open  ]],
Cell[CellGroupData[{
Cell[2247, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2725, 92, 69, 1, 70, "Notes",
 CellID->11348],
Cell[2797, 95, 621, 17, 70, "2ColumnTableMod",
 CellID->30493]
}, Closed]],
Cell[CellGroupData[{
Cell[3455, 117, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->167868075],
Cell[CellGroupData[{
Cell[3840, 131, 147, 5, 70, "ExampleSection",
 CellID->13747032],
Cell[3990, 138, 131, 3, 70, "Input",
 CellID->63933185],
Cell[4124, 143, 234, 8, 70, "ExampleText",
 CellID->1077547928],
Cell[CellGroupData[{
Cell[4383, 155, 340, 10, 28, "Input",
 CellID->512437895],
Cell[4726, 167, 1140, 23, 253, "Output",
 Evaluatable->False,
 CellID->266175849]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5927, 197, 311, 9, 70, "SeeAlsoSection",
 CellID->23836],
Cell[6241, 208, 728, 26, 70, "SeeAlso",
 CellID->815]
}, Open  ]],
Cell[6984, 237, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

