(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11763,        382]
NotebookOptionsPosition[      9224,        302]
NotebookOutlinePosition[     10670,        341]
CellTagsIndexPosition[     10585,        336]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "GeneralizedBarChart3D" :> 
         Documentation`HelpLookup[
          "paclet:BarCharts/ref/GeneralizedBarChart3D"], "Rectangle" :> 
         Documentation`HelpLookup["paclet:ref/Rectangle"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"GeneralizedBarChart3D\"\>", 
      3->"\<\"Rectangle\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeneralizedBarChart", "ObjectName",
 CellID->2319],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralizedBarChart", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pos", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["height", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["width", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pos", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["height", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["width", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         RowBox[{
          StyleBox["\[Ellipsis]", "TR"], 
          RowBox[{"}", "]"}]}]}]}]}]], "InlineFormula"],
     " \[LineSeparator]generates a bar chart with the bars at the given \
positions, and with given heights and widths."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralizedBarChart", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], 
        StyleBox["}", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a bar chart from lists of data."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1062]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GeneralizedBarChart"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " with the following additions:"
}], "Notes",
 CellID->1053],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style for the bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarValues",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarValues"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to show the length of each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edges are drawn around each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", "0.5", "]"}], Cell[
    "style for the bar edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarOrientation"], "Vertical", Cell[
    "determines horizontal or vertical orientation", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->23730]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29717604],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->194414468],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->630078311],

Cell[TextData[{
 Cell[BoxData["GeneralizedBarChart"], "InlineFormula"],
 " allows complete control over the size and position of bars:"
}], "ExampleText",
 CellID->59689082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeneralizedBarChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "0.8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1.5", ",", "0.5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1274886510],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM1OwkAQxxfaAoknOXnw4BNo8CSJBzVRE41f8YiNEqKhB6NBH4Cn8RWM
B30dH0NntpugQxfa2kVI/4Tu7rA7v5lud9IybXrSfe7f3nefo1537XDQfexH
vae1g4cB/eRVlKr0lVKfK4raX9TSG38i2uKmvfVOpUcKVZa8WFOxTFtIbV/0
cZP72nrch+ipCbkjqD7X/qhfqa1UnCshezk5odwTC6cjxt0ImfeDZ0H+/hfe
2P7+4thmTpKvjWd1U4emrpm6najFxZKDHvYz4gOv/dFjws4LfVWTC4fysq3f
+NgUPk+TY/+Hw6HhNfLat8gxj/jGXqDnD7OWf9ZGVrenUM61vLF+mXKvVgW/
JXibqby6yOhFayZWD8T4O1D/mcrQefcRVFBBRaSCCipiClRQy0dFpIJaHHWX
Cs5XeT/onEfSuSwnFne48EdUGiHseCW0G5B46sheYI7xrI5nIOxIudiVWze1
GyuLFMug4qwLKqjlpiJSQQUVMQUqqOWjIlJBLY66a1ZUVdDdZRP2BFXnZCZm
F8pgt7js0Hzvp7ssUS10mQNbpJgGFWdfUEEtNxWRCiqoiClQQS0fFZEKanHU
pCyRUi6fIZLZBGnFzZM882vVlh+KCNNIRfXDdPmR19S0LE8AJVOzPuGTTJm2
5qGVTivpnDEfnkFrsbSwkqCFNQEtrInF19qhwlf57hDbr/p+/ovQ15KZ7hSm
u0bNfgcy5vL19D5h9cih/qgqF/5IJhZVfFV+RvWb1jvR/qgJ7zAJxAgu4vd7
HI2NHX9PiV37+Ov3u0lq1pGzel+JqnwDRng3QQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74894114]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10056],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralizedBarChart3D",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/GeneralizedBarChart3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28684]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeneralizedBarChart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 15.3171368}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "GeneralizedBarChart[{{pos_1, height_1, width_1}, {pos_2, height_2, \
width_2}, ... }] generates a bar chart with the bars at the given positions, \
and with given heights and widths. GeneralizedBarChart[{list_1, list_2, ...}] \
generates a bar chart from lists of data.", "synonyms" -> {}, "title" -> 
    "GeneralizedBarChart", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/GeneralizedBarChart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5856, 187, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29717604]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10443, 329}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 845, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1468, 47, 56, 1, 70, "ObjectName",
 CellID->2319],
Cell[1527, 50, 1777, 54, 70, "Usage",
 CellID->1062]
}, Open  ]],
Cell[CellGroupData[{
Cell[3341, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3819, 126, 282, 9, 70, "Notes",
 CellID->1053],
Cell[4104, 137, 1715, 45, 70, "3ColumnTableMod",
 CellID->23730]
}, Closed]],
Cell[CellGroupData[{
Cell[5856, 187, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29717604],
Cell[CellGroupData[{
Cell[6240, 201, 148, 5, 70, "ExampleSection",
 CellID->194414468],
Cell[6391, 208, 132, 3, 70, "Input",
 CellID->630078311],
Cell[6526, 213, 173, 4, 70, "ExampleText",
 CellID->59689082],
Cell[CellGroupData[{
Cell[6724, 221, 291, 9, 28, "Input",
 CellID->1274886510],
Cell[7018, 232, 1045, 21, 252, "Output",
 Evaluatable->False,
 CellID->74894114]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8124, 260, 311, 9, 70, "SeeAlsoSection",
 CellID->10056],
Cell[8438, 271, 744, 26, 70, "SeeAlso",
 CellID->28684]
}, Open  ]],
Cell[9197, 300, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

