(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20419,        553]
NotebookOptionsPosition[     17935,        475]
NotebookOutlinePosition[     19362,        514]
CellTagsIndexPosition[     19277,        509]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart3D" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart3D"], 
         "GeneralizedBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/GeneralizedBarChart"],
          "Cuboid" :> Documentation`HelpLookup["paclet:ref/Cuboid"]}, #, 2]& ,
        Evaluator -> Automatic], {1->"\<\"BarChart3D\"\>", 
      2->"\<\"GeneralizedBarChart\"\>", 
      3->"\<\"Cuboid\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeneralizedBarChart3D", "ObjectName",
 CellID->4251],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralizedBarChart3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["xpos", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["ypos", "TI"], 
              StyleBox["1", "TR"]]}], "}"}], ",", 
           SubscriptBox[
            StyleBox["height", "TI"], 
            StyleBox["1", "TR"]], ",", 
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["xwidth", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["ywidth", "TI"], 
              StyleBox["1", "TR"]]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["xpos", "TI"], 
              StyleBox["2", "TR"]], ",", 
             SubscriptBox[
              StyleBox["ypos", "TI"], 
              StyleBox["2", "TR"]]}], "}"}], ",", 
           SubscriptBox[
            StyleBox["height", "TI"], 
            StyleBox["2", "TR"]], ",", 
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["xwidth", "TI"], 
              StyleBox["2", "TR"]], ",", 
             SubscriptBox[
              StyleBox["ywidth", "TI"], 
              StyleBox["2", "TR"]]}], "}"}]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a three-dimensional bar chart with the solid \
bars at the given positions, heights, and widths."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29398]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->13347],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw the edges of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    ButtonBox["Black",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Black"], Cell[
    "style for edges of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    ButtonBox["White",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/White"], Cell[
    "style for faces of bars", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->29745]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->199143459],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->346918831],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->134640988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeneralizedBarChart3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".5", ",", ".5"}], "}"}], ",", "2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", "3", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.5", ",", "2"}], "}"}], ",", "4", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2.5"}], "}"}], ",", "5", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1764884670],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[1], Glow[], Specularity[], 
   {EdgeForm[GrayLevel[0]], CuboidBox[{0., 0., 0}, {1., 1., 2}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{1, 0, 0}, {3, 2, 3}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{0., 1, 0}, {1., 3, 4}]}, 
   {EdgeForm[GrayLevel[0]], CuboidBox[{1, 2., 0}, {3, 3., 5}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->Automatic,
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 ImageSize->{364, 418},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151968127,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19414],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart3D",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralizedBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/GeneralizedBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cuboid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cuboid"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9395]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeneralizedBarChart3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 15.0671304}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "GeneralizedBarChart3D[{{{xpos_1, ypos_1}, height_1, {xwidth_1, \
ywidth_1}}, {{xpos_2, ypos_2}, height_2, {xwidth_2, ywidth_2}}, ...}] \
generates a three-dimensional bar chart with the solid bars at the given \
positions, heights, and widths.", "synonyms" -> {}, "title" -> 
    "GeneralizedBarChart3D", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/GeneralizedBarChart3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5180, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->199143459]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19134, 502}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 825, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1448, 46, 58, 1, 70, "ObjectName",
 CellID->4251],
Cell[1509, 49, 1934, 57, 70, "Usage",
 CellID->29398]
}, Open  ]],
Cell[CellGroupData[{
Cell[3480, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3958, 128, 68, 1, 70, "Notes",
 CellID->13347],
Cell[4029, 131, 1114, 31, 70, "3ColumnTableMod",
 CellID->29745]
}, Closed]],
Cell[CellGroupData[{
Cell[5180, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->199143459],
Cell[CellGroupData[{
Cell[5565, 181, 148, 5, 70, "ExampleSection",
 CellID->346918831],
Cell[5716, 188, 132, 3, 70, "Input",
 CellID->134640988],
Cell[CellGroupData[{
Cell[5873, 195, 875, 29, 47, "Input",
 CellID->1764884670],
Cell[6751, 226, 10030, 200, 439, 1543, 56, "CachedBoxData", "BoxData", \
"Output",
 CellID->151968127]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16842, 433, 311, 9, 70, "SeeAlsoSection",
 CellID->19414],
Cell[17156, 444, 737, 26, 70, "SeeAlso",
 CellID->9395]
}, Open  ]],
Cell[17908, 473, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

