(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13713,        449]
NotebookOptionsPosition[     11010,        359]
NotebookOutlinePosition[     12267,        395]
CellTagsIndexPosition[     12182,        390]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "PercentileBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/PercentileBarChart"], 
         "Rectangle" :> Documentation`HelpLookup["paclet:ref/Rectangle"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"PercentileBarChart\"\>", 
      3->"\<\"Rectangle\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StackedBarChart", "ObjectName",
 CellID->22438],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"StackedBarChart", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a stacked bar chart of the data in the \
lists."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["StackedBarChart"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " with the following additions:"
}], "Notes",
 CellID->20425],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style for the bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "fraction of bar width to space bars in a group", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarGroupSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarGroupSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "spacing between groups of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarLabels"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "labels at tick marks for each bar (or group) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarValues",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarValues"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to show the length of each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edges are drawn around each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", "0.5", "]"}], Cell[
    "style for the bar edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarOrientation"], "Vertical", Cell[
    "determines horizontal or vertical orientation", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1300],

Cell[TextData[{
 "Each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is a list of numbers, or numeric values. For example: ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "7", ",", 
    RowBox[{"-", "4"}], ",", "2", ",", "3"}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11121],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " need not have the same length."
}], "Notes",
 CellID->1599734575]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322058633],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->17013327],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->589390034],

Cell["Chart sets of values:", "ExampleText",
 CellID->925491420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StackedBarChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1597021023],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnEFPwjAYhgsbEe8aOHL2gCfRq5royRNHQLIQEjgYdcDRyMW/wl/zDxiv
+HV0wj46N00XWnwJa9d9fd+nZV0zOvQumI6GD8F0PAgat2HwNBoPJo2bx5AO
eSUhSiMhxHtd0P6S9qJNvsa0rXbT9y4p9UgwodynPFTliyh6JVMv9ltGteIy
pWLG4mda1TSjrFdx72dKyqkt47VDVm5Fqio7eq5T+etyWg+5T0u1babySeJT
5LVlcl9ARHjqtKhBMKStpNUcRuXTZrvXWdBbdGXizedzFT+K4lROxKm+ih9n
6CugggoqqDmpErrvfQQVVFDdoWJOAhVUUEHFTAgqqKDaRMWcBCqodlOFv8pW
L38nbSgzqmdNKypUPKC8X6+daIl0XIZ6lNQ09X7Tv3bzetF5o7foykRHS8Sp
fqJ/6Xq0YmvUbzyFqeykBfqrHVRQ3aKu7/H2t4+gggqqO1TMSaCCCqpNVMxJ
oIIKKqiYCUEF1W6qn/osoGhy/Dxio2DFGvX3kwASmyfyVXDegleHKMm/zeBn
0BDjh/V7MwR+3cH1f7pKU9vbCFe4uuSKawqucDXrimsKrnB1wRVXKlzNuXqF
fQPeqzUJtl4gV3NeYmcSy0WdHiW1XG5Zv2H8NNLznC6a859PyccjVH9TSZGd
LYPKLRVGElQYE1BhJLmvMnOPaMZF9zQ3nzJWbN43f1Dep4pVVUOFNfehMtn+
r2fptbJ6u67Jz0lREVH6AmeeFm8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90822120]
}, Open  ]],

Cell["The sets need not have the same length:", "ExampleText",
 CellID->713561762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StackedBarChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2.1", ",", "0.5", ",", "0.9", ",", "1.7"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1313504266],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnc9OwjAcx4sbiYl6lpN/ohc94AmiN/AfxqgXj0SThZDAwWiQB+DiCxif
wWcyvoCPob9uLSy1m3Nso4Uv2br99tvv20+7bl2hCdfesNd98Ib9jrfVGnhP
vX7neev8cUCHnBJjpR5j7KvCaP+b9vyVf/q0BrvRe3uUOhRwTFtXbLl9xr2O
VPoeH9/1o/Y1XmmziOiwrfq3taonin2q2A3BfJ5ITY1uUrJEZjgXzt5KpaaW
8Fion4ltUG/LylmbGibmTuzfNdkM6YaP72j1N8TZp6Gy6q6u9OtVeHKfg4c5
ospFo+3SWtLGuL59UL29a7/Twmo84bbwr/j+0WhUkL/u+8kW/jKoQQ1qUIMa
1AVQc2h7aO2sY1CDGtSgBrUd1OgTQQ3q+aNuNBq31RNaWJ2SNYNJyf/efqGF
1XjiEK4F9Qvq+aLOtB9EHYMa1KAGNagtpkafCGpQLx51/NjRJNLk9a+nDjDl
x7WyDEsKtYNSGFWKMguOH1XW9xN/D2NAXZPqtM82lOLvJ1BoNlfZyhLon/yg
BjWoQZ1mtGkDrZ11DGpQgxrUoLaDGn0iqEENalCDGtToE0ENalBH+kmSFlbn
ifHUV6ACVa5UJvSUptcRqECVnGqVkkNy38wk91c/VzdypkreOcvZMiGjcIZZ
/+ofUKi5cqrxPA8KnnaeR3QuYfsyo6s6Ufx9VTPKwwk2ulkO2eSg3ot5qkbM
j0vHl/L5B9WJKhc1nRGqULVJFffUPKryd5O3VNEfFkUlabs2lQdRaBOLEOXE
jQ7iI5WoyJHSv1X4qO4iUXSiMU6swl9j20LrInUpzG9nePYgatZRaBOIQktC
FNqE/VHZvLdlo6L7dShZpIyQ769Fvvma8u6cXavh37R8ar08yeN/AeR9P50K
K/0ATko/CQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->791471165]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14417],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PercentileBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/PercentileBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16505]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StackedBarChart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 16.0827814}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "StackedBarChart[{list_1, list_2, ...}] generates a stacked bar chart of \
the data in the lists.", "synonyms" -> {}, "title" -> "StackedBarChart", 
    "type" -> "Symbol", "uri" -> "BarCharts/ref/StackedBarChart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6248, 204, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->322058633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12039, 383}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 826, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1449, 46, 53, 1, 70, "ObjectName",
 CellID->22438],
Cell[1505, 49, 669, 21, 70, "Usage",
 CellID->24539]
}, Open  ]],
Cell[CellGroupData[{
Cell[2211, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2689, 92, 279, 9, 70, "Notes",
 CellID->20425],
Cell[2971, 103, 2681, 71, 70, "3ColumnTableMod",
 CellID->1300],
Cell[5655, 176, 357, 13, 70, "Notes",
 CellID->11121],
Cell[6015, 191, 196, 8, 70, "Notes",
 CellID->1599734575]
}, Closed]],
Cell[CellGroupData[{
Cell[6248, 204, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322058633],
Cell[CellGroupData[{
Cell[6633, 218, 147, 5, 70, "ExampleSection",
 CellID->17013327],
Cell[6783, 225, 132, 3, 70, "Input",
 CellID->589390034],
Cell[6918, 230, 64, 1, 70, "ExampleText",
 CellID->925491420],
Cell[CellGroupData[{
Cell[7007, 235, 281, 9, 28, "Input",
 CellID->1597021023],
Cell[7291, 246, 972, 20, 252, "Output",
 Evaluatable->False,
 CellID->90822120]
}, Open  ]],
Cell[8278, 269, 82, 1, 70, "ExampleText",
 CellID->713561762],
Cell[CellGroupData[{
Cell[8385, 274, 327, 11, 28, "Input",
 CellID->1313504266],
Cell[8715, 287, 1140, 23, 252, "Output",
 Evaluatable->False,
 CellID->791471165]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9916, 317, 311, 9, 70, "SeeAlsoSection",
 CellID->14417],
Cell[10230, 328, 738, 26, 70, "SeeAlso",
 CellID->16505]
}, Open  ]],
Cell[10983, 357, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

