(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9394,        328]
NotebookOptionsPosition[      6982,        247]
NotebookOutlinePosition[      8189,        283]
CellTagsIndexPosition[      8105,        278]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BENCHMARKING PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Benchmarking Package" :> 
          Documentation`HelpLookup[
           "paclet:Benchmarking/tutorial/Benchmark"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Benchmarking Package\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BenchmarkReport" :> 
          Documentation`HelpLookup["paclet:Benchmarking/ref/BenchmarkReport"],
           "$BenchmarkSystems" :> 
          Documentation`HelpLookup[
           "paclet:Benchmarking/ref/$BenchmarkSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BenchmarkReport\"\>", 
       2->"\<\"$BenchmarkSystems\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Benchmark", "ObjectName",
 CellID->20434],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Benchmark", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]runs the ",
     StyleBox["MathematicaMark6",
      FontSlant->"Italic"],
     " benchmark. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The result is a data structure in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " that can be used with ",
 Cell[BoxData[
  ButtonBox["BenchmarkReport",
   BaseStyle->"Link",
   ButtonData->"paclet:Benchmarking/ref/BenchmarkReport"]], "InlineFormula"],
 " to create custom comparison reports."
}], "Notes",
 CellID->1990714497],

Cell[TextData[{
 "The ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark should take about 100 seconds to run on an Intel 2.4 GHz Pentium \
4."
}], "Notes",
 CellID->12106]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132870794],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->589996463],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Benchmarking`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->474979825],

Cell[TextData[{
 "Running the ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark:"
}], "ExampleText",
 CellID->749479911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Benchmark", "[", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell["\<\
{\"MachineName\" -> \"reference\", 
 \"System\" -> \"Microsoft Windows XP (32-bit)\", 
 \"BenchmarkName\" -> \"MathematicaMark6\", \"FullVersionNumber\" -> \
\"6.0.0\", 
 \"Date\" -> \"February 6, 2007\", \"BenchmarkResult\" -> 1., 
 \"TotalTime\" -> 86.19, \"Results\" -> {{\"Data Fitting\", 5.046}, 
   {\"Digits of Pi\", 1.234}, {\"Discrete Fourier Transform\", 3.}, 
   {\"Eigenvalues of a Matrix\", 8.843}, {\"Elementary Functions\", 7.499}, 
   {\"Gamma Function\", 0.922}, {\"Large Integer Multiplication\", 1.625}, 
   {\"Matrix Arithmetic\", 9.171}, {\"Matrix Multiplication\", 8.781}, 
   {\"Matrix Transpose\", 5.39}, {\"Numerical Integration\", 6.171}, 
   {\"Polynomial Expansion\", 5.671}, {\"Random Number Sort\", 4.514}, 
   {\"Singular Value Decomposition\", 9.419}, {\"Solving a Linear System\", 
    8.904}}}\
\>", "Output",
 ImageSize->{504, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->1880170954]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19910],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BenchmarkReport",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/BenchmarkReport"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BenchmarkSystems",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/$BenchmarkSystems"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23820],

Cell[TextData[ButtonBox["Benchmarking Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Benchmarking/tutorial/Benchmark"]], "Tutorials",
 CellID->31893]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Benchmark - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 16.9109276}", "context" -> 
    "Benchmarking`", "keywords" -> {}, "index" -> True, "label" -> 
    "Benchmarking Package Symbol", "language" -> "en", "paclet" -> 
    "Benchmarking Package", "status" -> "None", "summary" -> 
    "Benchmark[] runs the MathematicaMark6 benchmark. ", "synonyms" -> {}, 
    "title" -> "Benchmark", "type" -> "Symbol", "uri" -> 
    "Benchmarking/ref/Benchmark"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3630, 128, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->132870794]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7962, 271}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1369, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1992, 62, 47, 1, 70, "ObjectName",
 CellID->20434],
Cell[2042, 65, 418, 14, 70, "Usage",
 CellID->23095]
}, Open  ]],
Cell[CellGroupData[{
Cell[2497, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2975, 101, 424, 13, 70, "Notes",
 CellID->1990714497],
Cell[3402, 116, 191, 7, 70, "Notes",
 CellID->12106]
}, Closed]],
Cell[CellGroupData[{
Cell[3630, 128, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132870794],
Cell[CellGroupData[{
Cell[4015, 142, 148, 5, 70, "ExampleSection",
 CellID->589996463],
Cell[4166, 149, 135, 3, 70, "Input",
 CellID->474979825],
Cell[4304, 154, 140, 6, 70, "ExampleText",
 CellID->749479911],
Cell[CellGroupData[{
Cell[4469, 164, 80, 2, 28, "Input"],
Cell[4552, 168, 997, 20, 242, "Output",
 CellID->1880170954]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5610, 195, 311, 9, 70, "SeeAlsoSection",
 CellID->19910],
Cell[5924, 206, 509, 17, 70, "SeeAlso",
 CellID->12718]
}, Open  ]],
Cell[CellGroupData[{
Cell[6470, 228, 314, 9, 70, "TutorialsSection",
 CellID->23820],
Cell[6787, 239, 153, 3, 70, "Tutorials",
 CellID->31893]
}, Open  ]],
Cell[6955, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

