(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5151,        181]
NotebookOptionsPosition[      2954,        118]
NotebookOutlinePosition[      4268,        150]
CellTagsIndexPosition[      4225,        147]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Black-Body Radiation Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["BlackBodyProfile",
  BaseStyle->"Link",
  ButtonData->"paclet:BlackBodyRadiation/ref/BlackBodyProfile"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a plot of black-body spectral n-distribution profiles"
}], "GuideText",
 CellID->680239994],

Cell["\t", "GuideDelimiter",
 CellID->90889331],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaxPower",
  BaseStyle->"Link",
  ButtonData->"paclet:BlackBodyRadiation/ref/MaxPower"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " radiative power emitted by a black body at a wavelength"
}], "GuideText",
 CellID->226076834],

Cell[TextData[{
 Cell[TextData[ButtonBox["TotalPower",
  BaseStyle->"Link",
  ButtonData->"paclet:BlackBodyRadiation/ref/TotalPower"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " total radiative power emitted by a black body"
}], "GuideText",
 CellID->820831261],

Cell["\t", "GuideDelimiter",
 CellID->227699737],

Cell[TextData[{
 Cell[TextData[ButtonBox["PeakWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:BlackBodyRadiation/ref/PeakWavelength"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " wavelength of the maximum emission of a black body"
}], "GuideText",
 CellID->650149205]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Black-Body Radiation Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]], "GuideTutorial",
 CellID->224555667]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/guide/UnitsPackage"]], "GuideMoreAbout",
 CellID->382940300],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"],
  FontSlant->"Italic"],
 ButtonBox[" Data Collections",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"]
}], "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Black-Body Radiation Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 22.9892082}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Black Body Radiation Package Guide", "language" -> "en", "paclet" -> 
    "BlackBodyRadiation Package", "status" -> "None", "summary" -> 
    "BlackBodyProfile -- create a plot of black-body spectral n-distribution \
profiles, MaxPower -- radiative power emitted by a black body at a \
wavelength, TotalPower -- total radiative power emitted by a black body, \
PeakWavelength -- wavelength of the maximum emission of a black body", 
    "synonyms" -> {}, "title" -> "Black-Body Radiation Package", "type" -> 
    "Guide", "uri" -> "BlackBodyRadiation/guide/BlackBodyRadiationPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[692, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[751, 31, 322, 9, 70, "GuideText",
 CellID->680239994],
Cell[1076, 42, 47, 1, 70, "GuideDelimiter",
 CellID->90889331],
Cell[1126, 45, 301, 9, 70, "GuideText",
 CellID->226076834],
Cell[1430, 56, 295, 9, 70, "GuideText",
 CellID->820831261],
Cell[1728, 67, 48, 1, 70, "GuideDelimiter",
 CellID->227699737],
Cell[1779, 70, 308, 9, 70, "GuideText",
 CellID->650149205]
}, Open  ]],
Cell[CellGroupData[{
Cell[2124, 84, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[2189, 87, 187, 4, 70, "GuideTutorial",
 CellID->224555667]
}, Open  ]],
Cell[CellGroupData[{
Cell[2413, 96, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[2478, 99, 148, 3, 70, "GuideMoreAbout",
 CellID->382940300],
Cell[2629, 104, 283, 9, 70, "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],
Cell[2927, 116, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

