(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6761,        234]
NotebookOptionsPosition[      4993,        179]
NotebookOutlinePosition[      6119,        209]
CellTagsIndexPosition[      6076,        206]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BLACK BODY RADIATION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Black-Body Radiation Package" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Black-Body Radiation Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MaxPower" :> 
          Documentation`HelpLookup["paclet:BlackBodyRadiation/ref/MaxPower"], 
          "TotalPower" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/ref/TotalPower"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MaxPower\"\>", 
       2->"\<\"TotalPower\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PeakWavelength", "ObjectName",
 CellID->20336],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PeakWavelength", "[", 
       StyleBox["temp", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the wavelength of the maximum emission of a \
black body at the specified temperature ",
     Cell[BoxData[
      StyleBox["temp", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The temperature ",
 Cell[BoxData[
  StyleBox["temp", "TI"]], "InlineFormula"],
 " is typically measured in degrees Kelvin (",
 Cell[BoxData[
  ButtonBox["Kelvin",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kelvin"]], "InlineFormula"],
 "). For example: ",
 Cell[BoxData[
  RowBox[{"5000", " ", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7646]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14612],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxPower",
    BaseStyle->"Link",
    ButtonData->"paclet:BlackBodyRadiation/ref/MaxPower"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TotalPower",
    BaseStyle->"Link",
    ButtonData->"paclet:BlackBodyRadiation/ref/TotalPower"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32305],

Cell[TextData[ButtonBox["Black-Body Radiation Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]], "Tutorials",
 CellID->5556]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PeakWavelength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 23.5985988}", "context" -> 
    "BlackBodyRadiation`", "keywords" -> {}, "index" -> True, "label" -> 
    "Black Body Radiation Package Symbol", "language" -> "en", "paclet" -> 
    "BlackBodyRadiation Package", "status" -> "None", "summary" -> 
    "PeakWavelength[temp] gives the wavelength of the maximum emission of a \
black body at the specified temperature temp.", "synonyms" -> {}, "title" -> 
    "PeakWavelength", "type" -> "Symbol", "uri" -> 
    "BlackBodyRadiation/ref/PeakWavelength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1383, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2006, 63, 52, 1, 70, "ObjectName",
 CellID->20336],
Cell[2061, 66, 532, 16, 70, "Usage",
 CellID->1161]
}, Open  ]],
Cell[CellGroupData[{
Cell[2630, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3108, 104, 468, 17, 70, "Notes",
 CellID->7646]
}, Closed]],
Cell[CellGroupData[{
Cell[3613, 126, 311, 9, 70, "SeeAlsoSection",
 CellID->14612],
Cell[3927, 137, 492, 17, 70, "SeeAlso",
 CellID->3455]
}, Open  ]],
Cell[CellGroupData[{
Cell[4456, 159, 314, 9, 70, "TutorialsSection",
 CellID->32305],
Cell[4773, 170, 178, 4, 70, "Tutorials",
 CellID->5556]
}, Open  ]],
Cell[4966, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

