(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6307,        220]
NotebookOptionsPosition[      4561,        165]
NotebookOutlinePosition[      5666,        195]
CellTagsIndexPosition[      5623,        192]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BLACK BODY RADIATION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Black-Body Radiation Package" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Black-Body Radiation Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MaxPower" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/ref/MaxPower"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MaxPower\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TotalPower", "ObjectName",
 CellID->16041],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TotalPower", "[", 
       StyleBox["temp", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the total radiative power emitted by a black \
body at the specified temperature ",
     Cell[BoxData[
      StyleBox["temp", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->992]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The temperature ",
 Cell[BoxData[
  StyleBox["temp", "TI"]], "InlineFormula"],
 " is typically measured in degrees Kelvin (",
 Cell[BoxData[
  ButtonBox["Kelvin",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kelvin"]], "InlineFormula"],
 "). For example: ",
 Cell[BoxData[
  RowBox[{"5000", " ", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32629]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14848],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MaxPower",
   BaseStyle->"Link",
   ButtonData->"paclet:BlackBodyRadiation/ref/MaxPower"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->315]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26293],

Cell[TextData[ButtonBox["Black-Body Radiation Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]], "Tutorials",
 CellID->12267]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TotalPower - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 23.8798560}", "context" -> 
    "BlackBodyRadiation`", "keywords" -> {}, "index" -> True, "label" -> 
    "Black Body Radiation Package Symbol", "language" -> "en", "paclet" -> 
    "BlackBodyRadiation Package", "status" -> "None", "summary" -> 
    "TotalPower[temp] gives the total radiative power emitted by a black body \
at the specified temperature temp.", "synonyms" -> {}, "title" -> 
    "TotalPower", "type" -> "Symbol", "uri" -> 
    "BlackBodyRadiation/ref/TotalPower"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1242, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1865, 60, 48, 1, 70, "ObjectName",
 CellID->16041],
Cell[1916, 63, 522, 16, 70, "Usage",
 CellID->992]
}, Open  ]],
Cell[CellGroupData[{
Cell[2475, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2953, 101, 469, 17, 70, "Notes",
 CellID->32629]
}, Closed]],
Cell[CellGroupData[{
Cell[3459, 123, 311, 9, 70, "SeeAlsoSection",
 CellID->14848],
Cell[3773, 134, 213, 6, 70, "SeeAlso",
 CellID->315]
}, Open  ]],
Cell[CellGroupData[{
Cell[4023, 145, 314, 9, 70, "TutorialsSection",
 CellID->26293],
Cell[4340, 156, 179, 4, 70, "Tutorials",
 CellID->12267]
}, Open  ]],
Cell[4534, 163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

