(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18148,        491]
NotebookOptionsPosition[     15127,        397]
NotebookOutlinePosition[     16756,        438]
CellTagsIndexPosition[     16713,        435]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BLACK BODY RADIATION PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BlackBodyProfile" :> 
         Documentation`HelpLookup[
          "paclet:BlackBodyRadiation/ref/BlackBodyProfile"], "MaxPower" :> 
         Documentation`HelpLookup["paclet:BlackBodyRadiation/ref/MaxPower"], 
         "PeakWavelength" :> 
         Documentation`HelpLookup[
          "paclet:BlackBodyRadiation/ref/PeakWavelength"], "TotalPower" :> 
         Documentation`HelpLookup[
          "paclet:BlackBodyRadiation/ref/TotalPower"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"BlackBodyProfile\"\>", 2->"\<\"MaxPower\"\>", 
      3->"\<\"PeakWavelength\"\>", 
      4->"\<\"TotalPower\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Black-Body Radiation Package", "Title",
 CellID->24544],

Cell["\<\
A body that absorbs all radiation incident on it is called an ideal black \
body. This package provides functions giving the basic properties of black\
\[Hyphen]body radiation at a specified temperature, and a function for \
plotting black\[Hyphen]body spectral distributions. \
\>", "Text",
 CellID->20165],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PeakWavelength",
      BaseStyle->"Link",
      ButtonData->"paclet:BlackBodyRadiation/ref/PeakWavelength"], "[", 
     StyleBox["temp", "TI"], "]"}], Cell["\<\
wavelength of the maximum emission of a black body at the specified \
temperature\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["TotalPower",
      BaseStyle->"Link",
      ButtonData->"paclet:BlackBodyRadiation/ref/TotalPower"], "[", 
     StyleBox["temp", "TI"], "]"}], Cell[
    "total power of a black body at the specified temperature", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["MaxPower",
      BaseStyle->"Link",
      ButtonData->"paclet:BlackBodyRadiation/ref/MaxPower"], "[", 
     StyleBox["temp", "TI"], ",", 
     StyleBox["band", "TI"], "]"}], Cell["\<\
power of a black body at the specified temperature for the specified \
wavelength band about the peak wavelength \
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->18503],

Cell["\<\
Black\[Hyphen]body radiation properties. \
\>", "Caption",
 CellID->28770],

Cell["This loads the package. ", "MathCaption",
 CellID->17569],

Cell[BoxData[
 RowBox[{"<<", "BlackBodyRadiation`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->739],

Cell["\<\
The surface of the sun is about 5000 K. Assuming the sun is a \
black\[Hyphen]body radiator, this gives the wavelength at which its spectrum \
peaks. \
\>", "MathCaption",
 CellID->29968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PeakWavelength", "[", 
  RowBox[{"5000", " ", "Kelvin"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15837],

Cell[BoxData[
 RowBox[{"5.8`*^-7", " ", "Meter"}]], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->120083640]
}, Open  ]],

Cell["\<\
This gives the total power radiated by a black body at a temperature of 5000 \
K. \
\>", "MathCaption",
 CellID->7456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotalPower", "[", 
  RowBox[{"5000", " ", "Kelvin"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23388],

Cell[BoxData[
 FractionBox[
  RowBox[{"3.543999590227373`*^7", " ", "Watt"}], 
  SuperscriptBox["Meter", "2"]]], "Output",
 ImageSize->{105, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->379648026]
}, Open  ]],

Cell[TextData[{
 "This gives the radiative power in the wavelength interval of 0.1 ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
 " about the peak wavelength of a black body at a temperature of 5000 K. "
}], "MathCaption",
 CellID->6296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxPower", "[", 
  RowBox[{
   RowBox[{"5000", " ", "Kelvin"}], ",", 
   FractionBox["Meter", 
    SuperscriptBox["10", "7"]]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23658],

Cell[BoxData[
 FractionBox[
  RowBox[{"4.0178445561290155`*^6", " ", "Watt"}], 
  SuperscriptBox["Meter", "2"]]], "Output",
 ImageSize->{119, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->779474978]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BlackBodyProfile",
      BaseStyle->"Link",
      ButtonData->"paclet:BlackBodyRadiation/ref/BlackBodyProfile"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["temp", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["temp", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell["\<\
plot the black\[Hyphen]body spectral distribution profiles at the specified \
temperatures \
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->9420],

Cell["Plotting black\[Hyphen]body profiles. ", "Caption",
 CellID->23832],

Cell["\<\
This gives the spectral distribution of radiation from a black body for three \
different temperatures. \
\>", "MathCaption",
 CellID->25],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlackBodyProfile", "[", 
  RowBox[{
   RowBox[{"4000", " ", "Kelvin"}], ",", 
   RowBox[{"5000", " ", "Kelvin"}], ",", 
   RowBox[{"6000", " ", "Kelvin"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2.0", "\[Times]", 
         SuperscriptBox["10", 
          RowBox[{"-", "6"}]]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"1.1", "\[Times]", 
         SuperscriptBox["10", "14"]}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29276],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->80751969]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["BlackBodyProfile",
   BaseStyle->"Link",
   ButtonData->"paclet:BlackBodyRadiation/ref/BlackBodyProfile"]], 
  "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " in order to specify different styles for each profile curve."
}], "Text",
 CellID->1769141320]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Black-Body Radiation Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 24.2548656}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Black Body Radiation Package Tutorial", "language" -> "en", "paclet" -> 
    "BlackBodyRadiation Package", "status" -> "None", "summary" -> 
    "A body that absorbs all radiation incident on it is called an ideal \
black body. This package provides functions giving the basic properties of \
black-body radiation at a specified temperature, and a function for plotting \
black-body spectral distributions. Black-body radiation properties. This \
loads the package. ", "synonyms" -> {}, "title" -> 
    "Black-Body Radiation Package", "type" -> "Tutorial", "uri" -> 
    "BlackBodyRadiation/tutorial/BlackBodyRadiation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1039, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1664, 50, 61, 1, 70, "Title",
 CellID->24544],
Cell[1728, 53, 317, 6, 70, "Text",
 CellID->20165],
Cell[2048, 61, 1117, 33, 70, "DefinitionBox",
 CellID->18503],
Cell[3168, 96, 84, 3, 70, "Caption",
 CellID->28770],
Cell[3255, 101, 63, 1, 70, "MathCaption",
 CellID->17569],
Cell[3321, 104, 100, 3, 70, "Input",
 CellID->739],
Cell[3424, 109, 197, 5, 70, "MathCaption",
 CellID->29968],
Cell[CellGroupData[{
Cell[3646, 118, 137, 4, 28, "Input",
 CellID->15837],
Cell[3786, 124, 191, 6, 36, "Output",
 CellID->120083640]
}, Open  ]],
Cell[3992, 133, 128, 4, 70, "MathCaption",
 CellID->7456],
Cell[CellGroupData[{
Cell[4145, 141, 133, 4, 70, "Input",
 CellID->23388],
Cell[4281, 147, 253, 8, 55, "Output",
 CellID->379648026]
}, Open  ]],
Cell[4549, 158, 262, 6, 70, "MathCaption",
 CellID->6296],
Cell[CellGroupData[{
Cell[4836, 168, 208, 7, 70, "Input",
 CellID->23658],
Cell[5047, 177, 254, 8, 55, "Output",
 CellID->779474978]
}, Open  ]],
Cell[5316, 188, 707, 22, 70, "DefinitionBox",
 CellID->9420],
Cell[6026, 212, 73, 1, 70, "Caption",
 CellID->23832],
Cell[6102, 215, 148, 4, 70, "MathCaption",
 CellID->25],
Cell[CellGroupData[{
Cell[6275, 223, 613, 19, 49, "Input",
 CellID->29276],
Cell[6891, 244, 7751, 131, 210, "Output",
 Evaluatable->False,
 CellID->80751969]
}, Open  ]],
Cell[14657, 378, 428, 14, 70, "Text",
 CellID->1769141320]
}, Open  ]],
Cell[15100, 395, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

