(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41245,       1570]
NotebookOptionsPosition[     26447,       1048]
NotebookOutlinePosition[     32192,       1235]
CellTagsIndexPosition[     32078,       1229]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
          "DayOfWeek" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/DayOfWeek"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"DateList\"\>", 
       2->"\<\"DayOfWeek\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DateQ", "ObjectName",
 CellID->306556375],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DateQ", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["year", "TI"], ",", 
         StyleBox["month", "TI"], ",", 
         StyleBox["day", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if date ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"]}], "}"}]], "InlineFormula"],
     " is a valid date in the current calendar system, and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DateQ", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["year", "TI"], ",", 
         StyleBox["month", "TI"], ",", 
         StyleBox["day", "TI"], ",", 
         StyleBox["hour", "TI"], ",", 
         StyleBox["minute", "TI"], ",", 
         StyleBox["second", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]date given in long form ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"], ",", 
        StyleBox["hour", "TI"], ",", 
        StyleBox["minute", "TI"], ",", 
        StyleBox["second", "TI"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->300829608]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->27273356],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Calendar",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Calendar"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies which calendar system to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->156279591],

Cell[TextData[{
 "The default calendar is the usual Western (American) calendar, but can be \
changed with the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->304489222],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["Calendar"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Jewish",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Jewish"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->92043307]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570718725],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->142383052],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell[TextData[{
 Cell[BoxData["DateQ"], "InlineFormula"],
 " recognizes ordinary Western dates:"
}], "ExampleText",
 CellID->259876615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->150062282],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->2217014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->425256619],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->250777325],

Cell[TextData[{
 Cell[BoxData["DateQ"], "InlineFormula"],
 " will identify leap years. The year 2000 was a leap year:"
}], "ExampleText",
 CellID->188625731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"2000", ",", " ", "2", ",", " ", "29"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->414752082],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->373341768]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87492009],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->516266307],

Cell["The year 1900 was not a leap year:", "ExampleText",
 CellID->508935046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"1900", ",", " ", "2", ",", " ", "29"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->172429365],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->127530876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286336396],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->353805177],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the standard Western (British American) calendar. The British \
American calendar applies the Julian calendar to dates before 1752 and the \
Gregorian calendar after:"
}], "ExampleText",
 CellID->94555647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"1700", ",", " ", "2", ",", " ", "29"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->417824246],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->407642903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"1900", ",", " ", "2", ",", " ", "29"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->350832098],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->165731453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4123617],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->85609124],

Cell["\<\
The default British American calendar deletes dates after September 2, 1752 \
and before September 13, 1752:\
\>", "ExampleText",
 CellID->438063517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"1752", ",", " ", "9", ",", " ", "3"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->200937894],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->11493774]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"1752", ",", " ", "9", ",", " ", "12"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->633595648],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->686873572]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->826725],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Calendar",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->261327167],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->132175881],

Cell[TextData[{
 "Catholic countries adopted the modern Gregorian calendar in 1582 while \
Britain and her colonies conserved the Julian calendar until 1752. By \
default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the British calendar, so dates in Catholic countries after October \
14, 1582 and before September 14, 1752 require the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " option.\nIn France, 1700 was not a leap year:"
}], "ExampleText",
 CellID->833986369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1700", ",", " ", "2", ",", " ", "29"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->92427465],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->194103822]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->819692366],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->289110843],

Cell["\<\
Britain was still using the Julian calendar where all centuries were leap \
years:\
\>", "ExampleText",
 CellID->319973268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"1700", ",", " ", "2", ",", " ", "29"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->731542362],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->78198668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278854828],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->55932308],

Cell["\<\
Catholic countries did not delete any days in September 1752:\
\>", "ExampleText",
 CellID->305142380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1752", ",", " ", "9", ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->445675392],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->169580254]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292018541],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->88878404],

Cell["\<\
The Russian Orthodox church has retained the Julian Calendar. Their year 1900 \
was a leap year:\
\>", "ExampleText",
 CellID->109343831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", " ", "2", ",", " ", "29"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Julian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->105239378],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->425046589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446021633],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->39993181],

Cell["\<\
The Islamic calendar has leap years (the 12th month has 29 or 30 days):\
\>", "ExampleText",
 CellID->78465965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1420", ",", " ", "12", ",", " ", "30"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->324416159],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->580136309]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1421", ",", " ", "12", ",", " ", "30"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->18212655],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->120605422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427595757],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->20317339],

Cell["The Jewish calendar has a leap month (13 months):", "ExampleText",
 CellID->715322205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5760", ",", " ", "13", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->615370764],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->398707997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5761", ",", " ", "13", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->110265301],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->309458647]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6030434],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->571107430],

Cell[TextData[{
 Cell[BoxData["DateQ"], "InlineFormula"],
 " can identify leap years:"
}], "ExampleText",
 CellID->463525971],

Cell[BoxData[
 RowBox[{
  RowBox[{"LeapYearQ", "[", 
   RowBox[{"year_", ",", " ", "Options___"}], "]"}], ":=", " ", 
  RowBox[{"DateQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"year", ",", " ", "2", ",", " ", "29"}], "}"}], ",", " ", 
    "Options"}], "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->65180715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapYearQ", "[", "2000", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->220825404],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->599303750]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapYearQ", "[", "1900", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->780520644],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->360992151]
}, Open  ]],

Cell[TextData[{
 "The default Calendar is ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " for dates prior to 1752, so 1700 is given as a leap year:"
}], "ExampleText",
 CellID->73343805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapYearQ", "[", "1700", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[5]:=",
 CellID->306625188],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[5]=",
 CellID->278659078]
}, Open  ]],

Cell["\<\
In Catholic countries, the Gregorian calendar was already used so 1700 was \
not a leap year:\
\>", "ExampleText",
 CellID->62466455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapYearQ", "[", 
  RowBox[{"1700", ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[6]:=",
 CellID->34708558],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[6]=",
 CellID->41136342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17202776],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->61526679],

Cell[TextData[{
 Cell[BoxData["DateQ"], "InlineFormula"],
 " can identify Islamic leap years (the 12th month has 30 days):"
}], "ExampleText",
 CellID->8160373],

Cell[BoxData[
 RowBox[{
  RowBox[{"LeapYearQ", "[", 
   RowBox[{"year_", ",", " ", 
    RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}], ":=", " ", 
  RowBox[{"DateQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"year", ",", " ", "12", ",", " ", "30"}], "}"}], ",", " ", 
    RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->5232569],

Cell["The year 1400 was not a leap year:", "ExampleText",
 CellID->59842799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapYearQ", "[", 
  RowBox[{"1400", ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->30982014],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->68779066]
}, Open  ]],

Cell["The year 1401 was a leap year:", "ExampleText",
 CellID->77399028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapYearQ", "[", 
  RowBox[{"1401", ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->570625763],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->258840342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246477308],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->230754029],

Cell[TextData[{
 Cell[BoxData["DateQ"], "InlineFormula"],
 " can identify Jewish years with a leap month (year has 13 months):"
}], "ExampleText",
 CellID->112615218],

Cell[BoxData[
 RowBox[{
  RowBox[{"LeapMonthYearQ", "[", 
   RowBox[{"year_", ",", " ", 
    RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}], ":=", " ", 
  RowBox[{"DateQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"year", ",", " ", "13", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->27148857],

Cell["The year 5760 had a leap month", "ExampleText",
 CellID->133673071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapMonthYearQ", "[", 
  RowBox[{"5760", ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->215430078],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->58857162]
}, Open  ]],

Cell["The year 5761 did not have a leap month", "ExampleText",
 CellID->213156389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeapMonthYearQ", "[", 
  RowBox[{"5761", ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->478242342],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->438933591]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->890105648],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DayOfWeek",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/DayOfWeek"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->140424135]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3587285],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DateQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 31.3019210}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "DateQ[{year, month, day}] yields True if date {year, month, day} is a \
valid date in the current calendar system, and yields False otherwise. \
DateQ[{year, month, day, hour, minute, second}] date given in long form \
{year, month, day, hour, minute, second}.", "synonyms" -> {}, "title" -> 
    "DateQ", "type" -> "Symbol", "uri" -> "Calendar/ref/DateQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5987, 206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->570718725]},
 "CellTags"->{
  Cell[6817, 240, 194, 6, 28, "Input",
   CellTags->"CellTags",
   CellID->150062282],
  Cell[7014, 248, 182, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->2217014],
  Cell[7655, 275, 195, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->414752082],
  Cell[7853, 283, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->373341768],
  Cell[8415, 307, 195, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->172429365],
  Cell[8613, 315, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->127530876],
  Cell[9395, 346, 195, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->417824246],
  Cell[9593, 354, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->407642903],
  Cell[9814, 365, 195, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->350832098],
  Cell[10012, 373, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->165731453],
  Cell[10655, 400, 194, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->200937894],
  Cell[10852, 408, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->11493774],
  Cell[11073, 419, 195, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->633595648],
  Cell[11271, 427, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->686873572],
  Cell[12713, 482, 274, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->92427465],
  Cell[12990, 492, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->194103822],
  Cell[13610, 519, 195, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->731542362],
  Cell[13808, 527, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->78198668],
  Cell[14404, 553, 274, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->445675392],
  Cell[14681, 563, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->169580254],
  Cell[15313, 590, 272, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->105239378],
  Cell[15588, 600, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->425046589],
  Cell[16194, 626, 274, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->324416159],
  Cell[16471, 636, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->580136309],
  Cell[16692, 647, 273, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->18212655],
  Cell[16968, 657, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->120605422],
  Cell[17546, 681, 272, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->615370764],
  Cell[17821, 691, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->398707997],
  Cell[18042, 702, 272, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->110265301],
  Cell[18317, 712, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->309458647],
  Cell[19053, 745, 345, 11, 70, "Input",
   CellTags->"CellTags",
   CellID->65180715],
  Cell[19423, 760, 131, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->220825404],
  Cell[19557, 766, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->599303750],
  Cell[19778, 777, 131, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->780520644],
  Cell[19912, 783, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->360992151],
  Cell[20405, 804, 131, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->306625188],
  Cell[20539, 810, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->278659078],
  Cell[20906, 827, 208, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->34708558],
  Cell[21117, 835, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->41136342],
  Cell[21739, 860, 423, 12, 70, "Input",
   CellTags->"CellTags",
   CellID->5232569],
  Cell[22266, 879, 206, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->30982014],
  Cell[22475, 887, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->68779066],
  Cell[22771, 901, 207, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->570625763],
  Cell[22981, 909, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->258840342],
  Cell[23611, 934, 426, 12, 70, "Input",
   CellTags->"CellTags",
   CellID->27148857],
  Cell[24138, 953, 211, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->215430078],
  Cell[24352, 961, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->58857162],
  Cell[24657, 975, 211, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->478242342],
  Cell[24871, 983, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->438933591]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27605, 1074},
 {"CellTags", 27740, 1078}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1256, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1879, 59, 47, 1, 70, "ObjectName",
 CellID->306556375],
Cell[1929, 62, 1808, 56, 70, "Usage",
 CellID->300829608]
}, Open  ]],
Cell[CellGroupData[{
Cell[3774, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4252, 140, 71, 1, 70, "Notes",
 CellID->27273356],
Cell[4326, 143, 548, 15, 70, "3ColumnTableMod",
 CellID->156279591],
Cell[4877, 160, 286, 9, 70, "Notes",
 CellID->304489222],
Cell[5166, 171, 784, 30, 70, "Notes",
 CellID->92043307]
}, Closed]],
Cell[CellGroupData[{
Cell[5987, 206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570718725],
Cell[CellGroupData[{
Cell[6372, 220, 148, 5, 70, "ExampleSection",
 CellID->142383052],
Cell[6523, 227, 131, 3, 70, "Input",
 CellID->518473573],
Cell[6657, 232, 135, 4, 70, "ExampleText",
 CellID->259876615],
Cell[CellGroupData[{
Cell[6817, 240, 194, 6, 28, "Input",
 CellTags->"CellTags",
 CellID->150062282],
Cell[7014, 248, 182, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->2217014]
}, Open  ]],
Cell[7211, 257, 125, 3, 70, "ExampleDelimiter",
 CellID->425256619],
Cell[7339, 262, 131, 3, 70, "Input",
 CellID->250777325],
Cell[7473, 267, 157, 4, 70, "ExampleText",
 CellID->188625731],
Cell[CellGroupData[{
Cell[7655, 275, 195, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->414752082],
Cell[7853, 283, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->373341768]
}, Open  ]],
Cell[8052, 292, 124, 3, 70, "ExampleDelimiter",
 CellID->87492009],
Cell[8179, 297, 131, 3, 70, "Input",
 CellID->516266307],
Cell[8313, 302, 77, 1, 70, "ExampleText",
 CellID->508935046],
Cell[CellGroupData[{
Cell[8415, 307, 195, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->172429365],
Cell[8613, 315, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->127530876]
}, Open  ]],
Cell[8813, 324, 125, 3, 70, "ExampleDelimiter",
 CellID->286336396],
Cell[8941, 329, 131, 3, 70, "Input",
 CellID->353805177],
Cell[9075, 334, 295, 8, 70, "ExampleText",
 CellID->94555647],
Cell[CellGroupData[{
Cell[9395, 346, 195, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->417824246],
Cell[9593, 354, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->407642903]
}, Open  ]],
Cell[CellGroupData[{
Cell[9814, 365, 195, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->350832098],
Cell[10012, 373, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->165731453]
}, Open  ]],
Cell[10212, 382, 123, 3, 70, "ExampleDelimiter",
 CellID->4123617],
Cell[10338, 387, 130, 3, 70, "Input",
 CellID->85609124],
Cell[10471, 392, 159, 4, 70, "ExampleText",
 CellID->438063517],
Cell[CellGroupData[{
Cell[10655, 400, 194, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->200937894],
Cell[10852, 408, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->11493774]
}, Open  ]],
Cell[CellGroupData[{
Cell[11073, 419, 195, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->633595648],
Cell[11271, 427, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->686873572]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11505, 439, 219, 7, 70, "ExampleSection",
 CellID->826725],
Cell[CellGroupData[{
Cell[11749, 450, 229, 7, 70, "ExampleSubsection",
 CellID->261327167],
Cell[11981, 459, 131, 3, 70, "Input",
 CellID->132175881],
Cell[12115, 464, 573, 14, 70, "ExampleText",
 CellID->833986369],
Cell[CellGroupData[{
Cell[12713, 482, 274, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->92427465],
Cell[12990, 492, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->194103822]
}, Open  ]],
Cell[13190, 501, 125, 3, 70, "ExampleDelimiter",
 CellID->819692366],
Cell[13318, 506, 131, 3, 70, "Input",
 CellID->289110843],
Cell[13452, 511, 133, 4, 70, "ExampleText",
 CellID->319973268],
Cell[CellGroupData[{
Cell[13610, 519, 195, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->731542362],
Cell[13808, 527, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->78198668]
}, Open  ]],
Cell[14006, 536, 125, 3, 70, "ExampleDelimiter",
 CellID->278854828],
Cell[14134, 541, 130, 3, 70, "Input",
 CellID->55932308],
Cell[14267, 546, 112, 3, 70, "ExampleText",
 CellID->305142380],
Cell[CellGroupData[{
Cell[14404, 553, 274, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->445675392],
Cell[14681, 563, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->169580254]
}, Open  ]],
Cell[14880, 572, 125, 3, 70, "ExampleDelimiter",
 CellID->292018541],
Cell[15008, 577, 130, 3, 70, "Input",
 CellID->88878404],
Cell[15141, 582, 147, 4, 70, "ExampleText",
 CellID->109343831],
Cell[CellGroupData[{
Cell[15313, 590, 272, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->105239378],
Cell[15588, 600, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->425046589]
}, Open  ]],
Cell[15787, 609, 125, 3, 70, "ExampleDelimiter",
 CellID->446021633],
Cell[15915, 614, 130, 3, 70, "Input",
 CellID->39993181],
Cell[16048, 619, 121, 3, 70, "ExampleText",
 CellID->78465965],
Cell[CellGroupData[{
Cell[16194, 626, 274, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->324416159],
Cell[16471, 636, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->580136309]
}, Open  ]],
Cell[CellGroupData[{
Cell[16692, 647, 273, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->18212655],
Cell[16968, 657, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->120605422]
}, Open  ]],
Cell[17168, 666, 125, 3, 70, "ExampleDelimiter",
 CellID->427595757],
Cell[17296, 671, 130, 3, 70, "Input",
 CellID->20317339],
Cell[17429, 676, 92, 1, 70, "ExampleText",
 CellID->715322205],
Cell[CellGroupData[{
Cell[17546, 681, 272, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->615370764],
Cell[17821, 691, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->398707997]
}, Open  ]],
Cell[CellGroupData[{
Cell[18042, 702, 272, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->110265301],
Cell[18317, 712, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->309458647]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18563, 725, 225, 7, 70, "ExampleSection",
 CellID->6030434],
Cell[18791, 734, 131, 3, 70, "Input",
 CellID->571107430],
Cell[18925, 739, 125, 4, 70, "ExampleText",
 CellID->463525971],
Cell[19053, 745, 345, 11, 70, "Input",
 CellTags->"CellTags",
 CellID->65180715],
Cell[CellGroupData[{
Cell[19423, 760, 131, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->220825404],
Cell[19557, 766, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->599303750]
}, Open  ]],
Cell[CellGroupData[{
Cell[19778, 777, 131, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->780520644],
Cell[19912, 783, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->360992151]
}, Open  ]],
Cell[20112, 792, 268, 8, 70, "ExampleText",
 CellID->73343805],
Cell[CellGroupData[{
Cell[20405, 804, 131, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->306625188],
Cell[20539, 810, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->278659078]
}, Open  ]],
Cell[20738, 819, 143, 4, 70, "ExampleText",
 CellID->62466455],
Cell[CellGroupData[{
Cell[20906, 827, 208, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->34708558],
Cell[21117, 835, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->41136342]
}, Open  ]],
Cell[21316, 844, 124, 3, 70, "ExampleDelimiter",
 CellID->17202776],
Cell[21443, 849, 130, 3, 70, "Input",
 CellID->61526679],
Cell[21576, 854, 160, 4, 70, "ExampleText",
 CellID->8160373],
Cell[21739, 860, 423, 12, 70, "Input",
 CellTags->"CellTags",
 CellID->5232569],
Cell[22165, 874, 76, 1, 70, "ExampleText",
 CellID->59842799],
Cell[CellGroupData[{
Cell[22266, 879, 206, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->30982014],
Cell[22475, 887, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->68779066]
}, Open  ]],
Cell[22674, 896, 72, 1, 70, "ExampleText",
 CellID->77399028],
Cell[CellGroupData[{
Cell[22771, 901, 207, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->570625763],
Cell[22981, 909, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->258840342]
}, Open  ]],
Cell[23180, 918, 125, 3, 70, "ExampleDelimiter",
 CellID->246477308],
Cell[23308, 923, 131, 3, 70, "Input",
 CellID->230754029],
Cell[23442, 928, 166, 4, 70, "ExampleText",
 CellID->112615218],
Cell[23611, 934, 426, 12, 70, "Input",
 CellTags->"CellTags",
 CellID->27148857],
Cell[24040, 948, 73, 1, 70, "ExampleText",
 CellID->133673071],
Cell[CellGroupData[{
Cell[24138, 953, 211, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->215430078],
Cell[24352, 961, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->58857162]
}, Open  ]],
Cell[24550, 970, 82, 1, 70, "ExampleText",
 CellID->213156389],
Cell[CellGroupData[{
Cell[24657, 975, 211, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->478242342],
Cell[24871, 983, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->438933591]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25117, 996, 315, 9, 70, "SeeAlsoSection",
 CellID->890105648],
Cell[25435, 1007, 466, 17, 70, "SeeAlso",
 CellID->140424135]
}, Open  ]],
Cell[CellGroupData[{
Cell[25938, 1029, 316, 9, 70, "TutorialsSection",
 CellID->3587285],
Cell[26257, 1040, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[26420, 1046, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

