(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41354,       1534]
NotebookOptionsPosition[     28382,       1078]
NotebookOutlinePosition[     32773,       1220]
CellTagsIndexPosition[     32659,       1214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DaysBetween" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/DaysBetween"], 
          "DaysPlus" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/DaysPlus"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DaysBetween\"\>", 
       2->"\<\"DaysPlus\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DayOfWeek", "ObjectName",
 CellID->44580209],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DayOfWeek", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["year", "TI"], ",", 
         StyleBox["month", "TI"], ",", 
         StyleBox["day", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the day of the week on which the given date ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"]}], "}"}]], "InlineFormula"],
     " occurred."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DayOfWeek", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["year", "TI"], ",", 
         StyleBox["month", "TI"], ",", 
         StyleBox["day", "TI"], ",", 
         StyleBox["hour", "TI"], ",", 
         StyleBox["minute", "TI"], ",", 
         StyleBox["second", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the day of the week for the given date."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->380029146]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->698165793],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Calendar",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Calendar"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies which calendar system to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->257750897],

Cell[TextData[{
 "The default calendar is the usual Western (American) calendar, but can be \
changed with the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->390650514],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["Calendar"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Jewish",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Jewish"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->163358871]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274074985],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->730510658],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell["The Declaration of Independence was signed on a Thursday:", \
"ExampleText",
 CellID->210515354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1776", ",", " ", "7", ",", " ", "4"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->42275686],

Cell[BoxData["Thursday"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->738323875]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65656534],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->127871431],

Cell["The Bastille was stormed on a Tuesday:", "ExampleText",
 CellID->526480410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1789", ",", " ", "7", ",", " ", "14"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->171324951],

Cell[BoxData["Tuesday"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->68316738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1598750],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->608544368],

Cell["Canada became an independent nation on a Monday:", "ExampleText",
 CellID->2348223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1867", ",", " ", "7", ",", " ", "1"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->382865139],

Cell[BoxData["Monday"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->31670784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->592224128],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->27995573],

Cell["Wolfram Research began on a Saturday:", "ExampleText",
 CellID->207786348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1959", ",", " ", "8", ",", " ", "29"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->170071102],

Cell[BoxData["Saturday"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->70451977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->388230981],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->175631837],

Cell["\<\
This gives the day of the week at the time the formula was input:\
\>", "ExampleText",
 CellID->367424983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"DateList", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->462994191],

Cell[BoxData["Thursday"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->465349560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10350311],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->126142671],

Cell["Hours, minutes, seconds do not affect the day of the week:", \
"ExampleText",
 CellID->77044837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DayOfWeek", "[", 
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], "]"}], " ", "==", 
  " ", 
  RowBox[{"DayOfWeek", "[", 
   RowBox[{"{", 
    RowBox[{
    "2000", ",", " ", "1", ",", " ", "1", ",", " ", "1", ",", " ", "1", ",", 
     " ", "1"}], "}"}], "]"}], " ", "==", " ", 
  RowBox[{"DayOfWeek", "[", 
   RowBox[{"{", 
    RowBox[{
    "2000", ",", " ", "1", ",", " ", "1", ",", " ", "23", ",", " ", "59", ",",
      " ", "59"}], "}"}], "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->209563650],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->92142797]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->113550562],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Calendar",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->312425969],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->38044769],

Cell[TextData[{
 "Dates in Catholic countries after October 14, 1582 and before September 14, \
1752 require the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " option.\nLouis XIV was born on a Sunday:"
}], "ExampleText",
 CellID->221284867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1638", ",", " ", "9", ",", " ", "5"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->336451069],

Cell[BoxData["Sunday"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->38527185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->843489],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->307401457],

Cell[TextData[{
 "Russian Orthodox dates require the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " option. Russian Orthodox Christmas 2000 was on a Sunday:"
}], "ExampleText",
 CellID->147381382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "12", ",", " ", "25"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Julian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->238195362],

Cell[BoxData["Sunday"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->10569301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347696200],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->65008777],

Cell["The Islamic calendar begins on a Friday:", "ExampleText",
 CellID->26547458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "\[Rule]", " ", "Islamic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30875053],

Cell[BoxData["Friday"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158881242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170230319],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->894088999],

Cell["\<\
This date corresponds to one attribution of the Hejira, July 16, 622 in the \
Western (Julian) calendar:\
\>", "ExampleText",
 CellID->106619854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"622", ",", " ", "7", ",", " ", "16"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187638644],

Cell[BoxData["Friday"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->213147396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->210877869],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->117994317],

Cell["By definition, Yom Kippur cannot fall on a Friday or Sunday:", \
"ExampleText",
 CellID->663636041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DayOfWeek", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "7", ",", " ", "10"}], "}"}], ",", " ", 
      RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}], "&"}], " ", "/@",
    " ", 
   RowBox[{"Range", "[", 
    RowBox[{"5700", ",", " ", "5800"}], "]"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->136400753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Monday", ",", "Saturday", ",", "Thursday", ",", "Wednesday"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->650101461]
}, Open  ]],

Cell[TextData[{
 "Because the Jewish calendar has a leap month preceding Passover, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a numbering starting with Nissan, the month of Passover, and Tishrei, \
the first month of the Jewish year, is number 7."
}], "ExampleText",
 CellID->18023314],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
   "Nissan", ",", " ", "Iyar", ",", " ", "Sivan", ",", " ", "Tammuz", ",", 
    " ", "Av", ",", " ", "Elul", ",", " ", "Tishrei", ",", " ", "Chesvan", 
    ",", " ", "Kislev", ",", " ", "Tevet", ",", " ", "Shvat", ",", " ", 
    "Adar", ",", " ", "AdarII"}], "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->826448632]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6547853],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->631104188],

Cell[TextData[{
 StyleBox["By definition, ", "ExampleText"],
 "the Western calendar rules follow a 400 year cycle. This cycle also \
includes days of the week since:"
}], "ExampleText",
 CellID->450885522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DayOfWeek", "[", 
   RowBox[{"{", 
    RowBox[{"2001", ",", " ", "1", ",", " ", "1"}], "}"}], "]"}], " ", 
  "\[Equal]", " ", 
  RowBox[{"DayOfWeek", "[", 
   RowBox[{"{", 
    RowBox[{"2401", ",", " ", "1", ",", " ", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->259733080],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102528285]
}, Open  ]],

Cell["\<\
That is, the 400 year cycle has an integral number of weeks (otherwise, the \
cycle would have 2800 years).\
\>", "ExampleText",
 CellID->120888810],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70148782],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->132391389],

Cell["A century never begins on a Sunday:", "ExampleText",
 CellID->423738341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2001", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2101", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2201", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2301", ",", " ", "1", ",", " ", "1"}], "}"}]}], 
   "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->621884921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Monday", ",", "Saturday", ",", "Thursday", ",", "Tuesday"}], 
  "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->20993421]
}, Open  ]],

Cell["No matter how beginning of century is defined:", "ExampleText",
 CellID->513727549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"DayOfWeek", " ", "/@", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2100", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2200", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2300", ",", " ", "1", ",", " ", "1"}], "}"}]}], 
    "}"}]}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->210476491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Saturday", ",", "Friday", ",", "Wednesday", ",", "Monday"}], 
  "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->138873678]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->72551731],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->78428307],

Cell[TextData[{
 "The Western calendar was modified from ",
 Cell[BoxData["Julian"], "InlineFormula"],
 " to ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " for better accuracy. The change deleted 10 days in October 1582 in \
Catholic countries and deleted 11 days in September 1752 in Britain and her \
colonies. By default, ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "applies the British (American) version. These calendar changes did not \
affect the day of the week, so there is an issue for ",
 Cell[BoxData["DayOfWeek"], "InlineFormula"],
 " concerning dates after October 14, 1582 and before September 14, 1752.",
 " ",
 "For British dates, the default gives the correct answer. For dates in \
Catholic countries, one must use the ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " option for ",
 Cell[BoxData["Calendar"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->361193654],

Cell["The Calendar change did not affect days of the week:", "ExampleText",
 CellID->31591258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1752", ",", " ", "9", ",", " ", "2"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->28766294],

Cell[BoxData["Wednesday"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->805278565]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1752", ",", " ", "9", ",", " ", "14"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->105495277],

Cell[BoxData["Thursday"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->243253002]
}, Open  ]],

Cell["George Washington was born on a Tuesday:", "ExampleText",
 CellID->565349852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1732", ",", " ", "2", ",", " ", "22"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->72190417],

Cell[BoxData["Tuesday"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->93667361]
}, Open  ]],

Cell["Voltaire was born on a Sunday:", "ExampleText",
 CellID->158580235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[5]:=",
 CellID->226768768],

Cell[BoxData["Sunday"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[5]=",
 CellID->652024557]
}, Open  ]],

Cell[TextData[{
 "Dates after September 2, 1752 and before September 14, 1752 are not \
accepted by the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " option. Use the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " option for these dates (valid only for non British Western countries):"
}], "ExampleText",
 CellID->317625494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1752", ",", " ", "9", ",", " ", "3"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[6]:=",
 CellID->36762665],

Cell[BoxData[
 RowBox[{
  RowBox[{"DayOfWeek", "::", "\<\"baddate\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The date \\\\\\\"\\\", \\\"MSG\\\"]\
\\)\\!\\({1752, 9, 3}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is not valid for the \
calendar \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(Automatic\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\\\\\"\\\", \
\\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"CellTags",
 CellID->8057564],

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1752", ",", "9", ",", "3"}], "}"}], "]"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[6]=",
 CellID->95500123]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31569542],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->307193784],

Cell["\<\
This computes the number of times each day of the week occurs as a 13th of \
the month over the complete 400 year cycle of the Western (Gregorian) \
calendar:\
\>", "ExampleText",
 CellID->727178215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", " ", "@@", "  ", 
  RowBox[{"DayOfWeek", "  ", "/@", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{"List", ",", " ", 
       RowBox[{"2000", "+", 
        RowBox[{"Range", "[", "400", "]"}]}], ",", " ", 
       RowBox[{"Range", "[", "12", "]"}], ",", " ", 
       RowBox[{"{", "13", "}"}]}], "]"}], ",", " ", "2"}], "]"}]}]}]], "Input",\

 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->118765238],

Cell[BoxData[
 RowBox[{
  RowBox[{"688", " ", "Friday"}], "+", 
  RowBox[{"685", " ", "Monday"}], "+", 
  RowBox[{"684", " ", "Saturday"}], "+", 
  RowBox[{"687", " ", "Sunday"}], "+", 
  RowBox[{"684", " ", "Thursday"}], "+", 
  RowBox[{"685", " ", "Tuesday"}], "+", 
  RowBox[{"687", " ", "Wednesday"}]}]], "Output",
 ImageSize->{355, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->23021659]
}, Open  ]],

Cell["\<\
The 13th of the month falls more often on a Friday than on any other day of \
the week.\
\>", "ExampleText",
 CellID->149897408]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->162848117],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DaysBetween",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/DaysBetween"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DaysPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/DaysPlus"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->198232581]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->660874546],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DayOfWeek - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 31.8331846}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "DayOfWeek[{year, month, day}] gives the day of the week on which the \
given date {year, month, day} occurred. DayOfWeek[{year, month, day, hour, \
minute, second}] gives the day of the week for the given date.", 
    "synonyms" -> {}, "title" -> "DayOfWeek", "type" -> "Symbol", "uri" -> 
    "Calendar/ref/DayOfWeek"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5426, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->274074985]},
 "CellTags"->{
  Cell[6223, 219, 197, 6, 28, "Input",
   CellTags->"CellTags",
   CellID->42275686],
  Cell[6423, 227, 188, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->738323875],
  Cell[6993, 251, 199, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->171324951],
  Cell[7195, 259, 186, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->68316738],
  Cell[7770, 283, 198, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->382865139],
  Cell[7971, 291, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->31670784],
  Cell[8537, 315, 199, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->170071102],
  Cell[8739, 323, 187, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->70451977],
  Cell[10050, 379, 589, 18, 70, "Input",
   CellTags->"CellTags",
   CellID->209563650],
  Cell[10642, 399, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->92142797],
  Cell[11840, 449, 278, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->336451069],
  Cell[12121, 459, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->38527185],
  Cell[12884, 490, 277, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->238195362],
  Cell[13164, 500, 235, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->10569301],
  Cell[15407, 592, 440, 14, 70, "Input",
   CellTags->"CellTags",
   CellID->136400753],
  Cell[15850, 608, 277, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->650101461],
  Cell[16447, 629, 400, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->826448632],
  Cell[18520, 709, 516, 15, 70, "Input",
   CellTags->"CellTags",
   CellID->621884921],
  Cell[19039, 726, 274, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->20993421],
  Cell[19442, 743, 545, 16, 70, "Input",
   CellTags->"CellTags",
   CellID->210476491],
  Cell[19990, 761, 275, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->138873678],
  Cell[21708, 819, 197, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->28766294],
  Cell[21908, 827, 189, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->805278565],
  Cell[22134, 838, 199, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->105495277],
  Cell[22336, 846, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->243253002],
  Cell[22697, 862, 198, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->72190417],
  Cell[22898, 870, 186, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->93667361],
  Cell[23197, 884, 280, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->226768768],
  Cell[23480, 894, 186, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->652024557],
  Cell[24332, 926, 197, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->36762665],
  Cell[24532, 934, 425, 9, 70, "Message",
   CellTags->"CellTags",
   CellID->8057564],
  Cell[24960, 945, 276, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->95500123],
  Cell[25883, 983, 478, 14, 70, "Input",
   CellTags->"CellTags",
   CellID->118765238],
  Cell[26364, 999, 471, 14, 54, "Output",
   CellTags->"CellTags",
   CellID->23021659]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29507, 1104},
 {"CellTags", 29642, 1108}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1282, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1905, 60, 50, 1, 70, "ObjectName",
 CellID->44580209],
Cell[1958, 63, 1216, 36, 70, "Usage",
 CellID->380029146]
}, Open  ]],
Cell[CellGroupData[{
Cell[3211, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3689, 121, 72, 1, 70, "Notes",
 CellID->698165793],
Cell[3764, 124, 548, 15, 70, "3ColumnTableMod",
 CellID->257750897],
Cell[4315, 141, 286, 9, 70, "Notes",
 CellID->390650514],
Cell[4604, 152, 785, 30, 70, "Notes",
 CellID->163358871]
}, Closed]],
Cell[CellGroupData[{
Cell[5426, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274074985],
Cell[CellGroupData[{
Cell[5811, 201, 148, 5, 70, "ExampleSection",
 CellID->730510658],
Cell[5962, 208, 131, 3, 70, "Input",
 CellID->518473573],
Cell[6096, 213, 102, 2, 70, "ExampleText",
 CellID->210515354],
Cell[CellGroupData[{
Cell[6223, 219, 197, 6, 28, "Input",
 CellTags->"CellTags",
 CellID->42275686],
Cell[6423, 227, 188, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->738323875]
}, Open  ]],
Cell[6626, 236, 124, 3, 70, "ExampleDelimiter",
 CellID->65656534],
Cell[6753, 241, 131, 3, 70, "Input",
 CellID->127871431],
Cell[6887, 246, 81, 1, 70, "ExampleText",
 CellID->526480410],
Cell[CellGroupData[{
Cell[6993, 251, 199, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->171324951],
Cell[7195, 259, 186, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->68316738]
}, Open  ]],
Cell[7396, 268, 123, 3, 70, "ExampleDelimiter",
 CellID->1598750],
Cell[7522, 273, 131, 3, 70, "Input",
 CellID->608544368],
Cell[7656, 278, 89, 1, 70, "ExampleText",
 CellID->2348223],
Cell[CellGroupData[{
Cell[7770, 283, 198, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->382865139],
Cell[7971, 291, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->31670784]
}, Open  ]],
Cell[8171, 300, 125, 3, 70, "ExampleDelimiter",
 CellID->592224128],
Cell[8299, 305, 130, 3, 70, "Input",
 CellID->27995573],
Cell[8432, 310, 80, 1, 70, "ExampleText",
 CellID->207786348],
Cell[CellGroupData[{
Cell[8537, 315, 199, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->170071102],
Cell[8739, 323, 187, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->70451977]
}, Open  ]],
Cell[8941, 332, 125, 3, 70, "ExampleDelimiter",
 CellID->388230981],
Cell[9069, 337, 131, 3, 70, "Input",
 CellID->175631837],
Cell[9203, 342, 116, 3, 70, "ExampleText",
 CellID->367424983],
Cell[CellGroupData[{
Cell[9344, 349, 135, 4, 70, "Input",
 CellID->462994191],
Cell[9482, 355, 165, 5, 36, "Output",
 CellID->465349560]
}, Open  ]],
Cell[9662, 363, 124, 3, 70, "ExampleDelimiter",
 CellID->10350311],
Cell[9789, 368, 131, 3, 70, "Input",
 CellID->126142671],
Cell[9923, 373, 102, 2, 70, "ExampleText",
 CellID->77044837],
Cell[CellGroupData[{
Cell[10050, 379, 589, 18, 70, "Input",
 CellTags->"CellTags",
 CellID->209563650],
Cell[10642, 399, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->92142797]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10874, 411, 222, 7, 70, "ExampleSection",
 CellID->113550562],
Cell[CellGroupData[{
Cell[11121, 422, 229, 7, 70, "ExampleSubsection",
 CellID->312425969],
Cell[11353, 431, 130, 3, 70, "Input",
 CellID->38044769],
Cell[11486, 436, 329, 9, 70, "ExampleText",
 CellID->221284867],
Cell[CellGroupData[{
Cell[11840, 449, 278, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->336451069],
Cell[12121, 459, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->38527185]
}, Open  ]],
Cell[12321, 468, 122, 3, 70, "ExampleDelimiter",
 CellID->843489],
Cell[12446, 473, 131, 3, 70, "Input",
 CellID->307401457],
Cell[12580, 478, 279, 8, 70, "ExampleText",
 CellID->147381382],
Cell[CellGroupData[{
Cell[12884, 490, 277, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->238195362],
Cell[13164, 500, 235, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->10569301]
}, Open  ]],
Cell[13414, 511, 125, 3, 70, "ExampleDelimiter",
 CellID->347696200],
Cell[13542, 516, 130, 3, 70, "Input",
 CellID->65008777],
Cell[13675, 521, 82, 1, 70, "ExampleText",
 CellID->26547458],
Cell[CellGroupData[{
Cell[13782, 526, 254, 7, 70, "Input",
 CellID->30875053],
Cell[14039, 535, 163, 5, 36, "Output",
 CellID->158881242]
}, Open  ]],
Cell[14217, 543, 125, 3, 70, "ExampleDelimiter",
 CellID->170230319],
Cell[14345, 548, 131, 3, 70, "Input",
 CellID->894088999],
Cell[14479, 553, 155, 4, 70, "ExampleText",
 CellID->106619854],
Cell[CellGroupData[{
Cell[14659, 561, 175, 5, 70, "Input",
 CellID->187638644],
Cell[14837, 568, 163, 5, 36, "Output",
 CellID->213147396]
}, Open  ]],
Cell[15015, 576, 125, 3, 70, "ExampleDelimiter",
 CellID->210877869],
Cell[15143, 581, 131, 3, 70, "Input",
 CellID->117994317],
Cell[15277, 586, 105, 2, 70, "ExampleText",
 CellID->663636041],
Cell[CellGroupData[{
Cell[15407, 592, 440, 14, 70, "Input",
 CellTags->"CellTags",
 CellID->136400753],
Cell[15850, 608, 277, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->650101461]
}, Open  ]],
Cell[16142, 620, 302, 7, 70, "ExampleText",
 CellID->18023314],
Cell[16447, 629, 400, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->826448632]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16896, 645, 225, 7, 70, "ExampleSection",
 CellID->6547853],
Cell[17124, 654, 131, 3, 70, "Input",
 CellID->631104188],
Cell[17258, 659, 205, 5, 70, "ExampleText",
 CellID->450885522],
Cell[CellGroupData[{
Cell[17488, 668, 328, 10, 70, "Input",
 CellID->259733080],
Cell[17819, 680, 161, 5, 36, "Output",
 CellID->102528285]
}, Open  ]],
Cell[17995, 688, 158, 4, 70, "ExampleText",
 CellID->120888810],
Cell[18156, 694, 124, 3, 70, "ExampleDelimiter",
 CellID->70148782],
Cell[18283, 699, 131, 3, 70, "Input",
 CellID->132391389],
Cell[18417, 704, 78, 1, 70, "ExampleText",
 CellID->423738341],
Cell[CellGroupData[{
Cell[18520, 709, 516, 15, 70, "Input",
 CellTags->"CellTags",
 CellID->621884921],
Cell[19039, 726, 274, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->20993421]
}, Open  ]],
Cell[19328, 738, 89, 1, 70, "ExampleText",
 CellID->513727549],
Cell[CellGroupData[{
Cell[19442, 743, 545, 16, 70, "Input",
 CellTags->"CellTags",
 CellID->210476491],
Cell[19990, 761, 275, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->138873678]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20314, 776, 229, 7, 70, "ExampleSection",
 CellID->72551731],
Cell[20546, 785, 130, 3, 70, "Input",
 CellID->78428307],
Cell[20679, 790, 907, 22, 70, "ExampleText",
 CellID->361193654],
Cell[21589, 814, 94, 1, 70, "ExampleText",
 CellID->31591258],
Cell[CellGroupData[{
Cell[21708, 819, 197, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->28766294],
Cell[21908, 827, 189, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->805278565]
}, Open  ]],
Cell[CellGroupData[{
Cell[22134, 838, 199, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->105495277],
Cell[22336, 846, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->243253002]
}, Open  ]],
Cell[22589, 857, 83, 1, 70, "ExampleText",
 CellID->565349852],
Cell[CellGroupData[{
Cell[22697, 862, 198, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->72190417],
Cell[22898, 870, 186, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->93667361]
}, Open  ]],
Cell[23099, 879, 73, 1, 70, "ExampleText",
 CellID->158580235],
Cell[CellGroupData[{
Cell[23197, 884, 280, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->226768768],
Cell[23480, 894, 186, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->652024557]
}, Open  ]],
Cell[23681, 903, 626, 19, 70, "ExampleText",
 CellID->317625494],
Cell[CellGroupData[{
Cell[24332, 926, 197, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->36762665],
Cell[24532, 934, 425, 9, 70, "Message",
 CellTags->"CellTags",
 CellID->8057564],
Cell[24960, 945, 276, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->95500123]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25285, 960, 227, 7, 70, "ExampleSection",
 CellID->31569542],
Cell[25515, 969, 131, 3, 70, "Input",
 CellID->307193784],
Cell[25649, 974, 209, 5, 70, "ExampleText",
 CellID->727178215],
Cell[CellGroupData[{
Cell[25883, 983, 478, 14, 70, "Input",
 CellTags->"CellTags",
 CellID->118765238],
Cell[26364, 999, 471, 14, 54, "Output",
 CellTags->"CellTags",
 CellID->23021659]
}, Open  ]],
Cell[26850, 1016, 138, 4, 70, "ExampleText",
 CellID->149897408]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27037, 1026, 315, 9, 70, "SeeAlsoSection",
 CellID->162848117],
Cell[27355, 1037, 479, 17, 70, "SeeAlso",
 CellID->198232581]
}, Open  ]],
Cell[CellGroupData[{
Cell[27871, 1059, 318, 9, 70, "TutorialsSection",
 CellID->660874546],
Cell[28192, 1070, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[28355, 1076, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

