(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40247,       1471]
NotebookOptionsPosition[     27713,       1036]
NotebookOutlinePosition[     32510,       1188]
CellTagsIndexPosition[     32396,       1182]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DaysPlus" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/DaysPlus"], 
          "DayOfWeek" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/DayOfWeek"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"DaysPlus\"\>", 
       2->"\<\"DayOfWeek\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DaysBetween", "ObjectName",
 CellID->613480955],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DaysBetween", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["year", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["month", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["day", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["year", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["month", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["day", "TI"], 
           StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of days between the dates ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["year", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["month", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["day", "TI"], 
         StyleBox["1", "TR"]]}], "}"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["year", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["month", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["day", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DaysBetween", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["year", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["month", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["day", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["hour", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["minute", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["second", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["year", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["month", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["day", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["hour", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["minute", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["second", "TI"], 
           StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of days between the given dates."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->431324041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->303471730],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Calendar",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Calendar"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies which calendar system to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->51768430],

Cell[TextData[{
 "The default calendar is the usual American calendar, but can be changed \
with the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->547688562],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["DaysBetween"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Jewish",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Jewish"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->49729532]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187257343],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(7)", "ExampleCount"]
}], "ExampleSection",
 CellID->320001616],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell["The number of days between consecutive days is 1:", "ExampleText",
 CellID->234181146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->184506419],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->197464161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100854736],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->637252288],

Cell["The number of days between the same date is 0:", "ExampleText",
 CellID->247530806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->218068296],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->105769260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213322307],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->224081256],

Cell["\<\
If the second date is earlier than the first date, then a negative result is \
returned:\
\>", "ExampleText",
 CellID->160332667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->259099522],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->826857291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433770411],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->13451064],

Cell["\<\
John F. Kennedy's presidency is referred to as lasting 1000 days:\
\>", "ExampleText",
 CellID->884452769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1961", ",", " ", "1", ",", " ", "20"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1963", ",", " ", "11", ",", " ", "22"}], "}"}]}], "]"}]], "Input",\

 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->162214302],

Cell[BoxData["1036"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->89934799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169013784],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->445460433],

Cell["Hours, minutes, seconds do not affect DaysBetween:", "ExampleText",
 CellID->200905642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2000", ",", " ", "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",", 
     " ", "0"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "2000", ",", " ", "1", ",", " ", "1", ",", " ", "23", ",", " ", "59", ",",
      " ", "59"}], "}"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->392401263],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->172755843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486589880],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->735366430],

Cell["\<\
In the default (Western American) calendar 11 days were deleted 11 in \
September 1752:\
\>", "ExampleText",
 CellID->28148510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1752", ",", " ", "9", ",", " ", "2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1752", ",", " ", "9", ",", " ", "14"}], "}"}]}], "]"}]], "Input",\

 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->10732776],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->424799994]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->413568936],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->977790854],

Cell["\<\
In the default (Western American) calendar, 1752 had 355 days:\
\>", "ExampleText",
 CellID->410909708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1752", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1753", ",", " ", "1", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->94368649],

Cell[BoxData["355"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->611854376]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->809466939],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Calendar",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->66173872],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->577560972],

Cell[TextData[{
 "Catholic countries adopted the modern Gregorian calendar in 1582 while \
Britain and her colonies conserved the Julian calendar until 1752. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the British calendar, so Catholic date computations require the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->736177777],

Cell["This computes the number of days Voltaire lived:", "ExampleText",
 CellID->282558914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1778", ",", " ", "5", ",", " ", "30"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->457005309],

Cell[BoxData["30505"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->512552748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84545486],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->455120358],

Cell["\<\
The Russian Orthodox church has retained the Julian Calendar. Their year 1900 \
was a leap year:\
\>", "ExampleText",
 CellID->425602153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1901", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Julian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->441605076],

Cell[BoxData["366"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->245428858]
}, Open  ]],

Cell["The standard Western year 1900 was not a leap year:", "ExampleText",
 CellID->180097175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1901", ",", " ", "1", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->1014836212],

Cell[BoxData["365"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->12397569]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->210015828],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->336704053],

Cell["The Islamic year is much shorter than the Western year:", "ExampleText",
 CellID->669883399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1420", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1421", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->227959985],

Cell[BoxData["355"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->72709911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78173466],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->9239316],

Cell["\<\
The length of the Jewish year varies greatly because there is a leap month:\
\>", "ExampleText",
 CellID->85713060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5761", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"5762", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->18405258],

Cell[BoxData["354"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->68950892]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5762", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"5763", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->121891711],

Cell[BoxData["385"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->554250353]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32453937],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->320739632],

Cell[TextData[{
 "The Western calendar was modified from ",
 Cell[BoxData["Julian"], "InlineFormula"],
 " to ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " for better accuracy. The change deleted 10 days in October 1582 in \
Catholic countries and deleted 11 days in September 1752 in Britain and her \
colonies. By default, ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "applies the British (American) version. There is an issue for ",
 Cell[BoxData["DaysBetween"], "InlineFormula"],
 " concerning dates after October 14, 1582 and before September 14, 1752.",
 " ",
 "For British dates, the default gives the correct answer. For dates in \
Catholic countries, one must use the ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " option for ",
 Cell[BoxData["Calendar"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->452816105],

Cell["This computes the number of days George Washington lived:", \
"ExampleText",
 CellID->15477229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1732", ",", " ", "2", ",", " ", "22"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1799", ",", " ", "12", ",", " ", "14"}], "}"}]}], "]"}]], "Input",\

 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->839204012],

Cell[BoxData["24756"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->10218298]
}, Open  ]],

Cell["This computes the number of days Voltaire lived:", "ExampleText",
 CellID->63737504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1778", ",", " ", "5", ",", " ", "30"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->11680581],

Cell[BoxData["30505"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->23651256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->449769870],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->346936934],

Cell["\<\
Because it is a solar and lunar calendar (the year follows the seasons and \
the months keep track of the phases of the moon), the Jewish calendar has an \
extra leap month 7 times every 19 years. This leap month occurs in Spring the \
month preceding Passover, so it is appropriate to count the Jewish months \
starting with Nissan, the month of Passover as follows: \
\>", "ExampleText",
 CellID->244050187],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
   "Nissan", ",", " ", "Iyar", ",", " ", "Sivan", ",", " ", "Tammuz", ",", 
    " ", "Av", ",", " ", "Elul", ",", " ", "Tishrei", ",", " ", "Chesvan", 
    ",", " ", "Kislev", ",", " ", "Tevet", ",", " ", "Shvat", ",", " ", 
    "Adar", ",", " ", "AdarII"}], "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->31413281],

Cell["\<\
Since the Jewish year begins in the Fall, this numeration of months will not \
always follow an increasing order, that is, later dates in the same year may \
have a smaller number for the month:\
\>", "ExampleText",
 CellID->319404554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "29"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->65326660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "12", ",", "29"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->770170300]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "30"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->502544945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->161029407]
}, Open  ]],

Cell[TextData[{
 "For this reason, ",
 Cell[BoxData["DaysBetween"], "InlineFormula"],
 " will still work with the ",
 Cell[BoxData[
  RowBox[{"Calendar", " ", "->", " ", "Jewish"}]], "InlineFormula"],
 " option, but will not follow the same rules, for example, it will return a \
positive number even if the second date is lexicographically smaller (smaller \
in the canonical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ordering): "
}], "ExampleText",
 CellID->345809696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5766", ",", " ", "12", ",", " ", "29"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"5766", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[5]:=",
 CellID->49730788],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[5]=",
 CellID->92122641]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15376706],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DaysPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/DaysPlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DayOfWeek",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/DayOfWeek"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29610703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->245259757],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DaysBetween - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 32.8019594}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "DaysBetween[{year_1, month_1, day_1}, {year_2, month_2, day_2}] gives \
the number of days between the dates {year_1, month_1, day_1} and {year_2, \
month_2, day_2}. DaysBetween[{year_1, month_1, day_1, hour_1, minute_1, \
second_1}, {year_2, month_2, day_2, hour_2, minute_2, second_2}] gives the \
number of days between the given dates.", "synonyms" -> {}, "title" -> 
    "DaysBetween", "type" -> "Symbol", "uri" -> "Calendar/ref/DaysBetween"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7515, 257, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->187257343]},
 "CellTags"->{
  Cell[8302, 288, 302, 9, 28, "Input",
   CellTags->"CellTags",
   CellID->184506419],
  Cell[8607, 299, 181, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->197464161],
  Cell[9179, 323, 302, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->218068296],
  Cell[9484, 334, 181, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->105769260],
  Cell[10106, 361, 302, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->259099522],
  Cell[10411, 372, 198, 7, 36, "Output",
   CellTags->"CellTags",
   CellID->826857291],
  Cell[11026, 399, 307, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->162214302],
  Cell[11336, 411, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->89934799],
  Cell[11914, 435, 417, 13, 70, "Input",
   CellTags->"CellTags",
   CellID->392401263],
  Cell[12334, 450, 181, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->172755843],
  Cell[12954, 477, 304, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->10732776],
  Cell[13261, 489, 181, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->424799994],
  Cell[13857, 515, 301, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->94368649],
  Cell[14161, 526, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->611854376],
  Cell[15589, 582, 370, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->457005309],
  Cell[15962, 594, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->512552748],
  Cell[16595, 621, 364, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->441605076],
  Cell[16962, 633, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->245428858],
  Cell[17279, 647, 303, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->1014836212],
  Cell[17585, 658, 182, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->12397569],
  Cell[18167, 682, 365, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->227959985],
  Cell[18535, 694, 182, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->72709911],
  Cell[19141, 720, 363, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->18405258],
  Cell[19507, 732, 182, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->68950892],
  Cell[19726, 743, 364, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->121891711],
  Cell[20093, 755, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->554250353],
  Cell[21677, 811, 307, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->839204012],
  Cell[21987, 823, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->10218298],
  Cell[22301, 837, 369, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->11680581],
  Cell[22673, 849, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->23651256],
  Cell[23556, 877, 399, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->31413281],
  Cell[24228, 898, 245, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->65326660],
  Cell[24476, 908, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->770170300],
  Cell[24754, 921, 246, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->502544945],
  Cell[25003, 931, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->161029407],
  Cell[25765, 959, 365, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->49730788],
  Cell[26133, 971, 180, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->92122641]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28968, 1063},
 {"CellTags", 29103, 1067}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1276, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1899, 60, 53, 1, 70, "ObjectName",
 CellID->613480955],
Cell[1955, 63, 3317, 106, 70, "Usage",
 CellID->431324041]
}, Open  ]],
Cell[CellGroupData[{
Cell[5309, 174, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5787, 191, 72, 1, 70, "Notes",
 CellID->303471730],
Cell[5862, 194, 547, 15, 70, "3ColumnTableMod",
 CellID->51768430],
Cell[6412, 211, 276, 9, 70, "Notes",
 CellID->547688562],
Cell[6691, 222, 787, 30, 70, "Notes",
 CellID->49729532]
}, Closed]],
Cell[CellGroupData[{
Cell[7515, 257, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187257343],
Cell[CellGroupData[{
Cell[7900, 271, 148, 5, 70, "ExampleSection",
 CellID->320001616],
Cell[8051, 278, 131, 3, 70, "Input",
 CellID->518473573],
Cell[8185, 283, 92, 1, 70, "ExampleText",
 CellID->234181146],
Cell[CellGroupData[{
Cell[8302, 288, 302, 9, 28, "Input",
 CellTags->"CellTags",
 CellID->184506419],
Cell[8607, 299, 181, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->197464161]
}, Open  ]],
Cell[8803, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->100854736],
Cell[8931, 313, 131, 3, 70, "Input",
 CellID->637252288],
Cell[9065, 318, 89, 1, 70, "ExampleText",
 CellID->247530806],
Cell[CellGroupData[{
Cell[9179, 323, 302, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->218068296],
Cell[9484, 334, 181, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->105769260]
}, Open  ]],
Cell[9680, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->213322307],
Cell[9808, 348, 131, 3, 70, "Input",
 CellID->224081256],
Cell[9942, 353, 139, 4, 70, "ExampleText",
 CellID->160332667],
Cell[CellGroupData[{
Cell[10106, 361, 302, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->259099522],
Cell[10411, 372, 198, 7, 36, "Output",
 CellTags->"CellTags",
 CellID->826857291]
}, Open  ]],
Cell[10624, 382, 125, 3, 70, "ExampleDelimiter",
 CellID->433770411],
Cell[10752, 387, 130, 3, 70, "Input",
 CellID->13451064],
Cell[10885, 392, 116, 3, 70, "ExampleText",
 CellID->884452769],
Cell[CellGroupData[{
Cell[11026, 399, 307, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->162214302],
Cell[11336, 411, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->89934799]
}, Open  ]],
Cell[11534, 420, 125, 3, 70, "ExampleDelimiter",
 CellID->169013784],
Cell[11662, 425, 131, 3, 70, "Input",
 CellID->445460433],
Cell[11796, 430, 93, 1, 70, "ExampleText",
 CellID->200905642],
Cell[CellGroupData[{
Cell[11914, 435, 417, 13, 70, "Input",
 CellTags->"CellTags",
 CellID->392401263],
Cell[12334, 450, 181, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->172755843]
}, Open  ]],
Cell[12530, 459, 125, 3, 70, "ExampleDelimiter",
 CellID->486589880],
Cell[12658, 464, 131, 3, 70, "Input",
 CellID->735366430],
Cell[12792, 469, 137, 4, 70, "ExampleText",
 CellID->28148510],
Cell[CellGroupData[{
Cell[12954, 477, 304, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->10732776],
Cell[13261, 489, 181, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->424799994]
}, Open  ]],
Cell[13457, 498, 125, 3, 70, "ExampleDelimiter",
 CellID->413568936],
Cell[13585, 503, 131, 3, 70, "Input",
 CellID->977790854],
Cell[13719, 508, 113, 3, 70, "ExampleText",
 CellID->410909708],
Cell[CellGroupData[{
Cell[13857, 515, 301, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->94368649],
Cell[14161, 526, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->611854376]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14393, 538, 222, 7, 70, "ExampleSection",
 CellID->809466939],
Cell[CellGroupData[{
Cell[14640, 549, 228, 7, 70, "ExampleSubsection",
 CellID->66173872],
Cell[14871, 558, 131, 3, 70, "Input",
 CellID->577560972],
Cell[15005, 563, 465, 12, 70, "ExampleText",
 CellID->736177777],
Cell[15473, 577, 91, 1, 70, "ExampleText",
 CellID->282558914],
Cell[CellGroupData[{
Cell[15589, 582, 370, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->457005309],
Cell[15962, 594, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->512552748]
}, Open  ]],
Cell[16162, 603, 124, 3, 70, "ExampleDelimiter",
 CellID->84545486],
Cell[16289, 608, 131, 3, 70, "Input",
 CellID->455120358],
Cell[16423, 613, 147, 4, 70, "ExampleText",
 CellID->425602153],
Cell[CellGroupData[{
Cell[16595, 621, 364, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->441605076],
Cell[16962, 633, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->245428858]
}, Open  ]],
Cell[17160, 642, 94, 1, 70, "ExampleText",
 CellID->180097175],
Cell[CellGroupData[{
Cell[17279, 647, 303, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->1014836212],
Cell[17585, 658, 182, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->12397569]
}, Open  ]],
Cell[17782, 667, 125, 3, 70, "ExampleDelimiter",
 CellID->210015828],
Cell[17910, 672, 131, 3, 70, "Input",
 CellID->336704053],
Cell[18044, 677, 98, 1, 70, "ExampleText",
 CellID->669883399],
Cell[CellGroupData[{
Cell[18167, 682, 365, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->227959985],
Cell[18535, 694, 182, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->72709911]
}, Open  ]],
Cell[18732, 703, 124, 3, 70, "ExampleDelimiter",
 CellID->78173466],
Cell[18859, 708, 129, 3, 70, "Input",
 CellID->9239316],
Cell[18991, 713, 125, 3, 70, "ExampleText",
 CellID->85713060],
Cell[CellGroupData[{
Cell[19141, 720, 363, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->18405258],
Cell[19507, 732, 182, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->68950892]
}, Open  ]],
Cell[CellGroupData[{
Cell[19726, 743, 364, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->121891711],
Cell[20093, 755, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->554250353]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20337, 768, 229, 7, 70, "ExampleSection",
 CellID->32453937],
Cell[20569, 777, 131, 3, 70, "Input",
 CellID->320739632],
Cell[20703, 782, 845, 21, 70, "ExampleText",
 CellID->452816105],
Cell[21551, 805, 101, 2, 70, "ExampleText",
 CellID->15477229],
Cell[CellGroupData[{
Cell[21677, 811, 307, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->839204012],
Cell[21987, 823, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->10218298]
}, Open  ]],
Cell[22186, 832, 90, 1, 70, "ExampleText",
 CellID->63737504],
Cell[CellGroupData[{
Cell[22301, 837, 369, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->11680581],
Cell[22673, 849, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->23651256]
}, Open  ]],
Cell[22872, 858, 125, 3, 70, "ExampleDelimiter",
 CellID->449769870],
Cell[23000, 863, 131, 3, 70, "Input",
 CellID->346936934],
Cell[23134, 868, 419, 7, 70, "ExampleText",
 CellID->244050187],
Cell[23556, 877, 399, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->31413281],
Cell[23958, 889, 245, 5, 70, "ExampleText",
 CellID->319404554],
Cell[CellGroupData[{
Cell[24228, 898, 245, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->65326660],
Cell[24476, 908, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->770170300]
}, Open  ]],
Cell[CellGroupData[{
Cell[24754, 921, 246, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->502544945],
Cell[25003, 931, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->161029407]
}, Open  ]],
Cell[25257, 942, 483, 13, 70, "ExampleText",
 CellID->345809696],
Cell[CellGroupData[{
Cell[25765, 959, 365, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->49730788],
Cell[26133, 971, 180, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->92122641]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26374, 984, 314, 9, 70, "SeeAlsoSection",
 CellID->15376706],
Cell[26691, 995, 474, 17, 70, "SeeAlso",
 CellID->29610703]
}, Open  ]],
Cell[CellGroupData[{
Cell[27202, 1017, 318, 9, 70, "TutorialsSection",
 CellID->245259757],
Cell[27523, 1028, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[27686, 1034, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

