(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41783,       1579]
NotebookOptionsPosition[     27795,       1085]
NotebookOutlinePosition[     33255,       1263]
CellTagsIndexPosition[     33141,       1257]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DaysBetween" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/DaysBetween"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"DaysBetween\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DaysPlus", "ObjectName",
 CellID->410750880],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DaysPlus", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["year", "TI"], ",", 
          StyleBox["month", "TI"], ",", 
          StyleBox["day", "TI"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the date ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " days after the date ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DaysPlus", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["year", "TI"], ",", 
          StyleBox["month", "TI"], ",", 
          StyleBox["day", "TI"], ",", 
          StyleBox["hour", "TI"], ",", 
          StyleBox["minute", "TI"], ",", 
          StyleBox["second", "TI"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the date ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " days after the date ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"], ",", 
        StyleBox["hour", "TI"], ",", 
        StyleBox["minute", "TI"], ",", 
        StyleBox["second", "TI"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->178219847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->106405679],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Calendar",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Calendar"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies which calendar system to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->242120541],

Cell[TextData[{
 "The default calendar is the usual American calendar, but can be changed \
with the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->38946648],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["DaysBetween"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Jewish",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Jewish"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->137173409]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->426303062],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->464293361],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell["Computing the next day:", "ExampleText",
 CellID->105047553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", "1"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->1206339],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2000", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->141813079]
}, Open  ]],

Cell["\<\
To compute an earlier date, a negative second argument is used:\
\>", "ExampleText",
 CellID->178540430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->366559242],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1999", ",", "12", ",", "31"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->63050698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171611389],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->212000579],

Cell[TextData[{
 "Hours, minutes, seconds are retained by ",
 Cell[BoxData["DayPlus"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->131564385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2000", ",", " ", "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",", 
     " ", "0"}], "}"}], ",", " ", "1"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->347198457],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2000", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->16601053]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2000", ",", " ", "1", ",", " ", "1", ",", " ", "23", ",", " ", "59", ",",
      " ", "59"}], "}"}], ",", " ", "1"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->189066408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2000", ",", "1", ",", "2", ",", "23", ",", "59", ",", "59"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->351607874]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->172581325],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Calendar",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31314233],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->442976732],

Cell[TextData[{
 "Catholic countries adopted the modern Gregorian calendar in 1582 while \
Britain and her colonies conserved the Julian calendar until 1752. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the British calendar, so Catholic date computations require the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->288450391],

Cell["\<\
 When changing calendars in 1752, Britain deleted 11 days in September:\
\>", "ExampleText",
 CellID->385663097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1752", ",", " ", "9", ",", " ", "2"}], "}"}], ",", " ", "1"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->23632612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1752", ",", "9", ",", "14"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->117646193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53394536],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->35295759],

Cell["\<\
In Catholic countries using the Gregorian calendar, no days were deleted:\
\>", "ExampleText",
 CellID->250526283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1752", ",", " ", "9", ",", " ", "2"}], "}"}], ",", " ", "1", ",",
    " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->366007363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1752", ",", "9", ",", "3"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->126823736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34193951],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->464890591],

Cell["\<\
The Russian Orthodox church has retained the Julian Calendar. Their year 1900 \
was a leap year:\
\>", "ExampleText",
 CellID->5278332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", " ", "2", ",", " ", "28"}], "}"}], ",", " ", "1", 
   ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Julian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->373441331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1900", ",", "2", ",", "29"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->528635061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17289274],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->271735816],

Cell["The standard Western year 1900 was not a leap year:", "ExampleText",
 CellID->868100082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", " ", "2", ",", " ", "28"}], "}"}], ",", " ", "1"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->558641042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1900", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->450616175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75054608],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->178083250],

Cell["The Islamic year is much shorter than the Western year:", "ExampleText",
 CellID->27631549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1420", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", "365", 
   ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->308754828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1421", ",", "1", ",", "11"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->363511477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446189829],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->304180914],

Cell["\<\
The length of the Jewish year varies greatly because there is a leap month:\
\>", "ExampleText",
 CellID->78047085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5761", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", "365", 
   ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->448230914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5762", ",", "1", ",", "12"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->506019484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5762", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", "365", 
   ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->1010422936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5763", ",", "13", ",", "10"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->561465081]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->344688641],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->101928846],

Cell["\<\
By definition the Christian Holiday of Ash Wednesday is 46 days before \
Easter:\
\>", "ExampleText",
 CellID->149047355],

Cell[BoxData[
 RowBox[{
  RowBox[{"AshWednesday", "[", "year_", "]"}], ":=", " ", 
  RowBox[{"DaysPlus", "[", 
   RowBox[{
    RowBox[{"EasterSunday", "[", "year", "]"}], ",", " ", 
    RowBox[{"-", "46"}]}], "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->110548071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AshWednesday", "[", "2006", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->302679467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->491468703]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", "%", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->56834690],

Cell[BoxData["Wednesday"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->249995323]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52703757],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->26986640],

Cell["\<\
One can easily compute the date after a given number of weeks:\
\>", "ExampleText",
 CellID->132001872],

Cell[BoxData[
 RowBox[{
  RowBox[{"WeeksPlus", "[", 
   RowBox[{"date_", ",", " ", "weeks_", ",", " ", "Options___"}], "]"}], ":=",
   " ", 
  RowBox[{"DaysPlus", "[", 
   RowBox[{"date", ",", " ", 
    RowBox[{"7", " ", "weeks"}], ",", " ", "Options"}], "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->102605244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeeksPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", "1"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->390092873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2000", ",", "1", ",", "8"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->349515236]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeeksPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", "30"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->203210767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2000", ",", "7", ",", "29"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->492183207]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeeksPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"-", "30"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[5]:=",
 CellID->15191394],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1999", ",", "6", ",", "5"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[5]=",
 CellID->11208307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68198582],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->10248544],

Cell["\<\
Yom Kippur is the tenth day of the Jewish Year, so this program returns the \
Western (Gregorian) date of Yom Kippur for a given Western year:\
\>", "ExampleText",
 CellID->35784471],

Cell[BoxData[
 RowBox[{
  RowBox[{"YomKippur", "[", "year_", "]"}], ":=", " ", 
  RowBox[{"DaysPlus", "[", 
   RowBox[{
    RowBox[{"JewishNewYear", "[", "year", "]"}], ",", " ", "9"}], 
   "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->22571630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YomKippur", "[", "2006", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->189573084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "10", ",", "2"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->30058022]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->607184710],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->223602491],

Cell[TextData[{
 "The Western calendar was modified from ",
 Cell[BoxData["Julian"], "InlineFormula"],
 " to ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " for better accuracy. The change deleted 10 days in October 1582 in \
Catholic countries and deleted 11 days in September 1752 in Britain and her \
colonies. By default, ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "applies the British (American) version. There is an issue for DaysPlus \
concerning dates after October 14, 1582 and before September 14, 1752.",
 " ",
 "For British dates, the default gives the correct answer. For dates in \
Catholic countries, one must use the ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " option for ",
 Cell[BoxData["Calendar"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->40998135],

Cell["\<\
In the default (Western American) calendar, dates in September 1752 were \
deleted:\
\>", "ExampleText",
 CellID->308763913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1752", ",", " ", "9", ",", " ", "2"}], "}"}], ",", " ", "1"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->377863343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1752", ",", "9", ",", "14"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->339789774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194929490],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->412948710],

Cell["\<\
Because it is a solar and lunar calendar (the year follows the seasons and \
the months keep track of the phases of the moon), the Jewish calendar has an \
extra leap month 7 times every 19 years. This leap month occurs in Spring the \
month preceding Passover, so it is appropriate to count the Jewish months \
starting with Nissan, the month of Passover as follows: \
\>", "ExampleText",
 CellID->647071506],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
   "Nissan", ",", " ", "Iyar", ",", " ", "Sivan", ",", " ", "Tammuz", ",", 
    " ", "Av", ",", " ", "Elul", ",", " ", "Tishrei", ",", " ", "Chesvan", 
    ",", " ", "Kislev", ",", " ", "Tevet", ",", " ", "Shvat", ",", " ", 
    "Adar", ",", " ", "AdarII"}], "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->329095345],

Cell["\<\
Since the Jewish year begins in the Fall, this numeration of months will not \
always follow an increasing order, that is, later dates in the same year may \
have a smaller number for the month:\
\>", "ExampleText",
 CellID->1793004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "29"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->206602261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "12", ",", "29"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->112066292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "30"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->7015758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->676168624]
}, Open  ]],

Cell[TextData[{
 "For this reason, ",
 Cell[BoxData["DaysPlus"], "InlineFormula"],
 " will still work with the ",
 Cell[BoxData[
  RowBox[{"Calendar", " ", "->", " ", "Jewish"}]], "InlineFormula"],
 " option, but will not follow the same rules, for example, it will return a \
lexicographically smaller (smaller in the canonical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ordering) for a later date: "
}], "ExampleText",
 CellID->468564612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5766", ",", " ", "12", ",", " ", "29"}], "}"}], ",", " ", "1", 
   ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[5]:=",
 CellID->75220111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[5]=",
 CellID->514464146]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->68729819],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DaysBetween",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/DaysBetween"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->309200681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9541462],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DaysPlus - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 33.1300928}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "DaysPlus[{year, month, day}, n] gives the date n days after the date \
{year, month, day}. DaysPlus[{year, month, day, hour, minute, second}, n] \
gives the date n days after the date {year, month, day, hour, minute, \
second}.", "synonyms" -> {}, "title" -> "DaysPlus", "type" -> "Symbol", "uri" -> 
    "Calendar/ref/DaysPlus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5854, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->426303062]},
 "CellTags"->{
  Cell[6615, 236, 228, 8, 28, "Input",
   CellTags->"CellTags",
   CellID->1206339],
  Cell[6846, 246, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->141813079],
  Cell[7239, 264, 246, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->366559242],
  Cell[7488, 274, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->63050698],
  Cell[8178, 304, 283, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->347198457],
  Cell[8464, 315, 272, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->16601053],
  Cell[8773, 329, 286, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->189066408],
  Cell[9062, 340, 276, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->351607874],
  Cell[10614, 401, 229, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->23632612],
  Cell[10846, 411, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->117646193],
  Cell[11510, 439, 296, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->366007363],
  Cell[11809, 450, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->126823736],
  Cell[12494, 479, 294, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->373441331],
  Cell[12791, 490, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->528635061],
  Cell[13426, 516, 231, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->558641042],
  Cell[13660, 526, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->450616175],
  Cell[14297, 552, 296, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->308754828],
  Cell[14596, 563, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->363511477],
  Cell[15263, 591, 295, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->448230914],
  Cell[15561, 602, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->506019484],
  Cell[15838, 615, 296, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->1010422936],
  Cell[16137, 626, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->561465081],
  Cell[16937, 661, 293, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->110548071],
  Cell[17255, 674, 134, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->302679467],
  Cell[17392, 680, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->491468703],
  Cell[17668, 693, 127, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->56834690],
  Cell[17798, 699, 189, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->249995323],
  Cell[18378, 723, 339, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->102605244],
  Cell[18742, 737, 231, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->390092873],
  Cell[18976, 747, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->349515236],
  Cell[19252, 760, 232, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->203210767],
  Cell[19487, 770, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->492183207],
  Cell[19764, 783, 247, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->15191394],
  Cell[20014, 793, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->11208307],
  Cell[20722, 820, 273, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->22571630],
  Cell[21020, 833, 131, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->189573084],
  Cell[21154, 839, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->30058022],
  Cell[22772, 897, 230, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->377863343],
  Cell[23005, 907, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->339789774],
  Cell[23944, 937, 400, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->329095345],
  Cell[24615, 958, 246, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->206602261],
  Cell[24864, 968, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->112066292],
  Cell[25142, 981, 244, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->7015758],
  Cell[25389, 991, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->676168624],
  Cell[26120, 1018, 294, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->75220111],
  Cell[26417, 1029, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->514464146]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28929, 1111},
 {"CellTags", 29064, 1115}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1166, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1789, 58, 50, 1, 70, "ObjectName",
 CellID->410750880],
Cell[1842, 61, 1768, 56, 70, "Usage",
 CellID->178219847]
}, Open  ]],
Cell[CellGroupData[{
Cell[3647, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4125, 139, 72, 1, 70, "Notes",
 CellID->106405679],
Cell[4200, 142, 548, 15, 70, "3ColumnTableMod",
 CellID->242120541],
Cell[4751, 159, 275, 9, 70, "Notes",
 CellID->38946648],
Cell[5029, 170, 788, 30, 70, "Notes",
 CellID->137173409]
}, Closed]],
Cell[CellGroupData[{
Cell[5854, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->426303062],
Cell[CellGroupData[{
Cell[6239, 219, 148, 5, 70, "ExampleSection",
 CellID->464293361],
Cell[6390, 226, 131, 3, 70, "Input",
 CellID->518473573],
Cell[6524, 231, 66, 1, 70, "ExampleText",
 CellID->105047553],
Cell[CellGroupData[{
Cell[6615, 236, 228, 8, 28, "Input",
 CellTags->"CellTags",
 CellID->1206339],
Cell[6846, 246, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->141813079]
}, Open  ]],
Cell[7100, 257, 114, 3, 70, "ExampleText",
 CellID->178540430],
Cell[CellGroupData[{
Cell[7239, 264, 246, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->366559242],
Cell[7488, 274, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->63050698]
}, Open  ]],
Cell[7743, 285, 125, 3, 70, "ExampleDelimiter",
 CellID->171611389],
Cell[7871, 290, 131, 3, 70, "Input",
 CellID->212000579],
Cell[8005, 295, 148, 5, 70, "ExampleText",
 CellID->131564385],
Cell[CellGroupData[{
Cell[8178, 304, 283, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->347198457],
Cell[8464, 315, 272, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->16601053]
}, Open  ]],
Cell[CellGroupData[{
Cell[8773, 329, 286, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->189066408],
Cell[9062, 340, 276, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->351607874]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9387, 355, 222, 7, 70, "ExampleSection",
 CellID->172581325],
Cell[CellGroupData[{
Cell[9634, 366, 228, 7, 70, "ExampleSubsection",
 CellID->31314233],
Cell[9865, 375, 131, 3, 70, "Input",
 CellID->442976732],
Cell[9999, 380, 465, 12, 70, "ExampleText",
 CellID->288450391],
Cell[10467, 394, 122, 3, 70, "ExampleText",
 CellID->385663097],
Cell[CellGroupData[{
Cell[10614, 401, 229, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->23632612],
Cell[10846, 411, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->117646193]
}, Open  ]],
Cell[11101, 422, 124, 3, 70, "ExampleDelimiter",
 CellID->53394536],
Cell[11228, 427, 130, 3, 70, "Input",
 CellID->35295759],
Cell[11361, 432, 124, 3, 70, "ExampleText",
 CellID->250526283],
Cell[CellGroupData[{
Cell[11510, 439, 296, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->366007363],
Cell[11809, 450, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->126823736]
}, Open  ]],
Cell[12063, 461, 124, 3, 70, "ExampleDelimiter",
 CellID->34193951],
Cell[12190, 466, 131, 3, 70, "Input",
 CellID->464890591],
Cell[12324, 471, 145, 4, 70, "ExampleText",
 CellID->5278332],
Cell[CellGroupData[{
Cell[12494, 479, 294, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->373441331],
Cell[12791, 490, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->528635061]
}, Open  ]],
Cell[13046, 501, 124, 3, 70, "ExampleDelimiter",
 CellID->17289274],
Cell[13173, 506, 131, 3, 70, "Input",
 CellID->271735816],
Cell[13307, 511, 94, 1, 70, "ExampleText",
 CellID->868100082],
Cell[CellGroupData[{
Cell[13426, 516, 231, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->558641042],
Cell[13660, 526, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->450616175]
}, Open  ]],
Cell[13914, 537, 124, 3, 70, "ExampleDelimiter",
 CellID->75054608],
Cell[14041, 542, 131, 3, 70, "Input",
 CellID->178083250],
Cell[14175, 547, 97, 1, 70, "ExampleText",
 CellID->27631549],
Cell[CellGroupData[{
Cell[14297, 552, 296, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->308754828],
Cell[14596, 563, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->363511477]
}, Open  ]],
Cell[14851, 574, 125, 3, 70, "ExampleDelimiter",
 CellID->446189829],
Cell[14979, 579, 131, 3, 70, "Input",
 CellID->304180914],
Cell[15113, 584, 125, 3, 70, "ExampleText",
 CellID->78047085],
Cell[CellGroupData[{
Cell[15263, 591, 295, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->448230914],
Cell[15561, 602, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->506019484]
}, Open  ]],
Cell[CellGroupData[{
Cell[15838, 615, 296, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->1010422936],
Cell[16137, 626, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->561465081]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16439, 641, 227, 7, 70, "ExampleSection",
 CellID->344688641],
Cell[16669, 650, 131, 3, 70, "Input",
 CellID->101928846],
Cell[16803, 655, 131, 4, 70, "ExampleText",
 CellID->149047355],
Cell[16937, 661, 293, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->110548071],
Cell[CellGroupData[{
Cell[17255, 674, 134, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->302679467],
Cell[17392, 680, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->491468703]
}, Open  ]],
Cell[CellGroupData[{
Cell[17668, 693, 127, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->56834690],
Cell[17798, 699, 189, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->249995323]
}, Open  ]],
Cell[18002, 708, 124, 3, 70, "ExampleDelimiter",
 CellID->52703757],
Cell[18129, 713, 130, 3, 70, "Input",
 CellID->26986640],
Cell[18262, 718, 113, 3, 70, "ExampleText",
 CellID->132001872],
Cell[18378, 723, 339, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->102605244],
Cell[CellGroupData[{
Cell[18742, 737, 231, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->390092873],
Cell[18976, 747, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->349515236]
}, Open  ]],
Cell[CellGroupData[{
Cell[19252, 760, 232, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->203210767],
Cell[19487, 770, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->492183207]
}, Open  ]],
Cell[CellGroupData[{
Cell[19764, 783, 247, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->15191394],
Cell[20014, 793, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->11208307]
}, Open  ]],
Cell[20267, 804, 124, 3, 70, "ExampleDelimiter",
 CellID->68198582],
Cell[20394, 809, 130, 3, 70, "Input",
 CellID->10248544],
Cell[20527, 814, 192, 4, 70, "ExampleText",
 CellID->35784471],
Cell[20722, 820, 273, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->22571630],
Cell[CellGroupData[{
Cell[21020, 833, 131, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->189573084],
Cell[21154, 839, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->30058022]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21442, 853, 230, 7, 70, "ExampleSection",
 CellID->607184710],
Cell[21675, 862, 131, 3, 70, "Input",
 CellID->223602491],
Cell[21809, 867, 801, 20, 70, "ExampleText",
 CellID->40998135],
Cell[22613, 889, 134, 4, 70, "ExampleText",
 CellID->308763913],
Cell[CellGroupData[{
Cell[22772, 897, 230, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->377863343],
Cell[23005, 907, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->339789774]
}, Open  ]],
Cell[23260, 918, 125, 3, 70, "ExampleDelimiter",
 CellID->194929490],
Cell[23388, 923, 131, 3, 70, "Input",
 CellID->412948710],
Cell[23522, 928, 419, 7, 70, "ExampleText",
 CellID->647071506],
Cell[23944, 937, 400, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->329095345],
Cell[24347, 949, 243, 5, 70, "ExampleText",
 CellID->1793004],
Cell[CellGroupData[{
Cell[24615, 958, 246, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->206602261],
Cell[24864, 968, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->112066292]
}, Open  ]],
Cell[CellGroupData[{
Cell[25142, 981, 244, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->7015758],
Cell[25389, 991, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->676168624]
}, Open  ]],
Cell[25643, 1002, 452, 12, 70, "ExampleText",
 CellID->468564612],
Cell[CellGroupData[{
Cell[26120, 1018, 294, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->75220111],
Cell[26417, 1029, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->514464146]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26717, 1044, 314, 9, 70, "SeeAlsoSection",
 CellID->68729819],
Cell[27034, 1055, 215, 6, 70, "SeeAlso",
 CellID->309200681]
}, Open  ]],
Cell[CellGroupData[{
Cell[27286, 1066, 316, 9, 70, "TutorialsSection",
 CellID->9541462],
Cell[27605, 1077, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[27768, 1083, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

