(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25302,        930]
NotebookOptionsPosition[     17398,        653]
NotebookOutlinePosition[     20388,        750]
CellTagsIndexPosition[     20276,        744]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CalendarChange" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/CalendarChange"], 
          "Calendar" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Calendar"], "Julian" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Julian"], "Islamic" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Islamic"], "Jewish" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Jewish"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CalendarChange\"\>", 
       2->"\<\"Calendar\"\>", 3->"\<\"Julian\"\>", 4->"\<\"Islamic\"\>", 
       5->"\<\"Jewish\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gregorian", "ObjectName",
 CellID->237928861],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gregorian"], "InlineFormula"],
     " \[LineSeparator]represents the Gregorian calendar system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6915475]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " is a value for the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option, and can be used as an argument to ",
 Cell[BoxData[
  ButtonBox["CalendarChange",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/CalendarChange"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->331402711],

Cell[TextData[{
 "This calendar was adopted for dates ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1582", ",", " ", "10", ",", " ", "15"}], "}"}]], 
  "InlineFormula"],
 " and later."
}], "Notes",
 CellID->133602119]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->775156407],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->22284975],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell[TextData[{
 "The Western calendar in current use is the Gregorian calendar. To convert a \
contemporary Western date to another calendar, one uses ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " for the contemporary Western date. \nIsrael obtained its independence on \
May 14, 1948. This finds the Jewish date:"
}], "ExampleText",
 CellID->438696883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1948", ",", " ", "5", ",", " ", "14"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->301936179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5708", ",", "2", ",", "5"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->275392623]
}, Open  ]],

Cell["\<\
This finds the Western date corresponding to the 50th Jewish anniversary:\
\>", "ExampleText",
 CellID->312111861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5758", ",", " ", "2", ",", " ", "5"}], "}"}], ",", " ", "Jewish",
    ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->233979624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1998", ",", "5", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->584750264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7416571],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->150448987],

Cell["\<\
Between 1582 and 1752, Catholic countries used the Gregorian calendar while \
Britain and her colonies used the Julian calendar. To convert British and \
Catholic dates occurring between 1582 and 1752 , one needs to change \
calendars from Julian to Gregorian.
 George Washington was born on February 22, 1732. In France, the date was:\
\>", "ExampleText",
 CellID->754946536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1732", ",", " ", "2", ",", " ", "22"}], "}"}], ",", " ", 
   "Julian", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->100646480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1732", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->25415629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->439917608],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->708225681],

Cell["\<\
Voltaire was born on November 21, 1694. In Great Britain the date was:\
\>", "ExampleText",
 CellID->120915265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Julian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->471073590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1694", ",", "11", ",", "11"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->267704230]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->630658764],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->50412488],

Cell[TextData[{
 "To know the day of the week corresponding to Voltaire's birth, one uses the \
",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " option:"
}], "ExampleText",
 CellID->309166172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->612542606],

Cell[BoxData["Sunday"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->29122604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->773975540],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->395483672],

Cell[TextData[{
 "To compute the number of days Voltaire lived, one uses the ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " option:"
}], "ExampleText",
 CellID->656494799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1778", ",", " ", "5", ",", " ", "30"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Gregorian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->280423188],

Cell[BoxData["30505"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->101440423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13863553],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->14624438],

Cell["\<\
The Russian Orthodox Church still uses the Julian calendar. This finds the \
Western (Gregorian) date of Greek Orthodox Christmas 2000:\
\>", "ExampleText",
 CellID->161495596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "12", ",", " ", "25"}], "}"}], ",", " ", 
   "Julian", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->554276917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2001", ",", "1", ",", "7"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->330910452]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->222777138],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->309809264],

Cell["\<\
The Gregorian calendar has a 400 year cycle with 146463 days:\
\>", "ExampleText",
 CellID->31393407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"2401", ",", " ", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->41989843],

Cell[BoxData["146463"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->523802188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134386703],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->150772745],

Cell["The Gregorian cycle also includes weeks:", "ExampleText",
 CellID->992331820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DayOfWeek", "[", 
   RowBox[{"{", 
    RowBox[{"2001", ",", " ", "1", ",", " ", "1"}], "}"}], "]"}], " ", 
  "\[Equal]", " ", 
  RowBox[{"DayOfWeek", "[", 
   RowBox[{"{", 
    RowBox[{"2401", ",", " ", "1", ",", " ", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->116193812],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->354963315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104550267],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->392332294],

Cell["A Gregorian century never begins on a Sunday:", "ExampleText",
 CellID->131975021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2001", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2101", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2201", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2301", ",", " ", "1", ",", " ", "1"}], "}"}]}], 
   "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->390121904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Monday", ",", "Saturday", ",", "Thursday", ",", "Tuesday"}], 
  "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->356764129]
}, Open  ]],

Cell["No matter how beginning of century is defined:", "ExampleText",
 CellID->323451588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"DayOfWeek", " ", "/@", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2100", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2200", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2300", ",", " ", "1", ",", " ", "1"}], "}"}]}], 
    "}"}]}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->432804337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Saturday", ",", "Friday", ",", "Wednesday", ",", "Monday"}], 
  "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->53641826]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->604747853],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CalendarChange",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/CalendarChange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calendar",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Calendar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Julian",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Julian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Islamic",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Islamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Jewish",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Jewish"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->112172367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->221414852],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gregorian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 38.5677320}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> "Gregorian represents the Gregorian calendar system.", 
    "synonyms" -> {}, "title" -> "Gregorian", "type" -> "Symbol", "uri" -> 
    "Calendar/ref/Gregorian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3833, 128, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->775156407]},
 "CellTags"->{
  Cell[4887, 165, 266, 8, 28, "Input",
   CellTags->"CellTags",
   CellID->301936179],
  Cell[5156, 175, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->275392623],
  Cell[5559, 193, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->233979624],
  Cell[5827, 203, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->584750264],
  Cell[6752, 235, 266, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->100646480],
  Cell[7021, 245, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->25415629],
  Cell[7682, 273, 267, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->471073590],
  Cell[7952, 283, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->267704230],
  Cell[8689, 314, 280, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->612542606],
  Cell[8972, 324, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->29122604],
  Cell[9635, 352, 370, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->280423188],
  Cell[10008, 364, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->101440423],
  Cell[10679, 391, 267, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->554276917],
  Cell[10949, 401, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->330910452],
  Cell[11737, 436, 296, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->41989843],
  Cell[12036, 447, 186, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->523802188],
  Cell[13489, 506, 516, 15, 70, "Input",
   CellTags->"CellTags",
   CellID->390121904],
  Cell[14008, 523, 275, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->356764129],
  Cell[14412, 540, 545, 16, 70, "Input",
   CellTags->"CellTags",
   CellID->432804337],
  Cell[14960, 558, 274, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->53641826]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18359, 676},
 {"CellTags", 18494, 680}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1602, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2225, 64, 51, 1, 70, "ObjectName",
 CellID->237928861],
Cell[2279, 67, 342, 10, 70, "Usage",
 CellID->6915475]
}, Open  ]],
Cell[CellGroupData[{
Cell[2658, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3136, 99, 440, 14, 70, "Notes",
 CellID->331402711],
Cell[3579, 115, 217, 8, 70, "Notes",
 CellID->133602119]
}, Closed]],
Cell[CellGroupData[{
Cell[3833, 128, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->775156407],
Cell[CellGroupData[{
Cell[4218, 142, 147, 5, 70, "ExampleSection",
 CellID->22284975],
Cell[4368, 149, 131, 3, 70, "Input",
 CellID->518473573],
Cell[4502, 154, 360, 7, 70, "ExampleText",
 CellID->438696883],
Cell[CellGroupData[{
Cell[4887, 165, 266, 8, 28, "Input",
 CellTags->"CellTags",
 CellID->301936179],
Cell[5156, 175, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->275392623]
}, Open  ]],
Cell[5410, 186, 124, 3, 70, "ExampleText",
 CellID->312111861],
Cell[CellGroupData[{
Cell[5559, 193, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->233979624],
Cell[5827, 203, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->584750264]
}, Open  ]],
Cell[6081, 214, 123, 3, 70, "ExampleDelimiter",
 CellID->7416571],
Cell[6207, 219, 131, 3, 70, "Input",
 CellID->150448987],
Cell[6341, 224, 386, 7, 70, "ExampleText",
 CellID->754946536],
Cell[CellGroupData[{
Cell[6752, 235, 266, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->100646480],
Cell[7021, 245, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->25415629]
}, Open  ]],
Cell[7274, 256, 125, 3, 70, "ExampleDelimiter",
 CellID->439917608],
Cell[7402, 261, 131, 3, 70, "Input",
 CellID->708225681],
Cell[7536, 266, 121, 3, 70, "ExampleText",
 CellID->120915265],
Cell[CellGroupData[{
Cell[7682, 273, 267, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->471073590],
Cell[7952, 283, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->267704230]
}, Open  ]],
Cell[8208, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->630658764],
Cell[8336, 299, 130, 3, 70, "Input",
 CellID->50412488],
Cell[8469, 304, 195, 6, 70, "ExampleText",
 CellID->309166172],
Cell[CellGroupData[{
Cell[8689, 314, 280, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->612542606],
Cell[8972, 324, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->29122604]
}, Open  ]],
Cell[9172, 333, 125, 3, 70, "ExampleDelimiter",
 CellID->773975540],
Cell[9300, 338, 131, 3, 70, "Input",
 CellID->395483672],
Cell[9434, 343, 176, 5, 70, "ExampleText",
 CellID->656494799],
Cell[CellGroupData[{
Cell[9635, 352, 370, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->280423188],
Cell[10008, 364, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->101440423]
}, Open  ]],
Cell[10208, 373, 124, 3, 70, "ExampleDelimiter",
 CellID->13863553],
Cell[10335, 378, 130, 3, 70, "Input",
 CellID->14624438],
Cell[10468, 383, 186, 4, 70, "ExampleText",
 CellID->161495596],
Cell[CellGroupData[{
Cell[10679, 391, 267, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->554276917],
Cell[10949, 401, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->330910452]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11237, 415, 227, 7, 70, "ExampleSection",
 CellID->222777138],
Cell[11467, 424, 131, 3, 70, "Input",
 CellID->309809264],
Cell[11601, 429, 111, 3, 70, "ExampleText",
 CellID->31393407],
Cell[CellGroupData[{
Cell[11737, 436, 296, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->41989843],
Cell[12036, 447, 186, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->523802188]
}, Open  ]],
Cell[12237, 456, 125, 3, 70, "ExampleDelimiter",
 CellID->134386703],
Cell[12365, 461, 131, 3, 70, "Input",
 CellID->150772745],
Cell[12499, 466, 83, 1, 70, "ExampleText",
 CellID->992331820],
Cell[CellGroupData[{
Cell[12607, 471, 328, 10, 70, "Input",
 CellID->116193812],
Cell[12938, 483, 161, 5, 36, "Output",
 CellID->354963315]
}, Open  ]],
Cell[13114, 491, 125, 3, 70, "ExampleDelimiter",
 CellID->104550267],
Cell[13242, 496, 131, 3, 70, "Input",
 CellID->392332294],
Cell[13376, 501, 88, 1, 70, "ExampleText",
 CellID->131975021],
Cell[CellGroupData[{
Cell[13489, 506, 516, 15, 70, "Input",
 CellTags->"CellTags",
 CellID->390121904],
Cell[14008, 523, 275, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->356764129]
}, Open  ]],
Cell[14298, 535, 89, 1, 70, "ExampleText",
 CellID->323451588],
Cell[CellGroupData[{
Cell[14412, 540, 545, 16, 70, "Input",
 CellTags->"CellTags",
 CellID->432804337],
Cell[14960, 558, 274, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->53641826]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15295, 574, 315, 9, 70, "SeeAlsoSection",
 CellID->604747853],
Cell[15613, 585, 1237, 44, 70, "SeeAlso",
 CellID->112172367]
}, Open  ]],
Cell[CellGroupData[{
Cell[16887, 634, 318, 9, 70, "TutorialsSection",
 CellID->221414852],
Cell[17208, 645, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[17371, 651, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

