(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28396,       1040]
NotebookOptionsPosition[     19623,        729]
NotebookOutlinePosition[     23219,        847]
CellTagsIndexPosition[     23107,        841]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CalendarChange" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/CalendarChange"], 
          "Calendar" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Calendar"], 
          "Gregorian" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Gregorian"], "Julian" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Julian"], "Jewish" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Jewish"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CalendarChange\"\>", 
       2->"\<\"Calendar\"\>", 3->"\<\"Gregorian\"\>", 4->"\<\"Julian\"\>", 
       5->"\<\"Jewish\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Islamic", "ObjectName",
 CellID->247818742],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Islamic"], "InlineFormula"],
     " \[LineSeparator]represents the Islamic calendar system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->112589756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Islamic"], "InlineFormula"],
 " is a value for the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option, and can be used as an argument to ",
 Cell[BoxData[
  ButtonBox["CalendarChange",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/CalendarChange"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->45937028],

Cell[TextData[{
 "This calendar began on ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["622", "TR"], ",", 
    StyleBox["7", "TR"], ",", 
    StyleBox["16", "TR"]}], "}"}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["1", "TR"], ",", 
    StyleBox["1", "TR"], ",", 
    StyleBox["1", "TR"]}], "}"}]], "InlineFormula"],
 " in the ",
 Cell[BoxData["Islamic"], "InlineFormula"],
 " calendar (one date given for the Hejira)."
}], "Notes",
 CellID->115781710]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108823900],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->187241430],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell[TextData[{
 "The argument ",
 Cell[BoxData["Islamic"], "InlineFormula"],
 " to ",
 Cell[BoxData["CalendarChange"], "InlineFormula"],
 " converts between Western (Gregorian) dates and Islamic dates. This \
computes the Islamic date of January 1, 2000:"
}], "ExampleText",
 CellID->210720259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Islamic"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->827651962],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1420", ",", "9", ",", "24"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->36995181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110560702],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->59434205],

Cell["The Islamic calendar has the following months:", "ExampleText",
 CellID->230900617],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
   "Muharram", ",", " ", "Safar", ",", " ", "RabiaI", ",", " ", "RabiaII", 
    ",", " ", "JumadaI", ",", " ", "JumadaII", ",", " ", "Rajab", ",", " ", 
    "Shaban", ",", " ", "Ramadan", ",", " ", "Shawwal", ",", " ", "DhualQada",
     ",", " ", "DhualHijah"}], "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->44099405],

Cell["The above date is therefore 24th of Ramadan, 1420. ", "ExampleText",
 CellID->489234050],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->410439263],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->532649748],

Cell["\<\
The Western date for the beginning of Ramadan of the Islamic year 1420:\
\>", "ExampleText",
 CellID->125287752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1420", ",", " ", "9", ",", " ", "1"}], "}"}], ",", " ", 
   "Islamic", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->38527930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1999", ",", "12", ",", "9"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->326344621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42950765],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->190124436],

Cell["The Islamic year has fewer days than a Western year:", "ExampleText",
 CellID->208855175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1420", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1421", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->41307484],

Cell[BoxData["355"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->175075792]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1421", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1422", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->29600716],

Cell[BoxData["354"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->69235194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->691151102],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->265435426],

Cell["\<\
The Islamic calendar is purely lunar (time of month corresponds to phase of \
the moon) but does not keep track of seasons, since there is no leap month. \
The Islamic calendar wanders backwards with respect to the Western calendar, \
for example, the start of Ramadan in successive years:\
\>", "ExampleText",
 CellID->315346737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1421", ",", " ", "9", ",", " ", "1"}], "}"}], ",", " ", 
   "Islamic", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->615545714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2000", ",", "11", ",", "28"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->418018944]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1422", ",", " ", "9", ",", " ", "1"}], "}"}], ",", " ", 
   "Islamic", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->196164246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2001", ",", "11", ",", "17"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->782255841]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1423", ",", " ", "9", ",", " ", "1"}], "}"}], ",", " ", 
   "Islamic", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->276540348],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2002", ",", "11", ",", "6"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->213841713]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->849821337],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->184759897],

Cell["\<\
A program which computes the first and last dates of Ramadan for a given \
Western calendar year for the Ramadan beginning the first time that given \
year:\
\>", "ExampleText",
 CellID->69365516],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ramadan", "[", "year_", "]"}], ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"islamicdate", ",", " ", "ramadanstart"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"islamicdate", " ", "=", " ", 
      RowBox[{"CalendarChange", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"year", "-", "1"}], ",", " ", "12", ",", " ", "31"}], "}"}],
         ",", " ", "Gregorian", ",", " ", "Islamic"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"ramadanstart", " ", "=", " ", 
      RowBox[{"CalendarChange", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"islamicdate", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", " ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"islamicdate", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "<", " ", "9"}], ",", " ",
              "0", ",", " ", "1"}], "]"}]}], ",", " ", "9", ",", " ", "1"}], 
         "}"}], ",", " ", "Islamic", ",", " ", "Gregorian"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"ramadanstart", ",", " ", 
       RowBox[{"DaysPlus", "[", 
        RowBox[{"ramadanstart", ",", " ", "29"}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->11419303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ramadan", "[", "2000", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->158673515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", "11", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2000", ",", "12", ",", "27"}], "}"}]}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->48076945]
}, Open  ]],

Cell["\<\
Note that Ramadan can occur partially twice in one year, as in 2000:\
\>", "ExampleText",
 CellID->41561734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ramadan", "[", "1999", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->75027673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1999", ",", "12", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2000", ",", "1", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->169157058]
}, Open  ]],

Cell["\<\
There is also the possibility that Ramadan begins twice in the same Western \
year, as in 1932. The program returns the first Ramadan beginning that year:\
\>", "ExampleText",
 CellID->230744197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ramadan", "[", "1932", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[5]:=",
 CellID->24338641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1932", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1932", ",", "2", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[5]=",
 CellID->984147608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1932", ",", " ", "1", ",", " ", "10"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Islamic"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[6]:=",
 CellID->105806952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1350", ",", "9", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[6]=",
 CellID->183176501]
}, Open  ]],

Cell["Ramadan of the following Islamic year also began in 1932:", \
"ExampleText",
 CellID->38150579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1351", ",", " ", "9", ",", " ", "1"}], "}"}], ",", " ", 
   "Islamic", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[7]:=",
 CellID->283078799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1932", ",", "12", ",", "29"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[7]=",
 CellID->225700932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->730781277],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18551903],

Cell["\<\
Since the names and the numerical order of the Islamic months is not well \
known in the Western world, it is useful to have the list of names:\
\>", "ExampleText",
 CellID->396490288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Muharram", ",", " ", "Safar", ",", " ", "RabiaI", ",", " ", "RabiaII", ",",
    " ", "JumadaI", ",", " ", "JumadaII", ",", " ", "Rajab", ",", " ", 
   "Shaban", ",", " ", "Ramadan", ",", " ", "Shawwal", ",", " ", "DhualQada", 
   ",", " ", "DhualHijah"}], "}"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->99870855]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->284044948],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CalendarChange",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/CalendarChange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calendar",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Calendar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gregorian",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Gregorian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Julian",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Julian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Jewish",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Jewish"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->85902314]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->356924175],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Islamic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 38.8177384}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> "Islamic represents the Islamic calendar system.", 
    "synonyms" -> {}, "title" -> "Islamic", "type" -> "Symbol", "uri" -> 
    "Calendar/ref/Islamic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4265, 145, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->108823900]},
 "CellTags"->{
  Cell[5255, 183, 266, 8, 28, "Input",
   CellTags->"CellTags",
   CellID->827651962],
  Cell[5524, 193, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->36995181],
  Cell[6131, 217, 403, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->44099405],
  Cell[7043, 249, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->38527930],
  Cell[7311, 259, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->326344621],
  Cell[7947, 285, 364, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->41307484],
  Cell[8314, 297, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->175075792],
  Cell[8534, 308, 364, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->29600716],
  Cell[8901, 320, 182, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->69235194],
  Cell[9725, 349, 266, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->615545714],
  Cell[9994, 359, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->418018944],
  Cell[10272, 372, 266, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->196164246],
  Cell[10541, 382, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->782255841],
  Cell[10819, 395, 266, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->276540348],
  Cell[11088, 405, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->213841713],
  Cell[11950, 440, 1449, 40, 70, "Input",
   CellTags->"CellTags",
   CellID->11419303],
  Cell[13424, 484, 129, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->158673515],
  Cell[13556, 490, 354, 12, 36, "Output",
   CellTags->"CellTags",
   CellID->48076945],
  Cell[14068, 512, 128, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->75027673],
  Cell[14199, 518, 352, 12, 36, "Output",
   CellTags->"CellTags",
   CellID->169157058],
  Cell[14796, 541, 128, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->24338641],
  Cell[14927, 547, 352, 12, 36, "Output",
   CellTags->"CellTags",
   CellID->984147608],
  Cell[15316, 564, 267, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->105806952],
  Cell[15586, 574, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->183176501],
  Cell[15966, 591, 266, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->283078799],
  Cell[16235, 601, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->225700932],
  Cell[17088, 635, 380, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->99870855]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20574, 752},
 {"CellTags", 20709, 756}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1619, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2242, 65, 49, 1, 70, "ObjectName",
 CellID->247818742],
Cell[2294, 68, 340, 10, 70, "Usage",
 CellID->112589756]
}, Open  ]],
Cell[CellGroupData[{
Cell[2671, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3149, 100, 438, 14, 70, "Notes",
 CellID->45937028],
Cell[3590, 116, 638, 24, 70, "Notes",
 CellID->115781710]
}, Closed]],
Cell[CellGroupData[{
Cell[4265, 145, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108823900],
Cell[CellGroupData[{
Cell[4650, 159, 148, 5, 70, "ExampleSection",
 CellID->187241430],
Cell[4801, 166, 131, 3, 70, "Input",
 CellID->518473573],
Cell[4935, 171, 295, 8, 70, "ExampleText",
 CellID->210720259],
Cell[CellGroupData[{
Cell[5255, 183, 266, 8, 28, "Input",
 CellTags->"CellTags",
 CellID->827651962],
Cell[5524, 193, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->36995181]
}, Open  ]],
Cell[5778, 204, 125, 3, 70, "ExampleDelimiter",
 CellID->110560702],
Cell[5906, 209, 130, 3, 70, "Input",
 CellID->59434205],
Cell[6039, 214, 89, 1, 70, "ExampleText",
 CellID->230900617],
Cell[6131, 217, 403, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->44099405],
Cell[6537, 229, 94, 1, 70, "ExampleText",
 CellID->489234050],
Cell[6634, 232, 125, 3, 70, "ExampleDelimiter",
 CellID->410439263],
Cell[6762, 237, 131, 3, 70, "Input",
 CellID->532649748],
Cell[6896, 242, 122, 3, 70, "ExampleText",
 CellID->125287752],
Cell[CellGroupData[{
Cell[7043, 249, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->38527930],
Cell[7311, 259, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->326344621]
}, Open  ]],
Cell[7566, 270, 124, 3, 70, "ExampleDelimiter",
 CellID->42950765],
Cell[7693, 275, 131, 3, 70, "Input",
 CellID->190124436],
Cell[7827, 280, 95, 1, 70, "ExampleText",
 CellID->208855175],
Cell[CellGroupData[{
Cell[7947, 285, 364, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->41307484],
Cell[8314, 297, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->175075792]
}, Open  ]],
Cell[CellGroupData[{
Cell[8534, 308, 364, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->29600716],
Cell[8901, 320, 182, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->69235194]
}, Open  ]],
Cell[9098, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->691151102],
Cell[9226, 334, 131, 3, 70, "Input",
 CellID->265435426],
Cell[9360, 339, 340, 6, 70, "ExampleText",
 CellID->315346737],
Cell[CellGroupData[{
Cell[9725, 349, 266, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->615545714],
Cell[9994, 359, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->418018944]
}, Open  ]],
Cell[CellGroupData[{
Cell[10272, 372, 266, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->196164246],
Cell[10541, 382, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->782255841]
}, Open  ]],
Cell[CellGroupData[{
Cell[10819, 395, 266, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->276540348],
Cell[11088, 405, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->213841713]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11377, 419, 227, 7, 70, "ExampleSection",
 CellID->849821337],
Cell[11607, 428, 131, 3, 70, "Input",
 CellID->184759897],
Cell[11741, 433, 206, 5, 70, "ExampleText",
 CellID->69365516],
Cell[11950, 440, 1449, 40, 70, "Input",
 CellTags->"CellTags",
 CellID->11419303],
Cell[CellGroupData[{
Cell[13424, 484, 129, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->158673515],
Cell[13556, 490, 354, 12, 36, "Output",
 CellTags->"CellTags",
 CellID->48076945]
}, Open  ]],
Cell[13925, 505, 118, 3, 70, "ExampleText",
 CellID->41561734],
Cell[CellGroupData[{
Cell[14068, 512, 128, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->75027673],
Cell[14199, 518, 352, 12, 36, "Output",
 CellTags->"CellTags",
 CellID->169157058]
}, Open  ]],
Cell[14566, 533, 205, 4, 70, "ExampleText",
 CellID->230744197],
Cell[CellGroupData[{
Cell[14796, 541, 128, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->24338641],
Cell[14927, 547, 352, 12, 36, "Output",
 CellTags->"CellTags",
 CellID->984147608]
}, Open  ]],
Cell[CellGroupData[{
Cell[15316, 564, 267, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->105806952],
Cell[15586, 574, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->183176501]
}, Open  ]],
Cell[15840, 585, 101, 2, 70, "ExampleText",
 CellID->38150579],
Cell[CellGroupData[{
Cell[15966, 591, 266, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->283078799],
Cell[16235, 601, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->225700932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16525, 615, 230, 7, 70, "ExampleSection",
 CellID->730781277],
Cell[16758, 624, 130, 3, 70, "Input",
 CellID->18551903],
Cell[16891, 629, 194, 4, 70, "ExampleText",
 CellID->396490288],
Cell[17088, 635, 380, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->99870855]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17517, 650, 315, 9, 70, "SeeAlsoSection",
 CellID->284044948],
Cell[17835, 661, 1240, 44, 70, "SeeAlso",
 CellID->85902314]
}, Open  ]],
Cell[CellGroupData[{
Cell[19112, 710, 318, 9, 70, "TutorialsSection",
 CellID->356924175],
Cell[19433, 721, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[19596, 727, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

