(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6718,        238]
NotebookOptionsPosition[      4943,        181]
NotebookOutlinePosition[      6017,        211]
CellTagsIndexPosition[      5974,        208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Jewish" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Jewish"], "Gregorian" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Gregorian"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Jewish\"\>", 
       2->"\<\"Gregorian\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JewishNewYear", "ObjectName",
 CellID->7830],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JewishNewYear", "[", 
       StyleBox["year", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator] gives the date of the Jewish New Year occurring in ",
     Cell[BoxData[
      ButtonBox["Gregorian",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
     " years between 1900 and 2099."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27112]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Year ",
 Cell[BoxData[
  StyleBox["year", "TI"]], "InlineFormula"],
 " must be such that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["1900", "TR"], "<=", 
   StyleBox["year", "TI"], "<", 
   StyleBox["2100", "TR"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6962],

Cell[TextData[{
 "Add ",
 Cell[BoxData[
  StyleBox["3761", "TR"]], "InlineFormula"],
 " to the Christian year ",
 Cell[BoxData[
  StyleBox["year", "TI"]], "InlineFormula"],
 " to get the corresponding new Jewish Year."
}], "Notes",
 CellID->3141]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16253],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Jewish",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Jewish"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gregorian",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Gregorian"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11818],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JewishNewYear - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 39.3177512}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "JewishNewYear[year] gives the date of the Jewish New Year occurring in \
Gregorian years between 1900 and 2099.", "synonyms" -> {}, "title" -> 
    "JewishNewYear", "type" -> "Symbol", "uri" -> 
    "Calendar/ref/JewishNewYear"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1259, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1882, 59, 50, 1, 70, "ObjectName",
 CellID->7830],
Cell[1935, 62, 598, 17, 70, "Usage",
 CellID->27112]
}, Open  ]],
Cell[CellGroupData[{
Cell[2570, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3048, 101, 284, 12, 70, "Notes",
 CellID->6962],
Cell[3335, 115, 246, 9, 70, "Notes",
 CellID->3141]
}, Closed]],
Cell[CellGroupData[{
Cell[3618, 129, 311, 9, 70, "SeeAlsoSection",
 CellID->16253],
Cell[3932, 140, 467, 17, 70, "SeeAlso",
 CellID->25332]
}, Open  ]],
Cell[CellGroupData[{
Cell[4436, 162, 314, 9, 70, "TutorialsSection",
 CellID->11818],
Cell[4753, 173, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[4916, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

