(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16772,        607]
NotebookOptionsPosition[     11702,        430]
NotebookOutlinePosition[     13879,        500]
CellTagsIndexPosition[     13767,        494]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CalendarChange" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/CalendarChange"], 
          "Calendar" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Calendar"], 
          "Gregorian" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Gregorian"], 
          "Islamic" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Islamic"], "Jewish" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Jewish"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CalendarChange\"\>", 
       2->"\<\"Calendar\"\>", 3->"\<\"Gregorian\"\>", 4->"\<\"Islamic\"\>", 
       5->"\<\"Jewish\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Julian", "ObjectName",
 CellID->175197920],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Julian"], "InlineFormula"],
     "\[LineSeparator]represents the Julian calendar system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->124968539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Julian"], "InlineFormula"],
 " is a value for the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option, and can be used as an argument to ",
 Cell[BoxData[
  ButtonBox["CalendarChange",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/CalendarChange"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->743549228]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323579878],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->470342907],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell["\<\
Between 1582 and 1752, Catholic countries used the Gregorian calendar while \
Britain and her colonies used the Julian calendar. To convert British and \
Catholic dates occurring between 1582 and 1752 , one needs to change \
calendars from Julian to Gregorian.
 George Washington was born on February 22, 1732. In France, the date was:\
\>", "ExampleText",
 CellID->462755170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1732", ",", " ", "2", ",", " ", "22"}], "}"}], ",", " ", 
   "Julian", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->6168499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1732", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->777411077]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100470530],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->192163709],

Cell["\<\
Voltaire was born on November 21, 1694. In Great Britain the date was:\
\>", "ExampleText",
 CellID->220361764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Julian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->422717649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1694", ",", "11", ",", "11"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->19333849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147358585],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->945533127],

Cell["\<\
The Russian Orthodox Church still uses the Julian calendar. This finds the \
Western (Gregorian) date of Greek Orthodox Christmas 2000:\
\>", "ExampleText",
 CellID->44009759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "12", ",", " ", "25"}], "}"}], ",", " ", 
   "Julian", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->437185648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2001", ",", "1", ",", "7"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->32962973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->352451264],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->46336906],

Cell["The Julian calendar has a four year cycle with 1461 days:", \
"ExampleText",
 CellID->25479245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"2004", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Julian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->206627378],

Cell[BoxData["1461"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->261705311]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->152768116],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->61065976],

Cell["\<\
Russian Orthodox dates are computed according to the Julian calendar. This \
program returns the standard Western (Gregorian) date for Russian Orthodox \
Christmas for the given Russian Orthodox year:\
\>", "ExampleText",
 CellID->383691944],

Cell[BoxData[
 RowBox[{
  RowBox[{"RussianOrthodoxChristmas", "[", "year_", "]"}], ":=", " ", 
  RowBox[{"CalendarChange", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"year", ",", " ", "12", ",", " ", "25"}], "}"}], ",", " ", 
    "Julian", ",", " ", "Gregorian"}], "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->742175627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RussianOrthodoxChristmas", "[", "2000", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->695307595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2001", ",", "1", ",", "7"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->213915087]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6397696],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CalendarChange",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/CalendarChange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calendar",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Calendar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gregorian",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Gregorian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Islamic",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Islamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Jewish",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Jewish"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->62921760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->238666369],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Julian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 39.5365068}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> "Julian represents the Julian calendar system.", 
    "synonyms" -> {}, "title" -> "Julian", "type" -> "Symbol", "uri" -> 
    "Calendar/ref/Julian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3633, 120, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->323579878]},
 "CellTags"->{
  Cell[4714, 157, 264, 8, 28, "Input",
   CellTags->"CellTags",
   CellID->6168499],
  Cell[4981, 167, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->777411077],
  Cell[5643, 195, 267, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->422717649],
  Cell[5913, 205, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->19333849],
  Cell[6640, 234, 267, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->437185648],
  Cell[6910, 244, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->32962973],
  Cell[7550, 271, 364, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->206627378],
  Cell[7917, 283, 184, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->261705311],
  Cell[8767, 316, 355, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->742175627],
  Cell[9147, 330, 146, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->695307595],
  Cell[9296, 336, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->213915087]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12648, 453},
 {"CellTags", 12783, 457}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1633, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2256, 66, 48, 1, 70, "ObjectName",
 CellID->175197920],
Cell[2307, 69, 337, 10, 70, "Usage",
 CellID->124968539]
}, Open  ]],
Cell[CellGroupData[{
Cell[2681, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3159, 101, 437, 14, 70, "Notes",
 CellID->743549228]
}, Closed]],
Cell[CellGroupData[{
Cell[3633, 120, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323579878],
Cell[CellGroupData[{
Cell[4018, 134, 148, 5, 70, "ExampleSection",
 CellID->470342907],
Cell[4169, 141, 131, 3, 70, "Input",
 CellID->518473573],
Cell[4303, 146, 386, 7, 70, "ExampleText",
 CellID->462755170],
Cell[CellGroupData[{
Cell[4714, 157, 264, 8, 28, "Input",
 CellTags->"CellTags",
 CellID->6168499],
Cell[4981, 167, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->777411077]
}, Open  ]],
Cell[5235, 178, 125, 3, 70, "ExampleDelimiter",
 CellID->100470530],
Cell[5363, 183, 131, 3, 70, "Input",
 CellID->192163709],
Cell[5497, 188, 121, 3, 70, "ExampleText",
 CellID->220361764],
Cell[CellGroupData[{
Cell[5643, 195, 267, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->422717649],
Cell[5913, 205, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->19333849]
}, Open  ]],
Cell[6168, 216, 125, 3, 70, "ExampleDelimiter",
 CellID->147358585],
Cell[6296, 221, 131, 3, 70, "Input",
 CellID->945533127],
Cell[6430, 226, 185, 4, 70, "ExampleText",
 CellID->44009759],
Cell[CellGroupData[{
Cell[6640, 234, 267, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->437185648],
Cell[6910, 244, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->32962973]
}, Open  ]],
Cell[7163, 255, 125, 3, 70, "ExampleDelimiter",
 CellID->352451264],
Cell[7291, 260, 130, 3, 70, "Input",
 CellID->46336906],
Cell[7424, 265, 101, 2, 70, "ExampleText",
 CellID->25479245],
Cell[CellGroupData[{
Cell[7550, 271, 364, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->206627378],
Cell[7917, 283, 184, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->261705311]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8150, 295, 227, 7, 70, "ExampleSection",
 CellID->152768116],
Cell[8380, 304, 130, 3, 70, "Input",
 CellID->61065976],
Cell[8513, 309, 251, 5, 70, "ExampleText",
 CellID->383691944],
Cell[8767, 316, 355, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->742175627],
Cell[CellGroupData[{
Cell[9147, 330, 146, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->695307595],
Cell[9296, 336, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->213915087]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9596, 351, 313, 9, 70, "SeeAlsoSection",
 CellID->6397696],
Cell[9912, 362, 1242, 44, 70, "SeeAlso",
 CellID->62921760]
}, Open  ]],
Cell[CellGroupData[{
Cell[11191, 411, 318, 9, 70, "TutorialsSection",
 CellID->238666369],
Cell[11512, 422, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[11675, 428, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

