(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16880,        554]
NotebookOptionsPosition[     13281,        452]
NotebookOutlinePosition[     14617,        485]
CellTagsIndexPosition[     14574,        482]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Built-in Graphs", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["CompleteGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CompleteGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a graph with an edge between each pair of vertices"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a random graph"
}], "GuideText",
 CellID->93645074],

Cell[TextData[{
 Cell[TextData[ButtonBox["EmptyGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EmptyGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OddGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OddGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CirculantGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CirculantGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CompleteKPartiteGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CompleteKPartiteGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Turan",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Turan"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->65730669],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Cycle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a circular chain of edges "
}], "GuideText",
 CellID->30905842],

Cell[TextData[{
 Cell[TextData[ButtonBox["Star",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:Combinatorica/ref/Star"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a tree-like graph with one vertex connected to all others"
}], "GuideText",
 CellID->397844609],

Cell[TextData[{
 Cell[TextData[ButtonBox["GridGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GridGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graph with nodes on a grid"
}], "GuideText",
 CellID->467407019],

Cell[TextData[{
 Cell[TextData[ButtonBox["Wheel",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Wheel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypercube",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Hypercube"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ButterflyGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ButterflyGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShuffleExchangeGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShuffleExchangeGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeBruijnGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeBruijnGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiterSubsection",
 CellID->49346422],

Cell[CellGroupData[{

Cell["Special Graphs", "GuideFunctionsSubsection",
 CellID->234053301],

Cell[TextData[{
 Cell[TextData[ButtonBox["Harary",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Harary"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "smallest ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "-connected graph with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " vertices"
}], "GuideText",
 CellID->214369659],

Cell[TextData[{
 Cell[TextData[ButtonBox["TutteGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TutteGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "example of non-Hamiltonian graph"
}], "GuideText",
 CellID->850203375],

Cell[TextData[{
 Cell[TextData[ButtonBox["PetersenGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PetersenGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GeneralizedPetersenGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GeneralizedPetersenGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CageGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CageGraph"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->61321977],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeredithGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MeredithGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NoPerfectMatchingGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NoPerfectMatchingGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ThomassenGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ThomassenGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->249865485],

Cell[TextData[{
 Cell[TextData[ButtonBox["KnightsTourGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KnightsTourGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChvatalGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChvatalGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoxeterGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CoxeterGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FolkmanGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FolkmanGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->515495817],

Cell[TextData[{
 Cell[TextData[ButtonBox["FranklinGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FranklinGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FruchtGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FruchtGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GrayGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GrayGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GroetzschGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GroetzschGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->96295001],

Cell[TextData[{
 Cell[TextData[ButtonBox["HerschelGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HerschelGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HeawoodGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HeawoodGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LeviGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LeviGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["McGeeGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/McGeeGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RobertsonGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RobertsonGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->48748704],

Cell[TextData[{
 Cell[TextData[ButtonBox["UnitransitiveGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnitransitiveGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Uniquely3ColorableGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Uniquely3ColorableGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WaltherGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/WaltherGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->602250842],

Cell[TextData[{
 Cell[TextData[ButtonBox["CubeConnectedCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CubeConnectedCycle"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MycielskiGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MycielskiGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->213575818]
}, Open  ]],

Cell[CellGroupData[{

Cell["Platonic Solids", "GuideFunctionsSubsection",
 CellID->13255161],

Cell[TextData[{
 Cell[TextData[ButtonBox["TetrahedralGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TetrahedralGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CubicalGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CubicalGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OctahedralGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OctahedralGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->553259641],

Cell[TextData[{
 Cell[TextData[ButtonBox["IcosahedralGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IcosahedralGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DodecahedralGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DodecahedralGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->840522959]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "GuideMoreAbout",\

 CellID->252299663],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphAlgorithms"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Built-in Graphs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 47.1304512}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CompleteGraph -- a graph with an edge between each pair of vertices, \
RandomGraph -- construct a random graph, Cycle -- a circular chain of edges , \
Star -- a tree-like graph with one vertex connected to all others, GridGraph \
-- graph with nodes on a grid, Harary -- smallest k-connected graph with n \
vertices, TutteGraph -- example of non-Hamiltonian graph", "synonyms" -> {}, 
    "title" -> "Built-in Graphs", "type" -> "Guide", "uri" -> 
    "Combinatorica/guide/BuiltinGraphs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[679, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[738, 31, 306, 10, 70, "GuideText",
 CellID->203374175],
Cell[1047, 43, 275, 10, 70, "GuideText",
 CellID->93645074],
Cell[1325, 55, 1131, 31, 70, "InlineGuideFunctionListing",
 CellID->65730669],
Cell[2459, 88, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2510, 91, 262, 9, 70, "GuideText",
 CellID->30905842],
Cell[2775, 102, 437, 12, 70, "GuideText",
 CellID->397844609],
Cell[3215, 116, 271, 9, 70, "GuideText",
 CellID->467407019],
Cell[3489, 127, 1140, 32, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[4632, 161, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->49346422],
Cell[CellGroupData[{
Cell[4714, 166, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->234053301],
Cell[4787, 169, 417, 15, 70, "GuideText",
 CellID->214369659],
Cell[5207, 186, 279, 9, 70, "GuideText",
 CellID->850203375],
Cell[5489, 197, 695, 19, 70, "InlineGuideFunctionListing",
 CellID->61321977],
Cell[6187, 218, 705, 20, 70, "InlineGuideFunctionListing",
 CellID->249865485],
Cell[6895, 240, 920, 27, 70, "InlineGuideFunctionListing",
 CellID->515495817],
Cell[7818, 269, 906, 26, 70, "InlineGuideFunctionListing",
 CellID->96295001],
Cell[8727, 297, 1134, 32, 70, "InlineGuideFunctionListing",
 CellID->48748704],
Cell[9864, 331, 713, 20, 70, "InlineGuideFunctionListing",
 CellID->602250842],
Cell[10580, 353, 462, 13, 70, "InlineGuideFunctionListing",
 CellID->213575818]
}, Open  ]],
Cell[CellGroupData[{
Cell[11079, 371, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->13255161],
Cell[11152, 374, 693, 20, 70, "InlineGuideFunctionListing",
 CellID->553259641],
Cell[11848, 396, 464, 13, 70, "InlineGuideFunctionListing",
 CellID->840522959]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12361, 415, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[12426, 418, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[12623, 427, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[12688, 430, 210, 5, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[12901, 437, 166, 4, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[13070, 443, 169, 4, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[13254, 450, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

